/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.armor;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.item.IAnimatorRepairable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.item.BLMaterialRegistry;

public class ItemBLArmor
extends ItemArmor
implements IAnimatorRepairable {
    protected final String[] armorTextures;
    protected final String[][] gemArmorTextures = new String[CircleGemType.values().length][2];
    protected final String armorName;

    public ItemBLArmor(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, String armorName) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77637_a(BLCreativeTabs.GEARS);
        this.armorName = armorName;
        this.armorTextures = new String[]{"thebetweenlands:textures/armor/" + armorName + "_1.png", "thebetweenlands:textures/armor/" + armorName + "_2.png"};
        CircleGemHelper.addGemPropertyOverrides((Item)this);
    }

    public ItemBLArmor setGemArmorTextureOverride(CircleGemType type, String armorName) {
        this.gemArmorTextures[type.ordinal()][0] = "thebetweenlands:textures/armor/" + armorName + "_1.png";
        this.gemArmorTextures[type.ordinal()][1] = "thebetweenlands:textures/armor/" + armorName + "_2.png";
        return this;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        String texture1 = this.armorTextures[0];
        String texture2 = this.armorTextures[1];
        CircleGemType gem = CircleGemHelper.getGem(stack);
        if (this.gemArmorTextures[gem.ordinal()][0] != null) {
            texture1 = this.gemArmorTextures[gem.ordinal()][0];
        }
        if (this.gemArmorTextures[gem.ordinal()][1] != null) {
            texture2 = this.gemArmorTextures[gem.ordinal()][1];
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            return texture2;
        }
        return texture1;
    }

    @Override
    public int getMinRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairFuelCost(this.func_82812_d());
    }

    @Override
    public int getFullRepairFuelCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairFuelCost(this.func_82812_d());
    }

    @Override
    public int getMinRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getMinRepairLifeCost(this.func_82812_d());
    }

    @Override
    public int getFullRepairLifeCost(ItemStack stack) {
        return BLMaterialRegistry.getFullRepairLifeCost(this.func_82812_d());
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    protected ResourceLocation getOverlayTexture(ItemStack stack, EntityPlayer player, float partialTicks) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    protected ResourceLocation getOverlaySideTexture(ItemStack stack, EntityPlayer player, float partialTicks, boolean left) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
        ResourceLocation overlay = this.getOverlayTexture(stack, player, partialTicks);
        if (overlay != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            ItemBLArmor.renderRepeatingOverlay((float)resolution.func_78327_c(), (float)resolution.func_78324_d(), overlay, this.getOverlaySideTexture(stack, player, partialTicks, true), this.getOverlaySideTexture(stack, player, partialTicks, false));
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
            GlStateManager.func_179141_d();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderRepeatingOverlay(float width, float height, ResourceLocation overlay, @Nullable ResourceLocation sideOverlayLeft, @Nullable ResourceLocation sideOverlayRight) {
        if (overlay != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(overlay);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            if (sideOverlayLeft != null && sideOverlayRight != null) {
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vertexBuffer.func_181662_b((double)(width / 2.0f - height / 2.0f), (double)height, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(width / 2.0f + height / 2.0f), (double)height, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(width / 2.0f + height / 2.0f), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(width / 2.0f - height / 2.0f), 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
                float texWidth = (width / 2.0f - height / 2.0f) / height;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(sideOverlayLeft);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vertexBuffer.func_181662_b(0.0, (double)height, -90.0).func_187315_a((double)(1.0f - texWidth), 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(width / 2.0f - height / 2.0f), (double)height, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(width / 2.0f - height / 2.0f), 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
                vertexBuffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a((double)(1.0f - texWidth), 0.0).func_181675_d();
                tessellator.func_78381_a();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(sideOverlayRight);
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vertexBuffer.func_181662_b((double)(width / 2.0f + height / 2.0f), (double)height, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)width, (double)height, -90.0).func_187315_a((double)texWidth, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)width, 0.0, -90.0).func_187315_a((double)texWidth, 0.0).func_181675_d();
                vertexBuffer.func_181662_b((double)(width / 2.0f + height / 2.0f), 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
            } else {
                vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                float offset = 0.5f - width / height / 2.0f;
                vertexBuffer.func_181662_b(0.0, (double)height, -90.0).func_187315_a((double)offset, 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)width, (double)height, -90.0).func_187315_a((double)(1.0f - offset), 1.0).func_181675_d();
                vertexBuffer.func_181662_b((double)width, 0.0, -90.0).func_187315_a((double)(1.0f - offset), 0.0).func_181675_d();
                vertexBuffer.func_181662_b(0.0, 0.0, -90.0).func_187315_a((double)offset, 0.0).func_181675_d();
                tessellator.func_78381_a();
            }
        }
    }
}

