/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.inventory;

import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import thebetweenlands.api.item.IAmphibiousArmorUpgrade;
import thebetweenlands.common.inventory.InventoryItem;
import thebetweenlands.common.item.armor.amphibious.AmphibiousArmorUpgrades;
import thebetweenlands.common.item.armor.amphibious.ItemAmphibiousArmor;

public class InventoryAmphibiousArmor
extends InventoryItem {
    private final EntityEquipmentSlot armorType;
    private final ItemAmphibiousArmor item;
    private boolean pauseUpgradeDamageUpdates = false;
    private boolean useUpgradeFilter = false;

    public InventoryAmphibiousArmor(ItemStack stack, String inventoryName) {
        super(stack, ((ItemAmphibiousArmor)stack.func_77973_b()).getUpgradeSlotCount(stack), inventoryName);
        this.item = (ItemAmphibiousArmor)stack.func_77973_b();
        this.armorType = this.item.field_77881_a;
    }

    @Override
    public int func_70297_j_() {
        return 3;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        IAmphibiousArmorUpgrade upgrade = AmphibiousArmorUpgrades.getUpgrade(this.armorType, stack);
        if (!(stack.func_77973_b() instanceof ItemAmphibiousArmor) && upgrade != null && (this.func_70301_a(slot).func_190926_b() || ItemStack.func_77989_b((ItemStack)this.func_70301_a(slot).func_77946_l().func_77979_a(1), (ItemStack)stack.func_77946_l().func_77979_a(1)) && ItemAmphibiousArmor.getUpgradeItemStoredDamage(stack) == 0)) {
            ItemStack filter;
            if (this.useUpgradeFilter && !(filter = this.item.getUpgradeFilter(this.getInventoryItemStack(), slot)).func_190926_b()) {
                ItemStack copy = stack.func_77946_l().func_77979_a(1);
                ItemAmphibiousArmor.setUpgradeItemStoredDamage(copy, 0, 0);
                if (!ItemStack.func_77989_b((ItemStack)filter, (ItemStack)copy)) {
                    return false;
                }
            }
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                IAmphibiousArmorUpgrade otherUpgrade;
                ItemStack otherStack = this.func_70301_a(i);
                if (otherStack == null || (otherUpgrade = AmphibiousArmorUpgrades.getUpgrade(this.armorType, otherStack)) == null || !otherUpgrade.isBlacklisted(upgrade) && !upgrade.isBlacklisted(otherUpgrade)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        if (!this.pauseUpgradeDamageUpdates && this.func_70301_a(slot).func_190926_b()) {
            this.item.setUpgradeDamage(this.getInventoryItemStack(), slot, 0, 0);
            IAmphibiousArmorUpgrade upgrade = AmphibiousArmorUpgrades.getUpgrade(this.armorType, stack);
            if (upgrade != null) {
                int maxDamage = upgrade.getMaxDamage();
                int damage = ItemAmphibiousArmor.getUpgradeItemStoredDamage(stack);
                this.item.setUpgradeDamage(this.getInventoryItemStack(), slot, damage, maxDamage);
                ItemAmphibiousArmor.setUpgradeItemStoredDamage(stack, 0, 0);
            }
        }
        if (!stack.func_190926_b()) {
            this.item.setUpgradeFilter(this.getInventoryItemStack(), slot, stack);
        }
        super.func_70299_a(slot, stack);
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.item.setUpgradeCounts(this.getInventoryItemStack(), this);
    }

    public void setPauseUpgradeDamageUpdates(boolean pause) {
        this.pauseUpgradeDamageUpdates = pause;
    }

    public void setUseUpgradeFilter(boolean use) {
        this.useUpgradeFilter = use;
    }
}

