/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.herblore.book;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import thebetweenlands.api.aspect.AspectItem;
import thebetweenlands.api.aspect.DiscoveryContainer;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.api.item.IDiscoveryProvider;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.book.HLEntryRegistry;
import thebetweenlands.common.herblore.book.ManualCategory;
import thebetweenlands.common.registries.ItemRegistry;

public class ManualManager {
    public static List<String> findablePagesHL = new ArrayList<String>();
    public static List<String> findablePagesAll = new ArrayList<String>();

    public static boolean findPage(EntityPlayer player, String pageName, Item itemManual) {
        if (pageName != null && player != null) {
            for (int i = -1; i < player.field_71071_by.func_70302_i_(); ++i) {
                ArrayList<String> foundPages;
                ItemStack stack = i >= 0 ? player.field_71071_by.func_70301_a(i) : player.func_184586_b(EnumHand.OFF_HAND);
                if (stack.func_190926_b() || stack.func_77973_b() != itemManual) continue;
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt == null) {
                    nbt = new NBTTagCompound();
                }
                if ((foundPages = ManualManager.getFoundPages(player, itemManual)) != null && !foundPages.contains(pageName)) {
                    NBTTagList pages = new NBTTagList();
                    for (String string : foundPages) {
                        NBTTagCompound data = new NBTTagCompound();
                        data.func_74778_a("page", string);
                        pages.func_74742_a((NBTBase)data);
                    }
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("page", pageName);
                    pages.func_74742_a((NBTBase)data);
                    nbt.func_74782_a("pages", (NBTBase)pages);
                } else {
                    NBTTagList pages = new NBTTagList();
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("page", pageName);
                    pages.func_74742_a((NBTBase)data);
                    nbt.func_74782_a("pages", (NBTBase)pages);
                }
                player.field_71071_by.func_70301_a(i).func_77982_d(nbt);
                return true;
            }
        }
        return false;
    }

    public static ArrayList<String> getFoundPages(EntityPlayer player, Item itemManual) {
        if (player != null) {
            ArrayList<String> foundPages = new ArrayList<String>();
            for (int i = -1; i < player.field_71071_by.func_70302_i_(); ++i) {
                NBTTagCompound nbt;
                ItemStack stack = i >= 0 ? player.field_71071_by.func_70301_a(i) : player.func_184586_b(EnumHand.OFF_HAND);
                if (stack.func_190926_b() || stack.func_77973_b() != itemManual || (nbt = stack.func_77978_p()) == null) continue;
                NBTTagList tag = nbt.func_150295_c("pages", 10);
                for (int j = 0; j < tag.func_74745_c(); ++j) {
                    NBTTagCompound data = tag.func_150305_b(j);
                    foundPages.add(data.func_74779_i("page"));
                }
                return foundPages;
            }
        }
        return null;
    }

    public static boolean hasFoundPage(EntityPlayer player, String page, Item itemManual) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.MANUAL_HL) {
            IDiscoveryProvider provider = (IDiscoveryProvider)stack.func_77973_b();
            DiscoveryContainer<ItemStack> container = provider.getContainer(stack);
            ItemStack ingredient = ItemStack.field_190927_a;
            Map<AspectItem, List<AspectManager.AspectItemEntry>> matchedAspects = AspectManager.getRegisteredItems();
            for (Map.Entry<AspectItem, List<AspectManager.AspectItemEntry>> e : matchedAspects.entrySet()) {
                ItemStack itemStack;
                if (e.getKey() == null || !(itemStack = new ItemStack(e.getKey().getOriginal().func_77973_b(), 1, e.getKey().getOriginal().func_77952_i())).func_77977_a().toLowerCase().replace(" ", "").equals(page)) continue;
                ingredient = new ItemStack(e.getKey().getOriginal().func_77973_b(), 1, e.getKey().getOriginal().func_77952_i());
                break;
            }
            if (!ingredient.func_190926_b()) {
                ItemAspectContainer aspectContainer = ItemAspectContainer.fromItem(ingredient, AspectManager.get((World)Minecraft.func_71410_x().field_71441_e));
                return aspectContainer.getAspects(container).size() > 0;
            }
            return false;
        }
        return player != null && page != null && ManualManager.getFoundPages(player, itemManual) != null && ManualManager.getFoundPages(player, itemManual).contains(page);
    }

    public static boolean isFullyDiscovered(EntityPlayer player, String page) {
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.MANUAL_HL) {
            IDiscoveryProvider provider = (IDiscoveryProvider)stack.func_77973_b();
            DiscoveryContainer<ItemStack> container = provider.getContainer(stack);
            ItemStack ingredient = ItemStack.field_190927_a;
            Map<AspectItem, List<AspectManager.AspectItemEntry>> matchedAspects = AspectManager.getRegisteredItems();
            for (Map.Entry<AspectItem, List<AspectManager.AspectItemEntry>> e : matchedAspects.entrySet()) {
                ItemStack itemStack;
                if (e.getKey() == null || !(itemStack = new ItemStack(e.getKey().getOriginal().func_77973_b(), 1, e.getKey().getOriginal().func_77952_i())).func_77977_a().toLowerCase().replace(" ", "").equals(page)) continue;
                ingredient = new ItemStack(e.getKey().getOriginal().func_77973_b(), 1, e.getKey().getOriginal().func_77952_i());
                break;
            }
            if (!ingredient.func_190926_b()) {
                AspectItem aspectItem = AspectManager.getAspectItem(ingredient);
                return container.getDiscoveredStaticAspects(AspectManager.get((World)Minecraft.func_71410_x().field_71441_e), aspectItem).size() == AspectManager.get((World)Minecraft.func_71410_x().field_71441_e).getStaticAspects(aspectItem).size();
            }
            return false;
        }
        return false;
    }

    public static void playerDiscoverPage(EntityPlayer player, String name, Item itemManual) {
        if (!ManualManager.hasFoundPage(player, name, itemManual) && player != null && player.field_71071_by.func_70431_c(new ItemStack(itemManual)) && !player.field_70170_p.field_72995_K && ManualManager.findPage(player, name, itemManual)) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.manual.discover_page", new Object[]{new TextComponentTranslation("manual." + name + ".title", new Object[0])}), true);
        }
    }

    public static void setCurrentPage(String category, int pageNumber, Item itemManual, EntityPlayer player, EnumHand hand) {
        if (player != null && !player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == itemManual && category != null) {
            if (player.func_184586_b(hand).func_77978_p() == null) {
                player.func_184586_b(hand).func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound tagCompound = player.func_184586_b(hand).func_77978_p();
            tagCompound.func_74768_a("page_number", pageNumber);
            tagCompound.func_74778_a("category", category);
            player.func_184586_b(EnumHand.MAIN_HAND).func_77982_d(tagCompound);
        }
    }

    public static int getCurrentPageNumber(ItemStack manual) {
        if (!manual.func_190926_b() && manual.func_77978_p() != null && manual.func_77978_p().func_74764_b("page_number")) {
            return manual.func_77978_p().func_74762_e("page_number");
        }
        return -1;
    }

    @Nullable
    public static ManualCategory getCurrentCategory(ItemStack manual) {
        NBTTagCompound nbt;
        if (!manual.func_190926_b() && (nbt = manual.func_77978_p()) != null && nbt.func_74764_b("category")) {
            return ManualManager.getCategoryFromString(nbt.func_74779_i("category"), manual.func_77973_b());
        }
        return null;
    }

    public static ManualCategory getCategoryFromString(String categoryName, Item itemManual) {
        if (itemManual == ItemRegistry.MANUAL_HL && categoryName != null) {
            for (ManualCategory category : HLEntryRegistry.CATEGORIES) {
                if (!category.getName().equals(categoryName)) continue;
                return category;
            }
        }
        return null;
    }
}

