/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.Collections;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import thebetweenlands.api.entity.spawning.IWeightProvider;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.world.teleporter.TeleporterHandler;
import thebetweenlands.util.WeightedList;

public class PlayerRespawnHandler {
    public static final String RESPAWN_IN_BL_NBT = "thebetweenlands.respawn_in_bl";

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            NBTTagCompound dataNbt = player.getEntityData();
            NBTTagCompound persistentNbt = dataNbt.func_74775_l("PlayerPersisted");
            BlockPos spawnPos = player.getBedLocation(player.field_71093_bK);
            BlockPos adjustedSpawnPos = spawnPos == null ? null : EntityPlayer.func_180467_a((World)player.field_70170_p, (BlockPos)spawnPos, (boolean)player.isSpawnForced(player.field_71093_bK));
            boolean respawnInBL = BetweenlandsConfig.WORLD_AND_DIMENSION.startInBetweenlands && (!player.field_70170_p.field_73011_w.func_76567_e() || adjustedSpawnPos == null);
            persistentNbt.func_74757_a(RESPAWN_IN_BL_NBT, respawnInBL);
            dataNbt.func_74782_a("PlayerPersisted", (NBTBase)persistentNbt);
        }
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            boolean shouldTeleportToBL;
            BlockPos spawnPos = event.player.getBedLocation(event.player.field_71093_bK);
            BlockPos adjustedSpawnPos = spawnPos == null ? null : EntityPlayer.func_180467_a((World)event.player.field_70170_p, (BlockPos)spawnPos, (boolean)event.player.isSpawnForced(event.player.field_71093_bK));
            NBTTagCompound dataNbt = event.player.getEntityData();
            NBTTagCompound persistentNbt = dataNbt.func_74775_l("PlayerPersisted");
            boolean bl = shouldTeleportToBL = BetweenlandsConfig.WORLD_AND_DIMENSION.startInBetweenlands && event.isEndConquered() || persistentNbt.func_74767_n(RESPAWN_IN_BL_NBT);
            if (shouldTeleportToBL && event.player.field_70170_p instanceof WorldServer) {
                WorldServer blWorld = ((WorldServer)event.player.field_70170_p).func_73046_m().func_71218_a(BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId);
                TeleporterHandler.transferToDim((Entity)event.player, (World)blWorld, false, false);
                spawnPos = event.player.getBedLocation(event.player.field_71093_bK);
                BlockPos blockPos = adjustedSpawnPos = spawnPos == null ? null : EntityPlayer.func_180467_a((World)event.player.field_70170_p, (BlockPos)spawnPos, (boolean)event.player.isSpawnForced(event.player.field_71093_bK));
                if (adjustedSpawnPos != null) {
                    event.player.func_70107_b((double)adjustedSpawnPos.func_177958_n() + 0.5, (double)adjustedSpawnPos.func_177956_o(), (double)adjustedSpawnPos.func_177952_p() + 0.5);
                    if (event.player instanceof EntityPlayerMP) {
                        EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
                        playerMP.field_71135_a.func_147364_a(playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v, playerMP.field_70177_z, playerMP.field_70125_A);
                        playerMP.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(adjustedSpawnPos));
                    }
                }
            }
            if (shouldTeleportToBL || event.player.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
                boolean newRespawn = false;
                if (adjustedSpawnPos == null) {
                    newRespawn = true;
                } else {
                    boolean isValidSpawnBlock;
                    IBlockState stateDown = event.player.field_70170_p.func_180495_p(adjustedSpawnPos.func_177977_b());
                    boolean bl2 = isValidSpawnBlock = stateDown.func_185904_a().func_76230_c() && !stateDown.func_177230_c().isLeaves(stateDown, (IBlockAccess)event.player.field_70170_p, adjustedSpawnPos.func_177977_b()) && !stateDown.func_177230_c().isFoliage((IBlockAccess)event.player.field_70170_p, adjustedSpawnPos.func_177977_b());
                    if (!isValidSpawnBlock) {
                        newRespawn = true;
                    }
                }
                if (newRespawn && persistentNbt.func_150297_b("thebetweenlands.last_portal_location", 4)) {
                    BlockPos lastPortal = BlockPos.func_177969_a((long)persistentNbt.func_74763_f("thebetweenlands.last_portal_location"));
                    PlayerRespawnHandler.respawnNearPos((Entity)event.player, lastPortal);
                }
            }
        }
    }

    public static void respawnNearPos(Entity entity, BlockPos pos) {
        BlockPos newSpawn = PlayerRespawnHandler.getRespawnPointNearPos(entity.field_70170_p, pos, 64);
        entity.func_70012_b((double)newSpawn.func_177958_n() + 0.5, (double)newSpawn.func_177956_o(), (double)newSpawn.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        while (!entity.field_70170_p.func_184144_a(entity, entity.func_174813_aQ()).isEmpty() && entity.field_70163_u < 256.0) {
            entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 1.0, entity.field_70161_v);
        }
        newSpawn = new BlockPos(entity);
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_180473_a(newSpawn, true);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            playerMP.field_71135_a.func_147364_a(playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v, playerMP.field_70177_z, playerMP.field_70125_A);
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(newSpawn));
        }
    }

    public static BlockPos getRespawnPointNearPos(World world, BlockPos pos, int fuzz) {
        BlockPos result = PlayerRespawnHandler.getSpawnPointNearPos(world, pos, fuzz, true, 16, 3);
        if (result == null) {
            int spawnFuzz = fuzz;
            int spawnFuzzHalf = spawnFuzz / 2;
            result = world.func_175672_r(pos.func_177982_a(world.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf, 0, world.field_73012_v.nextInt(spawnFuzz) - spawnFuzzHalf));
        }
        return result;
    }

    @Nullable
    public static BlockPos getSpawnPointNearPos(World world, BlockPos pos, int fuzz, boolean surface, int yRange, int xzSkip) {
        xzSkip = Math.max(xzSkip, 1);
        int spawnFuzz = fuzz;
        int spawnFuzzHalf = spawnFuzz / 2;
        short maxWeight = 0;
        class WeightedPos
        implements IWeightProvider {
            final BlockPos pos;
            short weight;

            WeightedPos(BlockPos pos) {
                this.pos = pos;
            }

            @Override
            public short getWeight() {
                return this.weight;
            }
        }
        WeightedList<WeightedPos> spawnCandidates = new WeightedList<WeightedPos>();
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (int xo = -spawnFuzzHalf; xo <= spawnFuzzHalf; xo += 1 + world.field_73012_v.nextInt(xzSkip)) {
            block1: for (int zo = -spawnFuzzHalf; zo <= spawnFuzzHalf; zo += 1 + world.field_73012_v.nextInt(xzSkip)) {
                checkPos.func_181079_c(pos.func_177958_n() + xo, 0, pos.func_177952_p() + zo);
                Chunk chunk = world.func_175726_f((BlockPos)checkPos);
                for (int yo = yRange; surface || yo >= -yRange; --yo) {
                    if (surface) {
                        checkPos.func_181079_c(checkPos.func_177958_n(), chunk.func_177433_f((BlockPos)checkPos), checkPos.func_177952_p());
                    } else {
                        checkPos.func_181079_c(checkPos.func_177958_n(), pos.func_177956_o() + yo, checkPos.func_177952_p());
                    }
                    if (Math.abs(checkPos.func_177956_o() - pos.func_177956_o()) <= yRange && EntityPlayer.func_180467_a((World)world, (BlockPos)checkPos, (boolean)true) != null) {
                        checkPos.func_185336_p(checkPos.func_177956_o() - 1);
                        IBlockState stateDown = chunk.func_177435_g((BlockPos)checkPos);
                        if (stateDown.func_185904_a().func_76230_c() && !stateDown.func_177230_c().isLeaves(stateDown, (IBlockAccess)world, (BlockPos)checkPos) && !stateDown.func_177230_c().isFoliage((IBlockAccess)world, (BlockPos)checkPos)) {
                            BlockPos newPos = checkPos.func_177984_a();
                            WeightedPos p = new WeightedPos(newPos);
                            p.weight = (short)Math.abs(newPos.func_177956_o() - pos.func_177956_o());
                            maxWeight = (short)Math.max(maxWeight, p.weight);
                            spawnCandidates.add(p);
                        }
                    }
                    if (surface) continue block1;
                }
            }
        }
        if (!spawnCandidates.isEmpty()) {
            Collections.shuffle(spawnCandidates, world.field_73012_v);
            for (WeightedPos p : spawnCandidates) {
                p.weight = (short)(maxWeight - p.weight);
                p.weight = (short)Math.pow(p.weight, 1.5);
            }
            spawnCandidates.recalculateWeight();
            return ((WeightedPos)spawnCandidates.getRandomItem((Random)world.field_73012_v)).pos;
        }
        return null;
    }
}

