/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.EnumDifficulty;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import thebetweenlands.api.capability.IDecayCapability;
import thebetweenlands.api.capability.IRotSmellCapability;
import thebetweenlands.common.capability.decay.DecayStats;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.config.properties.ItemDecayFoodProperty;
import thebetweenlands.common.handler.OverworldItemHandler;
import thebetweenlands.common.item.armor.amphibious.AmphibiousArmorUpgrades;
import thebetweenlands.common.item.armor.amphibious.ItemAmphibiousArmor;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;
import thebetweenlands.util.MathUtils;

public class PlayerDecayHandler {
    public static final UUID DECAY_HEALTH_MODIFIER_ATTRIBUTE_UUID = UUID.fromString("033f5f10-67b3-42f3-8511-67a575fbb099");

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IDecayCapability cap;
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.START && (cap = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) != null) {
            DecayStats stats = cap.getDecayStats();
            IAttributeInstance attr = player.func_110148_a(SharedMonsterAttributes.field_111267_a);
            if (attr != null) {
                if (BetweenlandsConfig.GENERAL.decayPercentual) {
                    float decayMaxBaseHealthPercentage = cap.getMaxPlayerHealthPercentage(stats.getDecayLevel());
                    float prevDecayMaxBaseHealthPercentage = cap.getMaxPlayerHealthPercentage(stats.getPrevDecayLevel());
                    AttributeModifier currentDecayModifier = attr.func_111127_a(DECAY_HEALTH_MODIFIER_ATTRIBUTE_UUID);
                    if (!MathUtils.epsilonEquals(decayMaxBaseHealthPercentage, prevDecayMaxBaseHealthPercentage) || currentDecayModifier == null && decayMaxBaseHealthPercentage < 1.0f) {
                        attr.func_188479_b(DECAY_HEALTH_MODIFIER_ATTRIBUTE_UUID);
                        if (decayMaxBaseHealthPercentage < 1.0f) {
                            attr.func_111121_a(new AttributeModifier(DECAY_HEALTH_MODIFIER_ATTRIBUTE_UUID, "Decay health modifier", (double)(-1.0f + decayMaxBaseHealthPercentage), 2));
                        }
                    }
                } else {
                    int prevDecayMaxBaseHealth;
                    int currentMaxHealth = (int)attr.func_111126_e();
                    int decayMaxBaseHealth = (int)(cap.getMaxPlayerHealth(stats.getDecayLevel()) / 2.0f) * 2;
                    boolean decayHealthChange = decayMaxBaseHealth - (prevDecayMaxBaseHealth = (int)(cap.getMaxPlayerHealth(stats.getPrevDecayLevel()) / 2.0f) * 2) != 0;
                    int decayHealthDiff = decayMaxBaseHealth - 20;
                    AttributeModifier currentDecayModifier = attr.func_111127_a(DECAY_HEALTH_MODIFIER_ATTRIBUTE_UUID);
                    if ((float)currentMaxHealth > BetweenlandsConfig.GENERAL.decayMinHealth && decayHealthDiff != 0 && (currentDecayModifier == null || decayHealthDiff != (int)currentDecayModifier.func_111164_d()) || decayHealthChange || (float)currentMaxHealth < BetweenlandsConfig.GENERAL.decayMinHealth && currentDecayModifier != null) {
                        attr.func_188479_b(DECAY_HEALTH_MODIFIER_ATTRIBUTE_UUID);
                        currentMaxHealth = (int)attr.func_111126_e();
                        int newHealth = (int)Math.max((float)(currentMaxHealth + decayHealthDiff), BetweenlandsConfig.GENERAL.decayMinHealth);
                        int attributeHealth = newHealth - currentMaxHealth;
                        if (attributeHealth < 0) {
                            attr.func_111121_a(new AttributeModifier(DECAY_HEALTH_MODIFIER_ATTRIBUTE_UUID, "Decay health modifier", (double)attributeHealth, 0));
                            cap.setRemovedHealth(-attributeHealth);
                        } else {
                            cap.setRemovedHealth(0);
                        }
                    }
                }
            }
            if (cap.isDecayEnabled()) {
                int decay = stats.getDecayLevel();
                if (decay >= 16) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 2, true, false));
                    player.field_70747_aH = 0.001f;
                } else if (decay >= 13) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 1, true, false));
                    player.field_70747_aH = 0.002f;
                } else if (decay >= 10) {
                    player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 0, true, false));
                }
                if (!event.player.func_184218_aH()) {
                    EnumDifficulty difficulty = player.field_70170_p.func_175659_aa();
                    float decayBaseSpeed = PlayerDecayHandler.isTargetSmelly((EntityLivingBase)player) ? PlayerDecayHandler.getDecayBaseSpeed(difficulty) * 1.5f : PlayerDecayHandler.getDecayBaseSpeed(difficulty);
                    float decaySpeed = 0.0f;
                    if (player.field_70140_Q - player.field_70141_P > 0.0f) {
                        decaySpeed += (player.field_70140_Q - player.field_70141_P) * 4.0f * decayBaseSpeed;
                    }
                    BetweenlandsWorldStorage storage = BetweenlandsWorldStorage.forWorld(player.field_70170_p);
                    if (storage.getEnvironmentEventRegistry().heavyRain.isActive() && player.field_70170_p.func_175678_i(player.func_180425_c())) {
                        decaySpeed += decayBaseSpeed;
                    }
                    if (player.func_70090_H()) {
                        decaySpeed += decayBaseSpeed * 2.75f;
                    }
                    if (decaySpeed > 0.0f) {
                        int armorDecayReduction = PlayerDecayHandler.getArmorDecayReduction((EntityLivingBase)player);
                        if (armorDecayReduction > 0) {
                            decaySpeed -= decaySpeed * ((float)armorDecayReduction / 4.0f);
                        }
                        stats.addDecayAcceleration(decaySpeed);
                    }
                }
                stats.onUpdate(player);
            } else {
                stats.setDecayLevel(0);
                stats.setDecaySaturationLevel(1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityAttacked(LivingHurtEvent event) {
        EntityPlayer player;
        IDecayCapability cap;
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving() instanceof EntityPlayer && (cap = (IDecayCapability)(player = (EntityPlayer)event.getEntityLiving()).getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) != null) {
            float decayBaseSpeed = PlayerDecayHandler.getDecayBaseSpeed(player.field_70170_p.func_175659_aa());
            cap.getDecayStats().addDecayAcceleration(decayBaseSpeed * 60.0f);
        }
    }

    public static float getDecayBaseSpeed(EnumDifficulty difficulty) {
        switch (difficulty) {
            case PEACEFUL: {
                return 0.0f;
            }
            case EASY: {
                return 0.0025f;
            }
            default: {
                return 0.0033f;
            }
            case HARD: 
        }
        return 0.005f;
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP && player.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(player.func_145782_y(), (Collection)ImmutableList.of((Object)player.func_110148_a(SharedMonsterAttributes.field_111267_a))));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onUseItemTick(LivingEntityUseItemEvent.Tick event) {
        EntityPlayer player;
        IDecayCapability cap;
        ItemDecayFoodProperty.DecayFoodStats decayFoodStats;
        if (!event.getEntityLiving().func_130014_f_().field_72995_K && event.getDuration() <= 1 && !event.getItem().func_190926_b() && event.getEntityLiving() instanceof EntityPlayer && (decayFoodStats = OverworldItemHandler.getDecayFoodStats(event.getItem())) != null && (cap = (IDecayCapability)(player = (EntityPlayer)event.getEntityLiving()).getCapability(CapabilityRegistry.CAPABILITY_DECAY, null)) != null) {
            cap.getDecayStats().addStats(-decayFoodStats.decay, decayFoodStats.saturation);
        }
    }

    @SubscribeEvent
    public static void onStartUsingItem(LivingEntityUseItemEvent.Start event) {
        if (!event.getItem().func_190926_b() && event.getEntityLiving() instanceof EntityPlayer) {
            boolean isDecayFood;
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            boolean bl = isDecayFood = OverworldItemHandler.getDecayFoodStats(event.getItem()) != null;
            if (isDecayFood) {
                boolean canEatFood = player.func_71024_bL().func_75121_c() && event.getItem().func_77973_b() instanceof ItemFood && ((ItemFood)event.getItem().func_77973_b()).func_150905_g(event.getItem()) > 0;
                boolean canEatDecayFood = false;
                IDecayCapability cap = (IDecayCapability)player.getCapability(CapabilityRegistry.CAPABILITY_DECAY, null);
                if (cap != null) {
                    boolean bl2 = canEatDecayFood = cap.getDecayStats().getDecayLevel() > 0;
                }
                if (!canEatFood && !canEatDecayFood) {
                    event.setDuration(-1);
                    event.setCanceled(true);
                }
            }
        }
    }

    private static boolean isTargetSmelly(EntityLivingBase entity) {
        IRotSmellCapability cap = (IRotSmellCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_ROT_SMELL, null);
        return cap != null && cap.isSmellingBad();
    }

    private static int getArmorDecayReduction(EntityLivingBase entity) {
        int armorCount = 0;
        for (ItemStack armor : entity.func_184193_aE()) {
            if (!(armor.func_77973_b() instanceof ItemAmphibiousArmor) || ((ItemAmphibiousArmor)armor.func_77973_b()).getUpgradeCount(armor, AmphibiousArmorUpgrades.DECAY_DECREASE) < 1) continue;
            ++armorCount;
        }
        return armorCount;
    }
}

