/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import thebetweenlands.common.capability.circlegem.CircleGem;
import thebetweenlands.common.capability.circlegem.CircleGemHelper;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.entity.mobs.EntityCryptCrawler;
import thebetweenlands.common.entity.mobs.EntityPeatMummy;
import thebetweenlands.common.entity.mobs.EntitySwampHag;
import thebetweenlands.common.entity.mobs.EntityTarBeast;
import thebetweenlands.common.entity.mobs.EntityWight;
import thebetweenlands.common.item.equipment.ItemAmulet;

public class EntitySpawnHandler {
    public static final int AMULET_SPAWN_CHANCE = 40;
    public static final List<Class<? extends EntityLivingBase>> AMULET_SPAWNS = new ArrayList<Class<? extends EntityLivingBase>>();

    private EntitySpawnHandler() {
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K) {
            EntityThrowable entityThrown;
            if (entity instanceof EntityArrow) {
                EntityArrow entityArrow = (EntityArrow)entity;
                if (entityArrow.field_70250_c instanceof EntityLivingBase) {
                    EntityLivingBase source = (EntityLivingBase)entityArrow.field_70250_c;
                    EntitySpawnHandler.copyGemModifier(source, (Entity)entityArrow);
                }
            }
            if (entity instanceof EntityThrowable && (entityThrown = (EntityThrowable)entity).func_85052_h() != null) {
                EntitySpawnHandler.copyGemModifier(entityThrown.func_85052_h(), (Entity)entityThrown);
            }
            if (AMULET_SPAWNS.contains(entity.getClass()) && entity.getEntityData() != null && entity.field_70170_p.field_73012_v.nextInt(40) == 0) {
                CircleGemType gem = CircleGemType.TYPES[entity.field_70170_p.field_73012_v.nextInt(CircleGemType.TYPES.length - 1)];
                ItemAmulet.addAmulet(gem, entity, false, false);
            }
        }
    }

    private static void copyGemModifier(EntityLivingBase source, Entity entity) {
        CircleGemType gem;
        ItemStack activeItem = source.func_184607_cu();
        if (activeItem.func_190926_b() && source.func_184600_cs() != null) {
            activeItem = source.func_184586_b(source.func_184600_cs());
        }
        if (activeItem.func_190926_b()) {
            activeItem = source.func_184614_ca();
        }
        if (!activeItem.func_190926_b() && (gem = CircleGemHelper.getGem(activeItem)) != CircleGemType.NONE) {
            CircleGemHelper.addGem(entity, gem, CircleGem.CombatType.OFFENSIVE);
        }
    }

    static {
        AMULET_SPAWNS.add(EntitySwampHag.class);
        AMULET_SPAWNS.add(EntityPeatMummy.class);
        AMULET_SPAWNS.add(EntityTarBeast.class);
        AMULET_SPAWNS.add(EntityWight.class);
        AMULET_SPAWNS.add(EntityCryptCrawler.class);
    }
}

