/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import thebetweenlands.common.entity.mobs.EntityDreadfulMummy;
import thebetweenlands.common.entity.mobs.EntityMultipartDummy;
import thebetweenlands.common.entity.mobs.EntityPeatMummy;

public class EntitySludgeBall
extends EntityThrowable {
    private int bounces = 0;
    private String ownerUUID;
    private boolean breakBlocks;

    public EntitySludgeBall(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.75f);
        this.ownerUUID = "";
        this.breakBlocks = false;
    }

    public EntitySludgeBall(World world, EntityLivingBase owner, boolean breakBlocks) {
        this(world);
        this.ownerUUID = owner.func_110124_au().toString();
        this.field_70192_c = owner;
        this.breakBlocks = breakBlocks;
    }

    public Entity getOwner() {
        try {
            UUID uuid = UUID.fromString(this.ownerUUID);
            return uuid == null ? null : this.getEntityByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    private Entity getEntityByUUID(UUID uuid) {
        for (int i = 0; i < this.func_130014_f_().field_72996_f.size(); ++i) {
            Entity entity = (Entity)this.func_130014_f_().field_72996_f.get(i);
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        double prevMotionX = this.field_70159_w;
        double prevMotionY = this.field_70181_x;
        double prevMotionZ = this.field_70179_y;
        double prevX = this.field_70165_t;
        double prevY = this.field_70163_u;
        double prevZ = this.field_70161_v;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.func_130014_f_().field_72995_K) {
            Vec3d vec3d = new Vec3d(prevX - this.field_70165_t, prevY - this.field_70163_u, prevZ - this.field_70161_v);
            if (vec3d.func_189985_c() < 0.001 && this.field_70173_aa > 10) {
                this.explode();
            }
        }
        this.field_70159_w = prevMotionX;
        this.field_70181_x = prevMotionY;
        this.field_70179_y = prevMotionZ;
        this.func_70107_b(prevX, prevY, prevZ);
        super.func_70071_h_();
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.field_70173_aa < 2) {
            return;
        }
        super.func_70091_d(type, x, y, z);
    }

    protected void func_70184_a(RayTraceResult collision) {
        IBlockState state;
        if (collision.field_72313_a == RayTraceResult.Type.BLOCK && (state = this.func_130014_f_().func_180495_p(collision.func_178782_a())).func_177230_c().func_176209_a(state, false)) {
            ArrayList aabbs = new ArrayList();
            state.func_185908_a(this.field_70170_p, collision.func_178782_a(), this.func_174813_aQ().func_72317_d(this.field_70159_w, this.field_70181_x, this.field_70179_y), aabbs, (Entity)this, true);
            if (!aabbs.isEmpty()) {
                Entity owner;
                if (!this.field_70170_p.field_72995_K && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) && this.bounces == 0 && (owner = this.getOwner()) instanceof EntityLivingBase && this.field_70163_u > owner.func_174813_aQ().field_72337_e && this.field_70181_x > 0.1) {
                    BlockPos pos = collision.func_178782_a();
                    IBlockState hitState = this.field_70170_p.func_180495_p(pos);
                    float hardness = hitState.func_185887_b(this.field_70170_p, pos);
                    if (!hitState.func_177230_c().isAir(hitState, (IBlockAccess)this.field_70170_p, pos) && hardness >= 0.0f && hardness <= 2.5f && hitState.func_177230_c().canEntityDestroy(hitState, (IBlockAccess)this.field_70170_p, pos, (Entity)((EntityLivingBase)owner)) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)((EntityLivingBase)owner), (BlockPos)pos, (IBlockState)hitState)) {
                        this.field_70170_p.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)hitState));
                        this.field_70170_p.func_175698_g(pos);
                        this.explode();
                    }
                }
                if (Math.abs(this.field_70181_x) <= 0.001) {
                    if (this.func_130014_f_().field_72995_K) {
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.0;
                        this.field_70159_w = 0.0;
                    } else {
                        this.explode();
                    }
                }
                if (collision.field_178784_b.func_176740_k() == EnumFacing.Axis.Y) {
                    this.field_70181_x *= -0.9;
                    this.field_70133_I = true;
                    ++this.bounces;
                    if (this.bounces >= 3) {
                        if (this.func_130014_f_().field_72995_K) {
                            this.field_70179_y = 0.0;
                            this.field_70181_x = 0.0;
                            this.field_70159_w = 0.0;
                        } else {
                            this.explode();
                        }
                    } else {
                        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), SoundEvents.field_187886_fs, SoundCategory.HOSTILE, 1.0f, 0.9f);
                        this.spawnBounceParticles(8);
                    }
                } else if (collision.field_178784_b.func_176740_k() == EnumFacing.Axis.Z) {
                    this.field_70179_y *= -0.9;
                    this.field_70133_I = true;
                    ++this.bounces;
                    if (this.bounces >= 3) {
                        if (this.func_130014_f_().field_72995_K) {
                            this.field_70179_y = 0.0;
                            this.field_70181_x = 0.0;
                            this.field_70159_w = 0.0;
                        } else {
                            this.explode();
                        }
                    }
                } else if (collision.field_178784_b.func_176740_k() == EnumFacing.Axis.X) {
                    this.field_70159_w *= -0.9;
                    this.field_70133_I = true;
                    ++this.bounces;
                    if (this.bounces >= 3) {
                        if (this.func_130014_f_().field_72995_K) {
                            this.field_70179_y = 0.0;
                            this.field_70181_x = 0.0;
                            this.field_70159_w = 0.0;
                        } else {
                            this.explode();
                        }
                    }
                }
            }
        }
        if (!(collision.field_72313_a != RayTraceResult.Type.ENTITY || collision.field_72308_g == this.field_70192_c || collision.field_72308_g instanceof EntitySludgeBall || collision.field_72308_g instanceof MultiPartEntityPart || collision.field_72308_g instanceof EntityMultipartDummy || collision.field_72308_g instanceof EntityPeatMummy || collision.field_72308_g instanceof EntityDreadfulMummy)) {
            if (this.attackEntity(collision.field_72308_g)) {
                this.explode();
            } else {
                this.field_70159_w *= -0.1;
                this.field_70181_x *= -0.1;
                this.field_70179_y *= -0.1;
                ++this.bounces;
            }
        }
    }

    private void explode() {
        if (!this.func_130014_f_().field_72995_K) {
            float radius = 3.0f;
            AxisAlignedBB region = new AxisAlignedBB(this.field_70165_t - (double)radius, this.field_70163_u - (double)radius, this.field_70161_v - (double)radius, this.field_70165_t + (double)radius, this.field_70163_u + (double)radius, this.field_70161_v + (double)radius);
            List entities = this.func_130014_f_().func_72839_b((Entity)this, region);
            double radiusSq = radius * radius;
            for (Entity entity : entities) {
                if (!(entity instanceof EntityLivingBase) || entity instanceof EntityPeatMummy || entity instanceof EntityDreadfulMummy || !(this.func_70068_e(entity) < radiusSq)) continue;
                this.attackEntity(entity);
            }
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), SoundEvents.field_187886_fs, SoundCategory.HOSTILE, 1.0f, 0.5f);
            this.func_130014_f_().func_184133_a(null, this.func_180425_c(), SoundEvents.field_187900_fz, SoundCategory.HOSTILE, 1.0f, 0.5f);
            this.func_70106_y();
        } else {
            this.spawnBounceParticles(20);
        }
    }

    private boolean attackEntity(Entity entity) {
        boolean attacked = false;
        Entity owner = this.getOwner();
        attacked = owner != null ? entity.func_70097_a(new EntityDamageSourceIndirect("mob", (Entity)this, owner).func_76349_b(), 8.0f) : entity.func_70097_a(new EntityDamageSource("entity", (Entity)this).func_76349_b(), 8.0f);
        if (!this.field_70170_p.field_72995_K && attacked && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 3));
        }
        return attacked;
    }

    protected float func_70185_h() {
        return 0.08f;
    }

    private void spawnBounceParticles(int amount) {
        for (int i = 0; i <= amount; ++i) {
            this.func_130014_f_().func_175688_a(EnumParticleTypes.SLIME, this.field_70165_t + (double)(amount / 8) * ((double)this.field_70146_Z.nextFloat() - 0.5), this.field_70163_u + 0.3, this.field_70161_v + (double)(amount / 8) * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("bounces", this.bounces);
        nbt.func_74778_a("ownerUUID", this.ownerUUID);
        nbt.func_74757_a("breakBlocks", this.breakBlocks);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.bounces = nbt.func_74762_e("bounces");
        this.ownerUUID = nbt.func_74779_i("ownerUUID");
        this.breakBlocks = nbt.func_74767_n("breakBlocks");
    }
}

