/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.projectiles;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.mobs.EntityBubblerCrab;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityBubblerCrabBubble
extends EntityThrowable {
    private static final byte EVENT_IMPACT = 106;
    private static final byte EVENT_EXPLODE = 107;
    private static final byte EVENT_BIG_EXPLODE = 108;
    private boolean impacted = false;
    private static final DataParameter<Float> STUCK_OFFSET_X = EntityDataManager.func_187226_a(EntityBubblerCrabBubble.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> STUCK_OFFSET_Y = EntityDataManager.func_187226_a(EntityBubblerCrabBubble.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> STUCK_OFFSET_Z = EntityDataManager.func_187226_a(EntityBubblerCrabBubble.class, (DataSerializer)DataSerializers.field_187193_c);
    private boolean updating = false;
    public int swell = 0;

    public EntityBubblerCrabBubble(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityBubblerCrabBubble(World world, EntityLiving entity) {
        super(world, (EntityLivingBase)entity);
    }

    public EntityBubblerCrabBubble(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    public EntityBubblerCrabBubble(World world, EntityPlayer player) {
        super(world, (EntityLivingBase)player);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STUCK_OFFSET_X, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(STUCK_OFFSET_Y, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(STUCK_OFFSET_Z, (Object)Float.valueOf(0.0f));
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.field_70173_aa < 2) {
            return;
        }
        super.func_70091_d(type, x, y, z);
    }

    public void func_70098_U() {
        super.func_70098_U();
        Entity entity = this.func_184187_bx();
        if (this.func_184218_aH() && entity != null) {
            this.func_70107_b(entity.field_70165_t + (double)((Float)this.field_70180_af.func_187225_a(STUCK_OFFSET_X)).floatValue(), entity.field_70163_u + (double)((Float)this.field_70180_af.func_187225_a(STUCK_OFFSET_Y)).floatValue(), entity.field_70161_v + (double)((Float)this.field_70180_af.func_187225_a(STUCK_OFFSET_Z)).floatValue());
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        if (!this.func_184218_aH()) {
            super.func_180426_a(x, y, z, yaw, pitch, posRotationIncrements, teleport);
        }
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        if (super.func_184205_a(entityIn, force)) {
            if (entityIn instanceof EntityPlayer && this.field_70170_p instanceof WorldServer) {
                ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketSetPassengers(entityIn));
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_187227_b(STUCK_OFFSET_X, (Object)Float.valueOf((float)(this.field_70165_t - entityIn.field_70165_t)));
                this.field_70180_af.func_187227_b(STUCK_OFFSET_Y, (Object)Float.valueOf((float)(this.field_70163_u - entityIn.field_70163_u)));
                this.field_70180_af.func_187227_b(STUCK_OFFSET_Z, (Object)Float.valueOf((float)(this.field_70161_v - entityIn.field_70161_v)));
            }
            return true;
        }
        return false;
    }

    public void func_184210_p() {
        Entity entity = this.func_184187_bx();
        super.func_184210_p();
        if (entity instanceof EntityPlayer && this.field_70170_p instanceof WorldServer) {
            ((WorldServer)this.field_70170_p).func_73039_n().func_151247_a((Entity)this, (Packet)new SPacketSetPassengers(entity));
        }
    }

    public void func_70071_h_() {
        double prevPosX = this.field_70165_t;
        double prevPosY = this.field_70163_u;
        double prevPosZ = this.field_70161_v;
        this.updating = true;
        super.func_70071_h_();
        this.updating = false;
        if (this.func_70090_H()) {
            this.field_70159_w *= (double)0.97f;
            this.field_70181_x *= (double)0.97f;
            this.field_70179_y *= (double)0.97f;
        }
        double newX = this.field_70165_t;
        double newY = this.field_70163_u;
        double newZ = this.field_70161_v;
        this.func_70107_b(prevPosX, prevPosY, prevPosZ);
        this.func_70091_d(MoverType.SELF, newX - prevPosX, newY - prevPosY, newZ - prevPosZ);
        this.field_70142_S = this.field_70169_q = prevPosX;
        this.field_70137_T = this.field_70167_r = prevPosY;
        this.field_70136_U = this.field_70166_s = prevPosZ;
        if (this.func_70090_H()) {
            this.field_70181_x += (double)0.033f;
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (this.field_70173_aa >= 120) {
                this.explode(2.0);
                this.func_130014_f_().func_72960_a((Entity)this, (byte)107);
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), (SoundEvent)SoundRegistry.BUBBLER_POP, SoundCategory.HOSTILE, 1.0f, 1.0f);
                this.func_70106_y();
            } else if (this.func_184218_aH() && this.field_70173_aa >= 100) {
                Entity riding = this.func_184187_bx();
                this.func_184210_p();
                if (riding != null) {
                    this.field_70159_w = riding.field_70159_w;
                    this.field_70181_x = riding.field_70181_x;
                    this.field_70179_y = riding.field_70179_y;
                    this.func_70024_g(0.0, 0.075f, 0.0);
                }
            }
        } else if (this.impacted) {
            this.spawnSwellingParticles();
            ++this.swell;
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        } else {
            this.spawnTrailParticles();
        }
    }

    public boolean func_70090_H() {
        return !this.updating && super.func_70090_H();
    }

    protected void func_71061_d_() {
    }

    private void explode(double radius) {
        AxisAlignedBB aoe = this.func_174813_aQ().func_186662_g(radius);
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, aoe);
            for (EntityLivingBase entity : list) {
                float attackDamage;
                if (entity instanceof EntityBubblerCrab || entity.func_190530_aW() || entity.field_70172_ad > 0 || !((double)entity.func_70032_d((Entity)this) <= radius) || !entity.func_70097_a((DamageSource)new EntityDamageSourceIndirect("generic", (Entity)(this.field_70192_c != null ? this.field_70192_c : this), (Entity)this), attackDamage = this.field_70192_c != null && this.field_70192_c.func_110148_a(SharedMonsterAttributes.field_111264_e) != null ? (float)this.field_70192_c.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * 1.5f : 2.0f)) continue;
                entity.field_70159_w *= 0.25;
                entity.field_70179_y *= 0.25;
                entity.func_70024_g(0.0, (double)0.1f, 0.0);
            }
        }
    }

    private float getBubbleRadius() {
        return 0.15f + (float)Math.min(this.swell, 120) * 0.0065f;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnTrailParticles() {
        float radius = this.getBubbleRadius();
        BLParticles.FANCY_BUBBLE.spawn(this.func_130014_f_(), this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), this.field_70163_u + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withColor(0.44f, 0.46f, 0.42f, 0.95f)).withScale(0.5f + this.field_70170_p.field_73012_v.nextFloat() * 0.5f));
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnSwellingParticles() {
        float radius = this.getBubbleRadius();
        if (this.field_70170_p.field_73012_v.nextInt(3) == 0) {
            double ox = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
            double oy = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
            double oz = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
            double velX = ox * (double)this.field_70146_Z.nextFloat() * 0.25;
            double velY = -0.1f;
            double velZ = oz * (double)this.field_70146_Z.nextFloat() * 0.25;
            BLParticles.FANCY_DRIP.spawn(this.func_130014_f_(), this.field_70165_t + ox, this.field_70163_u + (double)(radius * 0.25f) + oy, this.field_70161_v + oz, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(velX, velY, velZ)).withScale(0.5f)).withColor(0.44f, 0.46f, 0.42f, 0.8f));
        }
        if (this.field_70170_p.field_73012_v.nextInt(10) == 0) {
            BLParticles.FANCY_BUBBLE.spawn(this.func_130014_f_(), this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), this.field_70163_u + (double)(radius * 0.5f) + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius * 0.5f), this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.01f, 0.05f, (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * 0.01f)).withScale(0.25f + Math.max(0.0f, this.getBubbleRadius() - 0.2f) * 1.5f + this.field_70170_p.field_73012_v.nextFloat() * 0.5f)).withData(true)).withColor(0.44f, 0.46f, 0.42f, 0.8f));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        double velZ;
        double velY;
        double velX;
        double oz;
        int j;
        int i;
        float radius;
        super.func_70103_a(id);
        if (id == 106) {
            radius = this.getBubbleRadius();
            for (i = 0; i < 8; ++i) {
                BLParticles.FANCY_BUBBLE.spawn(this.func_130014_f_(), this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), this.field_70163_u + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withColor(0.44f, 0.46f, 0.42f, 0.8f));
            }
            this.impacted = true;
        }
        if (id == 107) {
            radius = this.getBubbleRadius();
            for (i = 0; i < 8; ++i) {
                BLParticles.FANCY_BUBBLE.spawn(this.func_130014_f_(), this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), this.field_70163_u + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius), (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withColor(0.44f, 0.46f, 0.42f, 0.9f)).withScale(1.0f + this.field_70170_p.field_73012_v.nextFloat()));
            }
            for (j = 0; j < 25; ++j) {
                double ox = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
                double oy = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
                oz = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
                velX = ox * (double)this.field_70146_Z.nextFloat();
                velY = 0.1f + this.field_70146_Z.nextFloat() * 0.5f;
                velZ = oz * (double)this.field_70146_Z.nextFloat();
                BLParticles.FANCY_DRIP.spawn(this.func_130014_f_(), this.field_70165_t + ox, this.field_70163_u + (double)(radius * 0.25f) + oy, this.field_70161_v + oz, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(velX, velY, velZ)).withScale(0.5f)).withColor(0.44f, 0.46f, 0.42f, 1.0f));
            }
        }
        if (id == 108) {
            radius = this.getBubbleRadius();
            for (i = 0; i < 25; ++i) {
                float ox = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius;
                float oy = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius;
                float oz2 = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) * radius;
                BLParticles.FANCY_BUBBLE.spawn(this.func_130014_f_(), this.field_70165_t + (double)ox, this.field_70163_u + (double)oy, this.field_70161_v + (double)oz2, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(ox * 1.5f, oy * 1.5f + 0.1f, oz2 * 1.5f)).withColor(0.44f, 0.46f, 0.42f, 0.9f)).withScale(1.0f + this.field_70170_p.field_73012_v.nextFloat()));
            }
            for (j = 0; j < 40; ++j) {
                double ox = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
                double oy = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
                oz = (this.field_70146_Z.nextFloat() - 0.5f) * radius * 0.5f;
                velX = ox * (double)this.field_70146_Z.nextFloat() * 3.5;
                velY = 0.1f + this.field_70146_Z.nextFloat() * 0.45f;
                velZ = oz * (double)this.field_70146_Z.nextFloat() * 3.5;
                BLParticles.FANCY_DRIP.spawn(this.func_130014_f_(), this.field_70165_t + ox, this.field_70163_u + (double)(radius * 0.25f) + oy, this.field_70161_v + oz, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(velX, velY, velZ)).withScale(0.75f)).withColor(0.44f, 0.46f, 0.42f, 1.0f));
            }
        }
    }

    protected SoundEvent func_184181_aa() {
        return SoundRegistry.BUBBLER_LAND;
    }

    protected void func_70184_a(RayTraceResult mop) {
        if (!this.field_70170_p.field_72995_K) {
            if (mop.field_72313_a != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                this.field_174854_a = true;
                this.field_70122_E = true;
                this.func_70018_K();
            }
            if (mop.field_72308_g != null && mop.field_72313_a == RayTraceResult.Type.ENTITY && mop.field_72308_g != this.field_70192_c && !(mop.field_72308_g instanceof EntityBubblerCrab)) {
                this.field_174854_a = true;
                this.field_70122_E = true;
                this.func_70018_K();
                if (!this.impacted && !this.func_184218_aH()) {
                    AxisAlignedBB aabb = mop.field_72308_g.func_174813_aQ();
                    Vec3d dir = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72432_b().func_186678_a(1.5);
                    RayTraceResult ray = aabb.func_72327_a(this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O * 0.5f), 0.0).func_178788_d(dir), this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O * 0.5f), 0.0));
                    if (ray == null || ray.field_72307_f == null) {
                        ray = aabb.func_72327_a(this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O * 0.5f), 0.0), this.func_174791_d().func_72441_c(0.0, (double)(this.field_70131_O * 0.5f), 0.0).func_178787_e(dir));
                    }
                    if (ray != null && ray.field_72307_f != null) {
                        this.func_70107_b(ray.field_72307_f.field_72450_a, ray.field_72307_f.field_72448_b, ray.field_72307_f.field_72449_c);
                        this.func_184205_a(mop.field_72308_g, true);
                    }
                }
            }
            if (!this.impacted) {
                this.func_130014_f_().func_72960_a((Entity)this, (byte)106);
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), this.func_184181_aa(), SoundCategory.HOSTILE, 0.5f, 1.0f);
                this.impacted = true;
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity.func_174813_aQ();
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && amount > 0.5f + this.field_70170_p.field_73012_v.nextFloat() * 5.0f) {
            if (this.func_184218_aH()) {
                this.func_184210_p();
            } else {
                this.explode(2.75);
                this.func_130014_f_().func_72960_a((Entity)this, (byte)108);
                this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), (SoundEvent)SoundRegistry.BUBBLER_POP, SoundCategory.HOSTILE, 1.0f, 0.5f);
                this.func_70106_y();
            }
        }
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }
}

