/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.PriorityQueue;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.mobs.EntityClimberBase;
import thebetweenlands.common.entity.movement.CustomPathFinder;
import thebetweenlands.common.entity.movement.ObstructionAwarePathNavigateClimber;
import thebetweenlands.common.entity.movement.ObstructionAwareWalkNodeProcessor;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityStalker
extends EntityClimberBase
implements IMob {
    public static final DataParameter<Boolean> SCREECHING = EntityDataManager.func_187226_a(EntityStalker.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> DROP = EntityDataManager.func_187226_a(EntityStalker.class, (DataSerializer)DataSerializers.field_187198_h);
    protected boolean restrictToPitstone = false;
    protected int maxPathingTargetHeight = 0;
    protected boolean isStalking = true;
    protected float farAnglePathingPenalty = 1.0f;
    protected float farAngle = 90.0f;
    protected float nearAnglePathingPenalty = 2.0f;
    protected float nearAngle = 65.0f;
    protected float stalkingDistanceNear = 4.0f;
    protected float stalkingDistanceFar = 8.0f;
    protected float stalkingDistancePenalty = 4.0f;
    protected boolean isFleeingFromView;
    protected int inViewTimer = 0;
    protected int checkSeenTimer = 20;
    protected boolean canStalkerBeSeen = false;
    public Vec3d eyeRotation;
    public Vec3d prevEyeRotation;
    public Vec3d eyeRotationTarget;
    private int nextEyeRotate;
    public int animationOffset;
    private boolean canCallAllies = true;
    public int screechingTicks = 0;
    public int prevScreechingTicks = 0;

    public EntityStalker(World world) {
        super(world);
        this.field_70728_aV = 30;
        this.maxPathingTargetHeight = 10;
        this.eyeRotation = new Vec3d(0.0, 0.0, 0.0);
        this.prevEyeRotation = new Vec3d(0.0, 0.0, 0.0);
        this.eyeRotationTarget = new Vec3d(0.0, 0.0, 0.0);
        this.animationOffset = this.field_70146_Z.nextInt(200);
        this.nextEyeRotate = 1;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIDropAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIScurry(this, 1.75f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIScreech(this, 80, 160, 1, 3));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIBreakLightSources(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.1, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.75));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 1, false, false, null));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCREECHING, (Object)false);
        this.field_70180_af.func_187214_a(DROP, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData data) {
        if (this.field_70163_u < 48.0 && this.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
            this.restrictToPitstone = true;
        }
        return super.func_180482_a(difficulty, data);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("restrictToPitstone", this.restrictToPitstone);
        nbt.func_74757_a("canCallAllies", this.canCallAllies);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.restrictToPitstone = nbt.func_74767_n("restrictToPitstone");
        this.canCallAllies = nbt.func_74767_n("canCallAllies");
    }

    public void setCanCallAllies(boolean canCall) {
        this.canCallAllies = canCall;
    }

    public boolean canCallAllies() {
        return this.canCallAllies;
    }

    public void setScreeching(boolean screeching) {
        this.field_70180_af.func_187227_b(SCREECHING, (Object)screeching);
    }

    public boolean isScreeching() {
        return (Boolean)this.field_70180_af.func_187225_a(SCREECHING);
    }

    public void setDropping(boolean dropping) {
        this.field_70180_af.func_187227_b(DROP, (Object)dropping);
    }

    public boolean isDropping() {
        return (Boolean)this.field_70180_af.func_187225_a(DROP);
    }

    @Override
    public float getMovementSpeed() {
        return super.getMovementSpeed() + (this.isStalking && this.isFleeingFromView ? 0.25f : 0.0f);
    }

    @Override
    public float getPathingMalus(EntityLiving entity, PathNodeType nodeType, BlockPos pos) {
        float priority = super.func_184643_a(nodeType);
        float penalty = 0.0f;
        if (this.restrictToPitstone && this.field_70163_u > 48.0 && (double)pos.func_177956_o() >= this.field_70163_u) {
            penalty = (float)((double)penalty + Math.min(((double)pos.func_177956_o() - this.field_70163_u) * 0.5, 8.0));
        }
        if (priority >= 0.0f && this.isStalking) {
            int height = 0;
            while (pos.func_177956_o() - height > 0 && this.field_70170_p.func_175623_d(pos.func_177967_a(EnumFacing.DOWN, ++height))) {
            }
            penalty += (float)Math.max(0, 6 - height) * 0.1f;
            EntityLivingBase target = this.func_70638_az();
            if (target != null) {
                Vec3d look = target.func_70676_i(1.0f);
                Vec3d dir = new Vec3d((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)).func_178788_d(target.func_174824_e(1.0f).func_178788_d(look)).func_72432_b();
                float dot = (float)look.func_72430_b(dir);
                float angle = (float)Math.toDegrees(Math.acos(dot));
                penalty += Math.max(0.0f, this.nearAngle - angle) / this.nearAngle * this.nearAnglePathingPenalty;
                penalty += Math.max(0.0f, this.farAngle - this.nearAngle - (angle - this.nearAngle)) / (this.farAngle - this.nearAngle) * this.farAnglePathingPenalty;
                double dst = new Vec3d((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)).func_178788_d(target.func_174824_e(1.0f)).func_72433_c();
                penalty = (float)((double)penalty + (1.0 - (MathHelper.func_151237_a((double)dst, (double)this.stalkingDistanceNear, (double)this.stalkingDistanceFar) - (double)this.stalkingDistanceNear) / (double)(this.stalkingDistanceFar - this.stalkingDistanceNear)) * (double)this.stalkingDistancePenalty);
            }
        }
        return priority + penalty;
    }

    protected boolean isPathNodeAllowed(int x, int y, int z) {
        EntityLivingBase target;
        if (this.restrictToPitstone && this.field_70163_u <= 48.0 && y >= 47) {
            return false;
        }
        if (this.isStalking && (target = this.func_70638_az()) != null) {
            Vec3d dir;
            if (target.func_70011_f((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f)) > (double)this.stalkingDistanceNear) {
                return true;
            }
            Vec3d look = target.func_70676_i(1.0f);
            float dot = (float)look.func_72430_b(dir = this.func_174791_d().func_178788_d(target.func_174824_e(1.0f).func_178788_d(look)).func_72432_b());
            float angle = (float)Math.toDegrees(Math.acos(dot));
            if (angle < this.nearAngle) {
                return new Vec3d((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f)).func_178788_d(target.func_174791_d()).func_72433_c() > this.func_174791_d().func_178788_d(target.func_174791_d()).func_72433_c();
            }
            return false;
        }
        return true;
    }

    @Override
    protected PathNavigate func_175447_b(World worldIn) {
        ObstructionAwarePathNavigateClimber<EntityStalker> navigate = new ObstructionAwarePathNavigateClimber<EntityStalker>(this, worldIn, false, true, true){

            @Override
            public Path func_75494_a(Entity entityIn) {
                BlockPos pos = new BlockPos(entityIn);
                if (EntityStalker.this.isStalking && !EntityStalker.this.isFleeingFromView) {
                    for (int i = 1; i <= EntityStalker.this.maxPathingTargetHeight; ++i) {
                        if (this.func_189566_q().func_186330_a((IBlockAccess)this.field_75513_b, pos.func_177958_n(), pos.func_177956_o() + i, pos.func_177952_p()) != PathNodeType.WALKABLE) continue;
                        pos = pos.func_177981_b(i);
                        break;
                    }
                }
                return this.func_179680_a(pos);
            }

            @Override
            protected CustomPathFinder createPathFinder() {
                ObstructionAwareWalkNodeProcessor<EntityStalker> nodeProcessor = new ObstructionAwareWalkNodeProcessor<EntityStalker>(){

                    @Override
                    public PathNodeType func_186330_a(IBlockAccess blockaccessIn, int x, int y, int z) {
                        if (!EntityStalker.this.isPathNodeAllowed(x, y, z)) {
                            return PathNodeType.BLOCKED;
                        }
                        return super.func_186330_a(blockaccessIn, x, y, z);
                    }
                };
                CustomPathFinder pathFinder = new CustomPathFinder((NodeProcessor)nodeProcessor);
                pathFinder.setMaxExpansions(400);
                pathFinder.setHeuristic((start, end, isTargetHeuristic) -> {
                    EntityLivingBase target;
                    if (isTargetHeuristic && EntityStalker.this.isFleeingFromView && (target = EntityStalker.this.func_70638_az()) != null) {
                        Vec3d look = target.func_70676_i(1.0f);
                        Vec3d diff = new Vec3d((double)((float)start.field_75839_a + 0.5f) - target.field_70165_t, (double)((float)start.field_75837_b + 0.5f) - target.field_70163_u, (double)((float)start.field_75838_c + 0.5f) - target.field_70161_v);
                        float dot = (float)look.func_72430_b(diff);
                        diff = diff.func_178788_d(look.func_186678_a((double)dot));
                        return 8.0f - (float)Math.abs(diff.field_72450_a) - (float)Math.abs(diff.field_72448_b) - (float)Math.abs(diff.field_72449_c);
                    }
                    return CustomPathFinder.DEFAULT_HEURISTIC.compute(start, end, isTargetHeuristic);
                });
                return pathFinder;
            }
        };
        navigate.func_179693_d(true);
        return navigate;
    }

    @Override
    public Vec3d getStickingForce(Pair<EnumFacing, Vec3d> walkingSide) {
        if (this.isDropping()) {
            return new Vec3d(0.0, -0.08, 0.0);
        }
        return super.getStickingForce(walkingSide);
    }

    @Override
    protected boolean canAttachToWalls() {
        return super.canAttachToWalls() && !this.isDropping();
    }

    private boolean canSeePosition(Vec3d start, Vec3d end) {
        return this.field_70170_p.func_147447_a(start, end, false, true, false) == null;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            this.setDropping(false);
        }
        super.func_70071_h_();
        this.prevScreechingTicks = this.screechingTicks++;
        if (this.isScreeching()) {
            if (this.screechingTicks == 40) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.STALKER_SCREECH, SoundCategory.HOSTILE, this.func_70599_aP(), 1.0f);
            }
        } else {
            this.screechingTicks = Math.min(Math.max(this.screechingTicks - 2, 0), 40);
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean wasFleeingFromView = this.isFleeingFromView;
            this.isFleeingFromView = false;
            EntityLivingBase target = this.func_70638_az();
            boolean isPotentiallySeen = false;
            if (this.isStalking) {
                Vec3d dir;
                Vec3d look;
                float dot;
                float angle;
                if (target != null && (angle = (float)Math.toDegrees(Math.acos(dot = (float)(look = target.func_70676_i(1.0f)).func_72430_b(dir = this.func_174791_d().func_178788_d(target.func_174824_e(1.0f).func_178788_d(look)).func_72432_b())))) < this.nearAngle) {
                    isPotentiallySeen = true;
                    AxisAlignedBB aabb = this.func_174813_aQ();
                    Vec3d center = new Vec3d((aabb.field_72340_a + aabb.field_72336_d) * 0.5, (aabb.field_72338_b + aabb.field_72337_e) * 0.5, (aabb.field_72339_c + aabb.field_72334_f) * 0.5);
                    if (this.checkSeenTimer++ >= 20) {
                        this.checkSeenTimer = 0;
                        this.canStalkerBeSeen = false;
                        if (this.canSeePosition(target.func_174824_e(1.0f), center)) {
                            this.canStalkerBeSeen = true;
                        } else {
                            AxisAlignedBB checkAabb = this.func_174813_aQ().func_186662_g(1.0);
                            for (int xo = 0; xo <= 1; ++xo) {
                                block1: for (int yo = 0; yo <= 1; ++yo) {
                                    for (int zo = 0; zo <= 1; ++zo) {
                                        Vec3d checkPos = new Vec3d(xo == 0 ? checkAabb.field_72340_a : checkAabb.field_72336_d, yo == 0 ? checkAabb.field_72338_b : checkAabb.field_72337_e, zo == 0 ? checkAabb.field_72339_c : checkAabb.field_72334_f);
                                        if (!this.canSeePosition(target.func_174824_e(1.0f), checkPos)) continue;
                                        this.canStalkerBeSeen = true;
                                        continue block1;
                                    }
                                }
                            }
                        }
                    }
                    if (this.canStalkerBeSeen) {
                        this.isFleeingFromView = true;
                        if (this.func_70661_as().func_75500_f() && this.field_70173_aa % 10 == 0) {
                            Vec3d right = look.func_72431_c(new Vec3d(0.0, 1.0, 0.0));
                            Vec3d up = right.func_72431_c(look);
                            float rot = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                            float radius = 8.0f;
                            Vec3d offset = right.func_186678_a(Math.cos(rot) * (double)radius).func_178787_e(up.func_186678_a(Math.sin(rot) * (double)radius)).func_178787_e(look.func_186678_a((double)(-radius * 0.5f)));
                            RayTraceResult result = this.field_70170_p.func_147447_a(center, center.func_178787_e(offset), false, true, false);
                            if (result != null && result.field_72307_f != null) {
                                offset = result.field_72307_f;
                            }
                            this.func_70661_as().func_75492_a(this.field_70165_t + offset.field_72450_a, this.field_70163_u + offset.field_72448_b, this.field_70161_v + offset.field_72449_c, 1.0);
                        }
                    }
                }
            } else if (target == null) {
                this.isStalking = true;
            }
            if (!isPotentiallySeen) {
                this.checkSeenTimer = 20;
            }
            if (wasFleeingFromView && !this.isFleeingFromView) {
                this.func_70661_as().func_75499_g();
            }
            if (this.isFleeingFromView && (target == null || this.func_70635_at().func_75522_a((Entity)target))) {
                ++this.inViewTimer;
                if (this.inViewTimer > 200) {
                    this.isStalking = false;
                    if (target != null && this.func_70032_d((Entity)target) < 16.0f) {
                        this.useParalysisAttack(target);
                    }
                }
            } else {
                this.inViewTimer = Math.max(0, this.inViewTimer - 3);
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.func_70106_y();
            }
        } else if (this.screechingTicks > 40 && this.field_70173_aa % 2 == 0) {
            this.spawnScreechingParticles();
        }
        this.prevEyeRotation = this.eyeRotation;
        if ((this.field_70173_aa + this.animationOffset) % this.nextEyeRotate == 0) {
            this.eyeRotationTarget = new Vec3d((double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5);
            this.nextEyeRotate = this.field_70146_Z.nextInt(15) + 20;
        }
        this.eyeRotation = this.eyeRotation.func_178787_e(this.eyeRotationTarget.func_178788_d(this.eyeRotation).func_186678_a(0.5));
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnScreechingParticles() {
        float angle = (float)Math.toRadians(-this.field_70761_aq);
        float ox = MathHelper.func_76126_a((float)angle) * 0.725f;
        float oz = MathHelper.func_76134_b((float)angle) * 0.725f;
        float screechingStrength = MathHelper.func_76131_a((float)((float)(this.screechingTicks - 20) / 30.0f), (float)0.0f, (float)1.0f);
        float screechingHeadRotationStrength = MathHelper.func_76126_a((float)((float)this.field_70173_aa * 0.4f)) * screechingStrength;
        float osx = MathHelper.func_76126_a((float)(angle + 1.5707964f)) * 0.05f * screechingHeadRotationStrength;
        float osz = MathHelper.func_76134_b((float)(angle + 1.5707964f)) * 0.05f * screechingHeadRotationStrength;
        Particle particle = BLParticles.SONIC_SCREAM.create(this.field_70170_p, this.field_70165_t + (double)ox, this.field_70163_u + 1.5, this.field_70161_v + (double)oz, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(osx, 0.3f, osz)).withScale(10.0f)).withData(30, MathHelper.func_76141_d((float)((float)this.field_70173_aa * 3.3f)))).withColor(1.0f, 0.9f, 0.8f, 1.0f));
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING, particle);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (super.func_70097_a(source, amount)) {
            if (this.func_70638_az() != null && source.func_76346_g() == this.func_70638_az()) {
                this.isStalking = false;
            }
            if (amount >= 5.0f && this.isScreeching()) {
                this.setScreeching(false);
            }
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entityIn) {
        return EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, entityIn);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && super.func_70601_bi();
    }

    protected boolean func_146066_aG() {
        return true;
    }

    public void useParalysisAttack(EntityLivingBase target) {
        target.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 3));
        target.func_70690_d(new PotionEffect(ElixirEffectRegistry.ROOT_BOUND, 80, 10));
        this.func_184185_a(SoundRegistry.STALKER_SCREAM, 0.6f, 1.0f);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundRegistry.STALKER_STEP, 1.5f, 1.0f);
    }

    protected SoundEvent func_184639_G() {
        return !this.isStalking ? SoundRegistry.STALKER_LIVING : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.STALKER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.STALKER_DEATH;
    }

    public static class AIScreech
    extends EntityAIBase {
        private final EntityStalker entity;
        private final int minCooldown;
        private final int maxCooldown;
        private final int minAllies;
        private final int maxAllies;
        private int cooldown;
        private int allies;
        private boolean didSpawn;

        public AIScreech(EntityStalker entity, int minCooldown, int maxCooldown, int minAllies, int maxAllies) {
            this.entity = entity;
            this.minCooldown = minCooldown;
            this.maxCooldown = maxCooldown;
            this.minAllies = minAllies;
            this.maxAllies = maxAllies;
            this.func_75248_a(3);
        }

        public boolean func_75252_g() {
            return false;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.entity.func_70638_az();
            return this.cooldown-- <= 0 && !this.entity.isStalking && this.entity.func_110143_aJ() <= this.entity.func_110138_aP() * 0.5f && target != null && this.entity.func_70032_d((Entity)target) > 8.0f && this.entity.canCallAllies();
        }

        public boolean func_75253_b() {
            EntityLivingBase target = this.entity.func_70638_az();
            return !this.entity.isStalking && target != null && this.entity.canCallAllies() && this.entity.isScreeching() && this.allies > 0 && this.entity.screechingTicks < 160;
        }

        public void func_75249_e() {
            this.cooldown = this.minCooldown + this.entity.field_70146_Z.nextInt(this.maxCooldown - this.minCooldown + 1);
            this.entity.setScreeching(true);
            this.allies = this.minAllies + this.entity.field_70146_Z.nextInt(this.maxAllies - this.minAllies + 1);
        }

        public void func_75251_c() {
            this.entity.setScreeching(false);
            if (this.didSpawn) {
                this.entity.setCanCallAllies(false);
            }
        }

        public void func_75246_d() {
            this.entity.setDropping(true);
            if (this.func_75253_b() && this.entity.screechingTicks >= 80) {
                EntityLivingBase target = this.entity.func_70638_az();
                EntitySenses targetSenses = target instanceof EntityLiving ? ((EntityLiving)target).func_70635_at() : null;
                Vec3d targetLook = target.func_70040_Z();
                EntityStalker stalker = null;
                for (int i = 0; i < 32 && this.allies > 0; ++i) {
                    float dx = this.entity.field_70146_Z.nextFloat() - 0.5f;
                    float dy = this.entity.field_70146_Z.nextFloat() - 0.5f;
                    float dz = this.entity.field_70146_Z.nextFloat() - 0.5f;
                    float dst = 8.0f + this.entity.field_70146_Z.nextFloat() * 8.0f;
                    float scale = dst / MathHelper.func_76129_c((float)(dx * dx + dy * dy + dz * dz));
                    BlockPos pos = new BlockPos(target.field_70165_t + (double)(dx *= scale), target.field_70163_u + (double)(dy *= scale), target.field_70161_v + (double)(dz *= scale));
                    for (int j = 0; j < 8 && this.entity.field_70170_p.func_175623_d(pos); ++j) {
                        pos = pos.func_177977_b();
                    }
                    if (this.entity.field_70170_p.func_175623_d(pos) || !this.entity.field_70170_p.func_175623_d(pos.func_177984_a())) continue;
                    pos = pos.func_177984_a();
                    if (stalker == null) {
                        stalker = new EntityStalker(this.entity.field_70170_p);
                    }
                    boolean isBlockedFromSight = true;
                    boolean isNotInView = true;
                    AxisAlignedBB visibilityBox = new AxisAlignedBB(pos).func_186662_g(2.0);
                    block2: for (int xo = 0; xo <= 1; ++xo) {
                        for (int yo = 0; yo <= 1; ++yo) {
                            for (int zo = 0; zo <= 1; ++zo) {
                                double cz;
                                double cy;
                                double cx = xo == 0 ? visibilityBox.field_72340_a : visibilityBox.field_72336_d;
                                Vec3d diff = new Vec3d(cx, cy = yo == 0 ? visibilityBox.field_72338_b : visibilityBox.field_72337_e, cz = zo == 0 ? visibilityBox.field_72339_c : visibilityBox.field_72334_f).func_178788_d(target.func_174824_e(1.0f));
                                if (diff.func_72432_b().func_72430_b(targetLook) > (double)0.1f) {
                                    isNotInView = false;
                                }
                                stalker.func_70012_b(cx, cy + (double)0.1f - (double)stalker.func_70047_e(), cz, 0.0f, 0.0f);
                                if (targetSenses != null && targetSenses.func_75522_a((Entity)stalker) || targetSenses == null && target.func_70685_l((Entity)stalker)) {
                                    isBlockedFromSight = false;
                                }
                                if (!isNotInView && !isBlockedFromSight) break block2;
                            }
                        }
                    }
                    if (!isBlockedFromSight && !isNotInView) continue;
                    stalker.func_70012_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, this.entity.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    if (!stalker.func_70601_bi() || !stalker.func_70058_J()) continue;
                    stalker.setCanCallAllies(false);
                    stalker.func_70624_b(this.entity.func_70638_az());
                    stalker.isStalking = false;
                    this.entity.field_70170_p.func_72838_d((Entity)stalker);
                    stalker = null;
                    --this.allies;
                    this.didSpawn = true;
                }
                if (stalker != null) {
                    stalker.func_70106_y();
                }
            }
        }
    }

    public static class AIDropAttack
    extends EntityAIBase {
        private final EntityStalker entity;
        private float dropRadius = 5.0f;
        private int dropTimer = 0;
        private int waitingTimer = 20;
        private boolean attacked = false;

        public AIDropAttack(EntityStalker entity) {
            this.entity = entity;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            Vec3d diff;
            Vec3d up;
            double diffY;
            EntityLivingBase target = this.entity.func_70638_az();
            boolean inRange = false;
            if (target != null && this.entity.func_70635_at().func_75522_a((Entity)target) && (diffY = (up = new Vec3d(0.0, 1.0, 0.0)).func_72430_b(diff = target.func_174791_d().func_178788_d(this.entity.func_174791_d()))) <= -3.0 && diff.func_178788_d(up.func_186678_a(diffY)).func_72433_c() <= (double)this.dropRadius) {
                inRange = true;
                if (this.dropTimer++ >= 40) {
                    return true;
                }
            }
            if (!inRange) {
                this.dropTimer = Math.max(0, this.dropTimer - 1);
            }
            return false;
        }

        public void func_75246_d() {
            this.entity.func_70661_as().func_75499_g();
            this.entity.func_70605_aq().func_75642_a(this.entity.field_70165_t, this.entity.field_70163_u, this.entity.field_70161_v, 1.0);
            this.entity.setDropping(true);
            this.entity.isStalking = false;
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null) {
                this.entity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                if (this.waitingTimer > 30 && this.entity.field_70122_E && !this.attacked) {
                    this.attacked = true;
                    this.entity.useParalysisAttack(target);
                }
            }
            ++this.waitingTimer;
        }

        public boolean func_75253_b() {
            return this.entity.func_70638_az() != null && this.waitingTimer < 80;
        }

        public void func_75251_c() {
            this.dropTimer = 0;
            this.waitingTimer = 0;
            this.attacked = false;
        }
    }

    public static class AIScurry
    extends EntityAIBase {
        private final EntityStalker entity;
        private final float speed;
        private int maxPathMemory = 32;
        private LinkedHashMap<Pair<Path, Integer>, BlockPos> pathMemory = new LinkedHashMap();
        private Path path;
        private Vec3d scurryingStart;
        private double lastDistance;
        private boolean isScurrying = false;
        private int scurryingCooldown = 0;

        public AIScurry(EntityStalker entity, float speed) {
            this.entity = entity;
            this.speed = speed;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase target;
            if (!this.isScurrying) {
                Path path = this.entity.func_70661_as().func_75505_d();
                if (path != null) {
                    Pair key;
                    double smallestDst = Double.MAX_VALUE;
                    PathPoint closestPathPoint = null;
                    int closestPathPointIndex = 0;
                    for (int i = 0; i < path.func_75873_e(); ++i) {
                        PathPoint point = path.func_75877_a(i);
                        double dst = this.entity.func_70092_e((float)point.field_75839_a + 0.5f, (float)point.field_75837_b + 0.5f, (float)point.field_75838_c + 0.5f);
                        if (!(dst <= smallestDst)) continue;
                        smallestDst = dst;
                        closestPathPoint = point;
                        closestPathPointIndex = i;
                    }
                    if (closestPathPoint != null && !this.pathMemory.containsKey(key = Pair.of((Object)path, (Object)closestPathPointIndex))) {
                        if (this.pathMemory.size() > this.maxPathMemory) {
                            this.pathMemory.remove(this.pathMemory.keySet().iterator().next());
                        }
                        this.pathMemory.put((Pair<Path, Integer>)key, new BlockPos(closestPathPoint.field_75839_a, closestPathPoint.field_75837_b, closestPathPoint.field_75838_c));
                    }
                }
                if (this.entity.isStalking || this.scurryingCooldown++ < 40) {
                    return false;
                }
            }
            if ((target = this.entity.func_70638_az()) != null) {
                Vec3d dir = this.entity.func_174824_e(1.0f).func_178788_d(target.func_174824_e(1.0f)).func_72432_b();
                float angle = (float)Math.toDegrees(Math.acos(dir.func_72430_b(target.func_70676_i(1.0f))));
                return angle < 5.0f;
            }
            return false;
        }

        public void func_75249_e() {
            PathPoint finalPoint;
            this.scurryingCooldown = 0;
            this.isScurrying = true;
            PathPoint pathPoint = finalPoint = this.path != null ? this.path.func_75870_c() : null;
            this.scurryingStart = this.entity.func_70638_az() != null ? this.entity.func_70638_az().func_174791_d() : (finalPoint != null ? new Vec3d((double)((float)finalPoint.field_75839_a + 0.5f), (double)((float)finalPoint.field_75837_b + 0.5f), (double)((float)finalPoint.field_75838_c + 0.5f)) : this.entity.func_174791_d());
            PathPoint[] pathPoints = new PathPoint[this.pathMemory.size()];
            double furthestPathPosDst = 0.0;
            BlockPos furthestPathPos = null;
            int i = 0;
            for (BlockPos pos : this.pathMemory.values()) {
                pathPoints[this.pathMemory.size() - ++i] = new PathPoint(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                double dst = pos.func_185332_f((int)this.scurryingStart.field_72450_a, (int)this.scurryingStart.field_72448_b, (int)this.scurryingStart.field_72449_c);
                if (!(dst > furthestPathPosDst)) continue;
                furthestPathPosDst = dst;
                furthestPathPos = pos;
            }
            if (furthestPathPos != null) {
                this.path = this.entity.func_70661_as().func_179680_a(furthestPathPos);
            }
            if (this.path == null) {
                this.path = new Path(pathPoints);
            }
            int j = 0;
            while (true) {
                if (this.path != null && this.path.func_75874_d() >= 6) {
                    PathPoint pathPoint2 = new PathPoint((int)this.scurryingStart.field_72450_a, (int)this.scurryingStart.field_72448_b, (int)this.scurryingStart.field_72449_c);
                    if (!(this.path.func_75870_c().func_75829_a(pathPoint2) < 6.0f)) break;
                }
                if (j >= 3) break;
                Vec3d dir = this.entity.func_174791_d().func_178788_d(this.scurryingStart).func_178787_e(this.entity.func_70040_Z().func_186678_a(-0.25)).func_72432_b();
                Vec3d right = dir.func_72431_c(new Vec3d(0.0, 1.0, 0.0));
                Vec3d up = right.func_72431_c(dir);
                Vec3d target = this.entity.func_174791_d().func_178787_e(dir.func_186678_a(32.0).func_178787_e(right.func_186678_a((double)((this.entity.field_70146_Z.nextFloat() - 0.5f) * 16.0f))).func_178787_e(up.func_186678_a((double)((this.entity.field_70146_Z.nextFloat() - 0.5f) * 16.0f))));
                this.path = this.entity.func_70661_as().func_75488_a(target.field_72450_a, target.field_72448_b, target.field_72449_c);
                ++j;
            }
            this.entity.func_70642_aH();
        }

        public void func_75246_d() {
            if (this.path != null) {
                PathPoint finalPoint = this.path.func_75870_c();
                if (finalPoint == null || this.entity.field_70173_aa % 20 == 0 && this.entity.func_70661_as().func_179680_a(new BlockPos(finalPoint.field_75839_a, finalPoint.field_75837_b, finalPoint.field_75838_c)) == null) {
                    this.isScurrying = false;
                } else {
                    this.entity.func_70661_as().func_75484_a(this.path, (double)this.speed);
                }
            }
        }

        public boolean func_75253_b() {
            double distance;
            if (this.scurryingStart != null) {
                distance = this.scurryingStart.func_72438_d(this.entity.func_174791_d());
                if (distance < this.lastDistance - 1.0) {
                    return false;
                }
            } else {
                return false;
            }
            this.lastDistance = Math.max(this.lastDistance, distance);
            return this.isScurrying && this.path != null && !this.path.func_75879_b();
        }

        public void func_75251_c() {
            this.isScurrying = false;
            this.scurryingStart = null;
            this.lastDistance = 0.0;
            this.path = null;
            this.pathMemory.clear();
            this.entity.func_70661_as().func_75499_g();
        }
    }

    public static class AIBreakLightSources
    extends EntityAIBase {
        private static final Set<Block> IGNORED_LIGHT_SOURCES = ImmutableSet.of((Object)BlockRegistry.OCTINE_ORE, (Object)BlockRegistry.LIFE_CRYSTAL_STALACTITE, (Object)BlockRegistry.MOB_SPAWNER);
        private final EntityStalker entity;
        private BlockPos lightSourcePos = null;
        private int failCount = 0;
        private Path path;

        public AIBreakLightSources(EntityStalker entity) {
            this.entity = entity;
            this.func_75248_a(3);
        }

        @Nullable
        private RayTraceResult rayTraceBlockLight(Vec3d start, Vec3d end) {
            if (!(Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c))) {
                if (!(Double.isNaN(end.field_72450_a) || Double.isNaN(end.field_72448_b) || Double.isNaN(end.field_72449_c))) {
                    int ex = MathHelper.func_76128_c((double)end.field_72450_a);
                    int ey = MathHelper.func_76128_c((double)end.field_72448_b);
                    int ez = MathHelper.func_76128_c((double)end.field_72449_c);
                    int sx = MathHelper.func_76128_c((double)start.field_72450_a);
                    int sy = MathHelper.func_76128_c((double)start.field_72448_b);
                    int sz = MathHelper.func_76128_c((double)start.field_72449_c);
                    BlockPos pos = new BlockPos(sx, sy, sz);
                    IBlockState state = this.entity.field_70170_p.func_180495_p(pos);
                    if (this.entity.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, pos) > 0 || state.func_185890_d((IBlockAccess)this.entity.field_70170_p, pos) != Block.field_185506_k && state.func_177230_c().func_176209_a(state, false)) {
                        RayTraceResult result = state.func_185910_a(this.entity.field_70170_p, pos, start, end);
                        if (result != null) {
                            return result;
                        }
                        return new RayTraceResult(new Vec3d((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)), EnumFacing.UP, pos);
                    }
                    int steps = 200;
                    while (steps-- >= 0) {
                        EnumFacing hitFacing;
                        if (Double.isNaN(start.field_72450_a) || Double.isNaN(start.field_72448_b) || Double.isNaN(start.field_72449_c)) {
                            return null;
                        }
                        if (sx == ex && sy == ey && sz == ez) {
                            return null;
                        }
                        boolean xDiff = true;
                        boolean yDiff = true;
                        boolean zDiff = true;
                        double newX = 999.0;
                        double newY = 999.0;
                        double newZ = 999.0;
                        if (ex > sx) {
                            newX = (double)sx + 1.0;
                        } else if (ex < sx) {
                            newX = (double)sx + 0.0;
                        } else {
                            xDiff = false;
                        }
                        if (ey > sy) {
                            newY = (double)sy + 1.0;
                        } else if (ey < sy) {
                            newY = (double)sy + 0.0;
                        } else {
                            yDiff = false;
                        }
                        if (ez > sz) {
                            newZ = (double)sz + 1.0;
                        } else if (ez < sz) {
                            newZ = (double)sz + 0.0;
                        } else {
                            zDiff = false;
                        }
                        double offsetX = 999.0;
                        double offsetY = 999.0;
                        double offsetZ = 999.0;
                        double dx = end.field_72450_a - start.field_72450_a;
                        double dy = end.field_72448_b - start.field_72448_b;
                        double dz = end.field_72449_c - start.field_72449_c;
                        if (xDiff) {
                            offsetX = (newX - start.field_72450_a) / dx;
                        }
                        if (yDiff) {
                            offsetY = (newY - start.field_72448_b) / dy;
                        }
                        if (zDiff) {
                            offsetZ = (newZ - start.field_72449_c) / dz;
                        }
                        if (offsetX == -0.0) {
                            offsetX = -1.0E-4;
                        }
                        if (offsetY == -0.0) {
                            offsetY = -1.0E-4;
                        }
                        if (offsetZ == -0.0) {
                            offsetZ = -1.0E-4;
                        }
                        if (offsetX < offsetY && offsetX < offsetZ) {
                            hitFacing = ex > sx ? EnumFacing.WEST : EnumFacing.EAST;
                            start = new Vec3d(newX, start.field_72448_b + dy * offsetX, start.field_72449_c + dz * offsetX);
                        } else if (offsetY < offsetZ) {
                            hitFacing = ey > sy ? EnumFacing.DOWN : EnumFacing.UP;
                            start = new Vec3d(start.field_72450_a + dx * offsetY, newY, start.field_72449_c + dz * offsetY);
                        } else {
                            hitFacing = ez > sz ? EnumFacing.NORTH : EnumFacing.SOUTH;
                            start = new Vec3d(start.field_72450_a + dx * offsetZ, start.field_72448_b + dy * offsetZ, newZ);
                        }
                        sx = MathHelper.func_76128_c((double)start.field_72450_a) - (hitFacing == EnumFacing.EAST ? 1 : 0);
                        sy = MathHelper.func_76128_c((double)start.field_72448_b) - (hitFacing == EnumFacing.UP ? 1 : 0);
                        sz = MathHelper.func_76128_c((double)start.field_72449_c) - (hitFacing == EnumFacing.SOUTH ? 1 : 0);
                        pos = new BlockPos(sx, sy, sz);
                        IBlockState offsetState = this.entity.field_70170_p.func_180495_p(pos);
                        if (this.entity.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, pos) <= 0 && (offsetState.func_185890_d((IBlockAccess)this.entity.field_70170_p, pos) == Block.field_185506_k || !offsetState.func_177230_c().func_176209_a(state, false))) continue;
                        RayTraceResult result = offsetState.func_185910_a(this.entity.field_70170_p, pos, start, end);
                        if (result != null) {
                            return result;
                        }
                        return new RayTraceResult(new Vec3d((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)), EnumFacing.UP, pos);
                    }
                    return null;
                }
                return null;
            }
            return null;
        }

        @Nullable
        private BlockPos findLightSource(BlockPos pos, int maxChecks) {
            int lightValue = this.entity.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, pos);
            if (lightValue > 0) {
                HashSet<BlockPos> checked = new HashSet<BlockPos>();
                PriorityQueue<Pair> queue = new PriorityQueue<Pair>(1, (p1, p2) -> -Integer.compare((Integer)p1.getRight(), (Integer)p2.getRight()));
                queue.add(Pair.of((Object)pos, (Object)lightValue));
                while (!queue.isEmpty() && maxChecks-- > 0) {
                    Pair queueEntry = (Pair)queue.remove();
                    BlockPos queuePos = (BlockPos)queueEntry.getLeft();
                    int queueLight = (Integer)queueEntry.getRight();
                    IBlockState state = this.entity.field_70170_p.func_180495_p(queuePos);
                    if (state.getLightValue((IBlockAccess)this.entity.field_70170_p, queuePos) > 0) {
                        return queuePos;
                    }
                    for (EnumFacing offset : EnumFacing.field_82609_l) {
                        BlockPos offsetPos = queuePos.func_177972_a(offset);
                        if (!this.entity.field_70170_p.func_175668_a(offsetPos, false) || (lightValue = this.entity.field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, offsetPos)) <= queueLight || !checked.add(offsetPos)) continue;
                        queue.add(Pair.of((Object)offsetPos, (Object)lightValue));
                    }
                }
            }
            return null;
        }

        private boolean isTargetLightSource(BlockPos pos) {
            IBlockState state;
            EntityLivingBase target = this.entity.func_70638_az();
            if (target != null) {
                Vec3d dir;
                if (target.func_174818_b(pos) < (double)(this.entity.stalkingDistanceFar * this.entity.stalkingDistanceFar)) {
                    return false;
                }
                Vec3d look = target.func_70676_i(1.0f);
                float dot = (float)look.func_72430_b(dir = new Vec3d((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f)).func_178788_d(target.func_174824_e(1.0f).func_178788_d(look)).func_72432_b());
                float angle = (float)Math.toDegrees(Math.acos(dot));
                if (angle < this.entity.farAngle) {
                    return false;
                }
            }
            if (!IGNORED_LIGHT_SOURCES.contains((state = this.entity.field_70170_p.func_180495_p(pos)).func_177230_c())) {
                float hardness = state.func_185887_b(this.entity.field_70170_p, pos);
                return this.entity.field_70170_p.func_180495_p(pos).getLightValue((IBlockAccess)this.entity.field_70170_p, pos) > 0 && hardness >= 0.0f && hardness <= 2.5f && state.func_177230_c().canEntityDestroy(state, (IBlockAccess)this.entity.field_70170_p, pos, (Entity)this.entity);
            }
            return false;
        }

        public boolean func_75250_a() {
            if (this.entity.isStalking && this.entity.field_70173_aa % 10 == 0 && ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity)) {
                BlockPos lightPos;
                Vec3d end;
                float checkRange = 32.0f;
                Vec3d start = this.entity.func_174824_e(1.0f);
                RayTraceResult result = this.rayTraceBlockLight(start, end = start.func_178787_e(new Vec3d((double)(this.entity.field_70146_Z.nextFloat() - 0.5f), (double)(this.entity.field_70146_Z.nextFloat() - 0.5f), (double)(this.entity.field_70146_Z.nextFloat() - 0.5f)).func_72432_b().func_186678_a((double)checkRange)));
                if (result != null && (lightPos = this.findLightSource(result.func_178782_a(), 32)) != null && this.isTargetLightSource(lightPos) && this.entity.func_70661_as().func_75488_a((double)((float)lightPos.func_177958_n() + 0.5f), (double)((float)lightPos.func_177956_o() + 0.5f), (double)((float)lightPos.func_177952_p() + 0.5f)) != null) {
                    this.lightSourcePos = lightPos;
                }
                return this.lightSourcePos != null;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.entity.isStalking && this.lightSourcePos != null && this.isTargetLightSource(this.lightSourcePos) && ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity) && this.failCount <= 5;
        }

        public void func_75251_c() {
            this.lightSourcePos = null;
            this.failCount = 0;
            this.entity.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            if (this.lightSourcePos != null) {
                if (this.failCount == 0 || this.entity.field_70173_aa % 20 == 0) {
                    this.failCount = !this.entity.func_70661_as().func_75492_a((double)((float)this.lightSourcePos.func_177958_n() + 0.5f), (double)((float)this.lightSourcePos.func_177956_o() + 0.5f), (double)((float)this.lightSourcePos.func_177952_p() + 0.5f), 1.0) ? ++this.failCount : 1;
                }
                if (this.entity.func_70011_f((float)this.lightSourcePos.func_177958_n() + 0.5f, (float)this.lightSourcePos.func_177956_o() + 0.5f - this.entity.field_70131_O / 2.0f, (float)this.lightSourcePos.func_177952_p() + 0.5f) < 2.0) {
                    IBlockState state = this.entity.field_70170_p.func_180495_p(this.lightSourcePos);
                    if (ForgeEventFactory.getMobGriefingEvent((World)this.entity.field_70170_p, (Entity)this.entity) && this.isTargetLightSource(this.lightSourcePos) && ForgeEventFactory.onEntityDestroyBlock((EntityLivingBase)this.entity, (BlockPos)this.lightSourcePos, (IBlockState)state)) {
                        state.func_177230_c().func_180653_a(this.entity.field_70170_p, this.lightSourcePos, state, 1.0f, 0);
                        this.entity.field_70170_p.func_175698_g(this.lightSourcePos);
                    } else {
                        this.lightSourcePos = null;
                    }
                }
            }
        }
    }
}

