/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.EntitySplodeshroom;
import thebetweenlands.common.entity.ai.EntityAIFollowTarget;
import thebetweenlands.common.entity.ai.EntityAIJumpRandomly;
import thebetweenlands.common.entity.mobs.EntityRootSprite;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class EntitySporeling
extends EntityCreature
implements IEntityBL {
    private float jumpHeightOverride = -1.0f;
    protected static final DataParameter<Boolean> IS_FALLING = EntityDataManager.func_187226_a(EntitySporeling.class, (DataSerializer)DataSerializers.field_187198_h);
    protected float prevFloatingRotationTicks = 0.0f;
    protected float floatingRotationTicks = 0.0f;
    private EntityAIAvoidEntity<EntityLivingBase> aiRunAway;
    private EntityAIFollowTarget moveToTarget;
    private boolean canFollow = false;

    public EntitySporeling(World world) {
        super(world);
        this.func_70105_a(0.3f, 0.6f);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 1;
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_FALLING, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.aiRunAway = new EntityAIAvoidEntity((EntityCreature)this, EntityLivingBase.class, entity -> entity instanceof EntityMob || entity instanceof IMob || entity instanceof EntityPlayer && !((EntityPlayer)entity).func_184812_l_(), 10.0f, 0.5, 1.0);
        this.moveToTarget = new EntityAIFollowTarget((EntityLiving)this, new EntityAIFollowTarget.FollowClosest<EntityPlayer>((EntityLiving)this, EntityPlayer.class, 16.0), 1.0, 0.5f, 16.0f, false);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(2, this.aiRunAway);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowTarget((EntityLiving)this, new EntityAIFollowTarget.FollowClosest<EntityRootSprite>((EntityLiving)this, EntityRootSprite.class, 10.0), 0.65, 0.5f, 10.0f, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIJumpRandomly((EntityLiving)this, 10, () -> !this.field_70170_p.func_72872_a(EntityRootSprite.class, this.func_174813_aQ().func_186662_g(1.0)).isEmpty()){

            @Override
            public void func_75249_e() {
                EntitySporeling.this.setJumpHeightOverride(0.2f);
                EntitySporeling.this.func_70683_ar().func_75660_a();
            }
        });
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.49);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            BLParticles.REDSTONE_DUST.spawn(this.field_70170_p, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O - 0.25, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withColor(0.5f + this.field_70146_Z.nextFloat() * 0.5f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f, 0.5f + this.field_70146_Z.nextFloat() * 0.5f, 1.0f));
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.func_70090_H()) {
                boolean canSpin;
                boolean bl = (this.func_184187_bx() != null ? !this.func_184187_bx().field_70122_E : !this.field_70122_E) && !this.field_70134_J && !this.func_70090_H() && !this.func_180799_ab() && this.field_70170_p.func_175623_d(this.func_180425_c().func_177977_b()) ? true : (canSpin = false);
                if (canSpin && (this.field_70181_x < 0.0 || this.func_184187_bx() != null && this.func_184187_bx().field_70181_x < 0.0)) {
                    if (!this.getIsFalling()) {
                        this.setIsFalling(true);
                    }
                    this.field_70181_x *= 0.7;
                    if (this.func_184187_bx() != null) {
                        this.func_184187_bx().field_70181_x *= 0.7;
                        this.func_184187_bx().field_70143_R = 0.0f;
                    }
                } else if (!canSpin && this.getIsFalling()) {
                    this.setIsFalling(false);
                }
            }
            if (this.func_184207_aI() && this.func_184188_bt().get(0) instanceof EntitySplodeshroom && !this.canFollow) {
                this.field_70714_bg.func_85156_a(this.aiRunAway);
                this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.moveToTarget);
                this.canFollow = true;
            }
            if (!this.func_184207_aI() && this.canFollow) {
                this.field_70714_bg.func_75776_a(2, this.aiRunAway);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.moveToTarget);
                this.canFollow = false;
            }
        }
        this.prevFloatingRotationTicks = this.floatingRotationTicks;
        if (this.getIsFalling()) {
            this.floatingRotationTicks += 30.0f;
            float wrap = MathHelper.func_76142_g((float)this.floatingRotationTicks) - this.floatingRotationTicks;
            this.floatingRotationTicks += wrap;
            this.prevFloatingRotationTicks += wrap;
        } else {
            this.floatingRotationTicks = 0.0f;
        }
        super.func_70071_h_();
    }

    public float smoothedAngle(float partialTicks) {
        return this.prevFloatingRotationTicks + (this.floatingRotationTicks - this.prevFloatingRotationTicks) * partialTicks;
    }

    private float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = MathHelper.func_76142_g((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }

    private void setIsFalling(boolean state) {
        this.field_70180_af.func_187227_b(IS_FALLING, (Object)state);
    }

    public boolean getIsFalling() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FALLING);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public int func_70641_bl() {
        return 1;
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.SPORELING_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundRegistry.SPORELING_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SPORELING_DEATH;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.SPORELING;
    }

    public void setJumpHeightOverride(float jumpHeightOverride) {
        this.jumpHeightOverride = jumpHeightOverride;
    }

    protected float func_175134_bD() {
        if (this.jumpHeightOverride > 0.0f) {
            float height = this.jumpHeightOverride;
            this.jumpHeightOverride = -1.0f;
            return height;
        }
        return super.func_175134_bD();
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.func_70089_S() && this.isBloodSkiesActive(this.field_70170_p)) {
                EntitySplodeshroom shroom = new EntitySplodeshroom(this.field_70170_p);
                shroom.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!this.field_70170_p.func_72953_d(shroom.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)shroom, shroom.func_174813_aQ()).isEmpty()) {
                    shroom.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v)), null);
                    this.field_70170_p.func_72838_d((Entity)shroom);
                    shroom.func_184220_m((Entity)this);
                }
            } else {
                this.canFollow = true;
            }
        }
        return livingdata;
    }

    public boolean isBloodSkiesActive(World world) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        return worldStorage.getEnvironmentEventRegistry().bloodSky.isActive();
    }
}

