/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.entity.mobs.EntityRockSnot;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.PlayerUtil;

public class EntityRockSnotTendril
extends Entity
implements IEntityAdditionalSpawnData {
    public EntityRockSnot parent;
    private static final DataParameter<Boolean> IS_EXTENDING = EntityDataManager.func_187226_a(EntityRockSnotTendril.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityRockSnotTendril(World world) {
        super(world);
        this.func_70105_a(0.25f, 0.25f);
        this.parent = null;
    }

    public EntityRockSnotTendril(EntityRockSnot parent) {
        super(parent.getWorld());
        this.func_70105_a(0.25f, 0.25f);
        this.parent = parent;
        this.field_70158_ak = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_EXTENDING, (Object)false);
    }

    public boolean getExtending() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_EXTENDING);
    }

    public void setExtending(boolean extending) {
        this.field_70180_af.func_187227_b(IS_EXTENDING, (Object)extending);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_EXTENDING.equals(key)) {
            this.setExtending(this.getExtending());
        }
        super.func_184206_a(key);
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K && (this.getParentEntity() == null || this.getParentEntity().field_70128_L)) {
            this.func_70106_y();
        }
        this.checkCollision();
        if (this.parent != null && !this.getExtending()) {
            this.returnToParent();
            if (this.func_174813_aQ().func_72326_a(this.parent.func_174813_aQ())) {
                if (this.field_70165_t != this.parent.field_70165_t || this.field_70161_v != this.parent.field_70161_v) {
                    this.func_70107_b(this.parent.field_70165_t, this.parent.field_70163_u + (double)this.parent.field_70131_O * 0.5, this.parent.field_70161_v);
                }
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
                if (!this.func_130014_f_().field_72995_K) {
                    if (this.func_184207_aI() && !this.parent.func_184207_aI()) {
                        Entity entity = (Entity)this.func_184188_bt().get(0);
                        entity.func_184205_a((Entity)this.parent, true);
                    }
                    this.func_70106_y();
                    this.parent.setTendrilCount(this.parent.getTendrilCount() - 1);
                }
            }
        }
        if ((this.parent != null && !this.func_184207_aI() && this.field_70173_aa > 20 || this.parent != null && this.field_70124_G) && !this.func_130014_f_().field_72995_K && this.getExtending()) {
            this.setExtending(false);
        }
        if (this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82737_E() % 5L == 0L) {
            this.spawnDrips();
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 1.0;
        this.field_70181_x *= 1.0;
        this.field_70179_y *= 1.0;
        super.func_70071_h_();
    }

    public void moveToTarget(double targetX, double targetY, double targetZ, float velocity) {
        float distSq = MathHelper.func_76133_a((double)(targetX * targetX + targetY * targetY + targetZ * targetZ));
        targetX /= (double)distSq;
        targetY /= (double)distSq;
        targetZ /= (double)distSq;
        this.field_70159_w = targetX *= (double)velocity;
        this.field_70181_x = targetY *= (double)velocity;
        this.field_70179_y = targetZ *= (double)velocity;
        float angle = MathHelper.func_76133_a((double)(targetX * targetX + targetZ * targetZ));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)targetX, (double)targetZ) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)targetY, (double)angle) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    protected Entity checkCollision() {
        if (this.parent != null) {
            List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.func_174813_aQ());
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity == null || !(entity instanceof EntityLivingBase) || entity instanceof EntityRockSnot || entity instanceof EntityRockSnotTendril || entity instanceof EntityLurker || !entity.func_184222_aU()) continue;
                if (entity instanceof EntityPlayer && this.parent.getPlacedByPlayer() || this.parent.func_184207_aI()) {
                    return null;
                }
                if (this.func_184207_aI()) continue;
                if (!this.func_130014_f_().field_72995_K) {
                    entity.func_184205_a((Entity)this, true);
                    this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.ROCK_SNOT_ATTACH, SoundCategory.HOSTILE, 1.0f, 1.0f);
                    if (this.getExtending()) {
                        this.setExtending(false);
                    }
                }
                this.returnToParent();
            }
        }
        return null;
    }

    public void returnToParent() {
        double targetX = this.parent.field_70165_t - this.field_70165_t;
        double targetY = this.parent.field_70163_u + (double)this.parent.field_70131_O * 0.5 - this.field_70163_u + (double)this.field_70131_O * 0.5;
        double targetZ = this.parent.field_70161_v - this.field_70161_v;
        this.moveToTarget(targetX, targetY, targetZ, 0.25f);
    }

    public void func_184232_k(Entity entity) {
        PlayerUtil.resetFloating(entity);
        if (entity instanceof EntityLivingBase) {
            entity.func_70107_b(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v);
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void func_70037_a(NBTTagCompound compound) {
    }

    public void func_70014_b(NBTTagCompound compound) {
    }

    public EntityRockSnot getParentEntity() {
        return this.parent;
    }

    public void writeSpawnData(ByteBuf buffer) {
        if (this.getParentEntity() != null) {
            buffer.writeInt(this.getParentEntity().func_145782_y());
        }
    }

    public void readSpawnData(ByteBuf buffer) {
        if (buffer.isReadable()) {
            EntityRockSnot parentEntityIn;
            int parentEntityID = buffer.readInt();
            this.parent = parentEntityIn = (EntityRockSnot)this.field_70170_p.func_73045_a(parentEntityID);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(10.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnDrips() {
        double x = this.field_70165_t + (double)this.field_70146_Z.nextFloat() * 0.25;
        double y = this.field_70163_u;
        double z = this.field_70161_v + (double)this.field_70146_Z.nextFloat() * 0.25;
        BLParticles.RAIN.spawn(this.field_70170_p, x, y, z).func_70538_b(0.4118f, 0.2745f, 0.1568f);
    }
}

