/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.model.ControlledAnimation;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.ai.EntityAIFlyingWander;
import thebetweenlands.common.entity.movement.FlightMoveHelper;
import thebetweenlands.common.entity.movement.PathNavigateFlyingBL;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityPuffin
extends EntityCreature
implements IEntityBL {
    private static final DataParameter<Boolean> IS_HOVERING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_DIVING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_LANDING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_FLYING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SHOULD_LAND = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SHOULD_TAKE_OFF = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> FLYING_TIMER = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RESTING_TIMER = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IS_FISHING = EntityDataManager.func_187226_a(EntityPuffin.class, (DataSerializer)DataSerializers.field_187198_h);
    public float animTime;
    public float prevAnimTime;
    public int flapTicks;
    public float flapSpeed = 1.0f;
    private int jumpTicks;
    private int jumpDuration;
    private int currentMoveTypeDuration;
    private boolean wasOnGround;
    private EntityMoveHelper moveHelperAir;
    private EntityMoveHelper moveHelperLand;
    private PathNavigateFlyingBL pathNavigatorAir;
    private PathNavigateGround pathNavigatorGround;
    public final ControlledAnimation landingTimer = new ControlledAnimation(10);
    public final ControlledAnimation divingTimer = new ControlledAnimation(10);
    public int MAX_RESTING_TIME = 120;
    public int MAX_FLIGHT_TIME = 120;

    public EntityPuffin(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.9f);
        this.field_70138_W = 1.0f;
        this.moveHelperAir = new FlightMoveHelper((EntityLiving)this);
        this.moveHelperLand = new PuffinMoveHelper(this);
        this.field_70767_i = new PuffinJumpHelper(this);
        this.pathNavigatorGround = new PathNavigateGround((EntityLiving)this, world);
        this.pathNavigatorGround.func_179693_d(true);
        this.pathNavigatorAir = new PathNavigateFlyingBL((EntityLiving)this, world, 0);
        this.func_184644_a(PathNodeType.WATER, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.OPEN, 8.0f);
        this.func_184644_a(PathNodeType.FENCE, -8.0f);
        this.func_184644_a(PathNodeType.DANGER_CACTUS, -8.0f);
        this.updateMovementAndPathfinding();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPuffinLandRandomly(this, 0.5));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlyingWanderPuffin(this, 0.5, 10));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0, 10));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_HOVERING, (Object)false);
        this.field_70180_af.func_187214_a(IS_DIVING, (Object)false);
        this.field_70180_af.func_187214_a(IS_LANDING, (Object)false);
        this.field_70180_af.func_187214_a(IS_FLYING, (Object)false);
        this.field_70180_af.func_187214_a(SHOULD_LAND, (Object)false);
        this.field_70180_af.func_187214_a(SHOULD_TAKE_OFF, (Object)true);
        this.field_70180_af.func_187214_a(RESTING_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(FLYING_TIMER, (Object)0);
        this.field_70180_af.func_187214_a(IS_FISHING, (Object)false);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateMovementAndPathfinding();
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getIsFlying()) {
                this.field_70160_al = true;
                this.field_70122_E = false;
                if (this.getFlyingTimer() < this.MAX_FLIGHT_TIME) {
                    this.setFlyingTimer(this.getFlyingTimer() + 1);
                }
                if (this.getFlyingTimer() >= this.MAX_FLIGHT_TIME && !this.getCanLand()) {
                    this.setCanLand(true);
                    this.setRestingTimer(0);
                }
            }
            if (!this.getIsFlying()) {
                this.field_70160_al = false;
                this.field_70122_E = true;
                if (this.getRestingTimer() < this.MAX_RESTING_TIME) {
                    this.setRestingTimer(this.getRestingTimer() + 1);
                }
                if (this.getRestingTimer() >= this.MAX_RESTING_TIME && this.getCanLand()) {
                    this.setCanLand(false);
                    this.setFlyingTimer(0);
                }
            }
        }
        if (this.getIsLanding() && this.func_130014_f_().func_175623_d(this.func_180425_c())) {
            this.field_70181_x -= 0.04;
        }
        if (this.field_70703_bu && this.func_70090_H()) {
            this.func_70605_aq().func_75642_a(this.field_70165_t, this.field_70163_u + 1.0, this.field_70161_v, 1.0);
        }
        if (this.func_130014_f_().field_72995_K) {
            this.landingTimer.updateTimer();
            this.divingTimer.updateTimer();
            if (this.getIsDiving()) {
                this.divingTimer.increaseTimer();
                this.landingTimer.decreaseTimer();
            } else if (!this.getIsFlying()) {
                this.landingTimer.increaseTimer();
                this.divingTimer.decreaseTimer();
            } else {
                this.landingTimer.decreaseTimer();
                this.divingTimer.decreaseTimer();
            }
        }
    }

    protected void updateMovementAndPathfinding() {
        this.field_70765_h = this.getIsFlying() ? this.moveHelperAir : this.moveHelperLand;
        this.field_70699_by = this.getIsFlying() ? this.pathNavigatorAir : this.pathNavigatorGround;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            ++this.flapTicks;
            if (!this.func_174814_R() && this.getIsFlying()) {
                float flapAngle1 = MathHelper.func_76134_b((float)((float)this.flapTicks * this.flapSpeed));
                float flapAngle2 = MathHelper.func_76134_b((float)((float)(this.flapTicks + 1) * this.flapSpeed));
                if (flapAngle1 <= 0.3f && flapAngle2 > 0.3f) {
                    this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getFlySound(), this.func_184176_by(), this.getIsLanding() ? 0.25f : 0.5f, this.getIsLanding() ? 2.5f + this.field_70146_Z.nextFloat() * 0.3f : 1.8f + this.field_70146_Z.nextFloat() * 0.3f, false);
                }
            }
            if (this.jumpTicks != this.jumpDuration) {
                ++this.jumpTicks;
            } else if (this.jumpDuration != 0) {
                this.jumpTicks = 0;
                this.jumpDuration = 0;
                this.func_70637_d(false);
            }
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.field_70122_E) {
            PuffinJumpHelper puffinjumphelper = (PuffinJumpHelper)this.field_70767_i;
            if (!this.wasOnGround) {
                this.func_70637_d(false);
                this.currentMoveTypeDuration = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
                puffinjumphelper.setCanJump(false);
            }
            if (!puffinjumphelper.getIsJumping()) {
                if (this.field_70765_h.func_75640_a() && this.currentMoveTypeDuration == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d vec3d = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        vec3d = path.func_75878_a((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.field_72450_a, vec3d.field_72449_c);
                    this.startJumping();
                }
            } else if (!puffinjumphelper.canJump()) {
                puffinjumphelper.setCanJump(true);
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    public void setMovementSpeed(double newSpeed) {
        this.func_70661_as().func_75489_a(newSpeed);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), newSpeed);
    }

    public void startJumping() {
        this.func_70637_d(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    protected float func_175134_bD() {
        return 0.2f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_70090_H()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)0.8f;
            this.field_70181_x *= (double)0.8f;
            this.field_70179_y *= (double)0.8f;
        } else if (this.func_180799_ab()) {
            this.func_191958_b(strafe, vertical, forward, 0.02f);
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= 0.5;
            this.field_70181_x *= 0.5;
            this.field_70179_y *= 0.5;
        } else if (this.getIsFlying()) {
            float f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277136f / (f * f * f);
            this.func_191958_b(strafe, vertical, forward, this.field_70122_E ? 0.1f * f1 : 0.02f);
            f = 0.91f;
            if (this.field_70122_E) {
                BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
                IBlockState underState = this.field_70170_p.func_180495_p(underPos);
                f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.91f;
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
            this.field_70159_w *= (double)f;
            this.field_70181_x *= (double)f;
            this.field_70179_y *= (double)f;
        } else {
            super.func_191986_a(strafe, vertical, forward);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d1 = this.field_70165_t - this.field_70169_q;
        double d0 = this.field_70161_v - this.field_70166_s;
        float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    private void calculateRotationYaw(double x, double z) {
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)(z - this.field_70161_v), (double)(x - this.field_70165_t)) * 57.29577951308232) - 90.0f;
    }

    public boolean getShouldTakeOff() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_TAKE_OFF);
    }

    private void setShouldTakeOff(boolean take_off) {
        this.field_70180_af.func_187227_b(SHOULD_TAKE_OFF, (Object)take_off);
    }

    public boolean getCanLand() {
        return (Boolean)this.field_70180_af.func_187225_a(SHOULD_LAND);
    }

    private void setCanLand(boolean land) {
        this.field_70180_af.func_187227_b(SHOULD_LAND, (Object)land);
    }

    public boolean getIsFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FLYING);
    }

    public void setIsFlying(boolean flying) {
        this.field_70180_af.func_187227_b(IS_FLYING, (Object)flying);
    }

    public int getFlyingTimer() {
        return (Integer)this.field_70180_af.func_187225_a(FLYING_TIMER);
    }

    public void setFlyingTimer(int timer) {
        this.field_70180_af.func_187227_b(FLYING_TIMER, (Object)timer);
    }

    public boolean getIsLanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LANDING);
    }

    public void setIsLanding(boolean landing) {
        this.field_70180_af.func_187227_b(IS_LANDING, (Object)landing);
    }

    public int getRestingTimer() {
        return (Integer)this.field_70180_af.func_187225_a(RESTING_TIMER);
    }

    public void setRestingTimer(int timer) {
        this.field_70180_af.func_187227_b(RESTING_TIMER, (Object)timer);
    }

    public boolean getIsFishing() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FISHING);
    }

    public void setIsFishing(boolean fishing) {
        this.field_70180_af.func_187227_b(IS_FISHING, (Object)fishing);
    }

    public boolean getIsHovering() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HOVERING);
    }

    public void setIsHovering(boolean hovering) {
        this.field_70180_af.func_187227_b(IS_HOVERING, (Object)hovering);
    }

    public boolean getIsDiving() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIVING);
    }

    public void setIsDiving(boolean diving) {
        this.field_70180_af.func_187227_b(IS_DIVING, (Object)diving);
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    protected SoundEvent func_184639_G() {
        return null;
    }

    protected SoundEvent getFlySound() {
        return SoundRegistry.CHIROMAW_MATRIARCH_FLAP;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    protected SoundEvent func_184615_bR() {
        return null;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean func_70652_k(Entity entityIn) {
        return EntityAIAttackOnCollide.useStandardAttack((EntityLiving)this, entityIn);
    }

    public int func_70641_bl() {
        return 3;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    static class PuffinMoveHelper
    extends EntityMoveHelper {
        private final EntityPuffin puffin;
        private double nextJumpSpeed;

        public PuffinMoveHelper(EntityPuffin puffin) {
            super((EntityLiving)puffin);
            this.puffin = puffin;
        }

        public void func_75641_c() {
            if (this.puffin.field_70122_E && !this.puffin.field_70703_bu && !((PuffinJumpHelper)this.puffin.field_70767_i).getIsJumping()) {
                this.puffin.setMovementSpeed(0.0);
            } else if (this.func_75640_a()) {
                this.puffin.setMovementSpeed(this.nextJumpSpeed);
            }
            super.func_75641_c();
        }

        public void func_75642_a(double x, double y, double z, double speedIn) {
            if (this.puffin.func_70090_H()) {
                speedIn = 1.5;
            }
            super.func_75642_a(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public class PuffinJumpHelper
    extends EntityJumpHelper {
        private final EntityPuffin puffin;
        private boolean canJump;

        public PuffinJumpHelper(EntityPuffin puffin) {
            super((EntityLiving)puffin);
            this.puffin = puffin;
        }

        public boolean getIsJumping() {
            return this.field_75662_b;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void func_75661_b() {
            if (this.field_75662_b) {
                this.puffin.startJumping();
                this.field_75662_b = false;
            }
        }
    }

    class EntityAIPuffinLandRandomly
    extends EntityAIMoveToBlock {
        private final EntityPuffin puffin;

        public EntityAIPuffinLandRandomly(EntityPuffin puffinIn, double speed) {
            super((EntityCreature)puffinIn, speed, 16);
            this.puffin = puffinIn;
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            return this.puffin.getCanLand() && super.func_75250_a();
        }

        public void func_75249_e() {
            super.func_75249_e();
        }

        public boolean func_75253_b() {
            return this.puffin.getCanLand() && super.func_75253_b();
        }

        public void func_75251_c() {
            super.func_75251_c();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (this.func_179487_f()) {
                if (this.puffin.getIsFlying()) {
                    this.puffin.setIsFlying(false);
                }
                if (!this.puffin.getIsLanding()) {
                    this.puffin.setIsLanding(true);
                }
            }
        }

        protected boolean func_179488_a(World world, BlockPos pos) {
            if (!world.func_175623_d(pos.func_177984_a())) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
        }
    }

    class EntityAIFlyingWanderPuffin
    extends EntityAIFlyingWander {
        private final EntityPuffin puffin;

        public EntityAIFlyingWanderPuffin(EntityPuffin puffinIn, double speedIn, int chance) {
            super(puffinIn, speedIn, chance);
            this.puffin = puffinIn;
            this.func_75248_a(3);
        }

        @Override
        public boolean func_75250_a() {
            return super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            return !this.puffin.getCanLand() && super.func_75253_b();
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
        }

        public void func_75246_d() {
            super.func_75246_d();
            if (!this.puffin.getIsFlying()) {
                this.puffin.setIsFlying(true);
            }
            if (this.puffin.getIsLanding()) {
                this.puffin.setIsLanding(false);
            }
        }
    }
}

