/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.entity.EntityAnimalBL;
import thebetweenlands.common.entity.mobs.EntityMireSnail;
import thebetweenlands.common.item.food.ItemMireSnailEgg;
import thebetweenlands.common.network.clientbound.MessageMireSnailEggHatching;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.AnimationMathHelper;

public class EntityMireSnailEgg
extends EntityAnimalBL {
    private static final DataParameter<Integer> HATCH_TICKS = EntityDataManager.func_187226_a(EntityMireSnailEgg.class, (DataSerializer)DataSerializers.field_187192_b);
    public float pulseFloat;
    AnimationMathHelper pulse = new AnimationMathHelper();

    public EntityMireSnailEgg(World world) {
        super(world);
        this.func_70105_a(0.45f, 0.35f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HATCH_TICKS, (Object)0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_70874_b() < 0 || this.func_70874_b() > 0) {
            this.func_70873_a(0);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.getHatchTime() < 12000) {
                this.setHatchTime(this.getHatchTime() + 1);
            }
            if (this.getHatchTime() >= 12000) {
                this.hatch();
            }
        }
        this.pulseFloat = this.pulse.swing(0.3f, 0.2f, false);
        this.field_70761_aq = this.field_70760_ar;
    }

    private void hatch() {
        EntityMireSnail snail = new EntityMireSnail(this.field_70170_p);
        snail.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (snail.func_70601_bi()) {
            this.func_70106_y();
            this.hatchParticlePacketTarget();
            snail.setHasMated(true);
            this.field_70170_p.func_72838_d((Entity)snail);
        }
    }

    private void hatchParticlePacketTarget() {
        TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageMireSnailEggHatching(this), new NetworkRegistry.TargetPoint(this.field_71093_bK, this.field_70165_t, this.field_70163_u, this.field_70161_v, 32.0));
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.CRUNCH;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.SQUISH;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
    }

    public int getHatchTime() {
        return (Integer)this.field_70180_af.func_187225_a(HATCH_TICKS);
    }

    public void setHatchTime(int hatchTime) {
        this.field_70180_af.func_187227_b(HATCH_TICKS, (Object)hatchTime);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("hatchTicks", this.getHatchTime());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("hatchTicks")) {
            this.setHatchTime(nbt.func_74762_e("hatchTicks"));
        }
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.MIRE_SNAIL_EGG;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            ItemStack egg = ItemMireSnailEgg.fromEgg(this);
            if (!player.field_71071_by.func_70441_a(egg)) {
                player.func_70099_a(egg, 0.0f);
            }
            this.func_70106_y();
        }
        return true;
    }
}

