/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.IMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.mobs.EntityLurker;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityJellyfish
extends EntityCreature
implements IEntityBL,
IEntityAdditionalSpawnData,
IMob {
    protected Vec3d prevOrientationPos = Vec3d.field_186680_a;
    protected Vec3d orientationPos = Vec3d.field_186680_a;
    private static final DataParameter<Byte> JELLYFISH_COLOUR = EntityDataManager.func_187226_a(EntityJellyfish.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Float> JELLYFISH_SIZE = EntityDataManager.func_187226_a(EntityJellyfish.class, (DataSerializer)DataSerializers.field_187193_c);
    protected float lengthScale = 1.0f;

    public EntityJellyfish(World world) {
        super(world);
        this.func_70105_a(0.8f, 0.8f);
        this.field_70765_h = new JellyfishMoveHelper(this);
        this.func_184644_a(PathNodeType.WALKABLE, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.WATER, 16.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5, 20));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(JELLYFISH_SIZE, (Object)Float.valueOf(0.5f));
        this.field_70180_af.func_187214_a(JELLYFISH_COLOUR, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (!this.func_130014_f_().field_72995_K) {
            this.setJellyfishSize(0.5f + this.field_70146_Z.nextFloat() * 0.75f);
            this.setJellyfishLength(0.5f + this.field_70146_Z.nextFloat() * 0.5f);
            this.setJellyfishColour((byte)this.field_70146_Z.nextInt(5));
        }
        return super.func_180482_a(difficulty, livingdata);
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public float getJellyfishSize() {
        return ((Float)this.field_70180_af.func_187225_a(JELLYFISH_SIZE)).floatValue();
    }

    private void setJellyfishSize(float size) {
        this.field_70180_af.func_187227_b(JELLYFISH_SIZE, (Object)Float.valueOf(size));
        this.func_70105_a(this.getJellyfishSize() * 0.5f, this.getJellyfishSize());
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public float getJellyfishLength() {
        return this.lengthScale;
    }

    private void setJellyfishLength(float length) {
        this.lengthScale = length;
    }

    public byte getJellyfishColour() {
        return (Byte)this.field_70180_af.func_187225_a(JELLYFISH_COLOUR);
    }

    public void setJellyfishColour(byte colour) {
        this.field_70180_af.func_187227_b(JELLYFISH_COLOUR, (Object)colour);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (JELLYFISH_SIZE.equals(key)) {
            this.func_70105_a(this.getJellyfishSize(), this.getJellyfishSize());
            this.field_70177_z = this.field_70759_as;
            this.field_70761_aq = this.field_70759_as;
        }
        if (JELLYFISH_COLOUR.equals(key)) {
            this.setJellyfishColour(this.getJellyfishColour());
        }
        super.func_184206_a(key);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74776_a("jellyfishSize", this.getJellyfishSize());
        nbt.func_74776_a("jellyfishLength", this.getJellyfishLength());
        nbt.func_74774_a("jellyfishColour", this.getJellyfishColour());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setJellyfishSize(nbt.func_74760_g("jellyfishSize"));
        this.setJellyfishLength(nbt.func_74760_g("jellyfishLength"));
        this.setJellyfishColour(nbt.func_74771_c("jellyfishColour"));
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.JELLYFISH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.JELLYFISH_DEATH;
    }

    protected SoundEvent func_184184_Z() {
        return SoundRegistry.JELLYFISH_SWIM;
    }

    public void func_184185_a(SoundEvent soundIn, float volume, float pitch) {
        super.func_184185_a(soundIn, soundIn == this.func_184184_Z() ? this.func_70599_aP() : volume, pitch);
    }

    protected float func_70599_aP() {
        return 0.35f;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.JELLYFISH;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.SWAMP_WATER;
    }

    public boolean isGrounded() {
        return !this.func_70090_H() && this.field_70170_p.func_175623_d(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u + 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))) && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)(this.field_70163_u - 1.0)), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c().func_149703_v();
    }

    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer((EntityLiving)this, world);
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public void func_70636_d() {
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E && this.func_130014_f_().func_82737_E() % 20L == 0L) {
            this.func_70665_d(DamageSource.field_76369_e, 0.5f);
        }
        this.field_70127_C = this.field_70125_A;
        float speedAngle = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        if (this.field_70159_w != 0.0 && this.field_70179_y != 0.0) {
            this.field_70125_A += (-((float)MathHelper.func_181159_b((double)speedAngle, (double)this.field_70181_x)) * 57.295776f - this.field_70125_A) * 0.1f;
        }
        super.func_70636_d();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.updateOrientationPos();
        } else if (this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
            AxisAlignedBB stingArea = this.func_174813_aQ().func_186662_g(0.25);
            List entities = this.field_70170_p.func_175647_a(EntityLivingBase.class, stingArea, e -> !(e instanceof IEntityBL));
            for (EntityLivingBase entity : entities) {
                if (entity.field_70173_aa % 10 != 0) continue;
                entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
            }
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source instanceof EntityDamageSource && ((EntityDamageSource)source).func_76346_g() instanceof EntityJellyfish) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70106_y() {
        if (!this.func_130014_f_().field_72995_K && this.func_94060_bK() instanceof EntityLurker) {
            EntityLurker lurker = (EntityLurker)this.func_94060_bK();
            lurker.setHuntingTimer(2400);
        }
        super.func_70106_y();
    }

    protected void updateOrientationPos() {
        double length = 0.5;
        Vec3d tether = this.func_174791_d();
        this.prevOrientationPos = this.orientationPos;
        this.orientationPos = this.orientationPos.func_72441_c(0.0, (double)-0.01f, 0.0);
        if (this.orientationPos.func_72438_d(tether) > 0.5) {
            this.orientationPos = tether.func_178787_e(this.orientationPos.func_178788_d(tether).func_72432_b().func_186678_a(0.5));
        }
    }

    public Vec3d getOrientationPos(float partialTicks) {
        return this.prevOrientationPos.func_178787_e(this.orientationPos.func_178788_d(this.prevOrientationPos).func_186678_a((double)partialTicks));
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.075f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.75;
                this.field_70181_x *= 0.75;
                this.field_70179_y *= 0.75;
                if (this.func_70638_az() == null) {
                    this.field_70181_x -= 0.003;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty();
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeFloat(this.lengthScale);
    }

    public void readSpawnData(ByteBuf buf) {
        this.lengthScale = buf.readFloat();
    }

    static class JellyfishMoveHelper
    extends EntityMoveHelper {
        private final EntityJellyfish jellyfish;

        public JellyfishMoveHelper(EntityJellyfish jellyfishIn) {
            super((EntityLiving)jellyfishIn);
            this.jellyfish = jellyfishIn;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.jellyfish.func_70661_as().func_75500_f()) {
                double targetX = this.field_75646_b - this.jellyfish.field_70165_t;
                double targetY = this.field_75647_c - this.jellyfish.field_70163_u;
                double targetZ = this.field_75644_d - this.jellyfish.field_70161_v;
                double targetDistance = targetX * targetX + targetY * targetY + targetZ * targetZ;
                targetDistance = MathHelper.func_76133_a((double)targetDistance);
                float targetAngle = (float)(MathHelper.func_181159_b((double)targetZ, (double)targetX) * 57.29577951308232) - 90.0f;
                this.jellyfish.field_70761_aq = this.jellyfish.field_70177_z = this.func_75639_a(this.jellyfish.field_70177_z, targetAngle, 180.0f);
                float travelSpeed = (float)(this.field_75645_e * this.jellyfish.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.jellyfish.func_70659_e(this.jellyfish.func_70689_ay() + (travelSpeed - this.jellyfish.func_70689_ay()) * 0.125f);
                this.jellyfish.field_70181_x += (double)this.jellyfish.func_70689_ay() * (targetY /= targetDistance) * 0.2;
                EntityLookHelper entitylookhelper = this.jellyfish.func_70671_ap();
                double targetDirectionX = this.jellyfish.field_70165_t + targetX / targetDistance * 2.0;
                double targetDirectionY = (double)this.jellyfish.func_70047_e() + this.jellyfish.field_70163_u + targetY / targetDistance;
                double targetDirectionZ = this.jellyfish.field_70161_v + targetZ / targetDistance * 2.0;
                double lookX = entitylookhelper.func_180423_e();
                double lookY = entitylookhelper.func_180422_f();
                double lookZ = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    lookX = targetDirectionX;
                    lookY = targetDirectionY;
                    lookZ = targetDirectionZ;
                }
                this.jellyfish.func_70671_ap().func_75650_a(lookX + (targetDirectionX - lookX) * 0.125, lookY + (targetDirectionY - lookY) * 0.125, lookZ + (targetDirectionZ - lookZ) * 0.125, 10.0f, 40.0f);
            } else {
                this.jellyfish.func_70659_e(0.0f);
            }
        }
    }
}

