/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityEmberlingWild
extends EntityMob
implements IEntityMultiPart,
IEntityBL {
    public MultiPartEntityPart[] tailPart;
    private static final DataParameter<Boolean> IS_FLAME_ATTACKING = EntityDataManager.func_187226_a(EntityEmberlingWild.class, (DataSerializer)DataSerializers.field_187198_h);
    public float animationTicks;
    public float prevAnimationTicks;
    private EntityMoveHelper moveHelperWater;
    private EntityMoveHelper moveHelperLand;
    private PathNavigateGround pathNavigatorGround;
    private PathNavigateSwimmer pathNavigatorWater;

    public EntityEmberlingWild(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.85f);
        this.field_70138_W = 1.0f;
        this.field_70178_ae = true;
        this.tailPart = new MultiPartEntityPart[]{new MultiPartEntityPart((IEntityMultiPart)this, "tail", 0.5f, 0.5f)};
        this.func_184644_a(PathNodeType.WATER, 100.0f);
        this.moveHelperWater = new EmberlingMoveHelper(this);
        this.moveHelperLand = new EntityMoveHelper((EntityLiving)this);
        this.pathNavigatorGround = new PathNavigateGround((EntityLiving)this, world);
        this.pathNavigatorGround.func_179693_d(true);
        this.pathNavigatorWater = new PathNavigateSwimmer((EntityLiving)this, world);
        this.updateMovementAndPathfinding();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_FLAME_ATTACKING, (Object)false);
    }

    public void setIsFlameAttacking(boolean flame_on) {
        this.field_70180_af.func_187227_b(IS_FLAME_ATTACKING, (Object)flame_on);
    }

    public boolean getIsFlameAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_FLAME_ATTACKING);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIFlameBreath(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIEmberlingAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.25);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.EMBERLING_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.EMBERLING_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.EMBERLING_DEATH;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.EMBERLING;
    }

    public boolean func_70652_k(Entity entity) {
        boolean hitTarget = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (hitTarget) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return hitTarget;
    }

    public boolean func_70601_bi() {
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return iblockstate.func_189884_a((Entity)this) && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL;
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public boolean func_70090_H() {
        this.field_70171_ac = this.func_130014_f_().func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
        return this.field_70171_ac;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public int func_70641_bl() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public float smoothedAngle(float partialTicks) {
        return this.prevAnimationTicks + (this.animationTicks - this.prevAnimationTicks) * partialTicks;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateMovementAndPathfinding();
        if (this.func_130014_f_().field_72995_K) {
            if (!this.getIsFlameAttacking() && this.field_70173_aa % 5 == 0) {
                this.flameParticles(this.func_130014_f_(), this.tailPart[0].field_70165_t, this.tailPart[0].field_70163_u + 0.25, this.tailPart[0].field_70161_v, this.field_70146_Z);
            }
            if (this.getIsFlameAttacking()) {
                this.spawnFlameBreathParticles();
            }
        }
    }

    public void playTameEffect(boolean play) {
        EnumParticleTypes enumparticletypes = EnumParticleTypes.HEART;
        if (!play) {
            enumparticletypes = EnumParticleTypes.SMOKE_NORMAL;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_175688_a(enumparticletypes, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2, new int[0]);
        }
    }

    protected void updateMovementAndPathfinding() {
        this.field_70765_h = this.func_70090_H() ? this.moveHelperWater : this.moveHelperLand;
        this.field_70699_by = this.func_70090_H() && !this.field_70170_p.func_175623_d(new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72337_e + 0.25, this.field_70161_v)) ? this.pathNavigatorWater : this.pathNavigatorGround;
        double a = Math.toRadians(this.field_70761_aq);
        double offSetX = -Math.sin(a) * 1.85;
        double offSetZ = Math.cos(a) * 1.85;
        this.tailPart[0].func_70012_b(this.field_70165_t - offSetX, this.field_70163_u + 0.2, this.field_70161_v - offSetZ, 0.0f, 0.0f);
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.1f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= (double)0.9f;
                this.field_70181_x *= (double)0.9f;
                this.field_70179_y *= (double)0.9f;
                if (this.func_70638_az() == null) {
                    this.field_70181_x += Math.sin((double)this.field_70173_aa * 0.05) * 0.0035 - 2.0E-4;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void flameParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 3; ++count) {
            double velX = 0.0;
            double velY = 0.0;
            double velZ = 0.0;
            int motionX = rand.nextBoolean() ? 1 : -1;
            int motionZ = rand.nextBoolean() ? 1 : -1;
            velY = (double)rand.nextFloat() * 0.05;
            velZ = (double)rand.nextFloat() * 0.025 * (double)motionZ;
            velX = (double)rand.nextFloat() * 0.025 * (double)motionX;
            if (this.field_70171_ac) {
                world.func_190523_a(EnumParticleTypes.WATER_BUBBLE.func_179348_c(), x, y, z, velX, velY, velZ, new int[0]);
                world.func_190523_a(EnumParticleTypes.SMOKE_NORMAL.func_179348_c(), x, y, z, velX, velY, velZ, new int[0]);
                continue;
            }
            world.func_190523_a(EnumParticleTypes.FLAME.func_179348_c(), x, y, z, velX, velY, velZ, new int[0]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnFlameBreathParticles() {
        for (int count = 0; count < 5; ++count) {
            Vec3d look = this.func_70676_i(1.0f).func_72432_b();
            double a = Math.toRadians(this.field_70761_aq);
            double offSetX = -Math.sin(a) * 1.0;
            double offSetZ = Math.cos(a) * 1.0;
            int motionX = this.field_70146_Z.nextBoolean() ? 1 : -1;
            int motionY = this.field_70146_Z.nextBoolean() ? 1 : -1;
            int motionZ = this.field_70146_Z.nextBoolean() ? 1 : -1;
            double velX = (double)this.field_70146_Z.nextFloat() * 0.1 * (double)motionX;
            double velY = (double)this.field_70146_Z.nextFloat() * 0.1 * (double)motionY;
            double velZ = (double)this.field_70146_Z.nextFloat() * 0.1 * (double)motionZ;
            float speed = 0.15f;
            this.field_70170_p.func_190523_a(EnumParticleTypes.FLAME.func_179348_c(), this.field_70165_t + offSetX + velX, this.field_70163_u + (double)this.func_70047_e() * 0.75 + velY, this.field_70161_v + offSetZ + velZ, look.field_72450_a * (double)speed, look.field_72448_b * (double)speed, look.field_72449_c * (double)speed, new int[0]);
        }
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (this.func_180431_b(source) || source.equals(DamageSource.field_76368_d) || source.equals(DamageSource.field_76369_e)) {
            return false;
        }
        return super.func_70097_a(source, damage);
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.tailPart;
    }

    public float func_180484_a(BlockPos pos) {
        return 0.5f;
    }

    static class EmberlingMoveHelper
    extends EntityMoveHelper {
        private final EntityEmberlingWild emberling;

        public EmberlingMoveHelper(EntityEmberlingWild emberling) {
            super((EntityLiving)emberling);
            this.emberling = emberling;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.emberling.func_70661_as().func_75500_f()) {
                double d0 = this.field_75646_b - this.emberling.field_70165_t;
                double d1 = this.field_75647_c - this.emberling.field_70163_u;
                double d2 = this.field_75644_d - this.emberling.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = MathHelper.func_76133_a((double)d3);
                d1 /= d3;
                float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                this.emberling.field_70761_aq = this.emberling.field_70177_z = this.func_75639_a(this.emberling.field_70177_z, f, 90.0f);
                float f1 = (float)(this.field_75645_e * this.emberling.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.emberling.func_70659_e(this.emberling.func_70689_ay() + (f1 - this.emberling.func_70689_ay()) * 0.125f);
                double d4 = Math.sin((double)(this.emberling.field_70173_aa + this.emberling.func_145782_y()) * 0.5) * 0.05;
                double d5 = Math.cos(this.emberling.field_70177_z * ((float)Math.PI / 180));
                double d6 = Math.sin(this.emberling.field_70177_z * ((float)Math.PI / 180));
                this.emberling.field_70159_w += d4 * d5;
                this.emberling.field_70179_y += d4 * d6;
                d4 = Math.sin((double)(this.emberling.field_70173_aa + this.emberling.func_145782_y()) * 0.75) * 0.05;
                this.emberling.field_70181_x += d4 * (d6 + d5) * 0.25;
                if (Math.abs(this.emberling.field_70181_x) < 0.35) {
                    this.emberling.field_70181_x = this.emberling.field_70181_x + (double)this.emberling.func_70689_ay() * d1 * 0.1 * (2.0 + (d1 > 0.0 ? 0.4 : 0.0) + (double)(this.emberling.field_70123_F ? 20 : 0));
                }
                EntityLookHelper entitylookhelper = this.emberling.func_70671_ap();
                double d7 = this.emberling.field_70165_t + d0 / d3 * 2.0;
                double d8 = (double)this.emberling.func_70047_e() + this.emberling.field_70163_u + d1 / d3;
                double d9 = this.emberling.field_70161_v + d2 / d3 * 2.0;
                double d10 = entitylookhelper.func_180423_e();
                double d11 = entitylookhelper.func_180422_f();
                double d12 = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    d10 = d7;
                    d11 = d8;
                    d12 = d9;
                }
                this.emberling.func_70671_ap().func_75650_a(d10 + (d7 - d10) * 0.125, d11 + (d8 - d11) * 0.125, d12 + (d9 - d12) * 0.125, 10.0f, 40.0f);
            } else {
                this.emberling.func_70659_e(0.0f);
            }
        }
    }

    static class EntityAIFlameBreath
    extends EntityAIBase {
        EntityEmberlingWild emberling;
        EntityLivingBase target;
        int missileCount;
        int shootCount;

        public EntityAIFlameBreath(EntityEmberlingWild emberling) {
            this.emberling = emberling;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            this.target = this.emberling.func_70638_az();
            if (this.target == null || this.emberling.func_70090_H()) {
                return false;
            }
            double distance = this.emberling.func_70068_e((Entity)this.target);
            if (distance >= 4.0 && distance <= 25.0) {
                if (!this.emberling.field_70122_E) {
                    return false;
                }
                return this.emberling.func_70681_au().nextInt(8) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.shootCount != -1 && this.missileCount != -1 && this.emberling.field_70718_bc <= 40;
        }

        public void func_75249_e() {
            this.missileCount = 0;
            this.shootCount = 0;
            this.emberling.func_130014_f_().func_184133_a(null, this.emberling.func_180425_c(), (SoundEvent)SoundRegistry.EMBERLING_FLAMES, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }

        public void func_75251_c() {
            this.shootCount = -1;
            this.missileCount = -1;
            if (this.emberling.getIsFlameAttacking()) {
                this.emberling.setIsFlameAttacking(false);
            }
        }

        public void func_75246_d() {
            if (!this.emberling.getIsFlameAttacking()) {
                this.emberling.setIsFlameAttacking(true);
            }
            this.emberling.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
            float f = (float)MathHelper.func_181159_b((double)(this.target.field_70161_v - this.emberling.field_70161_v), (double)(this.target.field_70165_t - this.emberling.field_70165_t));
            int distance = MathHelper.func_76141_d((float)this.emberling.func_70032_d((Entity)this.target));
            ++this.missileCount;
            if (this.missileCount % 5 == 0) {
                ++this.shootCount;
                double d2 = 1.0 * (double)this.shootCount;
                AxisAlignedBB flameBox = new AxisAlignedBB(new BlockPos(this.emberling.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, this.emberling.field_70163_u, this.emberling.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2));
                List list = this.emberling.func_130014_f_().func_72872_a(EntityLivingBase.class, flameBox);
                for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
                    Entity entity = (Entity)list.get(entityCount);
                    if (entity == null || entity != this.target || !(entity instanceof EntityLivingBase) || entity.func_70027_ad()) continue;
                    entity.func_70015_d(5);
                }
            }
            if (this.shootCount >= distance || this.shootCount >= 4) {
                this.func_75251_c();
            }
        }
    }

    static class AIEmberlingAttack
    extends EntityAIAttackMelee {
        public AIEmberlingAttack(EntityEmberlingWild emberling) {
            super((EntityCreature)emberling, 0.65, false);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

