/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.common.entity.mobs.EntityFlameJet;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityEmberlingShaman
extends EntityMob
implements IEntityMultiPart,
IEntityBL {
    public MultiPartEntityPart[] tailPart;
    private static final DataParameter<Boolean> IS_CASTING_SPELL = EntityDataManager.func_187226_a(EntityEmberlingShaman.class, (DataSerializer)DataSerializers.field_187198_h);
    public float animationTicks;
    public float prevAnimationTicks;

    public EntityEmberlingShaman(World world) {
        super(world);
        this.field_70728_aV = 7;
        this.func_70105_a(0.9f, 1.0f);
        this.field_70138_W = 1.0f;
        this.field_70178_ae = true;
        this.tailPart = new MultiPartEntityPart[]{new MultiPartEntityPart((IEntityMultiPart)this, "tail", 0.5f, 0.5f)};
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_CASTING_SPELL, (Object)false);
    }

    public void setIsCastingSpell(boolean casting) {
        this.field_70180_af.func_187227_b(IS_CASTING_SPELL, (Object)casting);
    }

    public boolean getIsCastingSpell() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CASTING_SPELL);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIHoverSpinAttack(this, 0.6f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFireballColumn(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIEmberlingAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 0, false, true, null));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.25);
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.EMBERLING_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.EMBERLING_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.EMBERLING_DEATH;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.EMBERLING_SHAMAN;
    }

    public boolean func_70686_a(Class entity) {
        return EntityEmberlingShaman.class != entity;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    public boolean func_70058_J() {
        return !this.func_130014_f_().func_72953_d(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70641_bl() {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public float smoothedAngle(float partialTicks) {
        return this.prevAnimationTicks + (this.animationTicks - this.prevAnimationTicks) * partialTicks;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70761_aq = this.field_70177_z;
        double a = Math.toRadians(this.field_70177_z);
        double offSetX = -Math.sin(a) * 1.5;
        double offSetZ = Math.cos(a) * 1.5;
        this.tailPart[0].func_70012_b(this.field_70165_t - offSetX, this.field_70163_u, this.field_70161_v - offSetZ, 0.0f, 0.0f);
        if (this.func_130014_f_().func_82737_E() % 5L == 0L && this.func_130014_f_().field_72995_K) {
            this.flameParticles(this.func_130014_f_(), this.tailPart[0].field_70165_t, this.tailPart[0].field_70163_u + 0.25, this.tailPart[0].field_70161_v, this.field_70146_Z);
        }
        this.checkCollision();
        if (this.func_130014_f_().field_72995_K) {
            if (this.getIsCastingSpell()) {
                this.prevAnimationTicks = this.animationTicks;
                if (this.animationTicks <= 1.0f) {
                    this.animationTicks += 0.1f;
                }
            }
            if (!this.getIsCastingSpell()) {
                this.prevAnimationTicks = this.animationTicks;
                if (this.animationTicks >= 0.1f) {
                    this.animationTicks -= 0.1f;
                }
                if (this.animationTicks < 0.0f) {
                    this.animationTicks = 0.0f;
                }
            }
        }
        if (!this.func_130014_f_().field_72995_K && this.field_70718_bc > 40 && this.getIsCastingSpell()) {
            this.setIsCastingSpell(false);
        }
        if (this.func_130014_f_().field_72995_K && this.field_70146_Z.nextInt(4) == 0) {
            Object args = ParticleFactory.ParticleArgs.get().withDataBuilder().setData(2, this).buildData();
            ((ParticleFactory.ParticleArgs)args).withColor(1.0f, 1.0f, 1.0f, 1.0f);
            ((ParticleFactory.ParticleArgs)args).withScale(0.75f + this.field_70146_Z.nextFloat() * 0.75f);
            BLParticles.EMBER_SWIRL.spawn(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, (ParticleFactory.ParticleArgs<?>)args);
        }
    }

    protected Entity checkCollision() {
        List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.tailPart[0].func_174813_aQ());
        for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
            Entity entity = (Entity)list.get(entityCount);
            if (entity == null || entity != this.func_70638_az() || entity instanceof IEntityMultiPart || entity instanceof MultiPartEntityPart || !(entity instanceof EntityLivingBase)) continue;
            this.func_70652_k(entity);
            entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.tailPart[0].field_70177_z * 3.141593f / 180.0f))) * 0.5, 0.3, (double)MathHelper.func_76134_b((float)(this.tailPart[0].field_70177_z * 3.141593f / 180.0f)) * 0.5);
            entity.func_70015_d(5);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void flameParticles(World world, double x, double y, double z, Random rand) {
        for (int count = 0; count < 3; ++count) {
            double velX = 0.0;
            double velY = 0.0;
            double velZ = 0.0;
            int motionX = rand.nextBoolean() ? 1 : -1;
            int motionZ = rand.nextBoolean() ? 1 : -1;
            velY = (double)rand.nextFloat() * 0.05;
            velZ = (double)rand.nextFloat() * 0.025 * (double)motionZ;
            velX = (double)rand.nextFloat() * 0.025 * (double)motionX;
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, velX, velY, velZ, new int[0]);
        }
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        return false;
    }

    public Entity[] func_70021_al() {
        return this.tailPart;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    static class EntityAIHoverSpinAttack
    extends EntityAIBase {
        EntityEmberlingShaman emberling;
        EntityLivingBase target;
        float motionY;
        float rotation;

        public EntityAIHoverSpinAttack(EntityEmberlingShaman emberling, float motionYIn) {
            this.emberling = emberling;
            this.motionY = motionYIn;
            this.func_75248_a(7);
        }

        public boolean func_75250_a() {
            this.target = this.emberling.func_70638_az();
            this.rotation = 0.0f;
            if (this.target == null) {
                return false;
            }
            double distance = this.emberling.func_70068_e((Entity)this.target);
            if (distance >= 4.0 && distance <= 36.0) {
                if (!this.emberling.field_70122_E) {
                    return false;
                }
                return this.emberling.func_70681_au().nextInt(5) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return !this.emberling.field_70122_E;
        }

        public void func_75249_e() {
            if (this.emberling.getIsCastingSpell()) {
                this.emberling.setIsCastingSpell(false);
            }
            this.emberling.func_130014_f_().func_184133_a(null, this.emberling.func_180425_c(), (SoundEvent)SoundRegistry.EMBERLING_JUMP, SoundCategory.HOSTILE, 1.0f, 1.0f);
            double d0 = this.target.field_70165_t - this.emberling.field_70165_t;
            double d1 = this.target.field_70161_v - this.emberling.field_70161_v;
            float f = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1));
            if ((double)f >= 1.0E-4) {
                this.emberling.field_70159_w += d0 / (double)f * 0.5 * (double)0.8f + this.emberling.field_70159_w * (double)0.2f;
                this.emberling.field_70179_y += d1 / (double)f * 0.5 * (double)0.8f + this.emberling.field_70179_y * (double)0.2f;
            }
            this.emberling.field_70181_x = this.motionY;
        }

        public void func_75246_d() {
            this.rotation += 30.0f;
            this.emberling.func_70101_b(this.rotation, 0.0f);
            if (this.emberling.field_70181_x < 0.0) {
                this.emberling.field_70181_x *= 0.5;
            }
        }
    }

    static class EntityAIFireballColumn
    extends EntityAIBase {
        EntityEmberlingShaman emberling;
        EntityLivingBase target;
        int missileCount;
        int shootCount;

        public EntityAIFireballColumn(EntityEmberlingShaman emberling) {
            this.emberling = emberling;
            this.func_75248_a(5);
        }

        public boolean func_75250_a() {
            this.target = this.emberling.func_70638_az();
            if (this.target == null) {
                return false;
            }
            double distance = this.emberling.func_70068_e((Entity)this.target);
            if (distance >= 36.0 && distance <= 144.0) {
                if (!this.emberling.field_70122_E) {
                    return false;
                }
                return this.emberling.func_70681_au().nextInt(8) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.shootCount != -1 && this.missileCount != -1 && this.emberling.field_70718_bc <= 40;
        }

        public void func_75249_e() {
            this.missileCount = 0;
            this.shootCount = 0;
            this.emberling.func_130014_f_().func_184133_a(null, this.emberling.func_180425_c(), (SoundEvent)SoundRegistry.EMBERLING_FLAMES, SoundCategory.HOSTILE, 1.0f, 1.0f);
        }

        public void func_75246_d() {
            if (!this.emberling.getIsCastingSpell()) {
                this.emberling.setIsCastingSpell(true);
            }
            this.emberling.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
            float f = (float)MathHelper.func_181159_b((double)(this.target.field_70161_v - this.emberling.field_70161_v), (double)(this.target.field_70165_t - this.emberling.field_70165_t));
            int distance = MathHelper.func_76141_d((float)this.emberling.func_70032_d((Entity)this.target));
            ++this.missileCount;
            if (this.missileCount % 5 == 0) {
                ++this.shootCount;
                double d2 = 1.0 * (double)this.shootCount;
                EntityFlameJet flame_jet = new EntityFlameJet(this.emberling.func_130014_f_(), (EntityLivingBase)this.emberling);
                flame_jet.func_70107_b(this.emberling.field_70165_t + (double)MathHelper.func_76134_b((float)f) * d2, this.emberling.field_70163_u, this.emberling.field_70161_v + (double)MathHelper.func_76126_a((float)f) * d2);
                this.emberling.func_130014_f_().func_72838_d((Entity)flame_jet);
                this.emberling.func_130014_f_().func_184133_a(null, this.emberling.func_180425_c(), SoundEvents.field_187616_bj, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.emberling.func_130014_f_().field_73012_v.nextFloat() - this.emberling.func_130014_f_().field_73012_v.nextFloat()) * 0.8f);
            }
            if (this.shootCount >= distance || this.shootCount >= 12) {
                this.shootCount = -1;
                this.missileCount = -1;
                if (this.emberling.getIsCastingSpell()) {
                    this.emberling.setIsCastingSpell(false);
                }
            }
        }
    }

    static class AIEmberlingAttack
    extends EntityAIAttackMelee {
        public AIEmberlingAttack(EntityEmberlingShaman emberling) {
            super((EntityCreature)emberling, 0.4, false);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

