/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityCryptCrawler
extends EntityMob
implements IEntityBL {
    protected static final int MUTEX_BLOCKING = 8;
    protected static final int MUTEX_ATTACKING = 16;
    private static final byte EVENT_SHIELD_BLOCKED = 80;
    private static final DataParameter<Boolean> IS_BIPED = EntityDataManager.func_187226_a(EntityCryptCrawler.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityCryptCrawler.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_CHIEF = EntityDataManager.func_187226_a(EntityCryptCrawler.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_BLOCKING = EntityDataManager.func_187226_a(EntityCryptCrawler.class, (DataSerializer)DataSerializers.field_187198_h);
    public float standingAngle;
    public float prevStandingAngle;
    protected boolean recentlyBlockedAttack;

    public EntityCryptCrawler(World world) {
        super(world);
        this.func_70105_a(0.5f, 1.0f);
        this.field_70138_W = 1.0f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
        this.field_70180_af.func_187214_a(IS_BIPED, (Object)false);
        this.field_70180_af.func_187214_a(IS_CHIEF, (Object)false);
        this.field_70180_af.func_187214_a(IS_BLOCKING, (Object)false);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    private void setIsStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    public boolean isBiped() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BIPED);
    }

    public void setIsBiped(boolean standing) {
        this.field_70180_af.func_187227_b(IS_BIPED, (Object)standing);
    }

    public boolean isChief() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CHIEF);
    }

    public void setIsChief(boolean chief) {
        this.field_70180_af.func_187227_b(IS_CHIEF, (Object)chief);
    }

    public boolean isBlocking() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_BLOCKING);
    }

    private void setIsBlocking(boolean blocking) {
        this.field_70180_af.func_187227_b(IS_BLOCKING, (Object)blocking);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIShieldCharge(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIShieldBlock(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AICryptCrawlerAttack(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 3, true, true, null).func_190882_b(120));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.updateAttributes();
    }

    protected void updateAttributes() {
        if (this.func_130014_f_() != null && !this.func_130014_f_().field_72995_K) {
            if (this.isChief()) {
                this.func_70105_a(0.98f, 1.9f);
                this.field_70728_aV = 20;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.28);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.25);
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.75);
            }
            if (!this.isChief() && this.isBiped()) {
                this.func_70105_a(0.75f, 1.5f);
                this.field_70728_aV = 10;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.29);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.5);
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
            }
            if (!this.isChief() && !this.isBiped()) {
                this.func_70105_a(0.95f, 1.0f);
                this.field_70728_aV = 5;
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.31);
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.75);
                this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(20.0);
                this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.25);
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundRegistry.CRYPT_CRAWLER_LIVING;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundRegistry.CRYPT_CRAWLER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.CRYPT_CRAWLER_DEATH;
    }

    protected ResourceLocation func_184647_J() {
        return LootTableRegistry.CRYPT_CRAWLER;
    }

    protected float func_70647_i() {
        if (this.isChief()) {
            return super.func_70647_i() * 0.5f;
        }
        return super.func_70647_i();
    }

    public void func_70636_d() {
        if (this.isBlocking() && !this.func_184592_cb().func_190926_b() && this.func_184592_cb().func_77973_b().isShield(this.func_184592_cb(), (EntityLivingBase)this)) {
            this.func_184598_c(EnumHand.OFF_HAND);
            if (this.field_70170_p.field_72995_K) {
                this.field_184627_bm = this.func_184592_cb();
            }
        } else if (this.func_184587_cr() && this.func_184600_cs() == EnumHand.OFF_HAND) {
            this.func_184597_cx();
        }
        if (this.func_130014_f_().field_72995_K) {
            if (this.isChief()) {
                this.func_70105_a(1.2f, 1.9f);
            }
            if (!this.isChief() && this.isBiped()) {
                this.func_70105_a(0.75f, 1.5f);
            }
            if (!this.isChief() && !this.isBiped()) {
                this.func_70105_a(0.95f - this.standingAngle * 0.2f, 1.0f + this.standingAngle * 0.75f);
            }
        }
        if (!this.func_130014_f_().field_72995_K && !this.isBiped()) {
            if (this.func_70638_az() != null) {
                double distance = this.func_70011_f(this.func_70638_az().field_70165_t, this.func_70638_az().func_174813_aQ().field_72338_b, this.func_70638_az().field_70161_v);
                this.setIsStanding(distance <= 3.0);
            }
            if (this.func_70638_az() == null) {
                this.setIsStanding(false);
            }
        }
        if (this.func_130014_f_().field_72995_K && !this.isBiped()) {
            this.prevStandingAngle = this.standingAngle;
            if (this.standingAngle > 0.0f && !this.isStanding()) {
                this.standingAngle -= 0.1f;
            }
            if (this.isStanding() && this.standingAngle <= 1.0f) {
                this.standingAngle += 0.1f;
            }
            if (this.standingAngle < 0.0f && !this.isStanding()) {
                this.standingAngle = 0.0f;
            }
            if (this.isStanding() && this.standingAngle > 1.0f) {
                this.standingAngle = 1.0f;
            }
            this.standingAngle = MathHelper.func_76131_a((float)this.standingAngle, (float)0.0f, (float)1.0f);
        }
        super.func_70636_d();
    }

    @SideOnly(value=Side.CLIENT)
    public float smoothedStandingAngle(float partialTicks) {
        return this.prevStandingAngle + (this.standingAngle - this.prevStandingAngle) * partialTicks;
    }

    public boolean func_70686_a(Class entity) {
        return EntityCryptCrawler.class != entity;
    }

    public boolean func_70601_bi() {
        return super.func_70601_bi();
    }

    public boolean func_70058_J() {
        return !this.func_130014_f_().func_72953_d(this.func_174813_aQ()) && this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70641_bl() {
        return 3;
    }

    public boolean func_70652_k(Entity entity) {
        if (!this.isBlocking() && this.func_70685_l(entity)) {
            boolean hasHitTarget = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
            if (hasHitTarget) {
                if (!this.func_184614_ca().func_190926_b()) {
                    this.func_184614_ca().func_77973_b().func_77644_a(this.func_184614_ca(), (EntityLivingBase)entity, (EntityLivingBase)this);
                }
                if (!this.func_130014_f_().field_72995_K) {
                    this.func_130014_f_().func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.CRYPT_CRAWLER_LIVING, SoundCategory.HOSTILE, 1.0f, 0.5f);
                }
            }
            return hasHitTarget;
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70173_aa < 40 && source == DamageSource.field_76368_d) {
            return false;
        }
        boolean wasAttackBlocked = super.func_70097_a(source, amount);
        if (this.isBlocking() && !wasAttackBlocked) {
            this.recentlyBlockedAttack = true;
            this.field_70170_p.func_72960_a((Entity)this, (byte)80);
        }
        return wasAttackBlocked;
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 80) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187767_eL, SoundCategory.NEUTRAL, 1.0f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.4f, false);
        }
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.setIsBiped(true);
            if (this.field_70146_Z.nextInt(3) == 0) {
                this.setIsChief(true);
            }
        }
        if (this.isBiped()) {
            if (this.field_70146_Z.nextFloat() < 0.05f) {
                this.func_184641_n(true);
            } else {
                this.func_184641_n(false);
            }
            this.setRandomEquipment();
        }
        this.updateAttributes();
        this.func_70606_j(this.func_110138_aP());
        return livingdata;
    }

    protected void setRandomEquipment() {
        if (!this.isChief()) {
            int randomWeapon = this.field_70146_Z.nextInt(5);
            int randomShield = this.field_70146_Z.nextInt(3);
            switch (randomWeapon) {
                case 0: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemRegistry.WIGHTS_BANE));
                    break;
                }
                case 1: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemRegistry.WEEDWOOD_SWORD));
                    break;
                }
                case 2: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemRegistry.BONE_SWORD));
                    break;
                }
                case 3: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemRegistry.BONE_AXE));
                    break;
                }
                case 4: {
                    this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemRegistry.WEEDWOOD_AXE));
                }
            }
            if (!this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_190926_b()) {
                switch (randomShield) {
                    case 0: {
                        this.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                        break;
                    }
                    case 1: {
                        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(ItemRegistry.WEEDWOOD_SHIELD));
                        break;
                    }
                    case 2: {
                        this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(ItemRegistry.BONE_SHIELD));
                    }
                }
            }
        } else {
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, new ItemStack(ItemRegistry.SYRMORITE_SHIELD));
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, new ItemStack(ItemRegistry.OCTINE_SWORD));
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("is_biped", this.isBiped());
        nbt.func_74757_a("is_chief", this.isChief());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setIsBiped(nbt.func_74767_n("is_biped"));
        this.setIsChief(nbt.func_74767_n("is_chief"));
    }

    public float func_70689_ay() {
        return (this.isBlocking() ? 0.5f : 1.0f) * super.func_70689_ay();
    }

    static class AIShieldBlock
    extends EntityAIBase {
        private EntityCryptCrawler crawler;
        private EntityLivingBase target;
        private int blockingCount;
        private int blockingCountMax;
        private int meleeBlockingCounter;
        private int meleeBlockingCounterMax;
        private int blockingCooldownCounter;
        private int blockingCooldownCounterMax = -1;

        public AIShieldBlock(EntityCryptCrawler crawler) {
            this.crawler = crawler;
            this.func_75248_a(8);
        }

        protected boolean isInMeleeRange() {
            return this.crawler != null && this.target != null && this.crawler.func_70068_e((Entity)this.target) < 9.0;
        }

        protected boolean isHoldingShield() {
            if (this.crawler != null) {
                ItemStack heldItem = this.crawler.func_184582_a(EntityEquipmentSlot.OFFHAND);
                if (heldItem.func_190926_b()) {
                    return false;
                }
                return heldItem.func_77973_b().isShield(heldItem, (EntityLivingBase)this.crawler);
            }
            return false;
        }

        public boolean func_75250_a() {
            if (!this.isHoldingShield()) {
                return false;
            }
            this.target = this.crawler.func_70638_az();
            if (this.target != null && !this.crawler.field_82175_bq && this.crawler.field_70172_ad <= Math.max(0, this.crawler.field_70771_an - 5)) {
                ++this.blockingCooldownCounter;
                if (this.blockingCooldownCounterMax < 0) {
                    this.blockingCooldownCounterMax = 4 + this.crawler.field_70146_Z.nextInt(5);
                }
                return this.blockingCooldownCounter > this.blockingCooldownCounterMax;
            }
            return false;
        }

        public boolean func_75253_b() {
            return this.isHoldingShield() && !this.crawler.recentlyBlockedAttack && this.blockingCount != -1 && this.crawler.field_70172_ad <= Math.max(0, this.crawler.field_70771_an - 5) && !this.crawler.field_82175_bq && this.blockingCount <= this.blockingCountMax && (this.meleeBlockingCounterMax < 0 || this.meleeBlockingCounter <= this.meleeBlockingCounterMax);
        }

        public void func_75249_e() {
            this.blockingCount = 0;
            this.blockingCountMax = 40 + this.crawler.field_70146_Z.nextInt(40);
            this.meleeBlockingCounterMax = -1;
            this.meleeBlockingCounter = 0;
            this.crawler.recentlyBlockedAttack = false;
            this.blockingCooldownCounter = 0;
            this.blockingCooldownCounterMax = -1;
        }

        public void func_75251_c() {
            this.crawler.setIsBlocking(false);
            this.blockingCount = -1;
            this.meleeBlockingCounterMax = -1;
            this.meleeBlockingCounter = 0;
        }

        public void func_75246_d() {
            if (!this.crawler.isBlocking()) {
                this.crawler.setIsBlocking(true);
            }
            ++this.blockingCount;
            if (this.isInMeleeRange()) {
                if (this.meleeBlockingCounterMax < 0) {
                    this.meleeBlockingCounterMax = 10 + this.crawler.field_70146_Z.nextInt(20);
                }
                ++this.meleeBlockingCounter;
            } else {
                this.meleeBlockingCounterMax = -1;
                this.meleeBlockingCounter = 0;
            }
        }
    }

    static class AIShieldCharge
    extends EntityAIBase {
        private EntityCryptCrawler crawler;
        private int chargeCooldown;
        private int chargeCooldownMax;
        private int chargeTimer = 0;

        public AIShieldCharge(EntityCryptCrawler crawler) {
            this.crawler = crawler;
            this.func_75248_a(27);
        }

        protected boolean isHoldingShield() {
            if (this.crawler != null) {
                ItemStack heldItem = this.crawler.func_184582_a(EntityEquipmentSlot.OFFHAND);
                if (heldItem.func_190926_b()) {
                    return false;
                }
                return heldItem.func_77973_b().isShield(heldItem, (EntityLivingBase)this.crawler);
            }
            return false;
        }

        public boolean func_75250_a() {
            if (!this.crawler.isChief()) {
                return false;
            }
            ItemStack heldItem = this.crawler.func_184582_a(EntityEquipmentSlot.OFFHAND);
            if (heldItem.func_190926_b()) {
                return false;
            }
            if (!heldItem.func_77973_b().isShield(heldItem, (EntityLivingBase)this.crawler)) {
                return false;
            }
            if (this.crawler.func_70638_az() != null) {
                if (this.chargeCooldownMax < 0) {
                    this.chargeCooldownMax = 80 + this.crawler.field_70146_Z.nextInt(90);
                }
                ++this.chargeCooldown;
                return this.chargeCooldown > this.chargeCooldownMax;
            }
            return false;
        }

        public void func_75249_e() {
            this.chargeCooldown = 0;
            this.chargeCooldownMax = -1;
        }

        public boolean func_75253_b() {
            return this.isHoldingShield() && this.chargeTimer < 60;
        }

        public void func_75251_c() {
            this.crawler.setIsBlocking(false);
            this.chargeTimer = 0;
        }

        public void func_75246_d() {
            ++this.chargeTimer;
            if (!this.crawler.isBlocking()) {
                this.crawler.setIsBlocking(true);
            }
            if (this.chargeTimer < 20) {
                this.crawler.func_70095_a(true);
            } else {
                this.crawler.func_70095_a(false);
            }
            EntityLivingBase target = this.crawler.func_70638_az();
            if (target != null) {
                this.crawler.func_70625_a((Entity)target, 15.0f, 15.0f);
            }
        }
    }

    static class AICryptCrawlerAttack
    extends EntityAIAttackMelee {
        public AICryptCrawlerAttack(EntityCryptCrawler crypt_crawler) {
            super((EntityCreature)crypt_crawler, 1.2, false);
            this.func_75248_a(this.func_75247_h() | 0x10);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 3.0f + attackTarget.field_70130_N;
        }
    }
}

