/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.entity.ai.EntityAIFollowTarget;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityCaveFish
extends EntityCreature
implements IEntityBL {
    protected static final DataParameter<Boolean> IS_LEADER = EntityDataManager.func_187226_a(EntityCaveFish.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIWander wanderAbout;
    private EntityAIFollowTarget followLeader;
    private EntityAIAvoidEntity<EntityLivingBase> aiAvoidFollowers;
    private EntityAINearestAttackableTarget targetRivalLeader;
    private AICaveFishMeleeAttack attackLeader;
    private boolean spawnedChildren = false;

    public EntityCaveFish(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.4f);
        this.func_70050_g(80);
        this.field_70765_h = new CaveFishMoveHelper(this);
        this.func_184644_a(PathNodeType.WALKABLE, -8.0f);
        this.func_184644_a(PathNodeType.BLOCKED, -8.0f);
        this.func_184644_a(PathNodeType.WATER, 16.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_LEADER, (Object)false);
    }

    protected void func_184651_r() {
        this.aiAvoidFollowers = new EntityAIAvoidEntity((EntityCreature)this, EntityLivingBase.class, entity -> entity instanceof EntityCaveFish, 10.0f, 0.5, 1.0);
        this.wanderAbout = new EntityAIWander((EntityCreature)this, 0.5, 5);
        this.followLeader = new EntityAIFollowTarget((EntityLiving)this, new EntityAIFollowTarget.FollowClosest<EntityCaveFish>((EntityLiving)this, EntityCaveFish.class, entity -> entity instanceof EntityCaveFish && ((EntityCaveFish)entity).isLeader(), 16.0), 14.0, 1.0f, 16.0f, false);
        this.targetRivalLeader = new EntityAINearestAttackableTarget((EntityCreature)this, EntityCaveFish.class, 0, false, true, entity -> entity instanceof EntityCaveFish && entity.isLeader());
        this.attackLeader = new AICaveFishMeleeAttack(this);
        this.field_70714_bg.func_75776_a(2, this.aiAvoidFollowers);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.4));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public PathNavigate func_175447_b(World world) {
        return new PathNavigateSwimmer((EntityLiving)this, world);
    }

    private void checkSpawnChildren() {
        if (!this.func_130014_f_().field_72995_K && !this.spawnedChildren) {
            this.setIsLeader(true);
            for (int x = 0; x < 3 + this.field_70170_p.field_73012_v.nextInt(4); ++x) {
                EntityCaveFish fish = new EntityCaveFish(this.field_70170_p);
                fish.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70170_p.field_73012_v.nextFloat() * 360.0f, 0.0f);
                fish.setIsLeader(false);
                fish.spawnedChildren = true;
                this.field_70170_p.func_72838_d((Entity)fish);
            }
            this.spawnedChildren = true;
        }
    }

    public void setIsLeader(boolean isLeader) {
        this.field_70180_af.func_187227_b(IS_LEADER, (Object)isLeader);
        if (!this.field_70170_p.field_72995_K) {
            if (isLeader) {
                this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.targetRivalLeader);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.followLeader);
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.wanderAbout);
                this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.attackLeader);
            } else {
                this.field_70715_bh.func_85156_a((EntityAIBase)this.targetRivalLeader);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.wanderAbout);
                this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.followLeader);
                this.field_70714_bg.func_85156_a((EntityAIBase)this.attackLeader);
            }
        }
    }

    public boolean isLeader() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_LEADER);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_LEADER.equals(key)) {
            if (this.isLeader()) {
                this.func_70105_a(0.6f, 0.4f);
            } else {
                this.func_70105_a(0.3f, 0.2f);
            }
        }
        super.func_184206_a(key);
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74757_a("isLeader", this.isLeader());
        nbt.func_74757_a("spawnedChildren", this.spawnedChildren);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setIsLeader(nbt.func_74767_n("isLeader"));
        this.spawnedChildren = nbt.func_74767_n("spawnedChildren");
    }

    public boolean func_70652_k(Entity entity) {
        boolean hitTarget = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (hitTarget) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return hitTarget;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.FISH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundRegistry.FISH_DEATH;
    }

    @MethodsReturnNonnullByDefault
    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_187593_cC;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    public float func_180484_a(BlockPos pos) {
        return this.field_70170_p.func_180495_p(pos).func_185904_a() == Material.field_151586_h ? 10.0f + this.field_70170_p.func_175724_o(pos) - 0.5f : super.func_180484_a(pos);
    }

    public boolean func_70601_bi() {
        return this.field_70163_u <= 15.0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_177230_c() == BlockRegistry.SWAMP_WATER;
    }

    public boolean func_70090_H() {
        return this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v))).func_185904_a() == Material.field_151586_h;
    }

    public void func_191986_a(float strafe, float up, float forward) {
        if (this.func_70613_aW()) {
            if (this.func_70090_H()) {
                this.func_191958_b(strafe, up, forward, 0.1f);
                this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.field_70159_w *= 0.75;
                this.field_70181_x *= 0.75;
                this.field_70179_y *= 0.75;
                if (this.func_70638_az() == null) {
                    this.field_70181_x -= 0.003;
                }
            } else {
                super.func_191986_a(strafe, up, forward);
            }
        } else {
            super.func_191986_a(strafe, up, forward);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.isLeader() && this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82737_E() % 5L + (long)this.func_130014_f_().field_73012_v.nextInt(5) == 0L && this.func_70090_H()) {
            for (int i = 0; i < 2; ++i) {
                double a = Math.toRadians(this.field_70177_z);
                double offSetX = -Math.sin(a) * (double)this.field_70130_N * 0.5;
                double offSetZ = Math.cos(a) * (double)this.field_70130_N * 0.5;
                this.func_130014_f_().func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t + offSetX, this.field_70163_u + (double)this.field_70131_O * 0.5 + this.field_70146_Z.nextDouble() * 0.5, this.field_70161_v + offSetZ, 0.0, 0.4, 0.0, new int[0]);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 200L == 0L) {
            this.checkIfCanBeLeader();
        }
        if (!this.spawnedChildren && this.field_70173_aa % 20 == 0 && this.isLeader() && this.field_70170_p.func_184137_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0, false) != null) {
            this.checkSpawnChildren();
        }
        if (this.field_70171_ac) {
            this.func_70050_g(300);
        } else if (this.field_70122_E) {
            this.field_70181_x += 0.25;
            this.field_70159_w += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.075f);
            this.field_70179_y += (double)((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.075f);
            this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
            this.field_70122_E = false;
            this.field_70160_al = true;
            if (this.field_70170_p.func_82737_E() % 5L == 0L) {
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.FISH_FLOP, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.func_70665_d(DamageSource.field_76369_e, 0.5f);
        }
    }

    private void checkIfCanBeLeader() {
        AxisAlignedBB aoe = new AxisAlignedBB(this.func_180425_c()).func_186662_g(10.0);
        if (!this.func_130014_f_().field_72995_K) {
            List list = this.func_130014_f_().func_72872_a(EntityCaveFish.class, aoe);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityLivingBase entity = (EntityLivingBase)iterator.next();
                if (entity == null || !(entity instanceof EntityCaveFish) || ((EntityCaveFish)entity).isLeader()) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                this.promoteThisFish();
            }
            if (!list.isEmpty()) {
                return;
            }
        }
    }

    private void promoteThisFish() {
        this.setIsLeader(true);
    }

    public boolean func_70067_L() {
        return this.isLeader();
    }

    public boolean func_70058_J() {
        return this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty() && this.func_130014_f_().func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    protected ResourceLocation func_184647_J() {
        return null;
    }

    static class AICaveFishMeleeAttack
    extends EntityAIAttackMelee {
        public AICaveFishMeleeAttack(EntityCaveFish cave_fish) {
            super((EntityCreature)cave_fish, 0.65, false);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 0.75;
        }
    }

    static class CaveFishMoveHelper
    extends EntityMoveHelper {
        private final EntityCaveFish fish;

        public CaveFishMoveHelper(EntityCaveFish fish) {
            super((EntityLiving)fish);
            this.fish = fish;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO && !this.fish.func_70661_as().func_75500_f()) {
                double targetX = this.field_75646_b - this.fish.field_70165_t;
                double targetY = this.field_75647_c - this.fish.field_70163_u;
                double targetZ = this.field_75644_d - this.fish.field_70161_v;
                double targetDistance = targetX * targetX + targetY * targetY + targetZ * targetZ;
                targetDistance = MathHelper.func_76133_a((double)targetDistance);
                targetY /= targetDistance;
                float targetAngle = (float)(MathHelper.func_181159_b((double)targetZ, (double)targetX) * 57.29577951308232) - 90.0f;
                this.fish.field_70761_aq = this.fish.field_70177_z = this.func_75639_a(this.fish.field_70177_z, targetAngle, 90.0f);
                float travelSpeed = (float)(this.field_75645_e * this.fish.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                this.fish.func_70659_e(this.fish.func_70689_ay() + (travelSpeed - this.fish.func_70689_ay()) * 0.125f);
                double wiggleSpeed = Math.sin((double)(this.fish.field_70173_aa + this.fish.func_145782_y()) * 0.5) * (double)this.fish.field_70131_O * 0.05;
                double wiggleOffsetX = Math.cos(this.fish.field_70177_z * ((float)Math.PI / 180));
                double wiggleOffsetZ = Math.sin(this.fish.field_70177_z * ((float)Math.PI / 180));
                this.fish.field_70159_w += wiggleSpeed * wiggleOffsetX;
                this.fish.field_70179_y += wiggleSpeed * wiggleOffsetZ;
                wiggleSpeed = Math.sin((double)(this.fish.field_70173_aa + this.fish.func_145782_y()) * 0.75) * 0.05;
                this.fish.field_70181_x += wiggleSpeed * (wiggleOffsetZ + wiggleOffsetX) * 0.25;
                this.fish.field_70181_x += (double)this.fish.func_70689_ay() * targetY * 0.1;
                EntityLookHelper entitylookhelper = this.fish.func_70671_ap();
                double targetDirectionX = this.fish.field_70165_t + targetX / targetDistance * 2.0;
                double targetDirectionY = (double)this.fish.func_70047_e() + this.fish.field_70163_u + targetY / targetDistance;
                double targetDirectionZ = this.fish.field_70161_v + targetZ / targetDistance * 2.0;
                double lookX = entitylookhelper.func_180423_e();
                double lookY = entitylookhelper.func_180422_f();
                double lookZ = entitylookhelper.func_180421_g();
                if (!entitylookhelper.func_180424_b()) {
                    lookX = targetDirectionX;
                    lookY = targetDirectionY;
                    lookZ = targetDirectionZ;
                }
                this.fish.func_70671_ap().func_75650_a(lookX + (targetDirectionX - lookX) * 0.125, lookY + (targetDirectionY - lookY) * 0.125, lookZ + (targetDirectionZ - lookZ) * 0.125, 10.0f, 40.0f);
            } else {
                this.fish.func_70659_e(0.0f);
            }
        }
    }
}

