/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity.mobs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import thebetweenlands.common.entity.ai.EntityAIAttackOnCollide;
import thebetweenlands.common.entity.mobs.EntitySiltCrab;
import thebetweenlands.common.entity.projectiles.EntityBubblerCrabBubble;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityBubblerCrab
extends EntitySiltCrab {
    private AIBubbleAttack aiBubbleAttack;

    public EntityBubblerCrab(World world) {
        super(world);
        this.func_70105_a(0.7f, 0.5f);
        this.field_70138_W = 2.0f;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundRegistry.CRUNCH;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundRegistry.CRUNCH;
    }

    @Override
    protected void func_184651_r() {
        this.aiAttack = new EntityAIAttackMelee((EntityCreature)this, 1.0, true);
        this.aiRunAway = new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 10.0f, 0.7, 0.7);
        this.aiTarget = new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true);
        this.aiBubbleAttack = new AIBubbleAttack(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.aiAttack);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)this.aiRunAway);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiBubbleAttack);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAttackOnCollide((EntityLiving)this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiTarget);
    }

    @Override
    public void randomizeSiltCrabProperties() {
        this.setItem1(this.getPartFromLootTable(LootTableRegistry.BUBBLER_CRAB_TRIM_1));
        this.setItem2(this.getPartFromLootTable(LootTableRegistry.BUBBLER_CRAB_TRIM_2));
        this.setItem3(this.getPartFromLootTable(LootTableRegistry.BUBBLER_CRAB_TRIM_3));
    }

    @Override
    public ItemMob getCrabPotItem() {
        return ItemRegistry.BUBBLER_CRAB;
    }

    static class AIBubbleAttack
    extends EntityAIBase {
        private final EntityBubblerCrab crab;
        private int attackStep;
        private int attackTime;

        public AIBubbleAttack(EntityBubblerCrab crabIn) {
            this.crab = crabIn;
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = this.crab.func_70638_az();
            return entitylivingbase != null && entitylivingbase.func_70089_S();
        }

        public void func_75249_e() {
            this.attackStep = 0;
        }

        public void func_75246_d() {
            double d0;
            --this.attackTime;
            EntityLivingBase entitylivingbase = this.crab.func_70638_az();
            if (entitylivingbase != null && entitylivingbase.func_70089_S() && (d0 = this.crab.func_70068_e((Entity)entitylivingbase)) < 25.0) {
                double d1 = entitylivingbase.field_70165_t - this.crab.field_70165_t;
                double d2 = entitylivingbase.field_70163_u - this.crab.field_70163_u;
                double d3 = entitylivingbase.field_70161_v - this.crab.field_70161_v;
                if (this.attackTime <= 0) {
                    ++this.attackStep;
                    if (this.attackStep == 1) {
                        this.attackTime = 40;
                    } else {
                        this.attackTime = 40;
                        this.attackStep = 0;
                    }
                    if (this.attackStep == 1) {
                        EntityBubblerCrabBubble entityBubble = new EntityBubblerCrabBubble(this.crab.func_130014_f_(), (EntityLiving)this.crab);
                        entityBubble.func_70107_b(this.crab.field_70165_t, this.crab.field_70163_u + (double)this.crab.field_70131_O + 0.5, this.crab.field_70161_v);
                        entityBubble.func_70186_c(d1, d2, d3, 0.5f, 0.0f);
                        this.crab.func_130014_f_().func_72838_d((Entity)entityBubble);
                        this.crab.func_130014_f_().func_184133_a((EntityPlayer)null, this.crab.func_180425_c(), (SoundEvent)SoundRegistry.BUBBLER_SPIT, SoundCategory.HOSTILE, 1.0f, 1.0f);
                        this.crab.aggroCooldown = 0;
                    }
                }
            }
            super.func_75246_d();
        }
    }
}

