/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thebetweenlands.common.entity.EntityCCGroundSpawner;
import thebetweenlands.common.entity.mobs.EntityLargeSludgeWorm;
import thebetweenlands.common.entity.mobs.EntitySludgeWorm;
import thebetweenlands.common.entity.mobs.EntityTinySludgeWorm;
import thebetweenlands.common.world.storage.BetweenlandsWorldStorage;

public class EntityWormGroundSpawner
extends EntityCCGroundSpawner {
    public EntityWormGroundSpawner(World world) {
        super(world);
        this.func_70105_a(3.0f, 0.5f);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public boolean isSpawnEventActive(World world) {
        BetweenlandsWorldStorage worldStorage = BetweenlandsWorldStorage.forWorld(world);
        return worldStorage.getEnvironmentEventRegistry().heavyRain.isActive();
    }

    @Override
    @Nullable
    protected Entity checkArea() {
        if (!this.func_130014_f_().field_72995_K) {
            if (this.getCanBeRemovedSafely() && this.canBeRemovedNow()) {
                this.func_70106_y();
            }
            if (this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
                if (this.isWorldSpawned() && !this.isSpawnEventActive(this.func_130014_f_())) {
                    return null;
                }
                List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, this.proximityBox());
                if (list.stream().filter(e -> e instanceof EntitySludgeWorm).count() >= 4L) {
                    return null;
                }
                for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
                    Entity entity = (Entity)list.get(entityCount);
                    if (entity == null || !(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_175149_v() || ((EntityPlayer)entity).func_184812_l_()) continue;
                    if (this.canSneakPast() && entity.func_70093_af()) {
                        return null;
                    }
                    if (this.checkSight() && !this.func_70685_l(entity) || this.getCanBeRemovedSafely()) {
                        return null;
                    }
                    for (int count = 0; count < this.getEntitySpawnCount(); ++count) {
                        Entity spawn = this.getEntitySpawned();
                        if (spawn == null) continue;
                        this.performPreSpawnaction(entity, spawn);
                        if (!spawn.field_70128_L) {
                            this.func_130014_f_().func_72838_d(spawn);
                        }
                        this.performPostSpawnaction(entity, spawn);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public boolean canBeRemovedNow() {
        AxisAlignedBB dead_zone = this.func_174813_aQ().func_72314_b(0.0, 1.0, 0.0).func_72317_d(0.0, -0.5, 0.0);
        List list = this.func_130014_f_().func_72872_a(EntityLivingBase.class, dead_zone);
        return list.stream().filter(e -> e instanceof EntitySludgeWorm).count() < 1L;
    }

    @Override
    protected Entity getEntitySpawned() {
        EntitySludgeWorm worm = null;
        int rand = this.func_130014_f_().field_73012_v.nextInt(5);
        switch (rand) {
            case 0: {
                worm = new EntityLargeSludgeWorm(this.func_130014_f_());
                break;
            }
            case 1: 
            case 2: {
                worm = new EntitySludgeWorm(this.func_130014_f_());
                break;
            }
            case 3: 
            case 4: {
                worm = new EntityTinySludgeWorm(this.func_130014_f_());
            }
        }
        if (worm != null) {
            worm.func_180482_a(this.func_130014_f_().func_175649_E(this.func_180425_c()), null);
        }
        return worm;
    }

    @Override
    protected void performPreSpawnaction(Entity targetEntity, Entity entitySpawned) {
        if (this.isWorldSpawned()) {
            this.setSpawnCount(this.getSpawnCount() + 1);
        }
        this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), this.getDigSound(), SoundCategory.HOSTILE, 0.5f, 1.0f);
        entitySpawned.func_70107_b((double)((float)this.func_180425_c().func_177958_n() + 0.5f), (double)((float)this.func_180425_c().func_177956_o() - 0.0f), (double)((float)this.func_180425_c().func_177952_p() + 0.5f));
    }

    @Override
    protected int maxUseCount() {
        return 8;
    }
}

