/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.item.misc.ItemVolarkite;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.util.PlayerUtil;

public class EntityVolarkite
extends Entity {
    public float prevRotationRoll;
    public float rotationRoll;
    protected int updraftTicks = 0;
    protected int downdraftTicks = 0;
    protected int draftSourcePos = 0;
    protected int userInAirTicks = 20;
    private static boolean isMountingEvent = false;

    public EntityVolarkite(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.8f);
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }

    public double func_70042_X() {
        return 0.01 + (this.func_184179_bs() != null ? -this.func_184179_bs().func_70033_W() : 0.0);
    }

    public double func_70033_W() {
        return this.func_184187_bx() != null ? -this.func_184187_bx().func_70042_X() : 0.0;
    }

    public void handleRiderDismount(EntityLivingBase rider) {
        float yaw = rider.field_70177_z;
        float pitch = rider.field_70125_A;
        rider.func_184210_p();
        rider.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, yaw, pitch);
        rider.field_70159_w = this.field_70159_w;
        rider.field_70181_x = this.field_70181_x;
        rider.field_70179_y = this.field_70179_y;
        rider.field_70122_E = this.field_70122_E;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        PlayerUtil.resetFloating(passenger);
        PlayerUtil.resetVehicleFloating(passenger);
    }

    public void func_70030_z() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.prevRotationRoll = this.rotationRoll;
        Entity passenger = this.func_184179_bs();
        Entity riding = this.func_184187_bx();
        if (!this.field_70170_p.field_72995_K) {
            boolean hasUpdraft;
            if (riding != null && riding.func_70093_af()) {
                this.func_184210_p();
            }
            boolean bl = hasUpdraft = this.updraftTicks > 0;
            if (this.field_70122_E && !hasUpdraft) {
                this.userInAirTicks = 0;
                if (passenger != null) {
                    this.func_184226_ay();
                    this.func_184205_a(passenger, true);
                }
            } else if (riding != null && (hasUpdraft || riding.field_70181_x < 0.0 && this.userInAirTicks++ > 3 && riding.field_70143_R > 0.55f)) {
                double mx = riding.field_70159_w;
                double my = riding.field_70181_x;
                double mz = riding.field_70179_y;
                this.func_184210_p();
                riding.func_184220_m((Entity)this);
                this.field_70159_w = mx;
                this.field_70181_x = my;
                this.field_70179_y = mz;
                this.field_70133_I = true;
                this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers(riding));
            }
            if (this.func_184102_h() != null && this.func_184187_bx() != null) {
                this.func_184102_h().func_184103_al().func_148540_a((Packet)new SPacketSetPassengers(this.func_184187_bx()));
            }
        }
        if (riding != null) {
            this.field_70177_z = riding.field_70177_z;
        }
        double targetMotionY = -0.04;
        this.field_70181_x = targetMotionY + (this.field_70181_x - targetMotionY) * 0.92;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70072_I();
        float invFriction = 1.0f;
        if (this.field_70122_E) {
            invFriction *= 0.8f;
        }
        if (this.func_70090_H() || this.func_180799_ab()) {
            invFriction *= 0.8f;
            if (this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O + 0.75, this.field_70161_v)).func_185904_a().func_76224_d()) {
                invFriction *= 0.5f;
            }
        }
        this.field_70159_w *= (double)invFriction;
        this.field_70181_x *= (double)invFriction;
        this.field_70179_y *= (double)invFriction;
        Entity controller = passenger != null ? passenger : riding;
        Vec3d kiteDir = new Vec3d(Math.cos(Math.toRadians(this.field_70177_z + 90.0f)), 0.0, Math.sin(Math.toRadians(this.field_70177_z + 90.0f)));
        double rotIncr = 0.0;
        boolean hasValidUser = false;
        if (controller != null) {
            controller.field_70143_R = 0.0f;
            if (this.field_70181_x < 0.0 && !this.field_70122_E) {
                double speedBoost = -this.field_70181_x * 0.1 + MathHelper.func_151237_a((double)(Math.sin(Math.toRadians(this.field_70125_A)) * 0.5), (double)-0.02, (double)0.02);
                this.field_70159_w += kiteDir.field_72450_a * (speedBoost + 0.01);
                this.field_70179_y += kiteDir.field_72449_c * (speedBoost + 0.01);
                this.field_70133_I = true;
            }
            Vec3d controllerDir = new Vec3d(Math.cos(Math.toRadians(controller.field_70177_z + 90.0f)), 0.0, Math.sin(Math.toRadians(controller.field_70177_z + 90.0f)));
            double rotDiff = Math.toDegrees(Math.acos(kiteDir.func_72430_b(controllerDir))) * -Math.signum(kiteDir.func_72431_c((Vec3d)controllerDir).field_72448_b);
            rotIncr = MathHelper.func_151237_a((double)(rotDiff * 0.05), (double)-1.0, (double)1.0);
            this.field_70177_z = (float)((double)this.field_70177_z + rotIncr);
            if (!this.field_70122_E && controller instanceof EntityLivingBase) {
                float forward = ((EntityLivingBase)controller).field_191988_bg;
                if (forward > 0.1f) {
                    this.field_70125_A = 20.0f + (this.field_70125_A - 20.0f) * 0.9f;
                    this.field_70181_x -= 0.01;
                } else if (forward < -0.1f) {
                    this.field_70125_A = -20.0f + (this.field_70125_A + 20.0f) * 0.9f;
                }
            }
            for (ItemStack stack : controller.func_184214_aD()) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemVolarkite) || !((ItemVolarkite)stack.func_77973_b()).canRideKite(stack, controller)) continue;
                hasValidUser = true;
                break;
            }
        }
        this.rotationRoll = !this.field_70122_E && Math.abs(rotIncr) > 0.1 ? (float)(rotIncr * 15.0 + ((double)this.rotationRoll - rotIncr * 15.0) * 0.9) : (this.rotationRoll *= 0.9f);
        this.field_70125_A *= 0.9f;
        this.updateUpdraft();
        double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (speed > 0.1) {
            double dx = this.field_70159_w / speed;
            double dz = this.field_70179_y / speed;
            this.field_70159_w = (kiteDir.field_72450_a + (dx - kiteDir.field_72450_a) * 0.9) * speed;
            this.field_70179_y = (kiteDir.field_72449_c + (dz - kiteDir.field_72449_c) * 0.9) * speed;
            double maxSpeed = 0.6;
            if (speed > maxSpeed) {
                double targetX = dx * maxSpeed;
                double targetZ = dz * maxSpeed;
                this.field_70159_w = targetX + (this.field_70159_w - targetX) * 0.8;
                this.field_70179_y = targetZ + (this.field_70179_y - targetZ) * 0.8;
            }
            this.field_70133_I = true;
        }
        if (!this.field_70170_p.field_72995_K && !hasValidUser) {
            this.func_70106_y();
        }
        this.field_70148_d = false;
    }

    protected void updateUpdraft() {
        int i;
        int range = 10;
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185346_s();
        pos.func_181079_c(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        for (i = 0; i <= range; ++i) {
            IBlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
            Block block = state.func_177230_c();
            boolean hasSource = false;
            if (block instanceof IFluidBlock) {
                Fluid fluid = ((IFluidBlock)block).getFluid();
                if (fluid.getTemperature() > 373) {
                    this.updraftTicks = 25;
                    hasSource = true;
                } else if ((double)fluid.getTemperature() < 272.15) {
                    this.downdraftTicks = 25;
                    hasSource = true;
                }
            } else if (state.func_185904_a() == Material.field_151581_o || state.func_185904_a() == Material.field_151587_i || block instanceof BlockFire || block == BlockRegistry.OCTINE_ORE || block == BlockRegistry.OCTINE_BLOCK || block == BlockRegistry.PEAT_SMOULDERING) {
                this.updraftTicks = 25;
                hasSource = true;
            } else if (state.func_185904_a() == Material.field_151588_w || state.func_185904_a() == Material.field_151597_y || state.func_185904_a() == Material.field_151596_z || state.func_185904_a() == Material.field_151598_x) {
                this.downdraftTicks = 25;
                hasSource = true;
            } else if (!block.isAir(state, (IBlockAccess)this.field_70170_p, (BlockPos)pos)) break;
            if (hasSource) {
                this.draftSourcePos = pos.func_177956_o();
                break;
            }
            pos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
        }
        pos.func_185344_t();
        if (this.updraftTicks > 0 || this.downdraftTicks > 0) {
            if (this.field_70181_x < 1.0) {
                this.field_70181_x += this.downdraftTicks > 0 ? -0.03 : 0.1;
            }
            if (this.field_70170_p.field_72995_K) {
                for (i = 0; i < (this.downdraftTicks > 0 ? 2 : 10); ++i) {
                    float offsetX = this.field_70170_p.field_73012_v.nextFloat() - 0.5f;
                    float offsetZ = this.field_70170_p.field_73012_v.nextFloat() - 0.5f;
                    float len = (float)Math.sqrt(offsetX * offsetX + offsetZ * offsetZ);
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t + (double)(offsetX /= len), (double)this.draftSourcePos + (this.field_70163_u + (this.downdraftTicks > 0 ? 2.4 : 1.0) - (double)this.draftSourcePos) * (double)this.field_70170_p.field_73012_v.nextFloat(), this.field_70161_v + (double)(offsetZ /= len), this.field_70159_w, this.field_70181_x + (this.downdraftTicks > 0 ? -0.15 : 0.25), this.field_70179_y, new int[0]);
                }
            }
        }
        if (this.updraftTicks > 0) {
            --this.updraftTicks;
        }
        if (this.downdraftTicks > 0) {
            --this.downdraftTicks;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_184186_bw() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        passenger.field_70143_R = 0.0f;
        passenger.field_70159_w = this.field_70159_w;
        passenger.field_70181_x = this.field_70181_x;
        passenger.field_70179_y = this.field_70179_y;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return super.func_70112_a(distance) || this.func_184179_bs() != null && this.func_184179_bs().func_70112_a(distance);
    }

    @SubscribeEvent
    public static void onMountEvent(EntityMountEvent event) {
        if (!isMountingEvent) {
            isMountingEvent = true;
            try {
                if (event.isDismounting()) {
                    Entity mount = event.getEntityBeingMounted();
                    Entity rider = event.getEntityMounting();
                    if (mount instanceof EntityVolarkite && rider instanceof EntityLivingBase) {
                        event.setCanceled(true);
                        ((EntityVolarkite)mount).handleRiderDismount((EntityLivingBase)rider);
                    }
                }
            }
            finally {
                isMountingEvent = false;
            }
        }
    }
}

