/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleUrchinSpike;
import thebetweenlands.common.registries.SoundRegistry;

public class EntityUrchinSpikeAOE
extends Entity {
    private static final DataParameter<Integer> SPIKE_BOX_SIZE = EntityDataManager.func_187226_a(EntityUrchinSpikeAOE.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean shootSpikes;
    public int MAX_SPIKE_TIMER = 10;
    private EntityPlayer owner;
    private int damage;
    public static final byte EVENT_ATTACK = 66;

    public EntityUrchinSpikeAOE(World world) {
        super(world);
        this.func_70105_a(0.0f, 0.0f);
    }

    public EntityUrchinSpikeAOE(World world, EntityPlayer owner, int damage) {
        super(world);
        this.owner = owner;
        this.damage = damage;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SPIKE_BOX_SIZE, (Object)0);
    }

    public int getSpikeBoxTimer() {
        return (Integer)this.field_70180_af.func_187225_a(SPIKE_BOX_SIZE);
    }

    public void setSpikeBoxTimer(int count) {
        this.field_70180_af.func_187227_b(SPIKE_BOX_SIZE, (Object)count);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_130014_f_().field_72995_K) {
            this.checkAOEDamage();
            if (this.getSpikeBoxTimer() < this.MAX_SPIKE_TIMER) {
                this.setSpikeBoxTimer(this.getSpikeBoxTimer() + 1);
            }
            if (this.getSpikeBoxTimer() >= this.MAX_SPIKE_TIMER) {
                this.func_70106_y();
            }
        }
    }

    private void checkAOEDamage() {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            List list = this.func_130014_f_().func_175647_a(EntityLivingBase.class, this.spikesBox(), e -> e instanceof IMob);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                EntityLivingBase entity = (EntityLivingBase)iterator.next();
                if (!(entity != null && entity == this.owner || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) && (!(entity instanceof EntityPlayer) || !((EntityPlayer)entity).func_184812_l_())) continue;
                iterator.remove();
            }
            if (list.isEmpty()) {
                return;
            }
            if (!list.isEmpty()) {
                EntityLivingBase entity = (EntityLivingBase)list.get(0);
                if (entity.field_70172_ad <= 0) {
                    entity.func_70097_a((DamageSource)new EntityDamageSource("mob", (Entity)(this.owner != null ? this.owner : this)), 2.0f * (float)this.damage);
                }
            }
        }
    }

    public void shootSpikes() {
        this.func_130014_f_().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.URCHIN_SHOOT, SoundCategory.NEUTRAL, 1.0f, 1.5f + (this.func_130014_f_().field_73012_v.nextFloat() - this.func_130014_f_().field_73012_v.nextFloat()) * 0.5f);
        this.func_130014_f_().func_72960_a((Entity)this, (byte)66);
    }

    public AxisAlignedBB spikesBox() {
        float x = 2.0f / (float)this.MAX_SPIKE_TIMER * (float)this.getSpikeBoxTimer();
        float y = 2.0f / (float)this.MAX_SPIKE_TIMER * (float)this.getSpikeBoxTimer();
        float z = 2.0f / (float)this.MAX_SPIKE_TIMER * (float)this.getSpikeBoxTimer();
        return new AxisAlignedBB(this.func_180425_c()).func_72314_b((double)x, (double)y, (double)z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 66) {
            Vec3d frontCenter = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            for (int i = 0; i < 64; ++i) {
                Random rnd = this.field_70170_p.field_73012_v;
                float rx = rnd.nextFloat() * 4.0f - 2.0f;
                float ry = rnd.nextFloat() * 4.0f - 2.0f;
                float rz = rnd.nextFloat() * 4.0f - 2.0f;
                Vec3d vec = new Vec3d((double)rx, (double)ry, (double)rz);
                vec = vec.func_72432_b();
                ParticleUrchinSpike particle = (ParticleUrchinSpike)BLParticles.URCHIN_SPIKE.spawn(this.field_70170_p, frontCenter.field_72450_a, frontCenter.field_72448_b - 0.25, frontCenter.field_72449_c, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion(vec.field_72450_a * (double)0.175f, vec.field_72448_b * (double)0.15f + (double)0.35f, vec.field_72449_c * (double)0.175f)).withScale(0.2f));
                particle.setUseSound(this.field_70146_Z.nextInt(15) == 0);
            }
        }
    }

    protected void func_70037_a(NBTTagCompound nbt) {
    }

    protected void func_70014_b(NBTTagCompound nbt) {
    }
}

