/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleGasCloud;
import thebetweenlands.common.entity.EntityProximitySpawner;
import thebetweenlands.common.herblore.elixir.ElixirEffectRegistry;
import thebetweenlands.common.registries.SoundRegistry;

public class EntitySplodeshroom
extends EntityProximitySpawner {
    private static final byte EVENT_EXPLODE_PARTICLES = 100;
    public int MAX_SWELL = 40;
    public int MIN_SWELL = 0;
    private static final DataParameter<Boolean> IS_SWELLING = EntityDataManager.func_187226_a(EntitySplodeshroom.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SWELL_COUNT = EntityDataManager.func_187226_a(EntitySplodeshroom.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_EXPLODED = EntityDataManager.func_187226_a(EntitySplodeshroom.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> AOE_SIZE_XZ = EntityDataManager.func_187226_a(EntitySplodeshroom.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> AOE_SIZE_Y = EntityDataManager.func_187226_a(EntitySplodeshroom.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntitySplodeshroom(World world) {
        super(world);
        this.func_70105_a(0.5f, 1.0f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_SWELLING, (Object)false);
        this.field_70180_af.func_187214_a(SWELL_COUNT, (Object)0);
        this.field_70180_af.func_187214_a(HAS_EXPLODED, (Object)false);
        this.field_70180_af.func_187214_a(AOE_SIZE_XZ, (Object)Float.valueOf(4.0f));
        this.field_70180_af.func_187214_a(AOE_SIZE_Y, (Object)Float.valueOf(0.5f));
    }

    public void func_70071_h_() {
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_82737_E() % 5L == 0L) {
            if (!this.getHasExploded()) {
                this.checkArea();
            }
            if (this.getHasExploded()) {
                this.checkAreaOfEffect();
            }
        }
        if (!this.func_130014_f_().field_72995_K) {
            if (!this.getSwelling() && this.getSwellCount() > this.MIN_SWELL) {
                this.setSwellCount(this.getSwellCount() - 1);
            }
            if (this.getSwelling() && this.getSwellCount() < this.MAX_SWELL) {
                this.setSwellCount(this.getSwellCount() + 1);
            }
            if (this.getHasExploded()) {
                if (this.getSwellCount() < this.MAX_SWELL) {
                    this.setSwellCount(this.MAX_SWELL);
                }
                if (this.getAOESizeXZ() > 0.5f) {
                    this.setAOESizeXZ(this.getAOESizeXZ() - 0.01f);
                }
                if (this.getAOESizeXZ() <= 0.5f) {
                    this.func_70106_y();
                }
            }
        }
        if (this.getHasExploded()) {
            this.setBoundingBoxSize();
        }
        if (this.func_130014_f_().field_72995_K && this.getHasExploded()) {
            this.spawnCloudParticle();
        }
    }

    @Override
    @Nullable
    protected Entity checkArea() {
        Entity entity = null;
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            List list = this.func_130014_f_().func_72872_a(EntityPlayer.class, this.proximityBox());
            for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
                entity = (Entity)list.get(entityCount);
                if (entity == null || !(entity instanceof EntityPlayer) || ((EntityPlayer)entity).func_175149_v() || ((EntityPlayer)entity).func_184812_l_()) continue;
                if (this.canSneakPast() && entity.func_70093_af()) {
                    return null;
                }
                if (this.checkSight() && !this.func_70685_l(entity)) {
                    return null;
                }
                if (!this.getSwelling()) {
                    this.setSwelling(true);
                }
                if (this.field_70128_L || !this.isSingleUse() || this.getSwellCount() < this.MAX_SWELL) continue;
                this.explode();
            }
            if (entity == null && this.getSwelling()) {
                this.setSwelling(false);
            }
        }
        return entity;
    }

    @Nullable
    protected Entity checkAreaOfEffect() {
        Entity entity = null;
        if (!this.func_130014_f_().field_72995_K && this.func_130014_f_().func_175659_aa() != EnumDifficulty.PEACEFUL) {
            List list = this.func_130014_f_().func_72872_a(EntityPlayer.class, this.func_174813_aQ());
            for (int entityCount = 0; entityCount < list.size(); ++entityCount) {
                EntityPlayer player;
                entity = (Entity)list.get(entityCount);
                if (entity == null || !(entity instanceof EntityPlayer) || (player = (EntityPlayer)entity).func_175149_v() || player.func_184812_l_()) continue;
                player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 60));
                player.func_70690_d(ElixirEffectRegistry.EFFECT_DECAY.createEffect(40, 1));
            }
        }
        return entity;
    }

    private void explode() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)100);
        this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), (SoundEvent)SoundRegistry.SPLODESHROOM_POP, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        this.setHasExploded(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 100) {
            for (int count = 0; count <= 200; ++count) {
                Particle fx = new ParticleBreaking.SnowballFactory().func_178902_a(EnumParticleTypes.SNOWBALL.func_179348_c(), this.field_70170_p, this.field_70165_t + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), this.field_70163_u + 0.25 + this.field_70170_p.field_73012_v.nextDouble(), this.field_70161_v + (this.field_70170_p.field_73012_v.nextDouble() - 0.5), 0.0, 0.0, 0.0, new int[]{0});
                fx.func_70538_b(128.0f, 203.0f, 175.0f);
                Minecraft.func_71410_x().field_71452_i.func_78873_a(fx);
            }
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (AOE_SIZE_XZ.equals(key)) {
            this.setAOESizeXZ(this.getAOESizeXZ());
        }
        if (AOE_SIZE_Y.equals(key)) {
            this.setAOESizeY(this.getAOESizeY());
        }
        super.func_184206_a(key);
    }

    protected void setBoundingBoxSize() {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t - (double)this.getAOESizeXZ() * 0.5, this.field_70163_u, this.field_70161_v - (double)this.getAOESizeXZ() * 0.5, this.field_70165_t + (double)this.getAOESizeXZ() * 0.5, this.field_70163_u + (double)this.getAOESizeY(), this.field_70161_v + (double)this.getAOESizeXZ() * 0.5);
        this.func_174826_a(axisalignedbb);
    }

    private void setSwelling(boolean swell) {
        this.field_70180_af.func_187227_b(IS_SWELLING, (Object)swell);
        if (swell) {
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), (SoundEvent)SoundRegistry.SPLODESHROOM_WINDUP, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        } else {
            this.func_130014_f_().func_184133_a((EntityPlayer)null, this.func_180425_c(), (SoundEvent)SoundRegistry.SPLODESHROOM_WINDDOWN, SoundCategory.HOSTILE, 0.5f, 1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.8f);
        }
    }

    public boolean getSwelling() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SWELLING);
    }

    private void setSwellCount(int swellCountIn) {
        this.field_70180_af.func_187227_b(SWELL_COUNT, (Object)swellCountIn);
    }

    public int getSwellCount() {
        return (Integer)this.field_70180_af.func_187225_a(SWELL_COUNT);
    }

    private void setHasExploded(boolean hasExploded) {
        this.field_70180_af.func_187227_b(HAS_EXPLODED, (Object)hasExploded);
    }

    public boolean getHasExploded() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_EXPLODED);
    }

    private void setAOESizeXZ(float aoeSizeXZ) {
        this.field_70180_af.func_187227_b(AOE_SIZE_XZ, (Object)Float.valueOf(aoeSizeXZ));
    }

    public float getAOESizeXZ() {
        return ((Float)this.field_70180_af.func_187225_a(AOE_SIZE_XZ)).floatValue();
    }

    private void setAOESizeY(float aoeSizeY) {
        this.field_70180_af.func_187227_b(AOE_SIZE_Y, (Object)Float.valueOf(aoeSizeY));
    }

    public float getAOESizeY() {
        return ((Float)this.field_70180_af.func_187225_a(AOE_SIZE_Y)).floatValue();
    }

    protected boolean func_70610_aX() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return !this.getHasExploded();
    }

    public void func_70024_g(double x, double y, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x += y;
        this.field_70179_y = 0.0;
    }

    public boolean func_190530_aW() {
        return true;
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source == DamageSource.field_76380_i) {
            return true;
        }
        if (source instanceof EntityDamageSource) {
            Entity sourceEntity = ((EntityDamageSource)source).func_76346_g();
            if (sourceEntity instanceof EntityPlayer && !this.func_130014_f_().field_72995_K && !this.getHasExploded()) {
                this.explode();
            }
            return true;
        }
        return false;
    }

    @Override
    protected float getProximityHorizontal() {
        return 3.0f;
    }

    @Override
    protected float getProximityVertical() {
        return 1.0f;
    }

    @Override
    protected boolean canSneakPast() {
        return true;
    }

    @Override
    protected boolean checkSight() {
        return true;
    }

    @Override
    protected Entity getEntitySpawned() {
        return null;
    }

    @Override
    protected int getEntitySpawnCount() {
        return 1;
    }

    @Override
    protected boolean isSingleUse() {
        return true;
    }

    @Override
    protected int maxUseCount() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnCloudParticle() {
        double x = this.field_70165_t + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
        double y = this.field_70163_u + 0.1;
        double z = this.field_70161_v + (double)((this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 2.0f);
        double mx = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 12.0f;
        double my = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 16.0f * 0.1f;
        double mz = (this.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 12.0f;
        int[] color = new int[]{100, 100, 0, 255};
        ParticleGasCloud hazeParticle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(null)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f)).withScale(8.0f));
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_HEAT_HAZE, hazeParticle);
        ParticleGasCloud particle = (ParticleGasCloud)BLParticles.GAS_CLOUD.create(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withData(null)).withMotion(mx, my, mz)).withColor((float)color[0] / 255.0f, (float)color[1] / 255.0f, (float)color[2] / 255.0f, (float)color[3] / 255.0f)).withScale(4.0f));
        BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.GAS_CLOUDS_TEXTURED, particle);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }
}

