/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityRopeNode
extends Entity {
    private static final DataParameter<Integer> DW_PREV_NODE = EntityDataManager.func_187226_a(EntityRopeNode.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DW_NEXT_NODE = EntityDataManager.func_187226_a(EntityRopeNode.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final double ROPE_LENGTH = 4.0;
    public static final double ROPE_LENGTH_MAX = 12.0;
    private boolean canExtend = true;
    private boolean pickUp = false;
    private int despawnTimer = 0;
    private UUID nextNodeUUID;
    private UUID prevNodeUUID;
    private int cachedPrevNodeDW;
    private int cachedNextNodeDW;
    private Entity cachedNextNodeEntity;
    private Entity cachedPrevNodeEntity;
    private BlockPos lightBlock = null;

    public EntityRopeNode(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DW_PREV_NODE, (Object)-1);
        this.cachedPrevNodeDW = -1;
        this.func_184212_Q().func_187214_a(DW_NEXT_NODE, (Object)-1);
        this.cachedNextNodeDW = -1;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setNextNodeUUID(nbt.func_186855_b("nextNodeUUID") ? nbt.func_186857_a("nextNodeUUID") : null);
        this.setPreviousNodeUUID(nbt.func_186855_b("previousNodeUUID") ? nbt.func_186857_a("previousNodeUUID") : null);
        this.pickUp = nbt.func_74767_n("pickUp");
        this.canExtend = nbt.func_74767_n("canExtend");
        this.despawnTimer = nbt.func_74762_e("despawnTimer");
        this.lightBlock = nbt.func_150297_b("lightBlock", 4) ? BlockPos.func_177969_a((long)nbt.func_74763_f("lightBlock")) : null;
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.getNextNodeUUID() != null) {
            nbt.func_186854_a("nextNodeUUID", this.getNextNodeUUID());
        }
        if (this.getPreviousNodeUUID() != null) {
            nbt.func_186854_a("previousNodeUUID", this.getPreviousNodeUUID());
        }
        nbt.func_74757_a("pickUp", this.pickUp);
        nbt.func_74757_a("canExtend", this.canExtend);
        nbt.func_74768_a("despawnTimer", this.despawnTimer);
        if (this.lightBlock != null) {
            nbt.func_74772_a("lightBlock", this.lightBlock.func_177986_g());
        }
    }

    public void func_70030_z() {
        Entity prevNode;
        Entity nextNode;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        boolean attached = this.isAttached();
        if (!attached) {
            this.func_70072_I();
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        boolean prevAttached = attached;
        attached = this.isAttached();
        if (attached && !prevAttached) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187778_dq, SoundCategory.PLAYERS, 1.0f, 1.5f);
        }
        if (!this.field_70170_p.field_72995_K) {
            nextNode = this.getNextNodeByUUID();
            prevNode = this.getPreviousNodeByUUID();
            if (nextNode != null && nextNode.func_145782_y() != this.cachedNextNodeDW) {
                this.func_184212_Q().func_187227_b(DW_NEXT_NODE, (Object)nextNode.func_145782_y());
                this.cachedNextNodeDW = nextNode.func_145782_y();
            } else if (nextNode == null && this.cachedNextNodeDW != -1) {
                this.func_184212_Q().func_187227_b(DW_NEXT_NODE, (Object)-1);
                this.cachedNextNodeDW = -1;
            }
            if (prevNode != null && prevNode.func_145782_y() != this.cachedPrevNodeDW) {
                this.func_184212_Q().func_187227_b(DW_PREV_NODE, (Object)prevNode.func_145782_y());
                this.cachedPrevNodeDW = prevNode.func_145782_y();
            } else if (prevNode == null && this.cachedPrevNodeDW != -1) {
                this.func_184212_Q().func_187227_b(DW_PREV_NODE, (Object)-1);
                this.cachedPrevNodeDW = -1;
            }
            if (this.func_70089_S()) {
                if (attached) {
                    BlockPos pos = this.func_180425_c();
                    if (this.lightBlock != null && (this.lightBlock.func_177958_n() != pos.func_177958_n() || this.lightBlock.func_177956_o() != pos.func_177956_o() || this.lightBlock.func_177952_p() != pos.func_177952_p())) {
                        if (this.field_70170_p.func_175667_e(this.lightBlock) && this.field_70170_p.func_180495_p(this.lightBlock).func_177230_c() == BlockRegistry.CAVING_ROPE_LIGHT) {
                            this.field_70170_p.func_175698_g(this.lightBlock);
                        }
                        this.lightBlock = null;
                    }
                    if (this.lightBlock == null && this.field_70170_p.func_175623_d(pos)) {
                        this.field_70170_p.func_175656_a(pos, BlockRegistry.CAVING_ROPE_LIGHT.func_176223_P());
                        this.lightBlock = pos;
                    }
                } else if (this.lightBlock != null) {
                    if (this.field_70170_p.func_175667_e(this.lightBlock) && this.field_70170_p.func_180495_p(this.lightBlock).func_177230_c() == BlockRegistry.CAVING_ROPE_LIGHT) {
                        this.field_70170_p.func_175698_g(this.lightBlock);
                    }
                    this.lightBlock = null;
                }
            }
        } else {
            nextNode = this.getNextNode();
            prevNode = this.getPreviousNode();
        }
        if (!this.field_70170_p.field_72995_K && nextNode instanceof EntityPlayer) {
            if ((double)nextNode.func_70032_d((Entity)this) > 1.5) {
                this.pickUp = true;
            }
            if (this.pickUp && nextNode.func_174813_aQ().func_72314_b(0.4, 0.4, 0.4).func_72326_a(this.func_174813_aQ())) {
                this.removeNode(nextNode);
                EntityPlayer player = (EntityPlayer)nextNode;
                if (player.field_71071_by.func_70441_a(new ItemStack(ItemRegistry.CAVING_ROPE, 1))) {
                    this.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                } else {
                    EntityItem itemEntity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ItemRegistry.CAVING_ROPE, 1));
                    itemEntity.func_174867_a(0);
                    this.field_70170_p.func_72838_d((Entity)itemEntity);
                }
            }
            if ((double)nextNode.func_70032_d((Entity)this) < 3.0) {
                this.canExtend = true;
            }
            if (this.canExtend && (double)nextNode.func_70032_d((Entity)this) > 5.0) {
                InventoryPlayer inventory = ((EntityPlayer)nextNode).field_71071_by;
                int invSize = inventory.func_70302_i_();
                for (int i = 0; i < invSize; ++i) {
                    EntityRopeNode rope;
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack.func_190926_b() || stack.func_77973_b() != ItemRegistry.CAVING_ROPE) continue;
                    stack.func_190918_g(1);
                    inventory.func_70299_a(i, stack.func_190916_E() > 0 ? stack : ItemStack.field_190927_a);
                    Vec3d connection = this.getConnectionToNext();
                    if (connection == null) continue;
                    Vec3d newPos = nextNode.func_174791_d().func_178787_e(connection.func_186678_a(-0.5)).func_72441_c(0.0, 0.1, 0.0);
                    RayTraceResult result = this.field_70170_p.func_72901_a(nextNode.func_174791_d(), newPos, false);
                    if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && result.field_72307_f.func_72436_e(nextNode.func_174791_d()) < newPos.func_72436_e(nextNode.func_174791_d())) {
                        newPos = result.field_72307_f.func_178787_e(result.field_72307_f.func_178788_d(this.func_174791_d()).func_72432_b().func_186678_a(0.1));
                    }
                    if (!(rope = this.extendRope(nextNode, newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c)).isAttached()) break;
                    this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187778_dq, SoundCategory.PLAYERS, 1.0f, 1.5f);
                    break;
                }
            }
            if ((double)nextNode.func_70032_d((Entity)this) > 12.0) {
                if (nextNode instanceof EntityPlayer) {
                    ((EntityPlayer)nextNode).func_146105_b((ITextComponent)new TextComponentTranslation("chat.rope.disconnected", new Object[0]), true);
                }
                this.setNextNode(null);
            }
        }
        this.field_70181_x *= 0.88;
        this.field_70159_w *= 0.88;
        this.field_70179_y *= 0.88;
        if (!(attached || this.field_70122_E || this.field_70171_ac)) {
            Vec3d diff;
            Vec3d constrainedPoint;
            double mz;
            double my;
            double mx;
            Vec3d nextPoint;
            Vec3d tetherPoint;
            Vec3d connection;
            boolean isFloating = false;
            if (nextNode != null && (double)this.func_70032_d(nextNode) >= 4.0 && (connection = this.getConnectionToNext()) != null) {
                double mx2 = connection.field_72450_a * 0.02;
                double my2 = connection.field_72448_b * 0.02;
                double mz2 = connection.field_72449_c * 0.02;
                double len = Math.sqrt(mx2 * mx2 + my2 * my2 + mz2 * mz2);
                if (len > 0.5) {
                    mx2 /= len * 0.5;
                    my2 /= len * 0.5;
                    mz2 /= len * 0.5;
                }
                if (prevNode != null && prevNode.func_70011_f(this.field_70165_t + mx2, this.field_70163_u + my2, this.field_70161_v + mz2) < 5.0) {
                    this.field_70159_w += mx2;
                    this.field_70179_y += mz2;
                    this.field_70181_x += my2;
                    isFloating = true;
                }
            }
            if (!isFloating) {
                this.field_70181_x -= 0.28;
            }
            if (nextNode != null && (tetherPoint = new Vec3d(nextNode.field_70165_t, nextNode.field_70163_u, nextNode.field_70161_v)).func_72438_d(nextPoint = new Vec3d(this.field_70165_t + (mx = this.field_70159_w), this.field_70163_u + (my = this.field_70181_x), this.field_70161_v + (mz = this.field_70179_y))) >= 4.0) {
                constrainedPoint = nextPoint.func_178788_d(tetherPoint).func_72432_b();
                constrainedPoint = new Vec3d(constrainedPoint.field_72450_a * 4.0, constrainedPoint.field_72448_b * 4.0, constrainedPoint.field_72449_c * 4.0).func_72441_c(tetherPoint.field_72450_a, tetherPoint.field_72448_b, tetherPoint.field_72449_c);
                diff = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178788_d(constrainedPoint);
                this.field_70159_w = -diff.field_72450_a;
                this.field_70181_x = -diff.field_72448_b;
                this.field_70179_y = -diff.field_72449_c;
            }
            if (prevNode != null && (tetherPoint = new Vec3d(prevNode.field_70165_t, prevNode.field_70163_u, prevNode.field_70161_v)).func_72438_d(nextPoint = new Vec3d(this.field_70165_t + (mx = this.field_70159_w), this.field_70163_u + (my = this.field_70181_x), this.field_70161_v + (mz = this.field_70179_y))) >= 4.0) {
                constrainedPoint = nextPoint.func_178788_d(tetherPoint).func_72432_b();
                constrainedPoint = new Vec3d(constrainedPoint.field_72450_a * 4.0, constrainedPoint.field_72448_b * 4.0, constrainedPoint.field_72449_c * 4.0).func_72441_c(tetherPoint.field_72450_a, tetherPoint.field_72448_b, tetherPoint.field_72449_c);
                diff = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_178788_d(constrainedPoint).func_186678_a(0.8);
                this.field_70159_w = -diff.field_72450_a;
                this.field_70181_x = -diff.field_72448_b;
                this.field_70179_y = -diff.field_72449_c;
            }
            double speed = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y);
            this.field_70159_w *= Math.min(speed, 0.05) / 0.05;
            this.field_70181_x *= Math.min(speed, 0.05) / 0.05;
            this.field_70179_y *= Math.min(speed, 0.05) / 0.05;
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (nextNode == null) {
                if (prevNode == null) {
                    this.func_174812_G();
                } else {
                    ++this.despawnTimer;
                    if (this.despawnTimer >= BetweenlandsConfig.GENERAL.cavingRopeDespawnTime * 20) {
                        if (prevNode != null && prevNode instanceof EntityRopeNode) {
                            EntityRopeNode prevRopeNode = (EntityRopeNode)prevNode;
                            prevRopeNode.setNextNode(null);
                            prevRopeNode.despawn();
                        }
                        this.func_174812_G();
                    }
                }
            } else {
                this.despawnTimer = 0;
            }
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K) {
            Entity prevNode = this.getPreviousNodeByUUID();
            Entity nextNode = this.getNextNodeByUUID();
            if (prevNode != null) {
                if (nextNode == null) {
                    EntityRopeNode connectedRopeNode = null;
                    for (Entity e : player.field_70170_p.field_72996_f) {
                        EntityRopeNode ropeNode;
                        if (!(e instanceof EntityRopeNode) || (ropeNode = (EntityRopeNode)e).getNextNodeByUUID() != player) continue;
                        connectedRopeNode = ropeNode;
                        break;
                    }
                    if (connectedRopeNode != null) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("chat.rope.already_connected", new Object[0]), true);
                        return false;
                    }
                    this.setNextNode((Entity)player);
                    return true;
                }
                if (!(nextNode instanceof EntityRopeNode)) {
                    this.setNextNode(null);
                    return true;
                }
            }
            if (nextNode instanceof EntityRopeNode) {
                EntityRopeNode endNode = (EntityRopeNode)nextNode;
                while (endNode.getNextNodeByUUID() instanceof EntityRopeNode && endNode.getNextNodeByUUID() != this) {
                    endNode = (EntityRopeNode)endNode.getNextNodeByUUID();
                }
                if (endNode.getNextNodeByUUID() == null && endNode.getPreviousNodeByUUID() instanceof EntityRopeNode) {
                    ((EntityRopeNode)endNode.getPreviousNodeByUUID()).setNextNode(null);
                    endNode.func_70106_y();
                    if (player.field_71071_by.func_70441_a(new ItemStack(ItemRegistry.CAVING_ROPE, 1))) {
                        this.field_70170_p.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    } else {
                        EntityItem itemEntity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(ItemRegistry.CAVING_ROPE, 1));
                        itemEntity.func_174867_a(0);
                        this.field_70170_p.func_72838_d((Entity)itemEntity);
                    }
                    return true;
                }
            }
        } else {
            return true;
        }
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.lightBlock != null && this.field_70170_p.func_175667_e(this.lightBlock) && this.field_70170_p.func_180495_p(this.lightBlock).func_177230_c() == BlockRegistry.CAVING_ROPE_LIGHT) {
            this.field_70170_p.func_175698_g(this.lightBlock);
        }
        this.lightBlock = null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    public void removeNode(Entity nextConnectionNode) {
        Entity prevNode = this.getPreviousNodeByUUID();
        if (prevNode != null && prevNode instanceof EntityRopeNode) {
            ((EntityRopeNode)prevNode).setNextNode(nextConnectionNode);
            ((EntityRopeNode)prevNode).canExtend = false;
        }
        this.func_174812_G();
    }

    public void despawn() {
        this.despawnTimer = BetweenlandsConfig.GENERAL.cavingRopeDespawnTime * 20;
    }

    public boolean isAttached() {
        return !this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1)).isEmpty();
    }

    public EntityRopeNode extendRope(Entity entity, double x, double y, double z) {
        EntityRopeNode ropeNode = new EntityRopeNode(this.field_70170_p);
        ropeNode.func_70012_b(x, y, z, 0.0f, 0.0f);
        ropeNode.setPreviousNode(this);
        ropeNode.setNextNode(entity);
        this.setNextNode(ropeNode);
        this.field_70170_p.func_72838_d((Entity)ropeNode);
        if (entity instanceof EntityPlayerMP) {
            AdvancementCriterionRegistry.CAVINGROPE_PLACED.trigger((EntityPlayerMP)entity);
        }
        return ropeNode;
    }

    public Vec3d getConnectionToNext() {
        Entity nextNode = this.field_70170_p.field_72995_K ? this.getNextNode() : this.getNextNodeByUUID();
        if (nextNode != null) {
            return new Vec3d(nextNode.field_70165_t - this.field_70165_t, nextNode.field_70163_u - this.field_70163_u, nextNode.field_70161_v - this.field_70161_v);
        }
        return null;
    }

    public void setNextNodeUUID(UUID uuid) {
        this.nextNodeUUID = uuid;
        if (this.cachedNextNodeEntity != null && !this.cachedNextNodeEntity.func_110124_au().equals(uuid)) {
            this.cachedNextNodeEntity = null;
        }
    }

    public UUID getNextNodeUUID() {
        return this.nextNodeUUID;
    }

    public void setNextNode(Entity entity) {
        this.cachedNextNodeEntity = entity;
        this.setNextNodeUUID(entity == null ? null : entity.func_110124_au());
    }

    public Entity getNextNodeByUUID() {
        Entity entity;
        if (this.cachedNextNodeEntity != null && this.cachedNextNodeEntity.func_70089_S() && this.cachedNextNodeEntity.func_110124_au().equals(this.nextNodeUUID)) {
            return this.cachedNextNodeEntity;
        }
        UUID uuid = this.nextNodeUUID;
        this.cachedNextNodeEntity = entity = uuid == null ? null : this.getEntityByUUID(uuid);
        return entity;
    }

    public void setPreviousNodeUUID(UUID uuid) {
        this.prevNodeUUID = uuid;
        if (this.cachedPrevNodeEntity != null && !this.cachedPrevNodeEntity.func_110124_au().equals(uuid)) {
            this.cachedPrevNodeEntity = null;
        }
    }

    public UUID getPreviousNodeUUID() {
        return this.prevNodeUUID;
    }

    public void setPreviousNode(Entity entity) {
        this.cachedPrevNodeEntity = entity;
        this.setPreviousNodeUUID(entity == null ? null : entity.func_110124_au());
    }

    public Entity getPreviousNodeByUUID() {
        Entity entity;
        if (this.cachedPrevNodeEntity != null && this.cachedPrevNodeEntity.func_70089_S() && this.cachedPrevNodeEntity.func_110124_au().equals(this.prevNodeUUID)) {
            return this.cachedPrevNodeEntity;
        }
        UUID uuid = this.prevNodeUUID;
        this.cachedPrevNodeEntity = entity = uuid == null ? null : this.getEntityByUUID(uuid);
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getNextNode() {
        if (this.cachedNextNodeEntity == null || !this.cachedNextNodeEntity.func_70089_S() || this.cachedNextNodeEntity.func_145782_y() != ((Integer)this.func_184212_Q().func_187225_a(DW_NEXT_NODE)).intValue()) {
            Entity entity;
            this.cachedNextNodeEntity = entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DW_NEXT_NODE)).intValue());
            return entity;
        }
        return this.cachedNextNodeEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getPreviousNode() {
        if (this.cachedPrevNodeEntity == null || !this.cachedPrevNodeEntity.func_70089_S() || this.cachedPrevNodeEntity.func_145782_y() != ((Integer)this.func_184212_Q().func_187225_a(DW_PREV_NODE)).intValue()) {
            Entity entity;
            this.cachedPrevNodeEntity = entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DW_PREV_NODE)).intValue());
            return entity;
        }
        return this.cachedPrevNodeEntity;
    }

    private Entity getEntityByUUID(UUID uuid) {
        for (Entity entity : this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(24.0, 24.0, 24.0))) {
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }
}

