/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.item.misc.ItemGrapplingHook;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.util.PlayerUtil;

public class EntityGrapplingHookNode
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> DW_PREV_NODE = EntityDataManager.func_187226_a(EntityGrapplingHookNode.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DW_NEXT_NODE = EntityDataManager.func_187226_a(EntityGrapplingHookNode.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> DW_CURRENT_ROPE_LENGTH = EntityDataManager.func_187226_a(EntityGrapplingHookNode.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> DW_ATTACHED = EntityDataManager.func_187226_a(EntityGrapplingHookNode.class, (DataSerializer)DataSerializers.field_187198_h);
    private UUID nextNodeUUID;
    private UUID prevNodeUUID;
    private int cachedPrevNodeDW;
    private int cachedNextNodeDW;
    private Entity cachedNextNodeEntity;
    private Entity cachedPrevNodeEntity;
    protected boolean isExtending = false;
    protected boolean climbing = false;
    protected double correctionX;
    protected double correctionY;
    protected double correctionZ;
    protected int pullCounter = 0;
    protected int nodeCount = 0;
    protected int maxNodeCount;
    protected Vec3d prevWeightPos;
    protected Vec3d weightPos;

    public EntityGrapplingHookNode(World world) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
    }

    public EntityGrapplingHookNode(World world, int nodeCount, int maxNodeCount) {
        super(world);
        this.func_70105_a(0.1f, 0.1f);
        this.nodeCount = nodeCount;
        this.maxNodeCount = maxNodeCount;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DW_PREV_NODE, (Object)-1);
        this.cachedPrevNodeDW = -1;
        this.func_184212_Q().func_187214_a(DW_NEXT_NODE, (Object)-1);
        this.cachedNextNodeDW = -1;
        this.func_184212_Q().func_187214_a(DW_CURRENT_ROPE_LENGTH, (Object)Float.valueOf(this.getDefaultRopeLength()));
        this.func_184212_Q().func_187214_a(DW_ATTACHED, (Object)false);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setNextNodeUUID(nbt.func_186855_b("nextNodeUUID") ? nbt.func_186857_a("nextNodeUUID") : null);
        this.setPreviousNodeUUID(nbt.func_186855_b("previousNodeUUID") ? nbt.func_186857_a("previousNodeUUID") : null);
        if (nbt.func_150297_b("ropeLength", 5)) {
            this.setCurrentRopeLength(nbt.func_74760_g("ropeLength"));
        } else {
            this.setCurrentRopeLength(this.getDefaultRopeLength());
        }
        this.nodeCount = nbt.func_74762_e("nodeCount");
        this.maxNodeCount = nbt.func_74762_e("maxNodeCount");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.getNextNodeUUID() != null) {
            nbt.func_186854_a("nextNodeUUID", this.getNextNodeUUID());
        }
        if (this.getPreviousNodeUUID() != null) {
            nbt.func_186854_a("previousNodeUUID", this.getPreviousNodeUUID());
        }
        nbt.func_74776_a("ropeLength", this.getCurrentRopeLength());
        nbt.func_74768_a("nodeCount", this.nodeCount);
        nbt.func_74768_a("maxNodeCount", this.maxNodeCount);
    }

    public double func_70042_X() {
        return 0.01 + (this.func_184179_bs() != null ? -this.func_184179_bs().func_70033_W() : 0.0);
    }

    public void func_70030_z() {
        boolean isMovable;
        Entity prevNode;
        Entity nextNode;
        if (this.field_70173_aa < 2) {
            return;
        }
        if (this.isMountNode()) {
            this.func_70105_a(0.6f, 1.8f);
        } else {
            this.func_70105_a(0.1f, 0.1f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        boolean attached = this.isAttached();
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(DW_ATTACHED, (Object)attached);
        }
        if (!this.field_70170_p.field_72995_K) {
            nextNode = this.getNextNodeByUUID();
            prevNode = this.getPreviousNodeByUUID();
            if (nextNode != null && nextNode.func_145782_y() != this.cachedNextNodeDW) {
                this.func_184212_Q().func_187227_b(DW_NEXT_NODE, (Object)nextNode.func_145782_y());
                this.cachedNextNodeDW = nextNode.func_145782_y();
            } else if (nextNode == null && this.cachedNextNodeDW != -1) {
                this.func_184212_Q().func_187227_b(DW_NEXT_NODE, (Object)-1);
                this.cachedNextNodeDW = -1;
            }
            if (prevNode != null && prevNode.func_145782_y() != this.cachedPrevNodeDW) {
                this.func_184212_Q().func_187227_b(DW_PREV_NODE, (Object)prevNode.func_145782_y());
                this.cachedPrevNodeDW = prevNode.func_145782_y();
            } else if (prevNode == null && this.cachedPrevNodeDW != -1) {
                this.func_184212_Q().func_187227_b(DW_PREV_NODE, (Object)-1);
                this.cachedPrevNodeDW = -1;
            }
        } else {
            nextNode = this.getNextNodeClient();
            prevNode = this.getPreviousNodeClient();
        }
        if (!this.isMountNode() || prevNode == null) {
            this.setCurrentRopeLength(this.getDefaultRopeLength());
        }
        if (!this.field_70170_p.field_72995_K && nextNode != null) {
            Entity controller;
            EntityGrapplingHookNode mountNode;
            if (nextNode instanceof EntityGrapplingHookNode && ((EntityGrapplingHookNode)nextNode).isMountNode()) {
                mountNode = (EntityGrapplingHookNode)nextNode;
                if (mountNode.isExtending && nextNode.field_70163_u < this.field_70163_u && nextNode.func_70011_f(this.field_70165_t, this.field_70163_u, this.field_70161_v) > (double)this.getDefaultRopeLength() - 0.2) {
                    if (mountNode.nodeCount < mountNode.maxNodeCount) {
                        Vec3d connection = this.getConnectionToNext();
                        if (connection != null) {
                            EntityGrapplingHookNode newNode;
                            Vec3d newPos = mountNode.func_174791_d().func_178787_e(connection.func_186678_a(-0.5)).func_72441_c(0.0, 0.1, 0.0);
                            RayTraceResult result = this.field_70170_p.func_72901_a(mountNode.func_174791_d().func_72441_c(0.0, (double)mountNode.field_70131_O, 0.0), newPos, false);
                            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && result.field_72307_f.func_72436_e(mountNode.func_174791_d().func_72441_c(0.0, (double)mountNode.field_70131_O, 0.0)) < newPos.func_72436_e(mountNode.func_174791_d().func_72441_c(0.0, (double)mountNode.field_70131_O, 0.0))) {
                                newPos = result.field_72307_f.func_178787_e(result.field_72307_f.func_178788_d(this.func_174791_d().func_72441_c(0.0, (double)this.field_70131_O, 0.0)).func_72432_b().func_186678_a(0.1));
                            }
                            if ((newNode = this.extendRope(mountNode, newPos.field_72450_a, newPos.field_72448_b, newPos.field_72449_c)) != null) {
                                newNode.setCurrentRopeLength((float)connection.func_72433_c() / 4.0f);
                                this.setCurrentRopeLength((float)connection.func_72433_c() / 4.0f);
                                if (mountNode.getCurrentRopeLength() < this.getDefaultRopeLength() - 0.05f) {
                                    mountNode.setCurrentRopeLength(0.05f);
                                }
                            }
                        }
                    } else {
                        controller = mountNode.func_184179_bs();
                        if (controller instanceof EntityPlayer) {
                            ((EntityPlayer)controller).func_146105_b((ITextComponent)new TextComponentTranslation("chat.grappling_hook.max_length", new Object[0]), true);
                        }
                    }
                }
            }
            if (nextNode.func_70011_f(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O - (double)nextNode.field_70131_O, this.field_70161_v) > (double)this.getMaxRopeLength()) {
                mountNode = this.getMountNode();
                if (mountNode != null) {
                    controller = mountNode.func_184179_bs();
                    if (controller instanceof EntityPlayer) {
                        ((EntityPlayer)controller).func_146105_b((ITextComponent)new TextComponentTranslation("chat.grappling_hook.disconnected", new Object[0]), true);
                    }
                    if (controller instanceof EntityLivingBase) {
                        for (ItemStack stack : ((EntityLivingBase)controller).func_184214_aD()) {
                            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemGrapplingHook)) continue;
                            ((ItemGrapplingHook)stack.func_77973_b()).onGrapplingHookRipped(stack, controller);
                        }
                    }
                }
                this.setNextNode(null);
            }
        }
        float friction = 1.0f;
        if (this.field_70122_E || this.field_70123_F || this.field_70124_G) {
            friction = 0.5f;
        }
        this.field_70181_x *= 0.98 * (double)friction;
        this.field_70159_w *= 0.98 * (double)friction;
        this.field_70179_y *= 0.98 * (double)friction;
        this.correctionX *= 0.5 * (double)friction;
        this.correctionY *= 0.5 * (double)friction;
        this.correctionZ *= 0.5 * (double)friction;
        if (!attached) {
            this.func_70072_I();
            this.func_70091_d(MoverType.SELF, this.field_70159_w + this.correctionX, this.field_70181_x + this.correctionY, this.field_70179_y + this.correctionZ);
            this.func_145771_j(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            if (this.isAttached()) {
                this.func_184185_a(SoundRegistry.ROPE_GRAB, 0.6f, 0.8f + this.field_70170_p.field_73012_v.nextFloat() * 0.3f);
            }
        }
        if ((isMovable = this.isMovable()) && !this.climbing) {
            this.field_70181_x -= 0.08;
        }
        if (prevNode instanceof EntityGrapplingHookNode) {
            Vec3d diff;
            boolean isPullable = this.isPullable();
            if (isPullable && isMovable) {
                if (nextNode instanceof EntityGrapplingHookNode) {
                    this.constrainMotion(prevNode, nextNode, 0.99, 0.0, 1.0);
                }
                this.constrainMotion(prevNode, prevNode, 0.99, -1.7976931348623157E308, 0.1);
            }
            if ((diff = prevNode.func_174791_d().func_72441_c(0.0, (double)prevNode.field_70131_O, 0.0).func_178788_d(this.func_174791_d().func_72441_c(0.0, (double)this.field_70131_O, 0.0))).func_72433_c() > (double)this.getCurrentRopeLength()) {
                float factor;
                double correction = diff.func_72433_c() - (double)this.getCurrentRopeLength();
                Vec3d forceVec = diff.func_72432_b().func_186678_a(correction * 0.5);
                EntityGrapplingHookNode other = (EntityGrapplingHookNode)prevNode;
                boolean isThisCorrectable = isPullable && isMovable;
                boolean isOtherCorrectable = other.isPullable() && other.isMovable();
                float f = factor = !isThisCorrectable || !isOtherCorrectable ? 2.0f : 1.0f;
                if (isThisCorrectable) {
                    this.correctionX += forceVec.field_72450_a * (double)factor;
                    this.correctionY += forceVec.field_72448_b * (double)factor;
                    this.correctionZ += forceVec.field_72449_c * (double)factor;
                }
                if (isOtherCorrectable) {
                    other.correctionX += -forceVec.field_72450_a * (double)factor;
                    other.correctionY += -forceVec.field_72448_b * (double)factor;
                    other.correctionZ += -forceVec.field_72449_c * (double)factor;
                }
            }
        }
        this.field_70133_I = true;
        if (!this.isMovable()) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        this.checkForEntityCollisions(prevNode, nextNode);
        if (this.field_70170_p.field_72995_K && this.isMountNode()) {
            this.updateWeight();
        }
        this.climbing = false;
        Entity controller = this.func_184179_bs();
        if (controller instanceof EntityLivingBase) {
            this.handleControllerMovement((EntityLivingBase)controller);
        }
        boolean hasValidUser = false;
        if (controller != null && this.isMountNode()) {
            for (ItemStack stack : controller.func_184214_aD()) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemGrapplingHook) || !((ItemGrapplingHook)stack.func_77973_b()).canRideGrapplingHook(stack, controller)) continue;
                hasValidUser = true;
                break;
            }
        }
        if (!(this.field_70170_p.field_72995_K || nextNode != null && (!this.isMountNode() || hasValidUser && prevNode != null))) {
            this.func_174812_G();
        }
        this.field_70148_d = false;
    }

    protected void updateWeight() {
        double weightRopeLength = 2.0;
        Vec3d tether = this.func_174791_d().func_72441_c(0.0, (double)this.field_70131_O, 0.0);
        if (this.weightPos == null) {
            this.prevWeightPos = this.weightPos = tether.func_72441_c(0.0, -2.0, 0.0);
        }
        this.prevWeightPos = this.weightPos;
        this.weightPos = this.weightPos.func_72441_c(0.0, -0.5, 0.0);
        if (this.weightPos.func_72438_d(tether) > 2.0) {
            this.weightPos = tether.func_178787_e(this.weightPos.func_178788_d(tether).func_72432_b().func_186678_a(2.0));
        }
    }

    protected void constrainMotion(Entity parentNode, Entity constraintNode, double ropeFriction, double constraintMin, double constraintDampening) {
        Vec3d nextPoint = new Vec3d(this.field_70165_t + this.field_70159_w - parentNode.field_70159_w, this.field_70163_u + (double)this.field_70131_O + this.field_70181_x - parentNode.field_70181_x, this.field_70161_v + this.field_70179_y - parentNode.field_70179_y);
        Vec3d tetherPoint = new Vec3d(constraintNode.field_70165_t, constraintNode.field_70163_u + (double)constraintNode.field_70131_O, constraintNode.field_70161_v);
        float currentRopeLength = this.getCurrentRopeLength();
        if (tetherPoint.func_72438_d(nextPoint) >= (double)currentRopeLength) {
            Vec3d constrainedPoint = nextPoint.func_178788_d(tetherPoint).func_72432_b();
            constrainedPoint = constrainedPoint.func_186678_a((double)currentRopeLength).func_72441_c(tetherPoint.field_72450_a, tetherPoint.field_72448_b, tetherPoint.field_72449_c);
            Vec3d fwd = tetherPoint.func_178788_d(constrainedPoint).func_72432_b();
            Vec3d relMotion = new Vec3d(this.field_70159_w - parentNode.field_70159_w, this.field_70181_x - parentNode.field_70181_x, this.field_70179_y - parentNode.field_70179_y);
            Vec3d side = fwd.func_72431_c(new Vec3d(0.0, 1.0, 0.0)).func_72432_b();
            Vec3d up = side.func_72431_c(fwd).func_72432_b();
            Vec3d newMotion = side.func_186678_a(side.func_72430_b(relMotion) * 1.0).func_178787_e(up.func_186678_a(up.func_72430_b(relMotion) * 1.0)).func_178787_e(fwd.func_186678_a(Math.max(constraintMin, fwd.func_72430_b(relMotion) * constraintDampening)));
            this.field_70159_w = (parentNode.field_70159_w + newMotion.field_72450_a) * ropeFriction;
            this.field_70181_x = (parentNode.field_70181_x + newMotion.field_72448_b) * ropeFriction;
            this.field_70179_y = (parentNode.field_70179_y + newMotion.field_72449_c) * ropeFriction;
        }
    }

    protected boolean isMovable() {
        return !this.isAttached() && !this.field_70122_E && !this.field_70171_ac;
    }

    protected boolean isPullable() {
        return !this.isMountNode() || (double)this.getCurrentRopeLength() < (double)this.getDefaultRopeLength() - 0.05;
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        PlayerUtil.resetFloating(passenger);
    }

    protected void handleControllerMovement(EntityLivingBase controller) {
        block14: {
            block15: {
                block16: {
                    Entity prevNode;
                    this.isExtending = false;
                    controller.field_70143_R = 0.0f;
                    if (this.field_70170_p.field_72995_K) break block14;
                    if (!controller.field_70703_bu) break block15;
                    if (!(controller.field_191988_bg > 0.0f)) break block16;
                    boolean canReelIn = false;
                    Entity checkRopeNode = this.getPreviousNode();
                    while (checkRopeNode instanceof EntityGrapplingHookNode) {
                        if (((EntityGrapplingHookNode)checkRopeNode).isAttached()) {
                            canReelIn = true;
                            break;
                        }
                        checkRopeNode = ((EntityGrapplingHookNode)checkRopeNode).getPreviousNode();
                    }
                    if (canReelIn && (prevNode = this.getPreviousNode()) instanceof EntityGrapplingHookNode) {
                        Vec3d dir = prevNode.func_174791_d().func_178788_d(this.func_174791_d()).func_72432_b();
                        float prevStepHeight = this.field_70138_W;
                        this.field_70138_W = 1.25f;
                        this.field_70122_E = true;
                        this.func_70091_d(MoverType.SELF, dir.field_72450_a * 0.25, dir.field_72448_b * 0.25, dir.field_72449_c * 0.52);
                        if (this.field_70123_F && dir.field_72448_b > 0.0) {
                            this.field_70122_E = true;
                            this.func_70091_d(MoverType.SELF, 0.0, 0.2, 0.0);
                            this.climbing = true;
                        }
                        this.field_70138_W = prevStepHeight;
                        if (prevNode.func_174813_aQ().func_72326_a(this.func_174813_aQ())) {
                            ((EntityGrapplingHookNode)prevNode).removeNode(this);
                            this.setCurrentRopeLength(this.getDefaultRopeLength() - 0.1f);
                        } else {
                            this.setCurrentRopeLength(Math.min(this.getDefaultRopeLength() - 0.1f, (float)prevNode.func_70011_f(this.field_70165_t, this.field_70163_u + (double)this.field_70131_O - (double)prevNode.field_70131_O, this.field_70161_v)));
                        }
                        if (this.pullCounter % 24 == 0) {
                            this.field_70170_p.func_184148_a(null, controller.field_70165_t, controller.field_70163_u, controller.field_70161_v, (SoundEvent)SoundRegistry.ROPE_PULL, SoundCategory.PLAYERS, 1.5f, 1.0f);
                        }
                        ++this.pullCounter;
                    }
                    break block14;
                }
                if (!(controller.field_191988_bg < 0.0f)) break block14;
                this.pullCounter = 0;
                this.setCurrentRopeLength(Math.min(this.getDefaultRopeLength() - 0.1f, this.getCurrentRopeLength() + 0.2f));
                this.isExtending = true;
                break block14;
            }
            this.pullCounter = 0;
            if (((double)Math.abs(controller.field_191988_bg) > 0.05 || (double)Math.abs(controller.field_70702_br) > 0.05) && !this.field_70122_E) {
                int count = 0;
                double swingX = 0.0;
                double swingZ = 0.0;
                if (controller.field_191988_bg > 0.0f) {
                    swingX += Math.cos(Math.toRadians(controller.field_70177_z + 90.0f));
                    swingZ += Math.sin(Math.toRadians(controller.field_70177_z + 90.0f));
                    ++count;
                }
                if (controller.field_191988_bg < 0.0f) {
                    swingX += Math.cos(Math.toRadians(controller.field_70177_z - 90.0f));
                    swingZ += Math.sin(Math.toRadians(controller.field_70177_z - 90.0f));
                    ++count;
                }
                if (controller.field_70702_br > 0.0f) {
                    swingX += Math.cos(Math.toRadians(controller.field_70177_z));
                    swingZ += Math.sin(Math.toRadians(controller.field_70177_z));
                    ++count;
                }
                if (controller.field_70702_br < 0.0f) {
                    swingX += Math.cos(Math.toRadians(controller.field_70177_z + 180.0f));
                    swingZ += Math.sin(Math.toRadians(controller.field_70177_z + 180.0f));
                    ++count;
                }
                double swingStrength = 0.05;
                this.field_70159_w += (swingX /= (double)count) * swingStrength;
                this.field_70179_y += (swingZ /= (double)count) * swingStrength;
                int incr = 0;
                Entity prev = this.getPreviousNode();
                while (prev instanceof EntityGrapplingHookNode && !((EntityGrapplingHookNode)prev).isAttached()) {
                    if (!prev.field_70122_E) {
                        prev.field_70159_w += swingX * swingStrength / (double)(1 + incr * 2);
                        prev.field_70179_y += swingZ * swingStrength / (double)(1 + incr * 2);
                    }
                    prev = ((EntityGrapplingHookNode)prev).getPreviousNode();
                    ++incr;
                }
            }
        }
    }

    protected void checkForEntityCollisions(Entity prevNode, Entity nextNode) {
        if (!this.field_70170_p.field_72995_K && prevNode != null) {
            Entity user;
            double velocity = Math.sqrt((this.field_70165_t - this.field_70169_q) * (this.field_70165_t - this.field_70169_q) + (this.field_70163_u - this.field_70167_r) * (this.field_70163_u - this.field_70167_r) + (this.field_70161_v - this.field_70166_s) * (this.field_70161_v - this.field_70166_s));
            EntityGrapplingHookNode mountNode = this.getMountNode();
            if (mountNode != null && (user = mountNode.func_184179_bs()) != null && velocity > 0.25) {
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, prevNode.field_70165_t, prevNode.field_70163_u, prevNode.field_70161_v));
                for (EntityLivingBase entity : entities) {
                    RayTraceResult intersect;
                    if (entity == user || (intersect = entity.func_174813_aQ().func_72327_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Vec3d(prevNode.field_70165_t, prevNode.field_70163_u, prevNode.field_70161_v))) == null) continue;
                    EntityDamageSourceIndirect source = user instanceof EntityPlayer ? new EntityDamageSourceIndirect("player", (Entity)this, user) : new EntityDamageSourceIndirect("mob", (Entity)this, user);
                    entity.func_70097_a((DamageSource)source, 3.0f + (float)Math.min((velocity - 0.25) * 1.5, 4.0));
                }
            }
        }
    }

    public boolean func_70067_L() {
        return !this.isMountNode();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        return distance < 4096.0;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_184186_bw() {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    protected void func_184225_p(Entity passenger) {
        super.func_184225_p(passenger);
        passenger.field_70159_w = this.field_70159_w * 1.5;
        passenger.field_70181_x = this.field_70181_x;
        passenger.field_70179_y = this.field_70179_y * 1.5;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public boolean isAttached() {
        if (this.field_70170_p.field_72995_K) {
            return (Boolean)this.func_184212_Q().func_187225_a(DW_ATTACHED);
        }
        return !this.isMountNode() && !this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72314_b(0.1, 0.1, 0.1)).isEmpty();
    }

    public EntityGrapplingHookNode extendRope(Entity entity, double x, double y, double z) {
        EntityGrapplingHookNode mountNode = this.getMountNode();
        if (mountNode != null && mountNode.nodeCount < mountNode.maxNodeCount) {
            EntityGrapplingHookNode ropeNode = new EntityGrapplingHookNode(this.field_70170_p);
            ropeNode.func_70012_b(x, y, z, 0.0f, 0.0f);
            ropeNode.setPreviousNode(this);
            this.setNextNode(ropeNode);
            ropeNode.setNextNode(entity);
            if (entity instanceof EntityGrapplingHookNode) {
                ((EntityGrapplingHookNode)entity).setPreviousNode(ropeNode);
            }
            this.field_70170_p.func_72838_d((Entity)ropeNode);
            ++mountNode.nodeCount;
            return ropeNode;
        }
        return null;
    }

    public void removeNode(Entity nextConnectionNode) {
        EntityGrapplingHookNode mountNode;
        Entity prevNode = this.getPreviousNodeByUUID();
        if (prevNode != null && prevNode instanceof EntityGrapplingHookNode) {
            ((EntityGrapplingHookNode)prevNode).setNextNode(nextConnectionNode);
            if (nextConnectionNode instanceof EntityGrapplingHookNode) {
                ((EntityGrapplingHookNode)nextConnectionNode).setPreviousNode(prevNode);
            }
        }
        if ((mountNode = this.getMountNode()) != null) {
            mountNode.nodeCount = Math.max(0, mountNode.nodeCount - 1);
        }
        this.func_174812_G();
    }

    public Vec3d getConnectionToNext() {
        Entity nextNode = this.field_70170_p.field_72995_K ? this.getNextNodeClient() : this.getNextNodeByUUID();
        if (nextNode != null) {
            return new Vec3d(nextNode.field_70165_t - this.field_70165_t, nextNode.field_70163_u + (double)nextNode.field_70131_O - (this.field_70163_u + (double)this.field_70131_O), nextNode.field_70161_v - this.field_70161_v);
        }
        return null;
    }

    public void setNextNodeUUID(UUID uuid) {
        this.nextNodeUUID = uuid;
        if (this.cachedNextNodeEntity != null && !this.cachedNextNodeEntity.func_110124_au().equals(uuid)) {
            this.cachedNextNodeEntity = null;
        }
    }

    public UUID getNextNodeUUID() {
        return this.nextNodeUUID;
    }

    public void setNextNode(Entity entity) {
        this.cachedNextNodeEntity = entity;
        this.setNextNodeUUID(entity == null ? null : entity.func_110124_au());
    }

    public Entity getNextNodeByUUID() {
        Entity entity;
        if (this.cachedNextNodeEntity != null && this.cachedNextNodeEntity.func_70089_S() && this.cachedNextNodeEntity.func_110124_au().equals(this.nextNodeUUID)) {
            return this.cachedNextNodeEntity;
        }
        UUID uuid = this.nextNodeUUID;
        this.cachedNextNodeEntity = entity = uuid == null ? null : this.getEntityByUUID(uuid);
        return entity;
    }

    public void setPreviousNodeUUID(UUID uuid) {
        this.prevNodeUUID = uuid;
        if (this.cachedPrevNodeEntity != null && !this.cachedPrevNodeEntity.func_110124_au().equals(uuid)) {
            this.cachedPrevNodeEntity = null;
        }
    }

    public UUID getPreviousNodeUUID() {
        return this.prevNodeUUID;
    }

    public void setPreviousNode(Entity entity) {
        this.cachedPrevNodeEntity = entity;
        this.setPreviousNodeUUID(entity == null ? null : entity.func_110124_au());
    }

    public Entity getPreviousNodeByUUID() {
        Entity entity;
        if (this.cachedPrevNodeEntity != null && this.cachedPrevNodeEntity.func_70089_S() && this.cachedPrevNodeEntity.func_110124_au().equals(this.prevNodeUUID)) {
            return this.cachedPrevNodeEntity;
        }
        UUID uuid = this.prevNodeUUID;
        this.cachedPrevNodeEntity = entity = uuid == null ? null : this.getEntityByUUID(uuid);
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getNextNodeClient() {
        if (this.cachedNextNodeEntity == null || !this.cachedNextNodeEntity.func_70089_S() || this.cachedNextNodeEntity.func_145782_y() != ((Integer)this.func_184212_Q().func_187225_a(DW_NEXT_NODE)).intValue()) {
            Entity entity;
            this.cachedNextNodeEntity = entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DW_NEXT_NODE)).intValue());
            return entity;
        }
        return this.cachedNextNodeEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getPreviousNodeClient() {
        if (this.cachedPrevNodeEntity == null || !this.cachedPrevNodeEntity.func_70089_S() || this.cachedPrevNodeEntity.func_145782_y() != ((Integer)this.func_184212_Q().func_187225_a(DW_PREV_NODE)).intValue()) {
            Entity entity;
            this.cachedPrevNodeEntity = entity = this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(DW_PREV_NODE)).intValue());
            return entity;
        }
        return this.cachedPrevNodeEntity;
    }

    public Entity getNextNode() {
        if (this.field_70170_p.field_72995_K) {
            return this.getNextNodeClient();
        }
        return this.getNextNodeByUUID();
    }

    public Entity getPreviousNode() {
        if (this.field_70170_p.field_72995_K) {
            return this.getPreviousNodeClient();
        }
        return this.getPreviousNodeByUUID();
    }

    private Entity getEntityByUUID(UUID uuid) {
        for (Entity entity : this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(24.0, 24.0, 24.0))) {
            if (!uuid.equals(entity.func_110124_au())) continue;
            return entity;
        }
        return null;
    }

    public boolean isMountNode() {
        return this.getNextNode() instanceof EntityLivingBase;
    }

    public float getCurrentRopeLength() {
        return ((Float)this.field_70180_af.func_187225_a(DW_CURRENT_ROPE_LENGTH)).floatValue();
    }

    public void setCurrentRopeLength(float length) {
        this.field_70180_af.func_187227_b(DW_CURRENT_ROPE_LENGTH, (Object)Float.valueOf(length));
    }

    protected float getDefaultRopeLength() {
        return 2.0f;
    }

    protected float getMaxRopeLength() {
        return 12.0f;
    }

    public EntityGrapplingHookNode getMountNode() {
        EntityGrapplingHookNode node = this;
        while (node instanceof EntityGrapplingHookNode) {
            EntityGrapplingHookNode hookNode = node;
            if (hookNode.isMountNode()) {
                return hookNode;
            }
            node = hookNode.getNextNode();
        }
        return null;
    }

    public Vec3d getWeightPos(float partialTicks) {
        if (this.weightPos == null) {
            return new Vec3d(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)partialTicks, this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)partialTicks, this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)partialTicks);
        }
        return this.prevWeightPos.func_178787_e(this.weightPos.func_178788_d(this.prevWeightPos).func_186678_a((double)partialTicks));
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.maxNodeCount);
    }

    public void readSpawnData(ByteBuf buf) {
        this.maxNodeCount = buf.readInt();
    }
}

