/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.gui.GuiGalleryFrame;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.registries.ItemRegistry;

public class EntityGalleryFrame
extends EntityHanging
implements IEntityAdditionalSpawnData {
    protected static final DataParameter<String> URL = EntityDataManager.func_187226_a(EntityGalleryFrame.class, (DataSerializer)DataSerializers.field_187194_d);
    private Type type;

    public EntityGalleryFrame(World world) {
        super(world);
    }

    public EntityGalleryFrame(World world, BlockPos pos, EnumFacing facing, Type type) {
        super(world, pos);
        this.type = type;
        this.func_174859_a(facing);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(URL, (Object)"");
    }

    public String func_70005_c_() {
        String s;
        if (this.type == null) {
            s = "small";
        } else {
            switch (this.type) {
                default: {
                    s = "small";
                    break;
                }
                case LARGE: {
                    s = "large";
                    break;
                }
                case VERY_LARGE: {
                    s = "very_large";
                }
            }
        }
        return I18n.func_74838_a((String)("entity.thebetweenlands.gallery_frame_" + s + ".name"));
    }

    public void setUrl(String url) {
        this.field_70180_af.func_187227_b(URL, (Object)url);
    }

    public String getUrl() {
        return (String)this.field_70180_af.func_187225_a(URL);
    }

    public Type getType() {
        return this.type;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("type", this.type.ordinal());
        nbt.func_74778_a("url", this.getUrl());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.type = Type.values()[nbt.func_74762_e("type")];
        this.setUrl(nbt.func_74779_i("url"));
    }

    public int func_82329_d() {
        if (this.type == null) {
            return 16;
        }
        switch (this.type) {
            default: {
                return 16;
            }
            case LARGE: {
                return 32;
            }
            case VERY_LARGE: 
        }
        return 64;
    }

    public int func_82330_g() {
        if (this.type == null) {
            return 16;
        }
        switch (this.type) {
            default: {
                return 16;
            }
            case LARGE: {
                return 32;
            }
            case VERY_LARGE: 
        }
        return 64;
    }

    public void func_110128_b(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
            this.func_184185_a(SoundEvents.field_187881_gQ, 1.0f, 1.0f);
            if (brokenEntity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)brokenEntity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_70099_a(new ItemStack(this.type == Type.VERY_LARGE ? ItemRegistry.GALLERY_FRAME_VERY_LARGE : (this.type == Type.LARGE ? ItemRegistry.GALLERY_FRAME_LARGE : ItemRegistry.GALLERY_FRAME_SMALL)), 0.0f);
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187891_gV, 1.0f, 1.0f);
    }

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(this.field_174861_a.func_177958_n(), this.field_174861_a.func_177956_o(), this.field_174861_a.func_177952_p());
    }

    public void writeSpawnData(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeLong(this.field_174861_a.func_177986_g());
        buf.writeBoolean(this.field_174860_b != null);
        if (this.field_174860_b != null) {
            buf.writeInt(this.field_174860_b.func_176745_a());
        }
    }

    public void readSpawnData(ByteBuf buf) {
        this.type = Type.values()[buf.readInt()];
        this.field_174861_a = BlockPos.func_177969_a((long)buf.readLong());
        if (buf.readBoolean()) {
            this.field_174860_b = EnumFacing.func_82600_a((int)buf.readInt());
            this.func_174859_a(this.field_174860_b);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K && player == TheBetweenlands.proxy.getClientPlayer()) {
            this.showGalleryGui();
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    private void showGalleryGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiGalleryFrame(this));
    }

    public static enum Type {
        VERY_LARGE,
        LARGE,
        SMALL;

    }
}

