/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.entity.EntityDecayPitTargetPart;
import thebetweenlands.common.entity.EntityRootGrabber;
import thebetweenlands.common.entity.mobs.EntityFortressBoss;
import thebetweenlands.common.entity.mobs.EntitySludgeMenace;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityDecayPitControl;
import thebetweenlands.common.tile.TileEntityDecayPitGroundChain;
import thebetweenlands.common.tile.TileEntityDecayPitHangingChain;
import thebetweenlands.util.RotationMatrix;

public class EntityDecayPitTarget
extends Entity
implements IEntityMultiPart {
    private static final byte EVENT_ATTACK_BLOCKED = 80;
    private static final byte EVENT_ATTACK_DAMAGE = 81;
    private final RotationMatrix rotationMatrix = new RotationMatrix();
    public float animationTicksPrev = 0.0f;
    public int animationTicksChain = 0;
    public int animationTicksChainPrev = 0;
    public final int MAX_PROGRESS = 768;
    public final int MIN_PROGRESS = 0;
    public final float MOVE_UNIT = 0.0078125f;
    public EntityDecayPitTargetPart[] parts;
    public EntityDecayPitTargetPart shield_1;
    public EntityDecayPitTargetPart shield_2;
    public EntityDecayPitTargetPart shield_3;
    public EntityDecayPitTargetPart shield_4;
    public EntityDecayPitTargetPart shield_5;
    public EntityDecayPitTargetPart shield_6;
    public EntityDecayPitTargetPart shield_7;
    public EntityDecayPitTargetPart shield_8;
    public EntityDecayPitTargetPart shield_9;
    public EntityDecayPitTargetPart shield_10;
    public EntityDecayPitTargetPart shield_11;
    public EntityDecayPitTargetPart shield_12;
    public EntityDecayPitTargetPart shield_13;
    public EntityDecayPitTargetPart shield_14;
    public EntityDecayPitTargetPart shield_15;
    public EntityDecayPitTargetPart shield_16;
    public EntityDecayPitTargetPart target_north;
    public EntityDecayPitTargetPart target_east;
    public EntityDecayPitTargetPart target_west;
    public EntityDecayPitTargetPart target_south;
    public EntityDecayPitTargetPart bottom;
    private static final DataParameter<Float> ANIMATION_TICKS = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> IS_RAISING = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_MOVING = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SLOW = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> PROGRESS = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> TARGET_N_ACTIVE = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TARGET_E_ACTIVE = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TARGET_S_ACTIVE = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TARGET_W_ACTIVE = EntityDataManager.func_187226_a(EntityDecayPitTarget.class, (DataSerializer)DataSerializers.field_187198_h);
    public int attackDamageTicks = 0;
    public int[] beamTransparencyTicks = new int[4];
    public int renderedFrame = -1;
    public int renderedFrameMultipass = -1;
    private EntitySludgeMenace.DummyPart[] dummies;

    public EntityDecayPitTarget(World world) {
        super(world);
        this.func_70105_a(5.0f, 5.0f);
        this.shield_1 = new EntityDecayPitTargetPart(this, "part1", 1.0f, 1.0f, true);
        this.shield_2 = new EntityDecayPitTargetPart(this, "part2", 1.0f, 1.0f, true);
        this.shield_3 = new EntityDecayPitTargetPart(this, "part3", 1.0f, 1.0f, true);
        this.shield_4 = new EntityDecayPitTargetPart(this, "part4", 1.0f, 1.0f, true);
        this.shield_5 = new EntityDecayPitTargetPart(this, "part5", 1.0f, 1.0f, true);
        this.shield_6 = new EntityDecayPitTargetPart(this, "part6", 1.0f, 1.0f, true);
        this.shield_7 = new EntityDecayPitTargetPart(this, "part7", 1.0f, 1.0f, true);
        this.shield_8 = new EntityDecayPitTargetPart(this, "part8", 1.0f, 1.0f, true);
        this.shield_9 = new EntityDecayPitTargetPart(this, "part9", 1.0f, 1.0f, true);
        this.shield_10 = new EntityDecayPitTargetPart(this, "part10", 1.0f, 1.0f, true);
        this.shield_11 = new EntityDecayPitTargetPart(this, "part11", 1.0f, 1.0f, true);
        this.shield_12 = new EntityDecayPitTargetPart(this, "part12", 1.0f, 1.0f, true);
        this.shield_13 = new EntityDecayPitTargetPart(this, "part13", 1.0f, 1.0f, true);
        this.shield_14 = new EntityDecayPitTargetPart(this, "part16", 1.0f, 1.0f, true);
        this.shield_15 = new EntityDecayPitTargetPart(this, "part15", 1.0f, 1.0f, true);
        this.shield_16 = new EntityDecayPitTargetPart(this, "part16", 1.0f, 1.0f, true);
        this.target_north = new EntityDecayPitTargetPart(this, "target_north", 2.0f, 2.0f, false);
        this.target_east = new EntityDecayPitTargetPart(this, "target_east", 2.0f, 2.0f, false);
        this.target_south = new EntityDecayPitTargetPart(this, "target_south", 2.0f, 2.0f, false);
        this.target_west = new EntityDecayPitTargetPart(this, "target_west", 2.0f, 2.0f, false);
        this.bottom = new EntityDecayPitTargetPart(this, "bottom", 3.0f, 1.0f, false);
        this.parts = new EntityDecayPitTargetPart[]{this.shield_1, this.shield_2, this.shield_3, this.shield_4, this.shield_5, this.shield_6, this.shield_7, this.shield_8, this.shield_9, this.shield_10, this.shield_11, this.shield_12, this.shield_13, this.shield_14, this.shield_15, this.shield_16, this.target_north, this.target_east, this.target_south, this.target_west, this.bottom};
        this.dummies = new EntitySludgeMenace.DummyPart[this.parts.length];
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(IS_RAISING, (Object)false);
        this.field_70180_af.func_187214_a(IS_MOVING, (Object)false);
        this.field_70180_af.func_187214_a(IS_SLOW, (Object)true);
        this.field_70180_af.func_187214_a(PROGRESS, (Object)0);
        this.field_70180_af.func_187214_a(ANIMATION_TICKS, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(TARGET_N_ACTIVE, (Object)true);
        this.field_70180_af.func_187214_a(TARGET_E_ACTIVE, (Object)true);
        this.field_70180_af.func_187214_a(TARGET_W_ACTIVE, (Object)true);
        this.field_70180_af.func_187214_a(TARGET_S_ACTIVE, (Object)true);
    }

    public void func_70071_h_() {
        float animationTicks;
        super.func_70071_h_();
        if (this.attackDamageTicks > 0) {
            --this.attackDamageTicks;
        }
        boolean isMovingDown = this.isMoving() && !this.isSlow();
        this.beamTransparencyTicks[0] = this.getTargetEActive() && !isMovingDown ? Math.min(15, this.beamTransparencyTicks[0] + 1) : Math.max(0, this.beamTransparencyTicks[0] - 1);
        this.beamTransparencyTicks[1] = this.getTargetWActive() && !isMovingDown ? Math.min(15, this.beamTransparencyTicks[1] + 1) : Math.max(0, this.beamTransparencyTicks[1] - 1);
        this.beamTransparencyTicks[2] = this.getTargetSActive() && !isMovingDown ? Math.min(15, this.beamTransparencyTicks[2] + 1) : Math.max(0, this.beamTransparencyTicks[2] - 1);
        this.beamTransparencyTicks[3] = this.getTargetNActive() && !isMovingDown ? Math.min(15, this.beamTransparencyTicks[3] + 1) : Math.max(0, this.beamTransparencyTicks[3] - 1);
        this.animationTicksPrev = animationTicks = ((Float)this.field_70180_af.func_187225_a(ANIMATION_TICKS)).floatValue();
        this.animationTicksChainPrev = this.animationTicksChain;
        if (!this.field_70170_p.field_72995_K) {
            if (animationTicks + 1.0f >= 360.0f) {
                this.field_70180_af.func_187227_b(ANIMATION_TICKS, (Object)Float.valueOf(0.0f));
            } else {
                this.field_70180_af.func_187227_b(ANIMATION_TICKS, (Object)Float.valueOf(animationTicks + 1.0f));
            }
        }
        while (animationTicks - this.animationTicksPrev < -180.0f) {
            this.animationTicksPrev -= 360.0f;
        }
        while (animationTicks - this.animationTicksPrev >= 180.0f) {
            this.animationTicksPrev += 360.0f;
        }
        for (EntityDecayPitTargetPart entity : this.parts) {
            entity.func_70071_h_();
        }
        this.setNewShieldHitboxPos(animationTicks, this.shield_1);
        this.setNewShieldHitboxPos(-animationTicks + 22.5f, this.shield_2);
        this.setNewShieldHitboxPos(animationTicks + 45.0f, this.shield_3);
        this.setNewShieldHitboxPos(-animationTicks + 67.5f, this.shield_4);
        this.setNewShieldHitboxPos(animationTicks + 90.0f, this.shield_5);
        this.setNewShieldHitboxPos(-animationTicks + 112.5f, this.shield_6);
        this.setNewShieldHitboxPos(animationTicks + 135.0f, this.shield_7);
        this.setNewShieldHitboxPos(-animationTicks + 157.0f, this.shield_8);
        this.setNewShieldHitboxPos(animationTicks + 180.0f, this.shield_9);
        this.setNewShieldHitboxPos(-animationTicks + 202.5f, this.shield_10);
        this.setNewShieldHitboxPos(animationTicks + 225.0f, this.shield_11);
        this.setNewShieldHitboxPos(-animationTicks + 247.5f, this.shield_12);
        this.setNewShieldHitboxPos(animationTicks + 270.0f, this.shield_13);
        this.setNewShieldHitboxPos(-animationTicks + 292.5f, this.shield_14);
        this.setNewShieldHitboxPos(animationTicks + 315.0f, this.shield_15);
        this.setNewShieldHitboxPos(-animationTicks + 337.5f, this.shield_16);
        this.target_north.func_70107_b(this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v - 0.75);
        this.target_east.func_70107_b(this.field_70165_t + 0.75, this.field_70163_u + 3.0, this.field_70161_v);
        this.target_south.func_70107_b(this.field_70165_t, this.field_70163_u + 3.0, this.field_70161_v + 0.75);
        this.target_west.func_70107_b(this.field_70165_t - 0.75, this.field_70163_u + 3.0, this.field_70161_v);
        this.bottom.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.isMoving()) {
            this.animationTicksChain = this.isSlow() ? ++this.animationTicksChain : (this.animationTicksChain += 8);
            if (this.getHangingChains() != null) {
                this.getHangingChains().setProgress(this.getProgress());
            }
            if (!this.isRaising() && this.getProgress() < 768) {
                this.func_70091_d(MoverType.SELF, 0.0, -0.0625, 0.0);
                this.setProgress(this.getProgress() + 8);
                if (this.getHangingChains() != null) {
                    this.getHangingChains().setMoving(true);
                    this.getHangingChains().setSlow(false);
                }
                if (this.getGroundChains() != null) {
                    for (TileEntityDecayPitGroundChain chain : this.getGroundChains()) {
                        chain.setRaising(true);
                        chain.setMoving(true);
                        chain.setSlow(false);
                    }
                }
            }
            if (this.isRaising() && this.getProgress() > 0) {
                this.func_70091_d(MoverType.SELF, 0.0, 0.0078125, 0.0);
                this.setProgress(this.getProgress() - 1);
                if (this.getHangingChains() != null) {
                    this.getHangingChains().setMoving(true);
                    this.getHangingChains().setSlow(true);
                }
                if (this.getGroundChains() != null) {
                    for (TileEntityDecayPitGroundChain chain : this.getGroundChains()) {
                        chain.setRaising(false);
                        chain.setMoving(true);
                        chain.setSlow(true);
                    }
                }
            }
        }
        if (this.animationTicksChainPrev >= 128) {
            this.animationTicksChainPrev = 0;
            this.animationTicksChain = 0;
            this.setMoving(false);
        }
        if (this.getProgress() > 768) {
            this.setProgress(768);
        }
        if (this.getProgress() < 0) {
            this.setProgress(0);
        }
        if (!this.func_130014_f_().field_72995_K) {
            TileEntityDecayPitControl control;
            if (this.getProgress() > 0 && this.func_130014_f_().func_82737_E() % 400L == 0L && this.attackDamageTicks == 0) {
                this.moveUp();
            }
            if ((control = this.getControl()) != null && this.func_130014_f_().func_82737_E() % 10L == 0L) {
                if (this.getProgress() < 128) {
                    control.setSpawnType(0);
                }
                if (this.getProgress() >= 128 && this.getProgress() < 256) {
                    control.setSpawnType(1);
                }
                if (this.getProgress() >= 256 && this.getProgress() < 384) {
                    control.setSpawnType(2);
                }
                if (this.getProgress() >= 384 && this.getProgress() < 512) {
                    control.setSpawnType(3);
                }
                if (this.getProgress() >= 512 && this.getProgress() < 640) {
                    control.setSpawnType(4);
                }
                if (this.getProgress() >= 640) {
                    control.setSpawnType(5);
                }
            }
            if (control != null && control.getSpawnType() == 5) {
                TileEntityDecayPitHangingChain hangingChains = this.getHangingChains();
                if (hangingChains != null) {
                    hangingChains.setBroken(true);
                    hangingChains.setMoving(true);
                    hangingChains.setSlow(false);
                    hangingChains.updateBlock();
                }
                if (this.getGroundChains() != null) {
                    for (TileEntityDecayPitGroundChain chain : this.getGroundChains()) {
                        chain.setBroken(true);
                        chain.setRaising(false);
                        chain.setMoving(true);
                        chain.setSlow(false);
                        chain.updateBlock();
                    }
                }
                this.func_70106_y();
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            for (int i = 0; i < this.dummies.length; ++i) {
                EntitySludgeMenace.DummyPart dummy = this.dummies[i];
                if (dummy == null || !dummy.func_70089_S()) {
                    EntityDecayPitTargetPart multipart = this.parts[i];
                    if (!(multipart instanceof MultiPartEntityPart)) continue;
                    this.dummies[i] = dummy = new EntitySludgeMenace.DummyPart(this.field_70170_p, multipart);
                    this.field_70170_p.func_72838_d((Entity)dummy);
                    continue;
                }
                dummy.updatePositioning();
            }
        }
    }

    protected void setHangingLength(EntityDecayPitTargetPart chain, float extended) {
        chain.field_70131_O = extended;
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(chain.field_70165_t - (double)chain.field_70130_N * 0.5, this.field_70163_u + (double)this.field_70131_O, chain.field_70161_v - (double)chain.field_70130_N * 0.5, chain.field_70165_t + (double)chain.field_70130_N * 0.5, this.field_70163_u + (double)this.field_70131_O + 2.0 + (double)((float)this.getProgress() * 0.0078125f), chain.field_70161_v + (double)chain.field_70130_N * 0.5);
        chain.func_174826_a(axisalignedbb);
        chain.func_70071_h_();
    }

    protected void setNewShieldHitboxPos(float animationTicks, EntityDecayPitTargetPart shield) {
        double a = Math.toRadians(animationTicks);
        double offSetX = -Math.sin(a) * 2.825;
        double offSetZ = Math.cos(a) * 2.825;
        float wobble = 0.0f;
        wobble = shield == this.shield_1 || shield == this.shield_3 || shield == this.shield_5 || shield == this.shield_7 || shield == this.shield_9 || shield == this.shield_11 || shield == this.shield_13 || shield == this.shield_15 ? MathHelper.func_76126_a((float)(animationTicks * 0.14f)) * 1.2f : -MathHelper.func_76126_a((float)(animationTicks * 0.14f)) * 1.2f;
        float squarePoint = Math.signum(wobble);
        if (squarePoint == -1.0f) {
            wobble = 0.0f;
        }
        shield.func_70107_b(this.field_70165_t + offSetX, this.target_north.field_70163_u + (double)this.target_north.field_70131_O / 2.0 - (double)shield.field_70131_O + (double)wobble, this.field_70161_v + offSetZ);
        shield.field_70177_z = animationTicks + 180.0f;
        while (shield.field_70177_z - shield.field_70126_B < -180.0f) {
            shield.field_70126_B -= 360.0f;
        }
        while (shield.field_70177_z - shield.field_70126_B >= 180.0f) {
            shield.field_70126_B += 360.0f;
        }
    }

    public void func_70106_y() {
        super.func_70106_y();
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70067_L() {
        return false;
    }

    @Nullable
    public Entity[] func_70021_al() {
        return this.parts;
    }

    public void func_70024_g(double x, double y, double z) {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_190530_aW() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        return false;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        boolean wasBlocked = false;
        if (source.func_94541_c()) {
            return false;
        }
        if (source instanceof EntityDamageSource) {
            Entity attackingEntity;
            EntityDamageSource entityDamage = (EntityDamageSource)source;
            Entity sourceEntity = entityDamage.func_76346_g();
            Entity immediateEntity = entityDamage.func_76364_f();
            Entity entity = attackingEntity = immediateEntity != null ? immediateEntity : sourceEntity;
            if (attackingEntity == null) {
                wasBlocked = true;
            } else {
                Vec3d ray;
                Vec3d pos = new Vec3d(attackingEntity.field_70165_t, attackingEntity.field_70163_u + (double)attackingEntity.func_70047_e(), attackingEntity.field_70161_v);
                EntityDecayPitTargetPart hitShield = this.rayTraceShields(pos, ray = attackingEntity instanceof EntityLivingBase ? attackingEntity.func_70040_Z() : new Vec3d(attackingEntity.field_70159_w, attackingEntity.field_70181_x, attackingEntity.field_70179_y).func_72432_b());
                if (hitShield != null) {
                    wasBlocked = true;
                }
            }
        }
        if (part == this.target_north && !wasBlocked) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.getTargetNActive()) {
                    this.setTargetNActive(false);
                    this.playHitSound(this.func_82194_d(), this.target_north.func_180425_c());
                }
                if (this.getAllTargetsHit()) {
                    this.moveDown();
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)81);
            }
            return true;
        }
        if (part == this.target_east && !wasBlocked) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.getTargetEActive()) {
                    this.setTargetEActive(false);
                    this.playHitSound(this.func_82194_d(), this.target_east.func_180425_c());
                }
                if (this.getAllTargetsHit()) {
                    this.moveDown();
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)81);
            }
            return true;
        }
        if (part == this.target_south && !wasBlocked) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.getTargetSActive()) {
                    this.setTargetSActive(false);
                    this.playHitSound(this.func_82194_d(), this.target_south.func_180425_c());
                }
                if (this.getAllTargetsHit()) {
                    this.moveDown();
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)81);
            }
            return true;
        }
        if (part == this.target_west && !wasBlocked) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.getTargetWActive()) {
                    this.setTargetWActive(false);
                    this.playHitSound(this.func_82194_d(), this.target_west.func_180425_c());
                }
                if (this.getAllTargetsHit()) {
                    this.moveDown();
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)81);
            }
            return true;
        }
        if (wasBlocked) {
            if (!this.field_70170_p.field_72995_K) {
                Entity sourceEntity;
                if (source instanceof EntityDamageSourceIndirect && (sourceEntity = ((EntityDamageSourceIndirect)source).func_76346_g()) != null && !this.field_70170_p.func_175623_d(sourceEntity.func_180425_c().func_177977_b())) {
                    EntityRootGrabber grabber = new EntityRootGrabber(this.field_70170_p, true);
                    grabber.setPosition(source.func_76346_g().func_180425_c().func_177977_b(), 40);
                    this.func_130014_f_().func_72838_d((Entity)grabber);
                }
                this.moveUp();
                this.field_70170_p.func_72960_a((Entity)this, (byte)80);
            }
            return false;
        }
        return false;
    }

    public void playHitSound(World world, BlockPos pos) {
        this.func_82194_d().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.BEAM_ACTIVATE, SoundCategory.HOSTILE, 0.5f, 1.0f);
    }

    public void playDropSound(World world, BlockPos pos) {
        this.func_82194_d().func_184133_a(null, this.func_180425_c(), (SoundEvent)SoundRegistry.PLUG_HIT, SoundCategory.HOSTILE, 1.0f, 1.0f);
    }

    private boolean getAllTargetsHit() {
        return !this.getTargetNActive() && !this.getTargetEActive() && !this.getTargetSActive() && !this.getTargetWActive();
    }

    @Nullable
    public EntityDecayPitTargetPart rayTraceShields(Vec3d pos, Vec3d dir) {
        Vec3d ray = dir.func_72432_b().func_186678_a(3.0);
        float shieldSize = 0.6f;
        Vec3d v0 = new Vec3d((double)(-shieldSize), (double)(-shieldSize), 0.0);
        Vec3d v1 = new Vec3d((double)shieldSize, (double)(-shieldSize), 0.0);
        Vec3d v2 = new Vec3d((double)shieldSize, (double)shieldSize, 0.0);
        Vec3d v3 = new Vec3d((double)(-shieldSize), (double)shieldSize, 0.0);
        for (EntityDecayPitTargetPart shieldPart : this.parts) {
            if (!shieldPart.isShield) continue;
            Vec3d center = shieldPart.func_174791_d().func_72441_c(0.0, (double)(shieldPart.field_70131_O / 2.0f), 0.0);
            this.rotationMatrix.setRotations(0.0f, (float)Math.toRadians(shieldPart.field_70177_z), 0.0f);
            Vec3d relPos = this.rotationMatrix.transformVec(pos.func_178788_d(center), Vec3d.field_186680_a);
            Vec3d relRay = this.rotationMatrix.transformVec(ray, Vec3d.field_186680_a);
            if (!EntityFortressBoss.rayTraceTriangle(relPos, relRay, v0, v1, v2) && !EntityFortressBoss.rayTraceTriangle(relPos, relRay, v2, v3, v0)) continue;
            return shieldPart;
        }
        return null;
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
        if (id == 81) {
            this.attackDamageTicks = 40;
        }
    }

    private void moveUp() {
        if (this.getProgress() > 0) {
            this.setRaising(true);
            this.setMoving(true);
            this.setSlow(true);
        }
    }

    private void moveDown() {
        if (this.getProgress() < 768) {
            this.setRaising(false);
            this.setMoving(true);
            this.setSlow(false);
            this.setTargetNActive(true);
            this.setTargetEActive(true);
            this.setTargetSActive(true);
            this.setTargetWActive(true);
        }
        this.playDropSound(this.func_82194_d(), this.func_180425_c());
    }

    public TileEntityDecayPitHangingChain getHangingChains() {
        TileEntityDecayPitHangingChain tile = null;
        for (int x = -1; x < 1; ++x) {
            for (int y = 0; y < 15; ++y) {
                for (int z = -1; z < 1; ++z) {
                    if (!(this.func_82194_d().func_175625_s(this.func_180425_c().func_177982_a(x, y, z)) instanceof TileEntityDecayPitHangingChain)) continue;
                    tile = (TileEntityDecayPitHangingChain)this.func_82194_d().func_175625_s(this.func_180425_c().func_177982_a(x, y, z));
                    tile.setProgress(this.getProgress());
                }
            }
        }
        return tile;
    }

    public TileEntityDecayPitControl getControl() {
        TileEntityDecayPitControl tile = null;
        for (int x = -1; x < 1; ++x) {
            for (int y = -15; y < 0; ++y) {
                for (int z = -1; z < 1; ++z) {
                    if (!(this.func_82194_d().func_175625_s(this.func_180425_c().func_177982_a(x, y, z)) instanceof TileEntityDecayPitControl)) continue;
                    tile = (TileEntityDecayPitControl)this.func_82194_d().func_175625_s(this.func_180425_c().func_177982_a(x, y, z));
                }
            }
        }
        return tile;
    }

    public List<TileEntityDecayPitGroundChain> getGroundChains() {
        TileEntityDecayPitGroundChain tile = null;
        ArrayList<TileEntityDecayPitGroundChain> chains = new ArrayList<TileEntityDecayPitGroundChain>();
        BlockPos posEntity = this.func_180425_c();
        Iterable blocks = BlockPos.func_177980_a((BlockPos)posEntity.func_177963_a(-12.0, 3.0, -12.0), (BlockPos)posEntity.func_177963_a(12.0, 9.0, 12.0));
        for (BlockPos pos : blocks) {
            if (!(this.func_82194_d().func_175625_s(pos) instanceof TileEntityDecayPitGroundChain)) continue;
            tile = (TileEntityDecayPitGroundChain)this.func_82194_d().func_175625_s(pos);
            chains.add(tile);
        }
        return chains;
    }

    public void setProgress(int progress) {
        this.field_70180_af.func_187227_b(PROGRESS, (Object)progress);
    }

    public int getProgress() {
        return (Integer)this.field_70180_af.func_187225_a(PROGRESS);
    }

    public void setRaising(boolean raising) {
        this.field_70180_af.func_187227_b(IS_RAISING, (Object)raising);
    }

    public boolean isRaising() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_RAISING);
    }

    public void setMoving(boolean moving) {
        this.field_70180_af.func_187227_b(IS_MOVING, (Object)moving);
    }

    public boolean isMoving() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MOVING);
    }

    public void setSlow(boolean slow) {
        this.field_70180_af.func_187227_b(IS_SLOW, (Object)slow);
    }

    public boolean isSlow() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SLOW);
    }

    public void setTargetNActive(boolean active) {
        this.field_70180_af.func_187227_b(TARGET_N_ACTIVE, (Object)active);
    }

    public boolean getTargetNActive() {
        return (Boolean)this.field_70180_af.func_187225_a(TARGET_N_ACTIVE);
    }

    public void setTargetEActive(boolean active) {
        this.field_70180_af.func_187227_b(TARGET_E_ACTIVE, (Object)active);
    }

    public boolean getTargetEActive() {
        return (Boolean)this.field_70180_af.func_187225_a(TARGET_E_ACTIVE);
    }

    public void setTargetWActive(boolean active) {
        this.field_70180_af.func_187227_b(TARGET_W_ACTIVE, (Object)active);
    }

    public boolean getTargetWActive() {
        return (Boolean)this.field_70180_af.func_187225_a(TARGET_W_ACTIVE);
    }

    public void setTargetSActive(boolean active) {
        this.field_70180_af.func_187227_b(TARGET_S_ACTIVE, (Object)active);
    }

    public boolean getTargetSActive() {
        return (Boolean)this.field_70180_af.func_187225_a(TARGET_S_ACTIVE);
    }

    public World func_82194_d() {
        return this.func_130014_f_();
    }

    public boolean canEntityBeSeen(Entity entity) {
        return this.func_130014_f_().func_147447_a(new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v), new Vec3d(entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v), false, true, false) == null;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.setProgress(nbt.func_74762_e("progress"));
        this.setTargetNActive(nbt.func_74767_n("target_north"));
        this.setTargetEActive(nbt.func_74767_n("target_east"));
        this.setTargetWActive(nbt.func_74767_n("target_west"));
        this.setTargetSActive(nbt.func_74767_n("target_south"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("progress", this.getProgress());
        nbt.func_74757_a("target_north", this.getTargetNActive());
        nbt.func_74757_a("target_east", this.getTargetEActive());
        nbt.func_74757_a("target_west", this.getTargetWActive());
        nbt.func_74757_a("target_south", this.getTargetSActive());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return this.func_174813_aQ().func_186662_g(2.0);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return 0xF000F0;
    }

    public float func_70013_c() {
        return 1.0f;
    }
}

