/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.config.properties;

import gnu.trove.map.TIntIntMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.config.ConfigProperty;

public class PortalTargetList
extends ConfigProperty {
    private Map<String, TIntIntMap> customPortalBlockMap;

    @Override
    protected void init() {
        String[] unparsed;
        this.customPortalBlockMap = new HashMap<String, TIntIntMap>();
        for (String listed : unparsed = BetweenlandsConfig.WORLD_AND_DIMENSION.portalDimensionTargets) {
            try {
                int dim;
                TIntIntMap metaMap;
                int meta;
                String block;
                String[] dimData;
                block12: {
                    dimData = listed.split("/");
                    if (dimData.length < 2) {
                        TheBetweenlands.logger.error("Failed to parse custom portal entry, missing dimension: " + listed);
                        continue;
                    }
                    String[] blockData = dimData[0].split(":");
                    block = blockData[0] + ":" + blockData[1];
                    if (this.customPortalBlockMap.get(block) != null && this.customPortalBlockMap.get(block).containsKey(Short.MAX_VALUE)) continue;
                    meta = 0;
                    if (blockData.length > 2) {
                        String metaStr = blockData[2].split("/")[0];
                        if (!"*".equals(metaStr)) {
                            try {
                                meta = Integer.parseInt(metaStr);
                                break block12;
                            }
                            catch (NumberFormatException ex) {
                                TheBetweenlands.logger.error("Failed to parse custom portal entry block: " + listed + ". Invalid metadata: " + metaStr);
                                continue;
                            }
                        }
                        meta = Short.MAX_VALUE;
                    }
                }
                if ((metaMap = this.customPortalBlockMap.get(block)) == null) {
                    metaMap = new TIntIntHashMap();
                    this.customPortalBlockMap.put(block, metaMap);
                }
                if (meta == Short.MAX_VALUE) {
                    metaMap.clear();
                }
                try {
                    dim = Integer.parseInt(dimData[1]);
                }
                catch (NumberFormatException ex) {
                    TheBetweenlands.logger.error("Failed to parse custom portal entry: " + listed + ". Invalid dimension: " + dimData[1]);
                    continue;
                }
                metaMap.put(meta, dim);
            }
            catch (Exception e) {
                TheBetweenlands.logger.error("Failed to parse custom portal entry: " + listed);
            }
        }
    }

    public boolean isListed(IBlockState state) {
        ResourceLocation name = state.func_177230_c().getRegistryName();
        TIntIntMap metaMap = this.customPortalBlockMap.get(name.toString());
        if (metaMap == null) {
            return false;
        }
        if (metaMap.containsKey(Short.MAX_VALUE)) {
            return true;
        }
        int meta = state.func_177230_c().func_176201_c(state);
        return metaMap.containsKey(meta);
    }

    public int getDimension(IBlockState state) {
        ResourceLocation name = state.func_177230_c().getRegistryName();
        TIntIntMap metaMap = this.customPortalBlockMap.get(name.toString());
        if (metaMap == null) {
            return BetweenlandsConfig.WORLD_AND_DIMENSION.portalDefaultReturnDimension;
        }
        if (metaMap.containsKey(Short.MAX_VALUE)) {
            return metaMap.get(Short.MAX_VALUE);
        }
        int meta = state.func_177230_c().func_176201_c(state);
        if (metaMap.containsKey(meta)) {
            return metaMap.get(meta);
        }
        return BetweenlandsConfig.WORLD_AND_DIMENSION.portalDefaultReturnDimension;
    }
}

