/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.playermounts;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.api.entity.IEntityBL;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.capability.playermounts.IPlayerMountsEntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class PlayerMountsEntityCapability
extends EntityCapability<PlayerMountsEntityCapability, IPlayerMountsEntityCapability, EntityPlayer>
implements IPlayerMountsEntityCapability,
ISerializableCapability {
    private List<NBTTagCompound> queuedPassengers = new ArrayList<NBTTagCompound>();

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "player_mounts");
    }

    @Override
    protected Capability<IPlayerMountsEntityCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_PLAYER_MOUNTS;
    }

    @Override
    protected Class<IPlayerMountsEntityCapability> getCapabilityClass() {
        return IPlayerMountsEntityCapability.class;
    }

    @Override
    protected PlayerMountsEntityCapability getDefaultCapabilityImplementation() {
        return new PlayerMountsEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public List<NBTTagCompound> getQueuedPassengers() {
        return this.queuedPassengers;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        EntityPlayer player = (EntityPlayer)this.getEntity();
        if (player.func_184207_aI()) {
            NBTTagList passengers = new NBTTagList();
            for (Entity entity : player.func_184188_bt()) {
                NBTTagCompound passengerNbt;
                if (!(entity instanceof IEntityBL) || !entity.func_184198_c(passengerNbt = new NBTTagCompound())) continue;
                passengers.func_74742_a((NBTBase)passengerNbt);
            }
            if (!passengers.func_82582_d()) {
                nbt.func_74782_a("PlayerPassengers", (NBTBase)passengers);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.queuedPassengers.clear();
        if (nbt.func_150297_b("PlayerPassengers", 9)) {
            NBTTagList passengers = nbt.func_150295_c("PlayerPassengers", 10);
            for (int i = 0; i < passengers.func_74745_c(); ++i) {
                this.queuedPassengers.add(passengers.func_150305_b(i));
            }
        }
    }

    @SubscribeEvent
    public static void onMountEvent(EntityMountEvent event) {
        if (event.isDismounting()) {
            EntityPlayerMP player;
            Entity mount = event.getEntityBeingMounted();
            Entity rider = event.getEntityMounting();
            if (mount instanceof EntityPlayerMP && rider instanceof IEntityBL && (player = (EntityPlayerMP)mount).func_193105_t()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        IPlayerMountsEntityCapability cap;
        if (!event.player.field_70170_p.field_72995_K && (cap = (IPlayerMountsEntityCapability)event.player.getCapability(CapabilityRegistry.CAPABILITY_PLAYER_MOUNTS, null)) != null) {
            for (NBTTagCompound nbt : cap.getQueuedPassengers()) {
                Entity entity = AnvilChunkLoader.func_186051_a((NBTTagCompound)nbt, (World)event.player.field_70170_p, (boolean)true);
                if (entity == null) continue;
                entity.func_184205_a((Entity)event.player, true);
            }
        }
    }
}

