/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.fishing;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.capability.IRotSmellCapability;
import thebetweenlands.api.capability.ISerializableCapability;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.capability.base.EntityCapability;
import thebetweenlands.common.registries.CapabilityRegistry;

public class RotSmellEntityCapability
extends EntityCapability<RotSmellEntityCapability, IRotSmellCapability, EntityPlayer>
implements IRotSmellCapability,
ISerializableCapability {
    private long smellyTime = -1L;
    private long immunityTime = -1L;

    @Override
    public ResourceLocation getID() {
        return new ResourceLocation("thebetweenlands", "rot_smell");
    }

    @Override
    protected Capability<IRotSmellCapability> getCapability() {
        return CapabilityRegistry.CAPABILITY_ROT_SMELL;
    }

    @Override
    protected Class<IRotSmellCapability> getCapabilityClass() {
        return IRotSmellCapability.class;
    }

    @Override
    protected RotSmellEntityCapability getDefaultCapabilityImplementation() {
        return new RotSmellEntityCapability();
    }

    @Override
    public boolean isApplicable(Entity entity) {
        return entity instanceof EntityPlayer;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74772_a("smellyTime", this.smellyTime);
        nbt.func_74772_a("immunityTime", this.immunityTime);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.smellyTime = nbt.func_74763_f("smellyTime");
        this.immunityTime = nbt.func_74763_f("immunityTime");
    }

    @Override
    public boolean isSmellingBad() {
        return this.getRemainingSmellyTicks() > 0 && this.getRemainingImmunityTicks() <= 0;
    }

    @Override
    public int getRemainingSmellyTicks() {
        return this.smellyTime >= 0L ? Math.max(0, (int)(this.smellyTime - ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E())) : 0;
    }

    @Override
    public void setSmellingBad(int duration) {
        if (duration <= 0) {
            this.setNotSmellingBad();
        } else {
            this.smellyTime = ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E() + (long)duration;
            this.markDirty();
        }
    }

    @Override
    public void setNotSmellingBad() {
        if (this.smellyTime != -1L) {
            this.smellyTime = -1L;
            this.markDirty();
        }
    }

    @Override
    public int getRemainingImmunityTicks() {
        return this.immunityTime >= 0L ? Math.max(0, (int)(this.immunityTime - ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E())) : 0;
    }

    @Override
    public void setImmune(int duration) {
        if (duration <= 0) {
            if (this.immunityTime != -1L) {
                this.immunityTime = -1L;
                this.markDirty();
            }
        } else {
            this.immunityTime = ((EntityPlayer)this.getEntity()).field_70170_p.func_82737_E() + (long)duration;
            this.markDirty();
        }
    }

    @Override
    public void writeTrackingDataToNBT(NBTTagCompound nbt) {
        this.writeToNBT(nbt);
    }

    @Override
    public void readTrackingDataFromNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public int getTrackingTime() {
        return 20;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        IRotSmellCapability cap;
        if (event.phase == TickEvent.Phase.END && event.player.field_70170_p.field_72995_K && (cap = (IRotSmellCapability)event.player.getCapability(CapabilityRegistry.CAPABILITY_ROT_SMELL, null)) != null && event.player.field_70170_p.field_73012_v.nextInt(4) == 0 && cap.isSmellingBad()) {
            BLParticles.FLY.spawn(event.player.field_70170_p, event.player.field_70165_t, event.player.field_70163_u + 1.0, event.player.field_70161_v);
        }
    }
}

