/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.capability.circlegem;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thebetweenlands.api.capability.ICircleGemCapability;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.capability.circlegem.CircleGem;
import thebetweenlands.common.capability.circlegem.CircleGemType;
import thebetweenlands.common.item.armor.amphibious.ItemAmphibiousArmor;
import thebetweenlands.common.item.equipment.ItemAmulet;
import thebetweenlands.common.network.clientbound.MessageGemProc;
import thebetweenlands.common.registries.CapabilityRegistry;
import thebetweenlands.util.NBTHelper;

public class CircleGemHelper {
    public static final String ITEM_GEM_NBT_TAG = "Gem";
    public static final float MAX_GEM_DAMAGE_VARIATION = 8.0f;
    public static final float GEM_PROC_CHANCE = 0.15f;

    public static boolean isApplicable(Item item) {
        return (item instanceof ItemAmulet || item instanceof ItemArmor || item instanceof ItemSword || item instanceof ItemBow || item instanceof ItemTool || item instanceof ItemShield) && !(item instanceof ItemAmphibiousArmor);
    }

    public static boolean isApplicable(Entity entity) {
        return entity instanceof EntityLivingBase;
    }

    public static void setGem(ItemStack stack, CircleGemType gem) {
        NBTTagCompound nbt = NBTHelper.getStackNBTSafe(stack);
        nbt.func_74768_a(ITEM_GEM_NBT_TAG, gem.id);
    }

    public static CircleGemType getGem(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_150297_b(ITEM_GEM_NBT_TAG, 3)) {
            return CircleGemType.fromID(nbt.func_74762_e(ITEM_GEM_NBT_TAG));
        }
        return CircleGemType.NONE;
    }

    public static void addGem(Entity entity, CircleGemType gemType, CircleGem.CombatType combatType) {
        CircleGem gem;
        ICircleGemCapability cap = (ICircleGemCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CIRCLE_GEM, null);
        if (cap != null && cap.canAdd(gem = new CircleGem(gemType, combatType))) {
            cap.addGem(gem);
        }
    }

    public static List<CircleGem> getGems(Entity entity) {
        ArrayList<CircleGem> gems = new ArrayList<CircleGem>();
        ICircleGemCapability cap = (ICircleGemCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CIRCLE_GEM, null);
        if (cap != null) {
            return cap.getGems();
        }
        return gems;
    }

    public static CircleGem getGem(Entity entity, int slot) {
        List<CircleGem> gems;
        ICircleGemCapability cap = (ICircleGemCapability)entity.getCapability(CapabilityRegistry.CAPABILITY_ENTITY_CIRCLE_GEM, null);
        if (cap != null && (gems = cap.getGems()).size() > slot) {
            return cap.getGems().get(slot);
        }
        return new CircleGem(CircleGemType.NONE, CircleGem.CombatType.BOTH);
    }

    public static void addGemPropertyOverrides(Item item) {
        item.func_185043_a(new ResourceLocation("gem"), (stack, worldIn, entityIn) -> CircleGemHelper.getGem((ItemStack)stack).id);
    }

    public static float handleAttack(DamageSource damageSource, EntityLivingBase attackedEntity, float damage) {
        if (!(attackedEntity.field_70737_aN != 0 || attackedEntity.field_70725_aQ != 0 || !(damageSource instanceof EntityDamageSource) || attackedEntity instanceof EntityPlayer && ((EntityPlayer)attackedEntity).field_71075_bZ.field_75102_a)) {
            Entity source;
            Entity attacker;
            if (damageSource instanceof EntityDamageSourceIndirect) {
                attacker = damageSource.func_76346_g();
                source = damageSource.func_76364_f();
            } else {
                source = attacker = damageSource.func_76364_f();
            }
            if (attacker != null && source != null) {
                EntityPlayer player;
                Object heldItem;
                ItemStack heldItem2;
                List<CircleGem> attackerGems = CircleGemHelper.getGems(attacker);
                ArrayList<CircleGem> sourceGems = new ArrayList<CircleGem>();
                if (source != attacker) {
                    sourceGems.addAll(CircleGemHelper.getGems(source));
                }
                CircleGemType attackerItemGem = CircleGemType.NONE;
                if (attacker instanceof EntityLivingBase && !(heldItem2 = CircleGemHelper.getActiveItem(attacker)).func_190926_b()) {
                    attackerItemGem = CircleGemHelper.getGem(heldItem2);
                }
                List<CircleGem> attackedGems = CircleGemHelper.getGems((Entity)attackedEntity);
                CircleGemType attackedBlockingItemGem = CircleGemType.NONE;
                if (attackedEntity instanceof EntityPlayer && !(heldItem = (player = (EntityPlayer)attackedEntity).func_184607_cu()).func_190926_b() && player.func_184585_cz()) {
                    attackedBlockingItemGem = CircleGemHelper.getGem((ItemStack)heldItem);
                }
                int gemRelation = 0;
                for (CircleGem circleGem : attackerGems) {
                    if (!circleGem.matchCombatType(CircleGem.CombatType.OFFENSIVE)) continue;
                    for (CircleGem gemAttacked : attackedGems) {
                        if (!gemAttacked.matchCombatType(CircleGem.CombatType.DEFENSIVE)) continue;
                        gemRelation += circleGem.getGemType().getRelation(gemAttacked.getGemType());
                    }
                    gemRelation += circleGem.getGemType().getRelation(attackedBlockingItemGem);
                }
                for (CircleGem circleGem : attackedGems) {
                    if (!circleGem.matchCombatType(CircleGem.CombatType.DEFENSIVE)) continue;
                    gemRelation += attackerItemGem.getRelation(circleGem.getGemType());
                }
                gemRelation += attackerItemGem.getRelation(attackedBlockingItemGem);
                for (CircleGem circleGem : sourceGems) {
                    if (!circleGem.matchCombatType(CircleGem.CombatType.OFFENSIVE)) continue;
                    for (CircleGem gemAttacked : attackedGems) {
                        if (!gemAttacked.matchCombatType(CircleGem.CombatType.DEFENSIVE)) continue;
                        gemRelation += circleGem.getGemType().getRelation(gemAttacked.getGemType());
                    }
                    gemRelation += circleGem.getGemType().getRelation(attackedBlockingItemGem);
                }
                Iterable equipment = attackedEntity.func_184209_aF();
                for (ItemStack equipmentStack : equipment) {
                    if (equipmentStack.func_190926_b() || equipmentStack.equals(CircleGemHelper.getActiveItem((Entity)attackedEntity)) || !(equipmentStack.func_77973_b() instanceof ItemArmor)) continue;
                    CircleGemType armorGem = CircleGemHelper.getGem(equipmentStack);
                    for (CircleGem gem : attackerGems) {
                        if (!gem.matchCombatType(CircleGem.CombatType.OFFENSIVE)) continue;
                        gemRelation += gem.getGemType().getRelation(armorGem);
                    }
                    gemRelation += attackerItemGem.getRelation(armorGem);
                    for (CircleGem gem : sourceGems) {
                        if (!gem.matchCombatType(CircleGem.CombatType.OFFENSIVE)) continue;
                        gemRelation += gem.getGemType().getRelation(armorGem);
                    }
                }
                float f = Math.min(((gemRelation != 0 ? Math.signum(gemRelation) * 1.0f : 0.0f) + (float)gemRelation) / 6.0f * 8.0f, 8.0f);
                if (f != 0.0f) {
                    damage = Math.max(damage + f, 1.0f);
                }
                damage = Math.max(0.0f, damage);
                boolean attackerProc = attacker.field_70170_p.field_73012_v.nextFloat() <= (source == attacker && !attacker.field_70122_E && attacker.field_70181_x < 0.0 ? 0.19950001f : 0.15f);
                boolean defenderProc = attacker.field_70170_p.field_73012_v.nextFloat() <= 0.15f;
                boolean attackerProcd = false;
                boolean defenderProcd = false;
                ArrayList<Object> attackerProcdGems = new ArrayList<Object>();
                ArrayList<CircleGem> defenderProcdGems = new ArrayList<CircleGem>();
                TObjectIntHashMap attackerGemCounts = new TObjectIntHashMap();
                for (Object gem : attackerGems) {
                    if (!gem.matchCombatType(CircleGem.CombatType.OFFENSIVE)) continue;
                    attackerGemCounts.adjustOrPutValue((Object)gem.getGemType(), 1, 1);
                }
                for (Object gem : sourceGems) {
                    if (!gem.matchCombatType(CircleGem.CombatType.OFFENSIVE)) continue;
                    attackerGemCounts.adjustOrPutValue((Object)gem.getGemType(), 1, 1);
                }
                attackerGemCounts.adjustOrPutValue((Object)attackerItemGem, 1, 1);
                for (Object gem : attackerGemCounts.keySet()) {
                    if (gem == CircleGemType.NONE || !CircleGemHelper.applyProc((CircleGemType)((Object)gem), attacker, source, attacker, (Entity)attackedEntity, attackerProc, defenderProc, CircleGemHelper.getMultipleProcStrength(attackerGemCounts.get(gem), damage), damageSource, damage)) continue;
                    attackerProcd = true;
                    if (attackerProcdGems.contains(gem)) continue;
                    attackerProcdGems.add(gem);
                }
                TObjectIntHashMap defenderGemCounts = new TObjectIntHashMap();
                for (ItemStack equipmentStack : equipment) {
                    CircleGemType armorGem;
                    if (equipmentStack.func_190926_b() || equipmentStack.equals(CircleGemHelper.getActiveItem((Entity)attackedEntity)) || !(equipmentStack.func_77973_b() instanceof ItemArmor) || (armorGem = CircleGemHelper.getGem(equipmentStack)) == CircleGemType.NONE) continue;
                    defenderGemCounts.adjustOrPutValue((Object)armorGem, 1, 1);
                }
                for (Object gem : attackedGems) {
                    if (!gem.matchCombatType(CircleGem.CombatType.DEFENSIVE)) continue;
                    defenderGemCounts.adjustOrPutValue((Object)gem.getGemType(), 1, 1);
                }
                defenderGemCounts.adjustOrPutValue((Object)attackedBlockingItemGem, 1, 1);
                for (Object gem : defenderGemCounts.keySet()) {
                    if (gem == CircleGemType.NONE || !CircleGemHelper.applyProc((CircleGemType)((Object)gem), (Entity)attackedEntity, source, attacker, (Entity)attackedEntity, attackerProc, defenderProc, CircleGemHelper.getMultipleProcStrength(defenderGemCounts.get(gem), damage), damageSource, damage)) continue;
                    defenderProcd = true;
                    if (defenderProcdGems.contains(gem)) continue;
                    defenderProcdGems.add((CircleGem)gem);
                }
                if (attackerProcd || defenderProcd) {
                    World world = attackedEntity.field_70170_p;
                    int dim = 0;
                    if (world instanceof WorldServer) {
                        dim = ((WorldServer)world).field_73011_w.getDimension();
                    }
                    if (attackerProcd) {
                        for (CircleGemType circleGemType : attackerProcdGems) {
                            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageGemProc((Entity)attackedEntity, true, circleGemType), new NetworkRegistry.TargetPoint(dim, attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, 64.0));
                        }
                    }
                    if (defenderProcd) {
                        for (CircleGemType circleGemType : defenderProcdGems) {
                            TheBetweenlands.networkWrapper.sendToAllAround((IMessage)new MessageGemProc((Entity)attackedEntity, false, circleGemType), new NetworkRegistry.TargetPoint(dim, attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, 64.0));
                        }
                    }
                    source.field_70170_p.func_184148_a(null, source.field_70165_t, source.field_70163_u, source.field_70161_v, SoundEvents.field_187734_u, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    source.field_70170_p.func_184148_a(null, attackedEntity.field_70165_t, attackedEntity.field_70163_u, attackedEntity.field_70161_v, SoundEvents.field_187734_u, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
        return damage;
    }

    private static ItemStack getActiveItem(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (!living.func_184607_cu().func_190926_b()) {
                return living.func_184607_cu();
            }
            if (living.func_184600_cs() != null) {
                return living.func_184586_b(living.func_184600_cs());
            }
        }
        return ItemStack.field_190927_a;
    }

    private static float getMultipleProcStrength(int procs, float strength) {
        float ret = 0.0f;
        for (int i = 0; i < procs; ++i) {
            ret = (float)((double)ret + (double)strength / Math.pow(1.4f, i));
        }
        return ret;
    }

    private static boolean applyProc(CircleGemType gem, Entity owner, Entity source, Entity attacker, Entity defender, boolean attackerProc, boolean defenderProc, float strength, DamageSource damageSource, float damage) {
        boolean isAttacker;
        boolean bl = isAttacker = owner == attacker;
        if (isAttacker && attackerProc || !isAttacker && defenderProc) {
            return gem.applyProc(isAttacker, owner, source, attacker, defender, strength, damageSource, damage);
        }
        return false;
    }
}

