/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.block.terrain.BlockLeavesBetweenlands;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockLeavesSpiritTree
extends BlockLeavesBetweenlands {
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.3, 0.3, 0.3, 0.7, 0.7, 0.7);
    public final Type type;

    public BlockLeavesSpiritTree(Type type) {
        this.type = type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos, world.func_180495_p(pos));
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        switch (this.type) {
            case MIDDLE: 
            case BOTTOM: {
                IBlockState above = world.func_180495_p(pos.func_177984_a());
                if (this.type == Type.MIDDLE) {
                    return above.func_177230_c() == BlockRegistry.LEAVES_SPIRIT_TREE_TOP || above.func_177230_c() == BlockRegistry.LEAVES_SPIRIT_TREE_MIDDLE;
                }
                return above.func_177230_c() == BlockRegistry.LEAVES_SPIRIT_TREE_MIDDLE;
            }
        }
        return true;
    }

    protected void checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(worldIn, pos, state)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        this.checkAndDropBlock(worldIn, pos, state);
    }

    @Override
    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.type == Type.TOP) {
            super.func_180650_b(worldIn, pos, state, rand);
        }
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (rand.nextInt(140) == 0) {
            drops.add((Object)new ItemStack(ItemRegistry.SPIRIT_FRUIT));
        }
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.4, 0.4, 0.4, 0.6, 0.6, 0.6);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(100) == 0) {
            double px = (double)pos.func_177958_n() + rand.nextDouble() * 0.5;
            double py = (double)pos.func_177956_o() + rand.nextDouble() * 0.5;
            double pz = (double)pos.func_177952_p() + rand.nextDouble() * 0.5;
            BLParticles.SPIRIT_BUTTERFLY.spawn(world, px, py, pz);
        }
    }

    public static enum Type {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

