/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.terrain.BlockFallenLeaves;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockLeavesBetweenlands
extends BlockLeaves
implements BlockRegistry.IStateMappedBlock {
    private int[] decayBlockCache;

    public BlockLeavesBetweenlands() {
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !Minecraft.func_71410_x().field_71474_y.field_74347_j && blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? false : this.internalShouldSideBeRendered(blockState, blockAccess, pos, side);
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        super.beginLeavesDecay(state, world, pos);
    }

    @SideOnly(value=Side.CLIENT)
    private boolean internalShouldSideBeRendered(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        AxisAlignedBB axisalignedbb = blockState.func_185900_c(blockAccess, pos);
        switch (side) {
            case DOWN: {
                if (!(axisalignedbb.field_72338_b > 0.0)) break;
                return true;
            }
            case UP: {
                if (!(axisalignedbb.field_72337_e < 1.0)) break;
                return true;
            }
            case NORTH: {
                if (!(axisalignedbb.field_72339_c > 0.0)) break;
                return true;
            }
            case SOUTH: {
                if (!(axisalignedbb.field_72334_f < 1.0)) break;
                return true;
            }
            case WEST: {
                if (!(axisalignedbb.field_72340_a > 0.0)) break;
                return true;
            }
            case EAST: {
                if (!(axisalignedbb.field_72336_d < 1.0)) break;
                return true;
            }
        }
        return !blockAccess.func_180495_p(pos.func_177972_a(side)).doesSideBlockRendering(blockAccess, pos.func_177972_a(side), side.func_176734_d());
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public NonNullList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(false));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.field_73012_v.nextInt(160) == 0 && world.func_175623_d(pos.func_177977_b())) {
            BLParticles.WEEDWOOD_LEAF.spawn(world, (float)pos.func_177958_n() + rand.nextFloat(), pos.func_177956_o(), (float)pos.func_177952_p() + rand.nextFloat(), (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withScale(1.0f + rand.nextFloat() * 1.25f));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{field_176236_b, field_176237_a});
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            int distanceToLog;
            int z;
            int y;
            int x;
            int logReach = 5;
            int checkRadius = logReach + 1;
            int cacheSize = 32;
            int cacheSquared = cacheSize * cacheSize;
            int cacheHalf = cacheSize / 2;
            if (this.decayBlockCache == null) {
                this.decayBlockCache = new int[cacheSize * cacheSize * cacheSize];
            }
            if (worldIn.func_175707_a(new BlockPos((x = pos.func_177958_n()) - checkRadius, (y = pos.func_177956_o()) - checkRadius, (z = pos.func_177952_p()) - checkRadius), new BlockPos(x + checkRadius, y + checkRadius, z + checkRadius))) {
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int xo = -logReach; xo <= logReach; ++xo) {
                    for (int yo = -logReach; yo <= logReach; ++yo) {
                        for (int zo = -logReach; zo <= logReach; ++zo) {
                            IBlockState blockState = worldIn.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(x + xo, y + yo, z + zo));
                            Block block = blockState.func_177230_c();
                            if (!block.canSustainLeaves(blockState, (IBlockAccess)worldIn, (BlockPos)mutableBlockPos.func_181079_c(x + xo, y + yo, z + zo))) {
                                if (block.isLeaves(blockState, (IBlockAccess)worldIn, (BlockPos)mutableBlockPos.func_181079_c(x + xo, y + yo, z + zo))) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = -2;
                                    continue;
                                }
                                this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = -1;
                                continue;
                            }
                            this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = 0;
                        }
                    }
                }
                for (int distancePass = 1; distancePass <= logReach; ++distancePass) {
                    for (int xo = -logReach; xo <= logReach; ++xo) {
                        for (int yo = -logReach; yo <= logReach; ++yo) {
                            for (int zo = -logReach; zo <= logReach; ++zo) {
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] != distancePass - 1) continue;
                                if (this.decayBlockCache[(xo + cacheHalf - 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf - 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf + 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf + 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf - 1) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf - 1) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf + 1) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf + 1) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + (zo + cacheHalf - 1)] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + (zo + cacheHalf - 1)] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf + 1] != -2) continue;
                                this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf + 1] = distancePass;
                            }
                        }
                    }
                }
            }
            if ((distanceToLog = this.decayBlockCache[cacheHalf * cacheSquared + cacheHalf * cacheSize + cacheHalf]) >= 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.FALSE), 4);
            } else {
                this.removeLeaves(worldIn, pos);
            }
        }
    }

    protected void removeLeaves(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175698_g(pos);
        BlockPos ground = this.findGround(world, pos, 12 + world.field_73012_v.nextInt(13));
        if (ground != null) {
            this.growFallenPile(world, ground, 0);
        }
    }

    protected boolean growFallenPile(World world, BlockPos pos, int i) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockFallenLeaves) {
            int layers = (Integer)state.func_177229_b((IProperty)BlockFallenLeaves.LAYERS);
            if (layers == 4) {
                if (i <= 3) {
                    for (int j = 0; j < 2; ++j) {
                        if (!this.growFallenPile(world, pos.func_177972_a(EnumFacing.field_176754_o[world.field_73012_v.nextInt(4)]), i + 1)) continue;
                        return true;
                    }
                    return false;
                }
            } else {
                world.func_175656_a(pos, state.func_177226_a((IProperty)BlockFallenLeaves.LAYERS, (Comparable)Integer.valueOf(Math.min(4, 1 + world.field_73012_v.nextInt(4)))));
            }
        } else if ((state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c() instanceof BlockFallenLeaves || state.func_177230_c().func_176200_f((IBlockAccess)world, pos)) && BlockRegistry.FALLEN_LEAVES.func_176196_c(world, pos)) {
            world.func_175656_a(pos, BlockRegistry.FALLEN_LEAVES.func_176223_P().func_177226_a((IProperty)BlockFallenLeaves.LAYERS, (Comparable)Integer.valueOf(1 + world.field_73012_v.nextInt(4))));
        }
        return true;
    }

    @Nullable
    protected BlockPos findGround(World world, BlockPos pos, int range) {
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(pos);
        boolean prevEmpty = false;
        for (int i = 0; i < range; ++i) {
            IBlockState state = world.func_180495_p((BlockPos)checkPos);
            if (state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)checkPos) || state.func_177230_c() instanceof BlockFallenLeaves || state.func_177230_c().func_176200_f((IBlockAccess)world, (BlockPos)checkPos)) {
                prevEmpty = true;
            } else {
                if (state.func_185904_a() != Material.field_151584_j) {
                    if (prevEmpty && world.isSideSolid((BlockPos)checkPos, EnumFacing.UP)) {
                        checkPos.func_185336_p(checkPos.func_177956_o() + 1);
                        return checkPos.func_185334_h();
                    }
                    return null;
                }
                prevEmpty = false;
            }
            checkPos.func_185336_p(checkPos.func_177956_o() - 1);
        }
        return null;
    }
}

