/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.ISickleHarvestable;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.item.herblore.ItemPlantDrop;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockHanger
extends Block
implements IShearable,
ISickleHarvestable,
BlockRegistry.IStateMappedBlock,
BlockRegistry.ISubtypeItemBlockModelDefinition,
BlockRegistry.ICustomItemBlock,
ITintedBlock {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    public static final PropertyBool CAN_GROW = PropertyBool.func_177716_a((String)"can_grow");
    public static final PropertyBool SEEDED = PropertyBool.func_177716_a((String)"seeded");

    public BlockHanger() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.1f);
        this.func_149647_a(BLCreativeTabs.PLANTS);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)CAN_GROW, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SEEDED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 3));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemUsed = playerIn.func_184586_b(hand);
        if (itemUsed != ItemStack.field_190927_a && itemUsed.func_77973_b() == ItemRegistry.MIDDLE_FRUIT && !((Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)SEEDED)).booleanValue()) {
            worldIn.func_175656_a(pos, BlockRegistry.HANGER.func_176223_P().func_177226_a((IProperty)SEEDED, (Comparable)Boolean.valueOf(true)));
            worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, 1.0f);
            itemUsed.func_190918_g(1);
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState stateAbove = worldIn.func_180495_p(pos.func_177984_a());
        boolean canHangOn = stateAbove.func_185904_a() == Material.field_151584_j || stateAbove.isSideSolid((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN) || stateAbove.func_177230_c() == this;
        return super.func_176196_c(worldIn, pos) && canHangOn;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean canHangOn;
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        IBlockState stateAbove = worldIn.func_180495_p(pos.func_177984_a());
        boolean bl = canHangOn = stateAbove.func_185904_a() == Material.field_151584_j || stateAbove.isSideSolid((IBlockAccess)worldIn, pos.func_177984_a(), EnumFacing.DOWN) || stateAbove.func_177230_c() == this;
        if (!canHangOn) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(16) == 0 && ((Boolean)state.func_177229_b((IProperty)CAN_GROW)).booleanValue() && worldIn.func_175623_d(pos.func_177977_b())) {
            worldIn.func_175656_a(pos.func_177977_b(), this.func_176223_P());
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return item.func_77973_b() == ItemRegistry.SYRMORITE_SHEARS || item.func_77973_b() == ItemRegistry.SILT_CRAB_CLAW;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)new ItemStack(Item.func_150898_a((Block)this)));
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public List<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return ImmutableList.of((Object)ItemPlantDrop.EnumItemPlantDrop.HANGER_ITEM.create(1));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{CAN_GROW}).ignore(new IProperty[]{SEEDED}).withPropertySuffixTrue((IProperty<Boolean>)SEEDED, "seeded");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CAN_GROW, SEEDED});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        state = state.func_177226_a((IProperty)CAN_GROW, (Comparable)Boolean.valueOf((meta & 1) != 0));
        state = state.func_177226_a((IProperty)SEEDED, (Comparable)Boolean.valueOf((meta & 2) != 0));
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((Boolean)state.func_177229_b((IProperty)CAN_GROW)).booleanValue()) {
            meta |= 1;
        }
        if (((Boolean)state.func_177229_b((IProperty)SEEDED)).booleanValue()) {
            meta |= 2;
        }
        return meta;
    }

    @Override
    public int getSubtypeNumber() {
        return 2;
    }

    @Override
    public int getSubtypeMeta(int subtype) {
        switch (subtype) {
            default: {
                return 0;
            }
            case 1: 
        }
        return 3;
    }

    @Override
    public String getSubtypeName(int meta) {
        switch (meta) {
            default: {
                return "%s";
            }
            case 3: 
        }
        return "%s_seeded";
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemBlock item = new ItemBlock(this){

            public String func_77667_c(ItemStack stack) {
                IBlockState state = this.field_150939_a.func_176203_a(this.func_77647_b(stack.func_77952_i()));
                return this.field_150939_a.func_149739_a() + ((Boolean)state.func_177229_b((IProperty)SEEDED) != false ? "_seeded" : "");
            }

            public int func_77647_b(int damage) {
                return damage;
            }
        };
        item.func_77627_a(true);
        return item;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, (Boolean)state.func_177229_b((IProperty)SEEDED) != false ? 3 : 0);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (((Boolean)state.func_177229_b((IProperty)SEEDED)).booleanValue()) {
            drops.add((Object)new ItemStack(ItemRegistry.MIDDLE_FRUIT_BUSH_SEEDS));
            return;
        }
        super.getDrops(drops, world, pos, state, fortune);
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : -1;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)CAN_GROW, (Comparable)Boolean.valueOf(true));
    }
}

