/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.terrain;

import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockBetweenstonePebblePileWater
extends BlockSwampWater
implements BlockRegistry.IStateMappedBlock,
BlockRegistry.ICustomItemBlock {
    public static final PropertyEnum<EnumPileType> PILE_TYPE = PropertyEnum.func_177709_a((String)"pile_type", EnumPileType.class);
    private static final AxisAlignedBB AABB_1_STONE = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.1875, 0.75);
    private static final AxisAlignedBB AABB_2_STONE = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.1875, 0.75);
    private static final AxisAlignedBB AABB_3_STONE = new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.1875, 0.8125);
    private static final AxisAlignedBB AABB_4_STONE = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.1875, 0.875);

    public BlockBetweenstonePebblePileWater() {
        this(FluidRegistry.SWAMP_WATER, Material.field_151586_h);
        this.func_149711_c(0.5f);
    }

    public BlockBetweenstonePebblePileWater(Fluid fluid, Material materialIn) {
        super(fluid, materialIn);
        this.func_149711_c(0.5f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.setUnderwaterBlock(true);
        this.func_180632_j(this.func_176223_P().func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.ONE)).func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{LEVEL});
    }

    @Override
    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = state.func_185899_b(source, pos);
        switch ((EnumPileType)((Object)state.func_177229_b(PILE_TYPE))) {
            default: {
                return AABB_1_STONE;
            }
            case TWO: 
            case TWO_PLANT: {
                return AABB_2_STONE;
            }
            case THREE: 
            case THREE_PLANT: {
                return AABB_3_STONE;
            }
            case FOUR: 
            case FOUR_PLANT: 
        }
        return AABB_4_STONE;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, EnumPileType.ONE.getMetadata()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!world.field_72995_K) {
            if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.getItem() && player.func_184586_b(hand).func_77952_i() == ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.getID()) {
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.FOUR || state.func_177229_b(PILE_TYPE) == EnumPileType.FOUR_PLANT) {
                    return false;
                }
                ItemStack stack = player.func_184586_b(hand).func_77979_a(1);
                if (!stack.func_190926_b()) {
                    IBlockState stateNew = state.func_177231_a(PILE_TYPE);
                    world.func_175656_a(pos, stateNew);
                    return true;
                }
            } else if (player.func_184586_b(hand).func_190926_b()) {
                ItemStack extracted = ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.create(1);
                EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, extracted);
                item.field_70179_y = 0.0;
                item.field_70181_x = 0.0;
                item.field_70159_w = 0.0;
                world.func_72838_d((Entity)item);
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.FOUR) {
                    world.func_175656_a(pos, state.func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.THREE)));
                }
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.THREE) {
                    world.func_175656_a(pos, state.func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.TWO)));
                }
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.TWO) {
                    world.func_175656_a(pos, state.func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.ONE)));
                }
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.ONE) {
                    world.func_175698_g(pos);
                }
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.FOUR_PLANT) {
                    world.func_175656_a(pos, state.func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.THREE_PLANT)));
                }
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.THREE_PLANT) {
                    world.func_175656_a(pos, state.func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.TWO_PLANT)));
                }
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.TWO_PLANT) {
                    world.func_175656_a(pos, state.func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.ONE_PLANT)));
                }
                if (state.func_177229_b(PILE_TYPE) == EnumPileType.ONE_PLANT) {
                    world.func_175698_g(pos);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && world.func_180495_p(pos.func_177977_b()).func_185913_b();
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        IBlockState stateDown = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() == null || world.func_175623_d(pos.func_177977_b())) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (!(world.func_180495_p(pos).func_177230_c() instanceof BlockBetweenstonePebblePileWater)) {
            if (world.field_73012_v.nextBoolean()) {
                return this.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.ONE_PLANT));
            }
            return this.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.ONE));
        }
        return this.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        int dropCount = 0;
        int meta = ((EnumPileType)((Object)state.func_177229_b(PILE_TYPE))).getMetadata();
        if (meta <= 3) {
            dropCount = meta;
        }
        if (meta >= 4 && meta <= 7) {
            dropCount = meta - 4;
        }
        drops.add((Object)ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.create(1 + dropCount));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return ItemMisc.EnumItemMisc.BETWEENSTONE_PEBBLE.create(1);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(PILE_TYPE, (Comparable)((Object)EnumPileType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumPileType)((Object)state.func_177229_b(PILE_TYPE))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{LEVEL}).add(new IProperty[]{PILE_TYPE}).add((IUnlistedProperty[])FLUID_RENDER_PROPS.toArray((Object[])new IUnlistedProperty[0])).build();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumPileType)((Object)state.func_177229_b(PILE_TYPE))).getMetadata();
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }

    public static enum EnumPileType implements IStringSerializable
    {
        ONE,
        TWO,
        THREE,
        FOUR,
        ONE_PLANT,
        TWO_PLANT,
        THREE_PLANT,
        FOUR_PLANT;

        private final String name = this.name().toLowerCase(Locale.ENGLISH);

        public int getMetadata() {
            return this.ordinal();
        }

        public String toString() {
            return this.name;
        }

        public static EnumPileType byMetadata(int metadata) {
            if (metadata < 0 || metadata >= EnumPileType.values().length) {
                metadata = 0;
            }
            return EnumPileType.values()[metadata];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

