/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.common.block.misc.BlockLantern;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class BlockRope
extends Block
implements BlockRegistry.ICustomItemBlock {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
    public static final PropertyEnum<EnumRopeVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumRopeVariant.class);

    public BlockRope() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.SINGLE)));
        this.func_149647_a(null);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        entity.field_70122_E = true;
        entity.field_70143_R = 0.0f;
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_190926_b() && player.func_70093_af()) {
            BlockPos offsetPos = pos.func_177977_b();
            while (world.func_180495_p(offsetPos).func_177230_c() == this) {
                offsetPos = offsetPos.func_177977_b();
            }
            if ((offsetPos = offsetPos.func_177984_a()).func_177956_o() != pos.func_177956_o()) {
                if (!world.field_72995_K) {
                    world.func_175698_g(offsetPos);
                    if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(new ItemStack(ItemRegistry.ROPE_ITEM))) {
                        world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(ItemRegistry.ROPE_ITEM)));
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return !worldIn.func_180495_p(pos).func_185904_a().func_76224_d() && super.func_176196_c(worldIn, pos) && (worldIn.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.DOWN) || worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ItemRegistry.ROPE_ITEM;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        if (!worldIn.func_180495_p(pos.func_177984_a()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.DOWN) && worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = state.func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.MIDDLE));
        if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() != this) {
            state = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLantern ? state.func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.TOP)) : state.func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.SINGLE));
        } else if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
            state = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockLantern ? state.func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.MIDDLE)) : state.func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.BOTTOM));
        }
        return state;
    }

    public IBlockState func_176203_a(int meta) {
        switch (meta) {
            default: {
                return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.SINGLE));
            }
            case 1: {
                return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.TOP));
            }
            case 2: {
                return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.MIDDLE));
            }
            case 3: 
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumRopeVariant.BOTTOM));
    }

    public int func_176201_c(IBlockState state) {
        switch ((EnumRopeVariant)((Object)state.func_177229_b(VARIANT))) {
            default: {
                return 0;
            }
            case TOP: {
                return 1;
            }
            case MIDDLE: {
                return 2;
            }
            case BOTTOM: 
        }
        return 3;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public ItemBlock getItemBlock() {
        return null;
    }

    public static enum EnumRopeVariant implements IStringSerializable
    {
        SINGLE,
        TOP,
        MIDDLE,
        BOTTOM;

        private final String name = this.name().toLowerCase(Locale.ENGLISH);

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

