/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.util.AdvancedStateMap;

public class BlockMistBridge
extends Block
implements BlockRegistry.IStateMappedBlock {
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool SOLID = PropertyBool.func_177716_a((String)"solid");

    public BlockMistBridge(Material materialIn) {
        super(materialIn);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(1.2f);
        this.func_149752_b(8.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOLID, (Comparable)Boolean.valueOf(true)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)SOLID)).booleanValue()) {
            return field_185506_k;
        }
        return field_185505_j;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        BlockPos.PooledMutableBlockPos offset = BlockPos.PooledMutableBlockPos.func_185346_s();
        BlockPos.PooledMutableBlockPos offsetDown = BlockPos.PooledMutableBlockPos.func_185346_s();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            PropertyBool prop;
            offset.func_181079_c(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + facing.func_82599_e());
            IBlockState offsetState = worldIn.func_180495_p((BlockPos)offset);
            offsetDown.func_181079_c(pos.func_177958_n() + facing.func_82601_c(), pos.func_177956_o() - 1, pos.func_177952_p() + facing.func_82599_e());
            IBlockState offsetDownState = worldIn.func_180495_p((BlockPos)offsetDown);
            switch (facing) {
                default: {
                    prop = NORTH;
                    break;
                }
                case EAST: {
                    prop = EAST;
                    break;
                }
                case SOUTH: {
                    prop = SOUTH;
                    break;
                }
                case WEST: {
                    prop = WEST;
                }
            }
            state = state.func_177226_a((IProperty)prop, (Comparable)Boolean.valueOf(!(offsetState.func_177230_c() instanceof BlockMistBridge)));
        }
        offset.func_185344_t();
        offsetDown.func_185344_t();
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, SOLID});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SOLID, (Comparable)Boolean.valueOf(meta == 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SOLID) != false ? 0 : 1;
    }

    @Override
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        builder.ignore(new IProperty[]{SOLID});
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)SOLID, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.func_175623_d(pos.func_177984_a())) {
            for (int i = 0; i < 3 + rand.nextInt(5); ++i) {
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_GLOWING_NEAREST_NEIGHBOR, BLParticles.SMOOTH_SMOKE.create(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 1.0f, (float)pos.func_177952_p() + 0.5f, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((rand.nextFloat() - 0.5f) * 0.08f, rand.nextFloat() * 0.01f + 0.01f, (rand.nextFloat() - 0.5f) * 0.08f)).withScale(1.0f + rand.nextFloat() * 8.0f)).withColor(1.0f, 1.0f, 1.0f, 0.05f)).withData(80, true, Float.valueOf(0.01f), true)));
            }
        }
    }
}

