/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.misc;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.block.IWaterDisplacementHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.misc.BlockGlowingGoopUnderwater;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.item.misc.ItemGlowingGoop;
import thebetweenlands.common.registries.BlockRegistry;

public class BlockGlowingGoop
extends BlockDirectional
implements BlockRegistry.ICustomItemBlock,
IWaterDisplacementHandler {
    public BlockGlowingGoop() {
        super(Material.field_151592_s);
        this.func_180632_j(this.func_176194_O().func_177621_b());
        this.func_149715_a(0.8f);
        this.func_149711_c(0.0f);
        this.func_149752_b(2.0f);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    @Override
    @Nullable
    public ItemBlock getItemBlock() {
        return new ItemGlowingGoop();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        float widthMin = 0.0f;
        float heightMin = 0.0f;
        float depthMin = 0.0f;
        float widthMax = 0.0f;
        float heightMax = 0.0f;
        float depthMax = 0.0f;
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)) {
            case UP: {
                widthMin = 0.125f;
                heightMin = 0.0f;
                depthMin = 0.125f;
                widthMax = 0.125f;
                heightMax = 0.75f;
                depthMax = 0.125f;
                break;
            }
            case DOWN: {
                widthMin = 0.125f;
                heightMin = 0.75f;
                depthMin = 0.125f;
                widthMax = 0.125f;
                heightMax = 0.0f;
                depthMax = 0.125f;
                break;
            }
            case NORTH: {
                widthMin = 0.125f;
                heightMin = 0.125f;
                depthMin = 0.75f;
                widthMax = 0.125f;
                heightMax = 0.125f;
                depthMax = 0.0f;
                break;
            }
            case WEST: {
                widthMin = 0.75f;
                heightMin = 0.125f;
                depthMin = 0.125f;
                widthMax = 0.0f;
                heightMax = 0.125f;
                depthMax = 0.125f;
                break;
            }
            case SOUTH: {
                widthMin = 0.125f;
                heightMin = 0.125f;
                depthMin = 0.0f;
                widthMax = 0.125f;
                heightMax = 0.125f;
                depthMax = 0.75f;
                break;
            }
            case EAST: {
                widthMin = 0.0f;
                heightMin = 0.125f;
                depthMin = 0.125f;
                widthMax = 0.75f;
                heightMax = 0.125f;
                depthMax = 0.125f;
            }
        }
        return new AxisAlignedBB((double)(0.0f + widthMin), (double)(0.0f + heightMin), (double)(0.0f + depthMin), (double)(1.0f - widthMax), (double)(1.0f - heightMax), (double)(1.0f - depthMax));
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return this.canPlaceBlock(world, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    public boolean canPlaceBlock(World world, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState state = world.func_180495_p(blockpos);
        boolean isSolid = state.func_193401_d((IBlockAccess)world, blockpos, direction) == BlockFaceShape.SOLID;
        return world.func_175677_d(blockpos, true) && state.func_185914_p() && isSolid;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N});
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        boolean shouldStay = false;
        if (world.isSideSolid(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176734_d()), (EnumFacing)state.func_177229_b((IProperty)field_176387_N))) {
            shouldStay = true;
        }
        if (!shouldStay) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
        super.func_189540_a(state, world, pos, block, fromPos);
    }

    @Override
    public boolean onWaterDisplacement(World world, BlockPos pos, BlockSwampWater block) {
        return world.func_180501_a(pos, BlockRegistry.GLOWING_GOOP_UNDERWATER.func_176223_P().func_177226_a((IProperty)BlockGlowingGoopUnderwater.FACING, world.func_180495_p(pos).func_177229_b((IProperty)field_176387_N)), 2);
    }
}

