/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.item.misc.ItemLifeCrystal;
import thebetweenlands.common.item.tools.ItemBLBucket;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityInfuser;

public class BlockInfuser
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockInfuser() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        int rotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        state = state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)rotation));
        worldIn.func_180501_a(pos, state, 3);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!world.field_72995_K && tileEntity instanceof TileEntityInfuser) {
            TileEntityInfuser tile = (TileEntityInfuser)tileEntity;
            IFluidHandler fluidHandler = this.getFluidHandler((IBlockAccess)world, pos);
            if (fluidHandler != null && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)fluidHandler)) {
                return true;
            }
            if (!player.func_70093_af()) {
                ItemAspectContainer aspectContainer;
                if (heldItem.func_190926_b() && tile.getStirProgress() >= 90) {
                    tile.setStirProgress(0);
                    return true;
                }
                if (!heldItem.func_190926_b() && !tile.hasInfusion() && (aspectContainer = ItemAspectContainer.fromItem(heldItem, AspectManager.get(world))).getAspects().size() > 0) {
                    ItemStack ingredient = heldItem;
                    for (int i = 0; i < 6; ++i) {
                        if (!tile.func_70301_a(i).func_190926_b()) continue;
                        ItemStack singleIngredient = ingredient.func_77946_l();
                        singleIngredient.func_190920_e(1);
                        tile.func_70299_a(i, singleIngredient);
                        tile.updateInfusingRecipe();
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                        world.func_184138_a(pos, state, state, 2);
                        if (tile.getWaterAmount() > 0) {
                            world.func_184133_a(null, pos, SoundEvents.field_187547_bF, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.3f);
                        } else {
                            world.func_184133_a(null, pos, SoundEvents.field_187620_cL, SoundCategory.BLOCKS, 0.3f, 0.9f + world.field_73012_v.nextFloat() * 0.3f);
                        }
                        return true;
                    }
                }
                if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemLifeCrystal) {
                    if (tile.func_70301_a(7).func_190926_b()) {
                        tile.func_70299_a(7, heldItem);
                        tile.updateInfusingRecipe();
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_184611_a(hand, ItemStack.field_190927_a);
                        }
                    }
                    return true;
                }
            }
            if (player.func_70093_af() && !tile.hasInfusion()) {
                for (int i = 6; i >= 0; --i) {
                    if (tile.func_70301_a(i).func_190926_b()) continue;
                    EntityItem itemEntity = player.func_71019_a(tile.func_70301_a(i).func_77946_l(), false);
                    if (itemEntity != null) {
                        itemEntity.func_174867_a(0);
                    }
                    tile.func_70299_a(i, ItemStack.field_190927_a);
                    tile.updateInfusingRecipe();
                    world.func_184138_a(pos, state, state, 2);
                    return true;
                }
            }
            if (player.func_70093_af()) {
                if (heldItem.func_77973_b() instanceof ItemBLBucket && ((ItemBLBucket)heldItem.func_77973_b()).getFluid(heldItem) == null && tile.hasInfusion() && tile.getWaterAmount() >= 1000) {
                    ItemStack infusionBucket = new ItemStack(ItemRegistry.BL_BUCKET_INFUSION, 1, heldItem.func_77960_j());
                    NBTTagCompound nbtCompound = new NBTTagCompound();
                    infusionBucket.func_77982_d(nbtCompound);
                    nbtCompound.func_74778_a("infused", "Infused");
                    NBTTagList nbtList = new NBTTagList();
                    for (int i = 0; i < tile.func_70302_i_() - 1; ++i) {
                        ItemStack stackInSlot = tile.func_70301_a(i);
                        if (stackInSlot.func_190926_b()) continue;
                        nbtList.func_74742_a((NBTBase)stackInSlot.func_77955_b(new NBTTagCompound()));
                    }
                    nbtCompound.func_74782_a("ingredients", (NBTBase)nbtList);
                    nbtCompound.func_74768_a("infusionTime", tile.getInfusionTime());
                    tile.extractFluids(new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, 1000));
                    if (heldItem.func_190916_E() == 1) {
                        player.func_184611_a(hand, infusionBucket.func_77946_l());
                        return true;
                    }
                    if (!player.func_191521_c(infusionBucket.func_77946_l())) {
                        player.func_71019_a(infusionBucket.func_77946_l(), false);
                    }
                    heldItem.func_190918_g(1);
                    return true;
                }
                if (!tile.func_70301_a(7).func_190926_b()) {
                    EntityItem itemEntity = player.func_71019_a(tile.func_70301_a(7).func_77946_l(), false);
                    if (itemEntity != null) {
                        itemEntity.func_174867_a(0);
                    }
                    tile.func_70299_a(7, ItemStack.field_190927_a);
                    tile.updateInfusingRecipe();
                    world.func_184138_a(pos, state, state, 2);
                    return true;
                }
            }
        }
        return true;
    }

    @Nullable
    private IFluidHandler getFluidHandler(IBlockAccess world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        return (IFluidHandler)tileentity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            ItemStack stack;
            IInventory tileInventory = (IInventory)world.func_175625_s(pos);
            TileEntityInfuser tile = (TileEntityInfuser)world.func_175625_s(pos);
            if (tileInventory != null && !tile.hasInfusion()) {
                for (int i = 0; i <= 7; ++i) {
                    ItemStack stack2 = tileInventory.func_70301_a(i);
                    if (stack2.func_190926_b()) continue;
                    float f = 0.7f;
                    double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack2);
                    entityitem.func_174869_p();
                    world.func_72838_d((Entity)entityitem);
                }
            } else if (tileInventory != null && tile.hasInfusion() && !(stack = tileInventory.func_70301_a(7)).func_190926_b()) {
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
                entityitem.func_174869_p();
                world.func_72838_d((Entity)entityitem);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (world.func_175625_s(pos) instanceof TileEntityInfuser) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            TileEntityInfuser infuser = (TileEntityInfuser)world.func_175625_s(pos);
            if (infuser.getWaterAmount() > 0 && infuser.getTemperature() > 0) {
                int amount = infuser.waterTank.getFluidAmount();
                int capacity = infuser.waterTank.getCapacity();
                float size = 1.0f / (float)capacity * (float)amount;
                float xx = (float)x + 0.5f;
                float yy = (float)y + 0.35f + size * 0.5f;
                float zz = (float)z + 0.5f;
                float fixedOffset = 0.25f;
                float randomOffset = rand.nextFloat() * 0.6f - 0.3f;
                if (rand.nextInt(101 - infuser.getTemperature()) / 4 == 0) {
                    float[] colors = infuser.currentInfusionColor;
                    BLParticles.BUBBLE_INFUSION.spawn(world, xx + 0.3f - rand.nextFloat() * 0.6f, yy, zz + 0.3f - rand.nextFloat() * 0.6f, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withScale(0.3f)).withColor(colors[0], colors[1], colors[2], 1.0f));
                    if (rand.nextInt(10) == 0 && infuser.getTemperature() > 70) {
                        world.func_184134_a((double)xx, (double)yy, (double)zz, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 1.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.5f, false);
                    }
                }
                if (infuser.getTemperature() >= 100) {
                    BLParticles.STEAM_PURIFIER.spawn(world, xx - fixedOffset, (double)y + 0.75, zz + randomOffset);
                    BLParticles.STEAM_PURIFIER.spawn(world, xx + fixedOffset, (double)y + 0.75, zz + randomOffset);
                    BLParticles.STEAM_PURIFIER.spawn(world, xx + randomOffset, (double)y + 0.75, zz - fixedOffset);
                    BLParticles.STEAM_PURIFIER.spawn(world, xx + randomOffset, (double)y + 0.75, zz + fixedOffset);
                }
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityInfuser();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntityInfuser tile;
        if (world.field_73011_w.getDimension() == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && world.func_175625_s(pos) instanceof TileEntityInfuser && (tile = (TileEntityInfuser)world.func_175625_s(pos)) != null) {
            tile.fill(new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, 1000), true);
        }
    }
}

