/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.BatchedParticleRenderer;
import thebetweenlands.client.render.particle.DefaultParticleBatches;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.TheBetweenlands;
import thebetweenlands.common.block.terrain.BlockSwampWater;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.tile.TileEntityCrabPotFilter;
import thebetweenlands.util.AdvancedStateMap;

public class BlockCrabPotFilter
extends BlockSwampWater
implements ITileEntityProvider,
BlockRegistry.IStateMappedBlock {
    public BlockCrabPotFilter() {
        this(FluidRegistry.SWAMP_WATER, Material.field_151586_h);
        this.func_149711_c(2.0f);
    }

    public BlockCrabPotFilter(Fluid fluid, Material materialIn) {
        super(fluid, materialIn);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.setUnderwaterBlock(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setStateMapper(AdvancedStateMap.Builder builder) {
        super.setStateMapper(builder);
        builder.ignore(new IProperty[]{LEVEL});
    }

    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_74837_a((String)"tooltip.bl.crab_pot_filter_item", (Object[])new Object[0]), 0));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @Override
    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityCrabPotFilter) {
            TileEntityCrabPotFilter tile = (TileEntityCrabPotFilter)world.func_175625_s(pos);
            tile.setRotation(placer.func_174811_aO().func_176735_f().func_176736_b());
            tile.markForUpdate();
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCrabPotFilter();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            player.openGui((Object)TheBetweenlands.instance, 33, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityCrabPotFilter tile = (TileEntityCrabPotFilter)world.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
            world.func_175713_t(pos);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntityCrabPotFilter tile = (TileEntityCrabPotFilter)world.func_175625_s(pos);
        if (tile != null && rand.nextInt(3) == 0 && tile.isActive() && tile.getSlotProgress() > 0) {
            for (int i = 0; i < 5 + rand.nextInt(5); ++i) {
                BatchedParticleRenderer.INSTANCE.addParticle(DefaultParticleBatches.TRANSLUCENT_NEAREST_NEIGHBOR, BLParticles.SMOOTH_SMOKE.create(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.99f, (float)pos.func_177952_p() + 0.5f, (ParticleFactory.ParticleArgs<?>)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)((ParticleFactory.ParticleArgs)ParticleFactory.ParticleArgs.get().withMotion((rand.nextFloat() - 0.5f) * 0.01f, -rand.nextFloat() * -0.05f - 0.05f, (rand.nextFloat() - 0.5f) * 0.01f)).withScale(0.5f + rand.nextFloat() * 8.0f)).withColor(0.59f, 0.29f, 0.0f, 0.3f)).withData(80, true, Float.valueOf(0.01f), true)));
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    @Override
    public ItemBlock getItemBlock() {
        return BlockRegistry.ICustomItemBlock.getDefaultItemBlock((Block)this);
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }
}

