/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.advancments;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import thebetweenlands.common.advancments.BLTrigger;
import thebetweenlands.common.advancments.BlockPredicate;

public class RightClickBlockTrigger
extends BLTrigger<Instance, Listener> {
    public static final ResourceLocation ID = new ResourceLocation("thebetweenlands", "right_click_block");

    public ResourceLocation func_192163_a() {
        return ID;
    }

    @Override
    public Listener createListener(PlayerAdvancements playerAdvancements) {
        return new Listener(playerAdvancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        JsonElement sides = json.get("sides");
        EnumFacing[] facings = null;
        if (sides == null || !sides.isJsonNull()) {
            // empty if block
        }
        BlockPredicate[] blockPredicates = BlockPredicate.deserializeArray((JsonElement)json.getAsJsonArray("blocks"));
        LocationPredicate locationpredicate = LocationPredicate.func_193454_a((JsonElement)json.get("location"));
        ItemPredicate[] itemPredicate = ItemPredicate.func_192494_b((JsonElement)json.get("items"));
        return new Instance(itemPredicate, blockPredicates, locationpredicate, facings);
    }

    public void trigger(ItemStack stack, EntityPlayerMP player, BlockPos pos, IBlockState state, EnumFacing face) {
        Listener listeners = (Listener)this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(stack, state, pos, face, player.func_71121_q());
        }
    }

    static class Listener
    extends BLTrigger.Listener<Instance> {
        public Listener(PlayerAdvancements playerAdvancementsIn) {
            super(playerAdvancementsIn);
        }

        public void trigger(ItemStack stack, IBlockState state, BlockPos pos, EnumFacing face, WorldServer world) {
            ArrayList<ICriterionTrigger.Listener> list = new ArrayList<ICriterionTrigger.Listener>();
            for (ICriterionTrigger.Listener listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(stack, state, pos, face, world)) continue;
                list.add(listener);
                break;
            }
            for (ICriterionTrigger.Listener listener : list) {
                listener.func_192159_a(this.playerAdvancements);
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final ItemPredicate[] items;
        private final BlockPredicate[] blocks;
        private final LocationPredicate location;
        private final EnumFacing[] facings;

        public Instance(ItemPredicate[] items, BlockPredicate[] blocks, LocationPredicate location, EnumFacing[] facings) {
            super(ID);
            this.items = items;
            this.blocks = blocks;
            this.location = location;
            this.facings = facings;
        }

        public boolean test(ItemStack stack, IBlockState state, BlockPos pos, EnumFacing face, WorldServer world) {
            ArrayList blockList = Lists.newArrayList((Object[])this.blocks);
            ArrayList itemList = Lists.newArrayList((Object[])this.items);
            int blockAmount = blockList.size();
            int itemAmount = itemList.size();
            blockList.removeIf(predicate -> predicate.test(state));
            itemList.removeIf(predicate -> predicate.func_192493_a(stack));
            boolean matchSide = this.facings == null || this.facings.length <= 0 || Arrays.stream(this.facings).anyMatch(enumFacing -> enumFacing.equals((Object)face));
            return matchSide && blockAmount > blockList.size() && itemAmount > itemList.size() && this.location.func_193453_a(world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
        }
    }
}

