/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.tile.ModelSiltGlassJar;
import thebetweenlands.common.tile.TileEntitySiltGlassJar;

@SideOnly(value=Side.CLIENT)
public class RenderSiltGlassJar
extends TileEntitySpecialRenderer<TileEntitySiltGlassJar> {
    public static final ResourceLocation WORM_WIGGLE = new ResourceLocation("thebetweenlands:blocks/worm_wiggle");
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/blocks/silt_glass_jar.png");
    private final ModelSiltGlassJar model = new ModelSiltGlassJar();

    public void render(TileEntitySiltGlassJar tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        int wormLevel;
        if (tile != null && (wormLevel = tile.getItemCount()) >= 1) {
            float height = 0.0859375f * (float)wormLevel;
            TextureAtlasSprite wormSprite = Minecraft.func_71410_x().func_147117_R().func_110572_b("thebetweenlands:blocks/worm_wiggle");
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            float yMin = 0.0f;
            float xMax = 1.5f;
            float zMax = 1.5f;
            float xMin = 0.5f;
            float zMin = 0.5f;
            yMin = 0.0625f;
            this.renderCuboid(buffer, xMax, xMin, yMin, height, zMin, zMax, wormSprite);
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179145_e();
        }
        this.func_147499_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179089_o();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        this.model.render();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        this.model.render();
        GlStateManager.func_179121_F();
    }

    private void renderCuboid(BufferBuilder buffer, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite) {
        double uMin = textureAtlasSprite.func_94209_e();
        double uMax = textureAtlasSprite.func_94212_f();
        double vMin = textureAtlasSprite.func_94206_g();
        double vMax = textureAtlasSprite.func_94210_h();
        double vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMax);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMax);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMax, yMin, zMin, uMin, vMin);
        this.addVertexWithUV(buffer, xMax, height, zMin, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, height, zMax, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMax, yMin, zMax, uMax, vMin);
        this.addVertexWithUV(buffer, xMin, yMin, zMax, uMin, vMin);
        this.addVertexWithUV(buffer, xMin, height, zMax, uMin, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, height, zMin, uMax, vMin + vHeight * (double)height);
        this.addVertexWithUV(buffer, xMin, yMin, zMin, uMax, vMin);
    }

    private void addVertexWithUV(BufferBuilder buffer, float x, float y, float z, double u, double v) {
        buffer.func_181662_b((double)(x / 2.0f), (double)y, (double)(z / 2.0f)).func_187315_a(u, v).func_181675_d();
    }
}

