/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.model.entity.ModelBubblerCrab;
import thebetweenlands.client.render.model.entity.ModelSiltCrab;
import thebetweenlands.client.render.model.tile.ModelCrabPot;
import thebetweenlands.common.entity.mobs.EntityBubblerCrab;
import thebetweenlands.common.entity.mobs.EntitySiltCrab;
import thebetweenlands.common.item.misc.ItemMob;
import thebetweenlands.common.tile.TileEntityCrabPot;

public class RenderCrabPot
extends TileEntitySpecialRenderer<TileEntityCrabPot> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/crab_pot.png");
    public static final ResourceLocation TEXTURE_SILT = new ResourceLocation("thebetweenlands:textures/entity/silt_crab.png");
    public static final ResourceLocation TEXTURE_BUBBLER = new ResourceLocation("thebetweenlands:textures/entity/bubbler_crab.png");
    public static final ModelCrabPot MODEL = new ModelCrabPot();
    public static final ModelSiltCrab MODEL_SILT = new ModelSiltCrab();
    public static final ModelBubblerCrab MODEL_BUBBLER = new ModelBubblerCrab();

    public void render(TileEntityCrabPot te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int index = te != null ? te.getRotation() : 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y), (float)((float)z + 0.5f));
        GlStateManager.func_179094_E();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179114_b((float)RenderCrabPot.getRotation(index), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.005f, (float)-1.0f, (float)-1.005f);
        this.func_147499_a(TEXTURE);
        MODEL.render();
        GlStateManager.func_179121_F();
        if (te != null && !te.func_70301_a(0).func_190926_b()) {
            if (this.isSafeMobItem(te) && te.getEntity() != null) {
                if (te.fallCounter > 0) {
                    float smoothed = (float)te.fallCounter * 0.03125f + ((float)te.fallCounter * 0.03125f - (float)te.fallCounterPrev * 0.03125f) * partialTicks;
                    float smoothedTumble = (float)te.fallCounter + ((float)te.fallCounter - (float)te.fallCounterPrev) * partialTicks;
                    this.renderMobInSlot(te.getEntity(), 0.0f, 0.0625f + smoothed, 0.0f, smoothedTumble);
                }
                if (te.fallCounter <= 0) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
                    if (!te.animate) {
                        GlStateManager.func_179114_b((float)(90.0f - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                    } else {
                        GlStateManager.func_179114_b((float)(-90.0f + RenderCrabPot.getRotation(index)), (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    float animationTicks = (float)te.prevAnimationTicks + (float)(te.animationTicks - te.prevAnimationTicks) * partialTicks;
                    Entity entity = te.getEntity();
                    if (entity != null) {
                        if (entity.getClass() == EntitySiltCrab.class) {
                            GlStateManager.func_179094_E();
                            this.func_147499_a(TEXTURE_SILT);
                            GlStateManager.func_179152_a((float)0.95f, (float)-0.95f, (float)-0.95f);
                            if (te.animate) {
                                MODEL_SILT.renderEating(animationTicks, 0.0625f);
                            } else {
                                MODEL_SILT.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                            }
                            GlStateManager.func_179121_F();
                        }
                        if (entity.getClass() == EntityBubblerCrab.class) {
                            GlStateManager.func_179094_E();
                            this.func_147499_a(TEXTURE_BUBBLER);
                            GlStateManager.func_179152_a((float)0.95f, (float)-0.95f, (float)-0.95f);
                            if (te.animate) {
                                MODEL_BUBBLER.renderEating(animationTicks, 0.0625f);
                            } else {
                                MODEL_BUBBLER.func_78088_a(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
                            }
                            GlStateManager.func_179121_F();
                        }
                    }
                    GlStateManager.func_179121_F();
                }
            } else {
                this.renderItemInSlot(te.func_70301_a(0), 0.0f, 0.5f, 0.0f, 0.5f);
            }
        }
        GlStateManager.func_179121_F();
    }

    public static float getRotation(int index) {
        switch (index) {
            case 3: {
                return 180.0f;
            }
            default: {
                return -90.0f;
            }
            case 1: {
                return 0.0f;
            }
            case 0: 
        }
        return 90.0f;
    }

    public boolean isSafeMobItem(TileEntityCrabPot te) {
        return te.func_70301_a(0).func_77973_b() instanceof ItemMob && (te.getEntity() instanceof EntitySiltCrab || te.getEntity() instanceof EntityBubblerCrab);
    }

    public void renderMobInSlot(Entity entity, float x, float y, float z, float rotation) {
        if (entity != null) {
            float scale = 0.95f;
            float tumble = rotation * 11.25f;
            float offsetRotation = 90.0f;
            float offsetY = 0.0625f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)(y + offsetY), (float)z);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            if (tumble > 0.0f) {
                GlStateManager.func_179114_b((float)tumble, (float)1.0f, (float)0.0f, (float)0.0f);
            } else {
                GlStateManager.func_179114_b((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.func_179114_b((float)(offsetRotation - Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            Render renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
            renderer.func_76986_a(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GlStateManager.func_179121_F();
        }
    }

    public void renderItemInSlot(ItemStack stack, float x, float y, float z, float scale) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)(-Minecraft.func_71410_x().func_175598_ae().field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }
}

