/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.render.block.IsolatedBlockModelRenderer;
import thebetweenlands.client.render.block.VertexBatchRenderer;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityBeamOrigin;
import thebetweenlands.util.LightingUtil;
import thebetweenlands.util.RotationMatrix;
import thebetweenlands.util.Stencil;

public class RenderBeamOrigin
extends TileEntitySpecialRenderer<TileEntityBeamOrigin> {
    private static final IsolatedBlockModelRenderer BLOCK_RENDERER = new IsolatedBlockModelRenderer();
    private VertexBatchRenderer blocksRenderer;

    public void render(TileEntityBeamOrigin te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179091_B();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y - 1.5), (double)(z + 0.5));
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        LightingUtil.INSTANCE.setLighting(255);
        GlStateManager.func_179140_f();
        float visibility = te.prevVisibility + (te.visibility - te.prevVisibility) * partialTicks;
        RotationMatrix m = new RotationMatrix();
        m.setRotations(0.0f, te.prevRotation + (te.rotation - te.prevRotation) * partialTicks, 0.0f);
        double h = 1.65;
        double w = 0.45;
        Vec3d v0 = new Vec3d(-w, 0.0, 0.0).func_72441_c(w, 1.0, 0.0);
        Vec3d v1 = new Vec3d(0.0, h, w).func_72441_c(w, 1.0, 0.0);
        Vec3d v2 = new Vec3d(0.0, h, -w).func_72441_c(w, 1.0, 0.0);
        Vec3d mid = Vec3d.field_186680_a;
        this.renderMirrorTri(te, m.transformVec(v0, mid), m.transformVec(v1, mid), m.transformVec(v2, mid), visibility, partialTicks);
        this.renderMirrorTri(te, m.transformVec(v0, mid), m.transformVec(v1.func_72441_c(-w * 2.0, 0.0, 0.0), mid), m.transformVec(v2.func_72441_c(0.0, 0.0, w * 2.0), mid), visibility, partialTicks);
        this.renderMirrorTri(te, m.transformVec(v0, mid), m.transformVec(v1.func_72441_c(-w * 2.0, 0.0, -w * 2.0), mid), m.transformVec(v2.func_72441_c(-w * 2.0, 0.0, w * 2.0), mid), visibility, partialTicks);
        this.renderMirrorTri(te, m.transformVec(v0, mid), m.transformVec(v1.func_72441_c(0.0, 0.0, -w * 2.0), mid), m.transformVec(v2.func_72441_c(-w * 2.0, 0.0, 0.0), mid), visibility, partialTicks);
        Vec3d p0 = m.transformVec(v1, mid);
        Vec3d p1 = m.transformVec(v1.func_72441_c(-w * 2.0, 0.0, 0.0), mid);
        Vec3d p2 = m.transformVec(v1.func_72441_c(-w * 2.0, 0.0, -w * 2.0), mid);
        Vec3d p3 = m.transformVec(v1.func_72441_c(0.0, 0.0, -w * 2.0), mid);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)visibility, (float)visibility, (float)visibility, (float)(0.75f + 0.25f * (1.0f - visibility)));
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(p3.field_72450_a, p3.field_72448_b, p3.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(p0.field_72450_a, p0.field_72448_b, p0.field_72449_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.9f * (1.0f - visibility)));
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(p3.field_72450_a, p3.field_72448_b, p3.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(p0.field_72450_a, p0.field_72448_b, p0.field_72449_c).func_181675_d();
        tessellator.func_78381_a();
        this.func_147499_a(new ResourceLocation("thebetweenlands", "textures/tiles/prism_mirror.png"));
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)visibility, (float)visibility, (float)visibility, (float)visibility);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(p3.field_72450_a, p3.field_72448_b, p3.field_72449_c).func_187315_a(0.25, 0.25).func_181675_d();
        bufferBuilder.func_181662_b(p2.field_72450_a, p2.field_72448_b, p2.field_72449_c).func_187315_a(0.25, 0.75).func_181675_d();
        bufferBuilder.func_181662_b(p1.field_72450_a, p1.field_72448_b, p1.field_72449_c).func_187315_a(0.75, 0.75).func_181675_d();
        bufferBuilder.func_181662_b(p0.field_72450_a, p0.field_72448_b, p0.field_72449_c).func_187315_a(0.25, 0.75).func_181675_d();
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179145_e();
        LightingUtil.INSTANCE.revert();
        GlStateManager.func_179101_C();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public boolean isGlobalRenderer(TileEntityBeamOrigin te) {
        return true;
    }

    protected void renderMirrorTri(TileEntityBeamOrigin te, Vec3d v0, Vec3d v1, Vec3d v2, float visibility, float partialTicks) {
        Vec3d normal = v1.func_178788_d(v0).func_72431_c(v2.func_178788_d(v0)).func_72432_b();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        Runnable mirrorRenderer = () -> {
            bufferBuilder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
            bufferBuilder.func_181662_b(v0.field_72450_a, v0.field_72448_b, v0.field_72449_c).func_181675_d();
            bufferBuilder.func_181662_b(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c).func_181675_d();
            bufferBuilder.func_181662_b(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c).func_181675_d();
            tessellator.func_78381_a();
        };
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)(visibility * 0.65f), (float)(visibility * 0.65f), (float)(visibility * 0.65f), (float)(0.75f + 0.25f * (1.0f - visibility)));
        bufferBuilder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(v0.field_72450_a, v0.field_72448_b, v0.field_72449_c).func_181675_d();
        tessellator.func_78381_a();
        this.renderMirror(te, v0, normal, mirrorRenderer, partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)(visibility * visibility), (float)(visibility * visibility), (float)(visibility * visibility), (float)0.25f);
        bufferBuilder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(v0.field_72450_a, v0.field_72448_b, v0.field_72449_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)(0.5f * (1.0f - visibility)));
        bufferBuilder.func_181668_a(4, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c).func_181675_d();
        bufferBuilder.func_181662_b(v0.field_72450_a, v0.field_72448_b, v0.field_72449_c).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)visibility, (float)visibility, (float)visibility, (float)visibility);
        this.func_147499_a(new ResourceLocation("thebetweenlands", "textures/tiles/prism_mirror.png"));
        bufferBuilder.func_181668_a(4, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b(v2.field_72450_a, v2.field_72448_b, v2.field_72449_c).func_187315_a(0.25, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(v1.field_72450_a, v1.field_72448_b, v1.field_72449_c).func_187315_a(0.75, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(v0.field_72450_a, v0.field_72448_b, v0.field_72449_c).func_187315_a(0.5, 1.0).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void renderMirror(TileEntityBeamOrigin te, Vec3d planePos, Vec3d planeNormal, Runnable mirrorRenderer, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(TextureMap.field_110575_b);
        Framebuffer fbo = Minecraft.func_71410_x().func_147110_a();
        try (Stencil stencil1 = Stencil.reserve(fbo);
             Stencil stencil2 = Stencil.reserve(fbo);){
            if (stencil1.valid() && stencil2.valid()) {
                GL11.glEnable((int)2960);
                stencil1.clear(false);
                stencil2.clear(false);
                stencil1.func(519, true);
                stencil1.op(7680, 7680, 7681);
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
                GlStateManager.func_179090_x();
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GlStateManager.func_179092_a((int)516, (float)0.5f);
                mirrorRenderer.run();
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179094_E();
                RenderBeamOrigin.mirrorTransform(planePos, planeNormal);
                GlStateManager.func_179098_w();
                GlStateManager.func_179143_c((int)518);
                GL11.glStencilMask((int)stencil2.mask);
                GL11.glStencilFunc((int)514, (int)(stencil1.mask | stencil2.mask), (int)stencil1.mask);
                GL11.glStencilOp((int)7680, (int)7680, (int)7681);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                this.renderMirrorWorld(te, partialTicks);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179121_F();
                stencil1.func(514, true);
                stencil1.op(7680);
                GlStateManager.func_179088_q();
                GlStateManager.func_179136_a((float)1.0f, (float)1.0E8f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                GlStateManager.func_179092_a((int)516, (float)0.5f);
                mirrorRenderer.run();
                GlStateManager.func_179092_a((int)516, (float)0.0f);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179113_r();
                GlStateManager.func_179094_E();
                RenderBeamOrigin.mirrorTransform(planePos, planeNormal);
                GlStateManager.func_179143_c((int)515);
                GL11.glStencilMask((int)(stencil1.mask | stencil2.mask));
                GL11.glStencilFunc((int)514, (int)(stencil1.mask | stencil2.mask), (int)(stencil1.mask | stencil2.mask));
                GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                this.renderMirrorWorld(te, partialTicks);
                GlStateManager.func_179121_F();
                GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            }
            GL11.glDisable((int)2960);
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179090_x();
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179092_a((int)516, (float)0.5f);
        mirrorRenderer.run();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
    }

    protected void renderMirrorWorld(TileEntityBeamOrigin te, float partialTicks) {
        boolean needsRebuild;
        GlStateManager.func_179094_E();
        for (EntityPlayer entity : te.func_145831_w().func_72872_a(EntityPlayer.class, new AxisAlignedBB(te.func_174877_v()).func_186662_g(20.0))) {
            Render renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)entity);
            if (renderer == null) continue;
            GlStateManager.func_179094_E();
            double ex = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTicks - ((double)te.func_174877_v().func_177958_n() + 0.5);
            double ey = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTicks - ((double)te.func_174877_v().func_177956_o() - 1.5);
            double ez = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTicks - ((double)te.func_174877_v().func_177952_p() + 0.5);
            renderer.func_76986_a((Entity)entity, ex, ey, ez, entity.field_70177_z, partialTicks);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        this.func_147499_a(TextureMap.field_110575_b);
        if (Minecraft.func_71379_u()) {
            GlStateManager.func_179103_j((int)7425);
        } else {
            GlStateManager.func_179103_j((int)7424);
        }
        boolean bl = needsRebuild = this.blocksRenderer == null;
        if (needsRebuild) {
            if (this.blocksRenderer == null) {
                this.blocksRenderer = new VertexBatchRenderer(DefaultVertexFormats.field_176600_a, OpenGlHelper.func_176075_f());
            }
            Vec3d firePos = new Vec3d(0.0, 1.0, 0.0);
            Vec3d brazierPos = new Vec3d(0.0, -1.0, 0.0);
            IBlockState stateFire = Blocks.field_150480_ab.func_176223_P();
            IBlockState stateBrazier = BlockRegistry.MUD_TOWER_BRAZIER.func_176223_P();
            IBakedModel modelFire = Minecraft.func_71410_x().func_175602_ab().func_184389_a(stateFire);
            IBakedModel modelBrazier = Minecraft.func_71410_x().func_175602_ab().func_184389_a(stateBrazier);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferBuilder = tessellator.func_178180_c();
            bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            BLOCK_RENDERER.setLighting((state, facing) -> 220);
            bufferBuilder.func_178969_c(-0.5 + firePos.field_72450_a - 3.0, -0.5 + firePos.field_72448_b, -0.5 + firePos.field_72449_c - 3.0);
            BLOCK_RENDERER.renderModel((IBlockAccess)te.func_145831_w(), te.func_174877_v(), modelFire, stateFire, MathHelper.func_180186_a((Vec3i)te.func_174877_v()), bufferBuilder);
            bufferBuilder.func_178969_c(-0.5 + brazierPos.field_72450_a - 3.0, -0.5 + brazierPos.field_72448_b, -0.5 + brazierPos.field_72449_c - 3.0);
            BLOCK_RENDERER.renderModel((IBlockAccess)te.func_145831_w(), te.func_174877_v(), modelBrazier, stateBrazier, MathHelper.func_180186_a((Vec3i)te.func_174877_v()), bufferBuilder);
            bufferBuilder.func_178969_c(-0.5 + firePos.field_72450_a - 3.0, -0.5 + firePos.field_72448_b, -0.5 + firePos.field_72449_c + 3.0);
            BLOCK_RENDERER.renderModel((IBlockAccess)te.func_145831_w(), te.func_174877_v(), modelFire, stateFire, MathHelper.func_180186_a((Vec3i)te.func_174877_v()), bufferBuilder);
            bufferBuilder.func_178969_c(-0.5 + brazierPos.field_72450_a - 3.0, -0.5 + brazierPos.field_72448_b, -0.5 + brazierPos.field_72449_c + 3.0);
            BLOCK_RENDERER.renderModel((IBlockAccess)te.func_145831_w(), te.func_174877_v(), modelBrazier, stateBrazier, MathHelper.func_180186_a((Vec3i)te.func_174877_v()), bufferBuilder);
            bufferBuilder.func_178969_c(-0.5 + firePos.field_72450_a + 3.0, -0.5 + firePos.field_72448_b, -0.5 + firePos.field_72449_c + 3.0);
            BLOCK_RENDERER.renderModel((IBlockAccess)te.func_145831_w(), te.func_174877_v(), modelFire, stateFire, MathHelper.func_180186_a((Vec3i)te.func_174877_v()), bufferBuilder);
            bufferBuilder.func_178969_c(-0.5 + brazierPos.field_72450_a + 3.0, -0.5 + brazierPos.field_72448_b, -0.5 + brazierPos.field_72449_c + 3.0);
            BLOCK_RENDERER.renderModel((IBlockAccess)te.func_145831_w(), te.func_174877_v(), modelBrazier, stateBrazier, MathHelper.func_180186_a((Vec3i)te.func_174877_v()), bufferBuilder);
            bufferBuilder.func_178969_c(-0.5 + firePos.field_72450_a + 3.0, -0.5 + firePos.field_72448_b, -0.5 + firePos.field_72449_c - 3.0);
            BLOCK_RENDERER.renderModel((IBlockAccess)te.func_145831_w(), te.func_174877_v(), modelFire, stateFire, MathHelper.func_180186_a((Vec3i)te.func_174877_v()), bufferBuilder);
            bufferBuilder.func_178969_c(-0.5 + brazierPos.field_72450_a + 3.0, -0.5 + brazierPos.field_72448_b, -0.5 + brazierPos.field_72449_c - 3.0);
            BLOCK_RENDERER.renderModel((IBlockAccess)te.func_145831_w(), te.func_174877_v(), modelBrazier, stateBrazier, MathHelper.func_180186_a((Vec3i)te.func_174877_v()), bufferBuilder);
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
            this.blocksRenderer.compile(bufferBuilder);
        }
        this.blocksRenderer.render();
        GlStateManager.func_179103_j((int)7424);
    }

    public static void mirrorTransform(Vec3d planePos, Vec3d planeNormal) {
        GlStateManager.func_179137_b((double)planePos.field_72450_a, (double)planePos.field_72448_b, (double)planePos.field_72449_c);
        RenderBeamOrigin.scaleTransform(planeNormal, -1.0f);
        GlStateManager.func_179137_b((double)(-planePos.field_72450_a), (double)(-planePos.field_72448_b), (double)(-planePos.field_72449_c));
    }

    public static void scaleTransform(Vec3d axis, float scale) {
        float yaw = -((float)Math.toDegrees(Math.atan2(axis.field_72449_c, axis.field_72450_a)));
        float pitch = (float)Math.toDegrees(Math.atan2(Math.sqrt(axis.field_72450_a * axis.field_72450_a + axis.field_72449_c * axis.field_72449_c), -axis.field_72448_b)) + 180.0f;
        GlStateManager.func_179114_b((float)yaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)pitch, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)scale, (float)1.0f);
        GlStateManager.func_179114_b((float)(-pitch), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

