/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.animation.FastTESR;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import thebetweenlands.common.tile.TileEntityBarrel;

public class RenderBarrel
extends FastTESR<TileEntityBarrel> {
    public static final ResourceLocation WHITE_SPRITE_PATH = new ResourceLocation("thebetweenlands", "tiles/white");

    public void renderTileEntityFast(TileEntityBarrel te, double x, double y, double z, float partialTicks, int destroyStage, float partial, BufferBuilder buffer) {
        IFluidTankProperties props = te.getTankProperties()[0];
        FluidStack fluid = props.getContents();
        if (fluid != null && fluid.amount > 0) {
            ResourceLocation texture = fluid.getFluid().getStill();
            if (texture == null) {
                texture = WHITE_SPRITE_PATH;
            }
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(texture.toString());
            int maxAmount = props.getCapacity();
            World world = te.func_145831_w();
            BlockPos pos = te.func_174877_v();
            IBlockState state = world.func_180495_p(pos);
            int packedLightmap = state.func_185889_a((IBlockAccess)world, pos);
            int skyLight = packedLightmap >> 16 & 0xFFFF;
            int blockLight = packedLightmap & 0xFFFF;
            float height = (float)fluid.amount / (float)maxAmount * 0.8f + 0.13f;
            int color = fluid.getFluid().getColor(fluid);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color >> 0 & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            float minU = sprite.func_94209_e();
            float minV = sprite.func_94206_g();
            float maxU = sprite.func_94212_f();
            float maxV = sprite.func_94210_h();
            float width = 0.5f;
            float depth = 0.5f;
            float offX = (1.0f - width) / 2.0f;
            float offZ = (1.0f - depth) / 2.0f;
            buffer.func_178969_c(x, y, z);
            buffer.func_181662_b((double)offX, (double)height, (double)offZ).func_181666_a(r, g, b, a).func_187315_a((double)minU, (double)maxV).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b((double)offX, (double)height, (double)(1.0f - offZ)).func_181666_a(r, g, b, a).func_187315_a((double)minU, (double)minV).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b((double)(1.0f - offX), (double)height, (double)(1.0f - offZ)).func_181666_a(r, g, b, a).func_187315_a((double)maxU, (double)minV).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_181662_b((double)(1.0f - offX), (double)height, (double)offZ).func_181666_a(r, g, b, a).func_187315_a((double)maxU, (double)maxV).func_187314_a(skyLight, blockLight).func_181675_d();
            buffer.func_178969_c(0.0, 0.0, 0.0);
        }
    }
}

