/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import java.util.Random;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.client.render.model.tile.ModelAspectrusCrop1;
import thebetweenlands.client.render.model.tile.ModelAspectrusCrop2;
import thebetweenlands.client.render.model.tile.ModelAspectrusCrop3;
import thebetweenlands.client.render.model.tile.ModelAspectrusCrop4;
import thebetweenlands.client.render.shader.LightSource;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.common.block.farming.BlockAspectrusCrop;
import thebetweenlands.common.block.farming.BlockGenericCrop;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.tile.TileEntityAspectrusCrop;
import thebetweenlands.util.ColorUtils;
import thebetweenlands.util.LightingUtil;
import thebetweenlands.util.StatePropertyHelper;

public class RenderAspectrusCrop
extends TileEntitySpecialRenderer<TileEntityAspectrusCrop> {
    protected static final ModelAspectrusCrop1 MODEL1 = new ModelAspectrusCrop1();
    protected static final ModelAspectrusCrop2 MODEL2 = new ModelAspectrusCrop2();
    protected static final ModelAspectrusCrop3 MODEL3 = new ModelAspectrusCrop3();
    protected static final ModelAspectrusCrop4 MODEL4 = new ModelAspectrusCrop4();
    protected static final ResourceLocation TEXTURE_0 = new ResourceLocation("thebetweenlands:textures/tiles/aspectrus_crop_0.png");
    protected static final ResourceLocation TEXTURE_1 = new ResourceLocation("thebetweenlands:textures/tiles/aspectrus_crop_1.png");
    protected static final ResourceLocation TEXTURE_2 = new ResourceLocation("thebetweenlands:textures/tiles/aspectrus_crop_2.png");
    protected static final ResourceLocation TEXTURE_3 = new ResourceLocation("thebetweenlands:textures/tiles/aspectrus_crop_3.png");
    protected static final ResourceLocation TEXTURE_4 = new ResourceLocation("thebetweenlands:textures/tiles/aspectrus_crop_4.png");
    protected static final ResourceLocation TEXTURE_5 = new ResourceLocation("thebetweenlands:textures/tiles/aspectrus_crop_5.png");
    protected static final ResourceLocation TEXTURE_6 = new ResourceLocation("thebetweenlands:textures/tiles/aspectrus_crop_6.png");

    public void render(TileEntityAspectrusCrop tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        float[] rgba;
        Random rnd = new Random();
        long seed = (long)tile.func_174877_v().func_177958_n() * 3129871L ^ (long)tile.func_174877_v().func_177956_o() * 116129781L ^ (long)tile.func_174877_v().func_177952_p();
        rnd.setSeed(seed * seed * 42317861L + seed * 11L);
        int rndRot = rnd.nextInt(4);
        Aspect aspect = tile.getAspect();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179114_b((float)((float)rndRot * 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179129_p();
        int index = StatePropertyHelper.getStatePropertySafely(tile, BlockAspectrusCrop.class, BlockRegistry.ASPECTRUS_CROP.getStageProperty(), 0, true, false) / 2;
        index = index <= 4 ? (index /= 2) : (index -= 2);
        if (index >= 5 && StatePropertyHelper.getStatePropertySafely(tile, BlockAspectrusCrop.class, BlockGenericCrop.DECAYED, false, true, false).booleanValue()) {
            index = 6;
        }
        if (index >= 4 && ShaderHelper.INSTANCE.isWorldShaderActive() && aspect != null) {
            rgba = ColorUtils.getRGBA(aspect.type.getColor());
            ShaderHelper.INSTANCE.require();
            float brightness = ((float)Math.sin(((float)tile.glowTicks + partialTicks) / 15.0f) * (float)Math.cos(((float)tile.glowTicks + partialTicks + 4.0f) / 80.0f) + 1.0f) / 2.0f;
            ShaderHelper.INSTANCE.getWorldShader().addLight(new LightSource((double)tile.func_174877_v().func_177958_n() + 0.5, (double)tile.func_174877_v().func_177956_o() + 0.5, (double)tile.func_174877_v().func_177952_p() + 0.5, brightness * brightness * 4.0f, rgba[0] * brightness * brightness * 2.5f, rgba[1] * brightness * brightness * 2.5f, rgba[2] * brightness * brightness * 2.5f));
        }
        switch (index) {
            case 0: {
                this.func_147499_a(TEXTURE_0);
                break;
            }
            case 1: {
                this.func_147499_a(TEXTURE_1);
                break;
            }
            case 2: {
                this.func_147499_a(TEXTURE_2);
                break;
            }
            case 3: {
                this.func_147499_a(TEXTURE_3);
                break;
            }
            case 4: {
                this.func_147499_a(TEXTURE_4);
                break;
            }
            case 5: {
                this.func_147499_a(TEXTURE_5);
                break;
            }
            case 6: {
                this.func_147499_a(TEXTURE_6);
            }
        }
        switch (index) {
            case 0: 
            case 1: {
                MODEL1.render();
                break;
            }
            case 2: 
            case 3: {
                MODEL2.render();
                break;
            }
            case 4: {
                if (aspect != null) {
                    rgba = ColorUtils.getRGBA(aspect.type.getColor());
                    GlStateManager.func_179131_c((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)0.85f);
                    LightingUtil.INSTANCE.setLighting(255);
                }
                MODEL3.renderFruitAspects();
                if (aspect != null) {
                    LightingUtil.INSTANCE.revert();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MODEL3.renderPlant();
                break;
            }
            default: {
                if (aspect != null) {
                    rgba = ColorUtils.getRGBA(aspect.type.getColor());
                    GlStateManager.func_179131_c((float)rgba[0], (float)rgba[1], (float)rgba[2], (float)0.85f);
                    LightingUtil.INSTANCE.setLighting(255);
                }
                MODEL4.renderFruitAspects();
                if (aspect != null) {
                    LightingUtil.INSTANCE.revert();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                MODEL4.renderPlant();
                break;
            }
            case 6: {
                MODEL4.renderPlant();
            }
        }
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }
}

