/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.common.block.terrain.BlockWisp;

public class ParticleWisp
extends Particle
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    private float prevFlameScale;
    private float flameScale;
    private int brightness;
    private float alphaMultiplier;
    private BlockPos wisp;
    private boolean visible;
    private boolean hidden;

    protected ParticleWisp(World world, double x, double y, double z, double mx, double my, double mz, float scale, int bright, boolean hidden) {
        super(world, x, y, z, mx, my, mz);
        this.field_187129_i = this.field_187129_i * 0.01 + mx;
        this.field_187130_j = this.field_187130_j * 0.01 + my;
        this.field_187131_k = this.field_187131_k * 0.01 + mz;
        this.field_187126_f = this.field_187123_c = (x += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_187127_g = this.field_187124_d = (y += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.field_187128_h = this.field_187125_e = (z += (double)((this.field_187136_p.nextFloat() - this.field_187136_p.nextFloat()) * 0.05f));
        this.flameScale = scale;
        this.field_70547_e = (int)(8.0 / (Math.random() * 0.8 + 0.2)) + 1000;
        this.brightness = bright;
        this.wisp = new BlockPos(x, y, z);
        this.hidden = hidden;
    }

    public int func_70537_b() {
        return 1;
    }

    public void func_180434_a(BufferBuilder buff, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        this.field_70544_f = this.prevFlameScale + (this.flameScale - this.prevFlameScale) * partialTicks;
        float scale = 0.1f * this.field_70544_f;
        float minU = this.field_187119_C.func_94209_e();
        float maxU = this.field_187119_C.func_94212_f();
        float minV = this.field_187119_C.func_94206_g();
        float maxV = this.field_187119_C.func_94210_h();
        float borderU = (maxU - minU) / (float)this.field_187119_C.func_94211_a();
        float borderV = (maxV - minV) / (float)this.field_187119_C.func_94216_b();
        minU += borderU;
        maxU -= borderU;
        minV += borderV;
        maxV -= borderV;
        float rpx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float rpy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float rpz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        int brightness = this.func_189214_a(partialTicks);
        int lightmapX = brightness >> 16 & 0xFFFF;
        int lightmapY = brightness & 0xFFFF;
        float v1x = -rotationX * scale - rotationXY * scale;
        float v1y = -rotationZ * scale;
        float v1z = -rotationYZ * scale - rotationXZ * scale;
        float v2x = -rotationX * scale + rotationXY * scale;
        float v2y = rotationZ * scale;
        float v2z = -rotationYZ * scale + rotationXZ * scale;
        float v3x = rotationX * scale + rotationXY * scale;
        float v3y = rotationZ * scale;
        float v3z = rotationYZ * scale + rotationXZ * scale;
        float v4x = rotationX * scale - rotationXY * scale;
        float v4y = -rotationZ * scale;
        float v4z = rotationYZ * scale - rotationXZ * scale;
        if (this.field_190014_F != 0.0f) {
            float angle = this.field_190014_F + (this.field_190014_F - this.field_190015_G) * partialTicks;
            float cos = MathHelper.func_76134_b((float)(angle * 0.5f));
            float rdx = MathHelper.func_76126_a((float)(angle * 0.5f)) * (float)ParticleWisp.field_190016_K.field_72450_a;
            float rdy = MathHelper.func_76126_a((float)(angle * 0.5f)) * (float)ParticleWisp.field_190016_K.field_72448_b;
            float rdz = MathHelper.func_76126_a((float)(angle * 0.5f)) * (float)ParticleWisp.field_190016_K.field_72449_c;
            float dotrdrd = cos * cos - ParticleWisp.dot(rdx, rdy, rdz, rdx, rdy, rdz);
            float dotvrd = 2.0f * ParticleWisp.dot(v1x, v1y, v1z, rdx, rdy, rdz);
            float nx = rdx * dotvrd + v1x * dotrdrd + ParticleWisp.crossX(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            float ny = rdy * dotvrd + v1y * dotrdrd + ParticleWisp.crossY(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            float nz = rdz * dotvrd + v1z * dotrdrd + ParticleWisp.crossZ(rdx, rdy, rdz, v1x, v1y, v1z) * 2.0f * cos;
            v1x = nx;
            v1y = ny;
            v1z = nz;
            dotvrd = 2.0f * ParticleWisp.dot(v2x, v2y, v2z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v2x * dotrdrd + ParticleWisp.crossX(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            ny = rdy * dotvrd + v2y * dotrdrd + ParticleWisp.crossY(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            nz = rdz * dotvrd + v2z * dotrdrd + ParticleWisp.crossZ(rdx, rdy, rdz, v2x, v2y, v2z) * 2.0f * cos;
            v2x = nx;
            v2y = ny;
            v2z = nz;
            dotvrd = 2.0f * ParticleWisp.dot(v3x, v3y, v3z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v3x * dotrdrd + ParticleWisp.crossX(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            ny = rdy * dotvrd + v3y * dotrdrd + ParticleWisp.crossY(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            nz = rdz * dotvrd + v3z * dotrdrd + ParticleWisp.crossZ(rdx, rdy, rdz, v3x, v3y, v3z) * 2.0f * cos;
            v3x = nx;
            v3y = ny;
            v3z = nz;
            dotvrd = 2.0f * ParticleWisp.dot(v4x, v4y, v4z, rdx, rdy, rdz);
            nx = rdx * dotvrd + v4x * dotrdrd + ParticleWisp.crossX(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            ny = rdy * dotvrd + v4y * dotrdrd + ParticleWisp.crossY(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            nz = rdz * dotvrd + v4z * dotrdrd + ParticleWisp.crossZ(rdx, rdy, rdz, v4x, v4y, v4z) * 2.0f * cos;
            v4x = nx;
            v4y = ny;
            v4z = nz;
        }
        buff.func_181662_b((double)rpx + (double)v1x, (double)rpy + (double)v1y, (double)rpz + (double)v1z).func_187315_a((double)maxU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * this.alphaMultiplier).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + (double)v2x, (double)rpy + (double)v2y, (double)rpz + (double)v2z).func_187315_a((double)maxU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * this.alphaMultiplier).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + (double)v3x, (double)rpy + (double)v3y, (double)rpz + (double)v3z).func_187315_a((double)minU, (double)minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * this.alphaMultiplier).func_187314_a(lightmapX, lightmapY).func_181675_d();
        buff.func_181662_b((double)rpx + (double)v4x, (double)rpy + (double)v4y, (double)rpz + (double)v4z).func_187315_a((double)minU, (double)maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as * this.alphaMultiplier).func_187314_a(lightmapX, lightmapY).func_181675_d();
    }

    private static float crossX(float x1, float y1, float z1, float x2, float y2, float z2) {
        return y1 * z2 - z1 * y2;
    }

    private static float crossY(float x1, float y1, float z1, float x2, float y2, float z2) {
        return z1 * x2 - x1 * z2;
    }

    private static float crossZ(float x1, float y1, float z1, float x2, float y2, float z2) {
        return x1 * y2 - y1 * x2;
    }

    private static float dot(float x1, float y1, float z1, float x2, float y2, float z2) {
        return x1 * x2 + y1 * y2 + z1 * z2;
    }

    public int func_189214_a(float partialTicks) {
        if (this.brightness < 0) {
            return super.func_189214_a(partialTicks);
        }
        return this.brightness;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.prevFlameScale = this.flameScale;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        this.field_187129_i *= 0.96;
        this.field_187131_k *= 0.96;
        if (this.field_70546_d++ >= this.field_70547_e || this.flameScale <= 0.0f) {
            this.func_187112_i();
        }
        if (this.field_70546_d != 0) {
            if (this.flameScale > 0.0f) {
                this.flameScale = (float)((double)this.flameScale - 0.025);
            }
            this.field_187130_j += 8.0E-5;
        }
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.hidden) {
            IBlockState state = this.field_187122_b.func_180495_p(this.wisp);
            boolean bl = this.visible = state.func_177230_c() instanceof BlockWisp ? (Boolean)state.func_177229_b((IProperty)BlockWisp.VISIBLE) : false;
            this.alphaMultiplier = !this.visible ? 1.0f - MathHelper.func_76126_a((float)(0.15707964f * MathHelper.func_76131_a((float)ParticleWisp.getDistanceToViewer(this.field_187126_f, this.field_187127_g, this.field_187128_h), (float)10.0f, (float)20.0f))) : 1.0f;
        } else {
            this.alphaMultiplier = 1.0f;
        }
        this.alphaMultiplier *= Math.min((float)this.field_70546_d * 0.2f, 1.0f);
    }

    public static float getDistanceToViewer(double x, double y, double z) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity != null) {
            double dx = entity.field_70165_t - x;
            double dy = entity.field_70163_u - y;
            double dz = entity.field_70161_v - z;
            return MathHelper.func_76129_c((float)((float)(dx * dx + dy * dy + dz * dz)));
        }
        return 0.0f;
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleWisp> {
        public Factory() {
            super(ParticleWisp.class, ParticleTextureStitcher.create(ParticleWisp.class, new ResourceLocation("thebetweenlands:particle/wisp")));
        }

        @Override
        public ParticleWisp createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleWisp(args.world, args.x, args.y, args.z, args.motionX, args.motionY, args.motionZ, args.scale, args.data.getInt(0), args.data.getBool(1));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(255, true);
        }
    }
}

