/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.particle.entity;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import thebetweenlands.client.handler.TextureStitchHandler;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.ParticleTextureStitcher;
import thebetweenlands.client.render.particle.entity.ParticleSwirl;
import thebetweenlands.client.render.sprite.TextureAnimation;

public class ParticleEntitySwirl
extends ParticleSwirl
implements ParticleTextureStitcher.IParticleSpriteReceiver {
    protected TextureAnimation animation;
    protected Entity target;
    protected double targetOffsetX;
    protected double targetOffsetY;
    protected double targetOffsetZ;

    public ParticleEntitySwirl(World world, double x, double y, double z, int maxAge, float scale, float progress, Entity target) {
        super(world, x, y, z, maxAge, scale, progress);
        this.animation = new TextureAnimation().setRandomStart(this.field_187136_p);
        this.target = target;
        this.setOffset(0.0, -1.6, 0.0);
        this.updateTarget();
    }

    @Override
    public ParticleEntitySwirl setOffset(double x, double y, double z) {
        super.setOffset(x, y, z);
        return this;
    }

    @Override
    public ParticleEntitySwirl setTarget(double x, double y, double z) {
        super.setTarget(x, y, z);
        return this;
    }

    @Override
    public ParticleEntitySwirl setTargetMotion(double x, double y, double z) {
        super.setTargetMotion(x, y, z);
        return this;
    }

    @Override
    public ParticleEntitySwirl setRotationSpeed(double speed) {
        super.setRotationSpeed(speed);
        return this;
    }

    @Override
    public ParticleEntitySwirl setRotate3D(boolean rotate3d) {
        super.setRotate3D(rotate3d);
        return this;
    }

    public ParticleEntitySwirl setTargetOffset(double x, double y, double z) {
        this.targetOffsetX = x;
        this.targetOffsetY = y;
        this.targetOffsetZ = z;
        return this;
    }

    public void updateTarget() {
        this.setTargetMotion(this.target.field_70165_t - this.target.field_70142_S, this.target.field_70163_u - this.target.field_70137_T, this.target.field_70161_v - this.target.field_70136_U);
        this.setTarget(this.target.field_70165_t + this.targetOffsetX, this.target.field_70163_u + (double)this.target.func_70047_e() / 2.0 + this.targetOffsetY, this.target.field_70161_v + this.targetOffsetZ);
    }

    @Override
    public void func_189213_a() {
        if (!this.target.func_70089_S()) {
            this.func_187112_i();
        }
        this.updateTarget();
        this.animation.update();
        this.func_187117_a(this.animation.getCurrentSprite());
        super.func_189213_a();
    }

    public int func_70537_b() {
        return 1;
    }

    @Override
    public void setStitchedSprites(TextureStitchHandler.Frame[][] frames) {
        this.animation.setFrames(frames[0]);
        if (this.field_187119_C == null) {
            this.func_187117_a(frames[0][0].getSprite());
        }
    }

    public static final class FactoryChiromawSwirl
    extends ParticleFactory<FactoryChiromawSwirl, ParticleEntitySwirl> {
        public FactoryChiromawSwirl() {
            super(ParticleEntitySwirl.class, ParticleTextureStitcher.create(ParticleEntitySwirl.class, new ResourceLocation("thebetweenlands:particle/chiromaw_transform")).setSplitAnimations(true));
        }

        @Override
        public ParticleEntitySwirl createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleEntitySwirl(args.world, args.x, args.y, args.z, args.data.getInt(0), args.scale, args.data.getFloat(1), args.data.getObject(Entity.class, 2));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(400, Float.valueOf(0.0f), null);
        }
    }

    public static final class FactorySludgeSwirl
    extends ParticleFactory<FactorySludgeSwirl, ParticleEntitySwirl> {
        public FactorySludgeSwirl() {
            super(ParticleEntitySwirl.class, ParticleTextureStitcher.create(ParticleEntitySwirl.class, new ResourceLocation("thebetweenlands:particle/smooth_smoke")));
        }

        @Override
        public ParticleEntitySwirl createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleEntitySwirl(args.world, args.x, args.y, args.z, args.data.getInt(0), args.scale, args.data.getFloat(1), args.data.getObject(Entity.class, 2));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(400, Float.valueOf(0.0f), null);
        }
    }

    public static final class FactoryEmberSwirl
    extends ParticleFactory<FactoryEmberSwirl, ParticleEntitySwirl> {
        public FactoryEmberSwirl() {
            super(ParticleEntitySwirl.class, ParticleTextureStitcher.create(ParticleEntitySwirl.class, new ResourceLocation("thebetweenlands:particle/ember_swirl")).setSplitAnimations(true));
        }

        @Override
        public ParticleEntitySwirl createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleEntitySwirl(args.world, args.x, args.y, args.z, args.data.getInt(0), args.scale, args.data.getFloat(1), args.data.getObject(Entity.class, 2));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(400, Float.valueOf(0.0f), null);
        }
    }

    public static final class Factory
    extends ParticleFactory<Factory, ParticleEntitySwirl> {
        public Factory() {
            super(ParticleEntitySwirl.class, ParticleTextureStitcher.create(ParticleEntitySwirl.class, new ResourceLocation("thebetweenlands:particle/leaf")).setSplitAnimations(true));
        }

        @Override
        public ParticleEntitySwirl createParticle(ParticleFactory.ImmutableParticleArgs args) {
            return new ParticleEntitySwirl(args.world, args.x, args.y, args.z, args.data.getInt(0), args.scale, args.data.getFloat(1), args.data.getObject(Entity.class, 2));
        }

        @Override
        protected void setBaseArguments(ParticleFactory.ParticleArgs<?> args) {
            args.withData(400, Float.valueOf(0.0f), null);
        }
    }
}

