/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.vecmath.Matrix4f;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.common.block.structure.BlockSlanted;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.StatePropertyHelper;

public class ModelSlant
implements IModel {
    public final ResourceLocation textureSlant;
    public final ResourceLocation textureSide;
    public final ResourceLocation textureBase;

    public ModelSlant(ResourceLocation texture) {
        this(texture, texture, texture);
    }

    public ModelSlant(ResourceLocation textureSlant, ResourceLocation textureSide, ResourceLocation textureBase) {
        this.textureSlant = textureSlant == null ? TextureMap.field_174945_f : textureSlant;
        this.textureSide = textureSide == null ? TextureMap.field_174945_f : textureSide;
        this.textureBase = textureBase == null ? TextureMap.field_174945_f : textureBase;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)this.textureSlant, (Object)this.textureSide, (Object)this.textureBase);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new ModelBakedSlant(state.apply(Optional.empty()), map, format, bakedTextureGetter.apply(this.textureSlant), bakedTextureGetter.apply(this.textureSide), bakedTextureGetter.apply(this.textureBase));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        ResourceLocation slant = null;
        ResourceLocation side = null;
        ResourceLocation base = null;
        if (textures.containsKey((Object)"slant")) {
            slant = new ResourceLocation((String)textures.get((Object)"slant"));
        }
        if (textures.containsKey((Object)"side")) {
            side = new ResourceLocation((String)textures.get((Object)"side"));
        }
        if (textures.containsKey((Object)"base")) {
            base = new ResourceLocation((String)textures.get((Object)"base"));
        }
        if (slant != null || side != null || base != null) {
            return new ModelSlant(slant != null ? slant : this.textureSlant, side != null ? side : this.textureSide, base != null ? base : this.textureBase);
        }
        return this;
    }

    public static class ModelBakedSlant
    implements IBakedModel {
        private final VertexFormat format;
        private final TextureAtlasSprite textureSlant;
        private final TextureAtlasSprite textureSide;
        private final TextureAtlasSprite textureBase;
        private float slopeEdge = 0.1875f;
        private Map<EnumFacing, ImmutableList<BakedQuad>> faceQuads;
        private List<BakedQuad> nonCulledQuads;
        protected final TRSRTransformation transformation;
        protected final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final LoadingCache<Integer, ModelBakedSlant> modelCache = CacheBuilder.newBuilder().maximumSize(256L).build((CacheLoader)new CacheLoader<Integer, ModelBakedSlant>(){

            public ModelBakedSlant load(Integer key) throws Exception {
                return new ModelBakedSlant(transformation != null ? Optional.of(transformation) : Optional.empty(), transforms, format, textureSlant, textureSide, textureBase, key);
            }
        });

        private ModelBakedSlant(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, TextureAtlasSprite textureSlant, TextureAtlasSprite textureSide, TextureAtlasSprite textureBase) {
            this.transformation = transformation.isPresent() ? transformation.get() : null;
            this.transforms = transforms;
            this.format = format;
            this.textureSlant = textureSlant;
            this.textureSide = textureSide;
            this.textureBase = textureBase;
        }

        private ModelBakedSlant(Optional<TRSRTransformation> transformation, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, TextureAtlasSprite textureSlant, TextureAtlasSprite textureSide, TextureAtlasSprite textureBase, Integer key) {
            this(transformation, transforms, format, textureSlant, textureSide, textureBase);
            boolean cornerNW = (key & 1) != 0;
            boolean cornerNE = (key & 2) != 0;
            boolean cornerSE = (key & 4) != 0;
            boolean cornerSW = (key & 8) != 0;
            boolean upsidedown = (key & 0x10) != 0;
            EnumFacing slantDir = EnumFacing.func_176731_b((int)(key >> 5));
            float cornerHeightNW = cornerNW ? 1.0f : this.slopeEdge;
            float cornerHeightNE = cornerNE ? 1.0f : this.slopeEdge;
            float cornerHeightSE = cornerSE ? 1.0f : this.slopeEdge;
            float cornerHeightSW = cornerSW ? 1.0f : this.slopeEdge;
            QuadBuilder builder = new QuadBuilder(this.format).setTransformation(this.transformation);
            int[] slantTexU = new int[4];
            int[] slantTexV = new int[4];
            switch (slantDir) {
                default: {
                    slantTexU = new int[]{0, 0, 16, 16};
                    slantTexV = new int[]{0, 16, 16, 0};
                    break;
                }
                case SOUTH: {
                    slantTexU = new int[]{16, 16, 0, 0};
                    slantTexV = new int[]{16, 0, 0, 16};
                    break;
                }
                case EAST: {
                    slantTexU = new int[]{0, 16, 16, 0};
                    slantTexV = new int[]{16, 16, 0, 0};
                    break;
                }
                case WEST: {
                    slantTexU = new int[]{16, 0, 0, 16};
                    slantTexV = new int[]{0, 0, 16, 16};
                }
            }
            if (!upsidedown) {
                builder.setSprite(this.textureSide);
                builder.setCullFace(EnumFacing.NORTH);
                builder.addVertex(0.0, 0.0, 1.0E-4f, 16.0f, 16.0f);
                builder.addVertex(0.0, cornerHeightNW, 1.0E-4f, 16.0f, 16.0f - cornerHeightNW * 16.0f);
                builder.addVertex(1.0, cornerHeightNE, 1.0E-4f, 0.0f, 16.0f - cornerHeightNE * 16.0f);
                builder.addVertex(1.0, 0.0, 1.0E-4f, 0.0f, 16.0f);
                builder.setCullFace(EnumFacing.SOUTH);
                builder.addVertex(0.0, 0.0, 1.0, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.0, 1.0, 16.0f, 16.0f);
                builder.addVertex(1.0, cornerHeightSE, 1.0, 16.0f, 16.0f - cornerHeightSE * 16.0f);
                builder.addVertex(0.0, cornerHeightSW, 1.0, 0.0f, 16.0f - cornerHeightSW * 16.0f);
                builder.setCullFace(EnumFacing.EAST);
                builder.addVertex(1.0, 0.0, 0.0, 16.0f, 16.0f);
                builder.addVertex(1.0, cornerHeightNE, 0.0, 16.0f, 16.0f - cornerHeightNE * 16.0f);
                builder.addVertex(1.0, cornerHeightSE, 1.0, 0.0f, 16.0f - cornerHeightSE * 16.0f);
                builder.addVertex(1.0, 0.0, 1.0, 0.0f, 16.0f);
                builder.setCullFace(EnumFacing.WEST);
                builder.addVertex(1.0E-4f, 0.0, 0.0, 0.0f, 16.0f);
                builder.addVertex(1.0E-4f, 0.0, 1.0, 16.0f, 16.0f);
                builder.addVertex(1.0E-4f, cornerHeightSW, 1.0, 16.0f, 16.0f - cornerHeightSW * 16.0f);
                builder.addVertex(1.0E-4f, cornerHeightNW, 0.0, 0.0f, 16.0f - cornerHeightNW * 16.0f);
                builder.setCullFace(null);
                builder.setSprite(this.textureSlant);
                if (cornerNW && cornerNE && cornerSE) {
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                } else if (cornerNE && cornerSE && cornerSW) {
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                } else if (cornerSE && cornerSW && cornerNW) {
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                } else if (cornerSW && cornerNW && cornerNE) {
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                } else if (cornerNW && !cornerNE && !cornerSE && !cornerSW) {
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                } else if (!cornerNW && cornerNE && !cornerSE && !cornerSW) {
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                } else if (!cornerNW && !cornerNE && cornerSE && !cornerSW) {
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                } else if (!cornerNW && !cornerNE && !cornerSE && cornerSW) {
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                } else if (cornerNW && cornerSE && !cornerNE && !cornerSW) {
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                } else if (!cornerNW && !cornerSE && cornerNE && cornerSW) {
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                } else {
                    builder.addVertex(0.0, cornerHeightNW, 0.0, slantTexU[0], slantTexV[0]);
                    builder.addVertex(0.0, cornerHeightSW, 1.0, slantTexU[1], slantTexV[1]);
                    builder.addVertex(1.0, cornerHeightSE, 1.0, slantTexU[2], slantTexV[2]);
                    builder.addVertex(1.0, cornerHeightNE, 0.0, slantTexU[3], slantTexV[3]);
                }
                builder.setCullFace(EnumFacing.DOWN);
                builder.setSprite(this.textureBase);
                builder.addVertex(0.0, 0.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(1.0, 0.0, 0.0, 0.0f, 16.0f);
                builder.addVertex(1.0, 0.0, 1.0, 16.0f, 16.0f);
                builder.addVertex(0.0, 0.0, 1.0, 16.0f, 0.0f);
            } else {
                builder.setSprite(this.textureSide);
                builder.setCullFace(EnumFacing.NORTH);
                builder.addVertex(0.0, 1.0, 1.0E-4f, 16.0f, 0.0f);
                builder.addVertex(1.0, 1.0, 1.0E-4f, 0.0f, 0.0f);
                builder.addVertex(1.0, 1.0f - cornerHeightNE, 1.0E-4f, 0.0f, cornerHeightNE * 16.0f);
                builder.addVertex(0.0, 1.0f - cornerHeightNW, 1.0E-4f, 16.0f, cornerHeightNW * 16.0f);
                builder.setCullFace(EnumFacing.SOUTH);
                builder.addVertex(0.0, 1.0, 1.0, 0.0f, 0.0f);
                builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, 0.0f, cornerHeightSW * 16.0f);
                builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, 16.0f, cornerHeightSE * 16.0f);
                builder.addVertex(1.0, 1.0, 1.0, 16.0f, 0.0f);
                builder.setCullFace(EnumFacing.EAST);
                builder.addVertex(1.0, 1.0, 0.0, 16.0f, 0.0f);
                builder.addVertex(1.0, 1.0, 1.0, 0.0f, 0.0f);
                builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, 0.0f, cornerHeightSE * 16.0f);
                builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, 16.0f, cornerHeightNE * 16.0f);
                builder.setCullFace(EnumFacing.WEST);
                builder.addVertex(1.0E-4f, 1.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(1.0E-4f, 1.0f - cornerHeightNW, 0.0, 0.0f, cornerHeightNW * 16.0f);
                builder.addVertex(1.0E-4f, 1.0f - cornerHeightSW, 1.0, 16.0f, cornerHeightSW * 16.0f);
                builder.addVertex(1.0E-4f, 1.0, 1.0, 16.0f, 0.0f);
                builder.setCullFace(null);
                builder.setSprite(this.textureSlant);
                if (cornerNW && cornerNE && cornerSE) {
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                } else if (cornerNE && cornerSE && cornerSW) {
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                } else if (cornerSE && cornerSW && cornerNW) {
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                } else if (cornerSW && cornerNW && cornerNE) {
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                } else if (cornerNW && !cornerNE && !cornerSE && !cornerSW) {
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                } else if (!cornerNW && cornerNE && !cornerSE && !cornerSW) {
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                } else if (!cornerNW && !cornerNE && cornerSE && !cornerSW) {
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                } else if (!cornerNW && !cornerNE && !cornerSE && cornerSW) {
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                } else if (cornerNW && cornerSE && !cornerNE && !cornerSW) {
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                } else if (!cornerNW && !cornerSE && cornerNE && cornerSW) {
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                } else {
                    builder.addVertex(1.0, 1.0f - cornerHeightNE, 0.0, slantTexU[3], 16 - slantTexV[3]);
                    builder.addVertex(1.0, 1.0f - cornerHeightSE, 1.0, slantTexU[2], 16 - slantTexV[2]);
                    builder.addVertex(0.0, 1.0f - cornerHeightSW, 1.0, slantTexU[1], 16 - slantTexV[1]);
                    builder.addVertex(0.0, 1.0f - cornerHeightNW, 0.0, slantTexU[0], 16 - slantTexV[0]);
                }
                builder.setCullFace(EnumFacing.UP);
                builder.setSprite(this.textureBase);
                builder.addVertex(0.0, 1.0, 0.0, 0.0f, 0.0f);
                builder.addVertex(0.0, 1.0, 1.0, 16.0f, 0.0f);
                builder.addVertex(1.0, 1.0, 1.0, 16.0f, 16.0f);
                builder.addVertex(1.0, 1.0, 0.0, 0.0f, 16.0f);
            }
            QuadBuilder.Quads result = builder.build();
            this.faceQuads = result.culledQuads;
            this.nonCulledQuads = result.nonCulledQuads;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            boolean upsidedown = state != null ? state.func_177229_b((IProperty)BlockSlanted.field_176308_b) == BlockStairs.EnumHalf.TOP : false;
            boolean cornerNW = false;
            boolean cornerNE = false;
            boolean cornerSE = false;
            boolean cornerSW = false;
            EnumFacing slantDir = EnumFacing.NORTH;
            cornerNW = StatePropertyHelper.getPropertyOptional(state, BlockSlanted.CORNER_NORTH_WEST).orElse(true);
            cornerNE = StatePropertyHelper.getPropertyOptional(state, BlockSlanted.CORNER_NORTH_EAST).orElse(false);
            cornerSE = StatePropertyHelper.getPropertyOptional(state, BlockSlanted.CORNER_SOUTH_EAST).orElse(false);
            cornerSW = StatePropertyHelper.getPropertyOptional(state, BlockSlanted.CORNER_SOUTH_WEST).orElse(true);
            slantDir = StatePropertyHelper.getPropertyOptional(state, BlockSlanted.field_176309_a).orElse(EnumFacing.WEST);
            int index = 0;
            if (cornerNW) {
                index |= 1;
            }
            if (cornerNE) {
                index |= 2;
            }
            if (cornerSE) {
                index |= 4;
            }
            if (cornerSW) {
                index |= 8;
            }
            if (upsidedown) {
                index |= 0x10;
            }
            ModelBakedSlant model = (ModelBakedSlant)this.modelCache.getUnchecked((Object)(index |= slantDir.func_176736_b() << 5));
            return side == null ? model.nonCulledQuads : (List)model.faceQuads.get(side);
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.textureSlant;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }
}

