/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.baked;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import thebetweenlands.client.render.model.baked.ModelFromModelBase;
import thebetweenlands.client.render.model.baked.modelbase.ModelMudBricksAlcove;
import thebetweenlands.common.block.container.BlockMudBrickAlcove;
import thebetweenlands.util.ModelConverter;
import thebetweenlands.util.QuadBuilder;
import thebetweenlands.util.StatePropertyHelper;
import thebetweenlands.util.TexturePacker;
import thebetweenlands.util.Vec3UV;

public class ModelAlcove
implements IModel {
    private static final ModelMudBricksAlcove ALCOVE_MODEL_BASE = new ModelMudBricksAlcove();
    private static final Predicate<ModelRenderer> OUTCROP_PREDICATE = part -> part == ModelAlcove.ALCOVE_MODEL_BASE.outcrop_a || part == ModelAlcove.ALCOVE_MODEL_BASE.outcrop_b;
    private static final Predicate<ModelRenderer> TOP_COBWEB_PREDICATE = part -> part == ModelAlcove.ALCOVE_MODEL_BASE.cobweb1 || part == ModelAlcove.ALCOVE_MODEL_BASE.cobweb2 || part == ModelAlcove.ALCOVE_MODEL_BASE.cobweb2b;
    private static final Predicate<ModelRenderer> BOTTOM_COBWEB_PREDICATE = part -> part == ModelAlcove.ALCOVE_MODEL_BASE.cobweb2 || part == ModelAlcove.ALCOVE_MODEL_BASE.cobweb2b;
    private static final Predicate<ModelRenderer> SMALL_CANDLE_PREDICATE = part -> part == ModelAlcove.ALCOVE_MODEL_BASE.candle2 || part == ModelAlcove.ALCOVE_MODEL_BASE.wicker2 || part == ModelAlcove.ALCOVE_MODEL_BASE.drip_texture2;
    private static final Predicate<ModelRenderer> BIG_CANDLE_PREDICATE = part -> part == ModelAlcove.ALCOVE_MODEL_BASE.candle1 || part == ModelAlcove.ALCOVE_MODEL_BASE.wicker1 || part == ModelAlcove.ALCOVE_MODEL_BASE.drip_texture1;
    private static final Predicate<ModelRenderer> BASE_PREDICATE = part -> !OUTCROP_PREDICATE.test((ModelRenderer)part) && !TOP_COBWEB_PREDICATE.test((ModelRenderer)part) && !BOTTOM_COBWEB_PREDICATE.test((ModelRenderer)part) && !SMALL_CANDLE_PREDICATE.test((ModelRenderer)part) && !BIG_CANDLE_PREDICATE.test((ModelRenderer)part);
    private final ModelFromModelBase[] baseModel;
    private final ModelFromModelBase[] topCobwebModel;
    private final ModelFromModelBase[] bottomCobwebModel;
    private final ModelFromModelBase[] smallCandleModel;
    private final ModelFromModelBase[] bigCandleModel;
    private final ResourceLocation particleTexture;

    public ModelAlcove(TexturePacker packer, ResourceLocation[] baseTextures, ResourceLocation particleTexture, int width, int height) {
        this.baseModel = new ModelFromModelBase[baseTextures.length];
        this.topCobwebModel = new ModelFromModelBase[baseTextures.length];
        this.bottomCobwebModel = new ModelFromModelBase[baseTextures.length];
        this.smallCandleModel = new ModelFromModelBase[baseTextures.length];
        this.bigCandleModel = new ModelFromModelBase[baseTextures.length];
        for (int i = 0; i < baseTextures.length; ++i) {
            ModelFromModelBase baseModel = this.baseModel[i] = new ModelFromModelBase.Builder(ALCOVE_MODEL_BASE, baseTextures[i], width, height).packer(packer).particleTexture(particleTexture).processor(new PredicateVertexProcessor(BASE_PREDICATE)).doubleFace(false).build();
            this.topCobwebModel[i] = new ModelFromModelBase(baseModel, particleTexture, width, height, new PredicateVertexProcessor(TOP_COBWEB_PREDICATE), baseModel.doubleFace, baseModel.ambientOcclusion);
            this.bottomCobwebModel[i] = new ModelFromModelBase(baseModel, particleTexture, width, height, new PredicateVertexProcessor(BOTTOM_COBWEB_PREDICATE), baseModel.doubleFace, baseModel.ambientOcclusion);
            this.smallCandleModel[i] = new ModelFromModelBase(baseModel, particleTexture, width, height, new PredicateVertexProcessor(SMALL_CANDLE_PREDICATE), baseModel.doubleFace, baseModel.ambientOcclusion);
            this.bigCandleModel[i] = new ModelFromModelBase(baseModel, particleTexture, width, height, new PredicateVertexProcessor(BIG_CANDLE_PREDICATE), baseModel.doubleFace, baseModel.ambientOcclusion);
        }
        this.particleTexture = particleTexture;
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.emptyList();
    }

    public Collection<ResourceLocation> getTextures() {
        ImmutableSet.Builder textures = ImmutableSet.builder();
        for (int i = 0; i < this.baseModel.length; ++i) {
            textures.addAll(this.baseModel[i].getTextures());
            textures.addAll(this.topCobwebModel[i].getTextures());
            textures.addAll(this.bottomCobwebModel[i].getTextures());
            textures.addAll(this.smallCandleModel[i].getTextures());
            textures.addAll(this.bigCandleModel[i].getTextures());
        }
        return textures.build();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel[] bakedBaseModel = new IBakedModel[this.baseModel.length];
        IBakedModel[] bakedTopCobwedModel = new IBakedModel[this.baseModel.length];
        IBakedModel[] bakedBottomCobwebModel = new IBakedModel[this.baseModel.length];
        IBakedModel[] bakedSmallCandleModel = new IBakedModel[this.baseModel.length];
        IBakedModel[] bakedBigCandleModel = new IBakedModel[this.baseModel.length];
        for (int i = 0; i < this.baseModel.length; ++i) {
            bakedBaseModel[i] = this.baseModel[i].bake(state, format, bakedTextureGetter);
            bakedTopCobwedModel[i] = this.topCobwebModel[i].bake(state, format, bakedTextureGetter);
            bakedBottomCobwebModel[i] = this.bottomCobwebModel[i].bake(state, format, bakedTextureGetter);
            bakedSmallCandleModel[i] = this.smallCandleModel[i].bake(state, format, bakedTextureGetter);
            bakedBigCandleModel[i] = this.bigCandleModel[i].bake(state, format, bakedTextureGetter);
        }
        return new ModelBakedAlcove(PerspectiveMapWrapper.getTransforms((IModelState)state), bakedBaseModel, bakedTopCobwedModel, bakedBottomCobwebModel, bakedSmallCandleModel, bakedBigCandleModel, bakedTextureGetter.apply(this.particleTexture));
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static class ModelBakedAlcove
    implements IBakedModel {
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final IBakedModel[] bakedBaseModel;
        private final IBakedModel[] bakedTopCobwebModel;
        private final IBakedModel[] bakedBottomCobwebModel;
        private final IBakedModel[] bakedSmallCandleModel;
        private final IBakedModel[] bakedBigCandleModel;
        private final TextureAtlasSprite particleTexture;

        private ModelBakedAlcove(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, IBakedModel[] bakedBaseModel, IBakedModel[] bakedTopCobwedModel, IBakedModel[] bakedBottomCobwebMode, IBakedModel[] bakedSmallCandleModel, IBakedModel[] bakedBigCandleModel, TextureAtlasSprite particleTexture) {
            this.transforms = transforms;
            this.bakedBaseModel = bakedBaseModel;
            this.bakedTopCobwebModel = bakedTopCobwedModel;
            this.bakedBottomCobwebModel = bakedBottomCobwebMode;
            this.bakedSmallCandleModel = bakedSmallCandleModel;
            this.bakedBigCandleModel = bakedBigCandleModel;
            this.particleTexture = particleTexture;
        }

        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
            if (side == null) {
                int level = StatePropertyHelper.getPropertyOptional(state, BlockMudBrickAlcove.LEVEL).orElse(0);
                if (level <= 2) {
                    level = 0;
                }
                if (level == 3) {
                    level = 1;
                }
                if (level == 4) {
                    level = 2;
                }
                if (level == 5) {
                    level = 3;
                }
                if (level >= 6) {
                    level = 4;
                }
                level = Math.min(this.bakedBaseModel.length - 1, Math.max(0, level));
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(this.bakedBaseModel[level].func_188616_a(state, side, rand));
                if (StatePropertyHelper.getPropertyOptional(state, BlockMudBrickAlcove.TOP_COBWEB).orElse(true).booleanValue()) {
                    quads.addAll(this.bakedTopCobwebModel[level].func_188616_a(state, side, rand));
                }
                if (StatePropertyHelper.getPropertyOptional(state, BlockMudBrickAlcove.BOTTOM_COBWEB).orElse(true).booleanValue()) {
                    quads.addAll(this.bakedBottomCobwebModel[level].func_188616_a(state, side, rand));
                }
                if (StatePropertyHelper.getPropertyOptional(state, BlockMudBrickAlcove.SMALL_CANDLE).orElse(true).booleanValue()) {
                    quads.addAll(this.bakedSmallCandleModel[level].func_188616_a(state, side, rand));
                }
                if (StatePropertyHelper.getPropertyOptional(state, BlockMudBrickAlcove.BIG_CANDLE).orElse(true).booleanValue()) {
                    quads.addAll(this.bakedBigCandleModel[level].func_188616_a(state, side, rand));
                }
                return quads;
            }
            return ImmutableList.of();
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return true;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particleTexture;
        }

        public ItemCameraTransforms func_177552_f() {
            return ItemCameraTransforms.field_178357_a;
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
        }
    }

    private static final class PredicateVertexProcessor
    implements ModelFromModelBase.IVertexProcessor {
        private final Predicate<ModelRenderer> partPredicate;

        private PredicateVertexProcessor(Predicate<ModelRenderer> partPredicate) {
            this.partPredicate = partPredicate;
        }

        @Override
        public Vec3UV process(Vec3UV vertexIn, ModelConverter.Model model, ModelConverter.Quad quad, ModelConverter.Box box, QuadBuilder builder) {
            return this.partPredicate.test(box.getModelRenderer()) ? vertexIn : null;
        }
    }
}

